/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.io.Serializable;
import java.util.Arrays;

public class ByteString
implements Comparable<ByteString>,
Serializable {
    private final byte[] bytes;
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public ByteString(byte[] bytes) {
        this.bytes = (byte[])bytes.clone();
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public boolean equals(Object obj) {
        return obj instanceof ByteString && Arrays.equals(this.bytes, ((ByteString)obj).bytes);
    }

    @Override
    public int compareTo(ByteString that) {
        byte[] v1 = this.bytes;
        byte[] v2 = that.bytes;
        int n = Math.min(v1.length, v2.length);
        int i = 0;
        while (i < n) {
            byte c1 = v1[i];
            byte c2 = v2[i];
            if (c1 != c2) {
                return c1 - c2;
            }
            ++i;
        }
        return v1.length - v2.length;
    }

    public String toString() {
        char[] chars = new char[this.bytes.length * 2];
        int i = 0;
        int j = 0;
        while (i < this.bytes.length) {
            byte b = this.bytes[i];
            chars[j++] = digits[(b & 0xF0) >> 4];
            chars[j++] = digits[b & 0xF];
            ++i;
        }
        return new String(chars);
    }

    public Object clone() {
        return this;
    }

    public int length() {
        return this.bytes.length;
    }

    public byte byteAt(int i) {
        return this.bytes[i];
    }
}

