/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;
import mondrian.olap.Util;

public class CartesianProductList<T>
extends AbstractList<List<T>>
implements RandomAccess {
    private final List<List<T>> lists;

    public CartesianProductList(List<List<T>> lists) {
        this.lists = lists;
    }

    @Override
    public List<T> get(int index) {
        ArrayList<T> result = new ArrayList<T>();
        int i = this.lists.size();
        while (--i >= 0) {
            List<T> list = this.lists.get(i);
            int size = list.size();
            int y = index % size;
            index /= size;
            result.add(0, list.get(y));
        }
        return result;
    }

    @Override
    public int size() {
        int n = 1;
        for (List<T> list : this.lists) {
            n *= list.size();
        }
        return n;
    }

    public void getIntoArray(int index, Object[] a) {
        int n = 0;
        int i = this.lists.size();
        while (--i >= 0) {
            List<T> list = this.lists.get(i);
            int size = list.size();
            int y = index % size;
            index /= size;
            T t = list.get(y);
            if (t instanceof List) {
                List tList = (List)t;
                int j = tList.size();
                while (--j >= 0) {
                    a[n++] = tList.get(j);
                }
                continue;
            }
            a[n++] = t;
        }
        this.reverse(a, n);
    }

    private void reverse(Object[] a, int size) {
        int i = 0;
        int j = size - 1;
        while (i < j) {
            Object t = a[i];
            a[i] = a[j];
            a[j] = t;
            ++i;
            --j;
        }
    }

    @Override
    public Iterator<List<T>> iterator() {
        return new CartesianProductIterator();
    }

    private class CartesianProductIterator
    implements Iterator<List<T>> {
        private final int[] offsets;
        private final T[] elements;
        private boolean hasNext;

        public CartesianProductIterator() {
            this.offsets = new int[CartesianProductList.this.lists.size()];
            this.elements = new Object[CartesianProductList.this.lists.size()];
            this.hasNext = true;
            int i = 0;
            while (i < CartesianProductList.this.lists.size()) {
                List list = (List)CartesianProductList.this.lists.get(i);
                if (list.isEmpty()) {
                    this.hasNext = false;
                    return;
                }
                this.elements[i] = list.get(0);
                ++i;
            }
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public List<T> next() {
            List result = Util.flatListCopy(this.elements);
            this.moveToNext();
            return result;
        }

        private void moveToNext() {
            int ordinal = this.offsets.length;
            while (ordinal > 0) {
                int n = --ordinal;
                this.offsets[n] = this.offsets[n] + 1;
                List list = (List)CartesianProductList.this.lists.get(ordinal);
                if (this.offsets[ordinal] < list.size()) {
                    this.elements[ordinal] = list.get(this.offsets[ordinal]);
                    return;
                }
                this.offsets[ordinal] = 0;
                this.elements[ordinal] = list.get(0);
            }
            this.hasNext = false;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

