/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import mondrian.util.CacheMap;

public class FilteredIterableList<T>
extends AbstractSequentialList<T> {
    private List<T> plainList = null;
    private int size;
    private boolean isEmpty;
    private int lastIndex = 0;
    private int lastGetIndex = -1;
    private T lastGet = null;
    private ListIterator<T> lastListIterator;
    private final List<? extends T> internal;
    private final Filter<T> filter;
    private final Map<Integer, T> cached;

    public FilteredIterableList(List<? extends T> list, Filter filter) {
        this.filter = filter;
        this.internal = list;
        this.isEmpty = !this.listIterator(0).hasNext();
        this.size = -1;
        this.cached = new CacheMap<Integer, T>(4);
    }

    @Override
    public T get(int index) {
        if (this.plainList != null) {
            return this.plainList.get(index);
        }
        T t = this.cached.get(index);
        if (t != null) {
            return this.cached.get(index);
        }
        if (index != this.lastGetIndex || index < 0) {
            this.lastGet = super.get(index);
            if (this.lastGet == null) {
                throw new IndexOutOfBoundsException();
            }
            this.lastGetIndex = index;
        }
        this.cached.put(index, this.lastGet);
        return this.lastGet;
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        if (this.plainList == null) {
            if (index == this.lastIndex + 1 && this.lastListIterator != null) {
                if (this.lastListIterator.hasNext()) {
                    this.lastIndex = index;
                    return this.lastListIterator;
                }
                throw new IndexOutOfBoundsException();
            }
            final Iterator<T> it = this.internal.iterator();
            Object nextTmp = null;
            while (it.hasNext()) {
                T n = it.next();
                if (!this.filter.accept(n)) continue;
                nextTmp = n;
                break;
            }
            Object first = nextTmp;
            this.lastListIterator = new ListIterator<T>(first){
                private int idx = 0;
                private T nxt;
                {
                    this.nxt = object;
                }

                private void postNext() {
                    while (it.hasNext()) {
                        Object n = it.next();
                        if (!FilteredIterableList.this.filter.accept(n)) continue;
                        this.nxt = n;
                        return;
                    }
                    this.nxt = null;
                }

                @Override
                public boolean hasNext() {
                    return this.nxt != null;
                }

                @Override
                public T next() {
                    ++this.idx;
                    Object n = this.nxt;
                    FilteredIterableList.this.cached.put(this.idx - 1, n);
                    this.postNext();
                    return n;
                }

                @Override
                public int nextIndex() {
                    return this.idx;
                }

                @Override
                public void add(T t) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void set(T t) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean hasPrevious() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public T previous() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public int previousIndex() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
            int i = this.lastIndex = 0;
            while (i < index) {
                if (!this.lastListIterator.hasNext()) {
                    throw new IndexOutOfBoundsException();
                }
                this.lastListIterator.next();
                ++i;
            }
            this.lastIndex = index;
            return this.lastListIterator;
        }
        return this.plainList.listIterator(index);
    }

    @Override
    public boolean isEmpty() {
        return this.plainList != null ? this.plainList.isEmpty() : this.isEmpty;
    }

    @Override
    public int size() {
        if (this.size == -1) {
            int s = this.lastIndex;
            try {
                ListIterator<T> it = this.listIterator(this.lastIndex);
                while (it.hasNext()) {
                    ++s;
                    it.next();
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            this.size = s;
        }
        this.lastListIterator = null;
        return this.size;
    }

    @Override
    public Object[] toArray() {
        this.ensurePlainList();
        return this.plainList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] contents) {
        this.ensurePlainList();
        return this.plainList.toArray(contents);
    }

    private void ensurePlainList() {
        if (this.plainList == null) {
            ArrayList<T> tmpPlainList = new ArrayList<T>();
            ListIterator<T> it = this.listIterator(0);
            while (it.hasNext()) {
                tmpPlainList.add(it.next());
            }
            this.plainList = tmpPlainList;
        }
    }

    @Override
    public int hashCode() {
        return this.filter.hashCode();
    }

    public static interface Filter<T> {
        public boolean accept(T var1);
    }
}

