/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mondrian.calc.TupleList;
import mondrian.calc.impl.ArrayTupleList;
import mondrian.olap.Cube;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.OlapElement;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.fun.FunUtil;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapCube;
import org.olap4j.impl.IdentifierParser;

public class IdentifierParser
extends org.olap4j.impl.IdentifierParser {

    public static class BuilderImpl
    extends IdentifierParser.MemberBuilder {
        private final SchemaReader schemaReader;
        private final Cube cube;
        protected final List<Hierarchy> hierarchyList;
        private final boolean ignoreInvalid;

        BuilderImpl(SchemaReader schemaReader, Cube cube, List<Hierarchy> hierarchyList) {
            this.schemaReader = schemaReader;
            this.cube = cube;
            this.hierarchyList = hierarchyList;
            MondrianProperties props = MondrianProperties.instance();
            boolean load = ((RolapCube)cube).isLoadInProgress();
            this.ignoreInvalid = load ? props.IgnoreInvalidMembers.get() : props.IgnoreInvalidMembersDuringQuery.get();
        }

        protected Member resolveMember(Hierarchy expectedHierarchy) {
            List<Id.Segment> mondrianSegmentList = Util.convert(this.segmentList);
            Member member = (Member)Util.lookupCompound(this.schemaReader, this.cube, mondrianSegmentList, !this.ignoreInvalid, 6);
            if (member == null) {
                assert (this.ignoreInvalid);
                if (expectedHierarchy != null) {
                    return expectedHierarchy.getNullMember();
                }
                int i = mondrianSegmentList.size() - 1;
                while (i > 0) {
                    List<Id.Segment> partialName = mondrianSegmentList.subList(0, i);
                    OlapElement olapElement = this.schemaReader.lookupCompound(this.cube, partialName, false, 0);
                    if (olapElement != null) {
                        return olapElement.getHierarchy().getNullMember();
                    }
                    --i;
                }
                throw MondrianResource.instance().MdxChildObjectNotFound.ex(Util.implode(mondrianSegmentList), this.cube.getQualifiedName());
            }
            if (expectedHierarchy != null && member.getHierarchy() != expectedHierarchy) {
                throw Util.newInternal("member is of wrong hierarchy");
            }
            return member;
        }
    }

    public static class MemberListBuilder
    extends BuilderImpl {
        public final List<Member> memberList = new ArrayList<Member>();

        public MemberListBuilder(SchemaReader schemaReader, Cube cube, Hierarchy hierarchy) {
            super(schemaReader, cube, Collections.singletonList(hierarchy));
        }

        public void memberComplete() {
            Member member = this.resolveMember((Hierarchy)this.hierarchyList.get(0));
            if (!member.isNull()) {
                this.memberList.add(member);
            }
            this.segmentList.clear();
        }

        public void tupleComplete() {
        }
    }

    public static class TupleBuilder
    extends BuilderImpl {
        protected final List<Member> memberList = new ArrayList<Member>();

        public TupleBuilder(SchemaReader schemaReader, Cube cube, List<Hierarchy> hierarchyList) {
            super(schemaReader, cube, hierarchyList);
        }

        public void memberComplete() {
            super.memberComplete();
            if (this.memberList.size() >= this.hierarchyList.size()) {
                throw Util.newInternal("expected ')");
            }
            Hierarchy hierarchy = (Hierarchy)this.hierarchyList.get(this.memberList.size());
            Member member = this.resolveMember(hierarchy);
            this.memberList.add(member);
            this.segmentList.clear();
        }

        public void tupleComplete() {
            if (this.memberList.size() < this.hierarchyList.size()) {
                throw Util.newInternal("too few members");
            }
        }
    }

    public static class TupleListBuilder
    extends TupleBuilder {
        public final TupleList tupleList;

        public TupleListBuilder(SchemaReader schemaReader, Cube cube, List<Hierarchy> hierarchyList) {
            super(schemaReader, cube, hierarchyList);
            this.tupleList = new ArrayTupleList(hierarchyList.size());
        }

        @Override
        public void tupleComplete() {
            super.tupleComplete();
            if (!FunUtil.tupleContainsNullMember(this.memberList)) {
                this.tupleList.add(this.memberList);
            }
            this.memberList.clear();
        }
    }
}

