/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import mondrian.util.Base64;

public class LockBox {
    private static final Object DUMMY = new Object();
    private final Map<LockBoxEntryImpl, Object> map = new WeakHashMap<LockBoxEntryImpl, Object>();
    private final Random random = new Random();
    private final byte[] bytes = new byte[16];
    private long ordinal;

    private static Object wrap(Object o) {
        return o == null ? DUMMY : o;
    }

    private static Object unwrap(Object value) {
        return value == DUMMY ? null : value;
    }

    public synchronized Entry register(Object o) {
        String moniker = this.generateMoniker();
        LockBoxEntryImpl entry = new LockBoxEntryImpl(this, moniker);
        this.map.put(entry, LockBox.wrap(o));
        return entry;
    }

    private String generateMoniker() {
        this.random.nextBytes(this.bytes);
        String base64 = Base64.encodeBytes(this.bytes);
        while (base64.endsWith("=")) {
            base64 = base64.substring(0, base64.length() - 1);
        }
        base64 = base64.replace('/', '$');
        base64 = base64.replace('+', '_');
        return "$" + Long.toHexString(++this.ordinal) + base64;
    }

    public synchronized boolean deregister(Entry entry) {
        return this.map.remove(entry) != null;
    }

    public synchronized Entry get(String moniker) {
        for (LockBoxEntryImpl entry : this.map.keySet()) {
            if (!entry.moniker.equals(moniker)) continue;
            return entry;
        }
        return null;
    }

    public static interface Entry {
        public Object getValue();

        public String getMoniker();

        public boolean isRegistered();
    }

    private static class LockBoxEntryImpl
    implements Entry {
        private final LockBox lockBox;
        private final String moniker;

        private LockBoxEntryImpl(LockBox lockBox, String moniker) {
            this.lockBox = lockBox;
            this.moniker = moniker;
        }

        @Override
        public Object getValue() {
            Object value = this.lockBox.map.get(this);
            if (value == null) {
                throw new RuntimeException("LockBox has no entry with moniker [" + this.moniker + "]");
            }
            return LockBox.unwrap(value);
        }

        @Override
        public String getMoniker() {
            return this.moniker;
        }

        @Override
        public boolean isRegistered() {
            return this.lockBox.map.containsKey(this);
        }
    }
}

