/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import mondrian.util.DigitList;

class MondrianFloatingDecimal {
    boolean isExceptional;
    boolean isNegative;
    int decExponent;
    char[] digits;
    int nDigits;
    private final DigitList digitList = new DigitList();
    private final DigitList expDigitList = new DigitList();
    private static final int MAX_SIGNIFICANT_DIGITS = 19;

    public MondrianFloatingDecimal(double d) {
        if (d < 0.0) {
            this.isNegative = true;
            d = -d;
        } else {
            this.isNegative = false;
        }
        this.digitList.set(d, 19, true);
        this.nDigits = 0;
        int i = 0;
        while (i < this.digitList.digits.length) {
            if (this.digitList.digits[i] != 0) {
                ++this.nDigits;
            }
            ++i;
        }
        this.digits = this.toCharArray(this.digitList.digits);
        this.isExceptional = Double.isInfinite(d);
        this.decExponent = this.digitList.decimalAt;
    }

    public String toString() {
        StringBuilder s = new StringBuilder(19);
        if (this.nDigits == 0) {
            return "0";
        }
        if (this.isNegative) {
            s.append("-");
        }
        if (this.decExponent < -5) {
            s.append('.').append(this.digits).append("E-").append(this.decExponent);
        } else if (this.decExponent < 0) {
            s.append('.');
            int i = 0;
            while (i < this.decExponent) {
                s.append('0');
                ++i;
            }
            s.append(this.digits);
        } else if (this.decExponent < this.nDigits) {
            s.append(this.digits, 0, this.decExponent).append(".").append(this.digits, this.decExponent, this.nDigits - this.decExponent);
        } else if (this.decExponent == this.nDigits) {
            s.append(this.digits);
        } else if (this.decExponent < this.nDigits + 10) {
            s.append(this.digits);
            int i = 0;
            while (i < this.decExponent - this.nDigits) {
                s.append('0');
                ++i;
            }
        } else {
            s.append('.').append(this.digits).append("E").append(this.decExponent);
        }
        return s.toString();
    }

    public int formatExponent(char[] result, int i, boolean expSign, int minExpDigits) {
        int j;
        int useExp = this.nDigits == 0 ? 0 : this.decExponent - 1;
        this.expDigitList.set(Math.abs(useExp));
        if (useExp < 0 || expSign) {
            int n = result[i++] = useExp < 0 ? 45 : 43;
        }
        if (minExpDigits > this.expDigitList.decimalAt) {
            j = 0;
            while (j < minExpDigits - this.expDigitList.decimalAt) {
                result[i++] = 48;
                ++j;
            }
        }
        j = 0;
        while (j < this.expDigitList.decimalAt) {
            result[i++] = (char)this.expDigitList.digits[j];
            ++j;
        }
        return i;
    }

    private char[] toCharArray(byte[] bytes) {
        char[] chars = new char[bytes.length];
        int i = 0;
        while (i < bytes.length) {
            chars[i] = (char)bytes[i];
            ++i;
        }
        return chars;
    }
}

