/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import mondrian.util.PrimeFinder;

public class ObjectPool<T> {
    protected static final byte FREE = 0;
    protected static final byte FULL = 1;
    protected static final int DEFAULT_CAPACITY = 277;
    protected static final double DEFAULT_MIN_LOAD_FACTOR = 0.2;
    protected static final double DEFAULT_MAX_LOAD_FACTOR = 0.5;
    protected int distinct;
    protected int highWaterMark;
    protected double minLoadFactor;
    protected double maxLoadFactor;
    protected T[] values;
    protected int freeEntries;

    public ObjectPool() {
        this(277);
    }

    public ObjectPool(int initialCapacity) {
        this(initialCapacity, 0.2, 0.5);
    }

    public ObjectPool(int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        this.setUp(initialCapacity, minLoadFactor, maxLoadFactor);
    }

    public int size() {
        return this.distinct;
    }

    public void trimToSize() {
        int newCapacity = this.nextPrime((int)(1.0 + 1.2 * (double)this.size()));
        if (this.values.length > newCapacity) {
            this.rehash(newCapacity);
        }
    }

    public boolean contains(T key) {
        int i = this.indexOfInsertion(key);
        return i < 0;
    }

    public T add(T key) {
        int i = this.indexOfInsertion(key);
        if (i < 0) {
            i = -i - 1;
            return this.values[i];
        }
        if (this.distinct > this.highWaterMark) {
            int newCapacity = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
            return this.add(key);
        }
        T v = this.values[i];
        this.values[i] = key;
        if (v == null) {
            --this.freeEntries;
        }
        ++this.distinct;
        if (this.freeEntries < 1) {
            int newCapacity = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
        }
        return key;
    }

    public void clear() {
        this.values = new Object[this.values.length];
        this.distinct = 0;
        this.freeEntries = this.values.length;
        this.trimToSize();
    }

    public Iterator<T> iterator() {
        return new Itr();
    }

    protected int chooseGrowCapacity(int size, double minLoad, double maxLoad) {
        return this.nextPrime(Math.max(size + 1, (int)((double)(4 * size) / (3.0 * minLoad + maxLoad))));
    }

    protected final int chooseHighWaterMark(int capacity, double maxLoad) {
        return Math.min(capacity - 2, (int)((double)capacity * maxLoad));
    }

    protected final int chooseLowWaterMark(int capacity, double minLoad) {
        return (int)((double)capacity * minLoad);
    }

    protected int nextPrime(int desiredCapacity) {
        return PrimeFinder.nextPrime(desiredCapacity);
    }

    protected void setUp(int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        int capacity = initialCapacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Initial Capacity must not be less than zero: " + initialCapacity);
        }
        if (minLoadFactor < 0.0 || minLoadFactor >= 1.0) {
            throw new IllegalArgumentException("Illegal minLoadFactor: " + minLoadFactor);
        }
        if (maxLoadFactor <= 0.0 || maxLoadFactor >= 1.0) {
            throw new IllegalArgumentException("Illegal maxLoadFactor: " + maxLoadFactor);
        }
        if (minLoadFactor >= maxLoadFactor) {
            throw new IllegalArgumentException("Illegal minLoadFactor: " + minLoadFactor + " and maxLoadFactor: " + maxLoadFactor);
        }
        if ((capacity = this.nextPrime(capacity)) == 0) {
            capacity = 1;
        }
        this.values = new Object[capacity];
        this.minLoadFactor = minLoadFactor;
        this.maxLoadFactor = capacity == Integer.MAX_VALUE ? 1.0 : maxLoadFactor;
        this.distinct = 0;
        this.freeEntries = capacity;
        this.highWaterMark = this.chooseHighWaterMark(capacity, this.maxLoadFactor);
    }

    protected int hash(T key) {
        return key == null ? 0 : key.hashCode();
    }

    protected boolean equals(T t, T key) {
        return t != null && t.equals(key);
    }

    protected int indexOfInsertion(T key) {
        T[] tab = this.values;
        int length = tab.length;
        int hash = key.hashCode() & Integer.MAX_VALUE;
        int i = hash % length;
        int decrement = hash % (length - 2);
        if (decrement == 0) {
            decrement = 1;
        }
        T v = tab[i];
        while (v != null && !v.equals(key)) {
            if ((i -= decrement) < 0) {
                i += length;
            }
            v = tab[i];
        }
        return v != null ? -i - 1 : i;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this.values.length;
        T[] oldValues = this.values;
        Object[] newValues = new Object[newCapacity];
        this.highWaterMark = this.chooseHighWaterMark(newCapacity, this.maxLoadFactor);
        this.values = newValues;
        this.freeEntries = newCapacity - this.distinct;
        int i = oldCapacity;
        while (i-- > 0) {
            T v = oldValues[i];
            if (v == null) continue;
            int index = this.indexOfInsertion(v);
            newValues[index] = v;
        }
    }

    private class Itr
    implements Iterator<T> {
        int index = 0;

        Itr() {
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean hasNext() {
            if (this.index != ObjectPool.this.values.length) ** GOTO lbl6
            return false;
lbl-1000:
            // 1 sources

            {
                ++this.index;
                if (this.index != ObjectPool.this.values.length) continue;
                return false;
lbl6:
                // 2 sources

                ** while (ObjectPool.this.values[this.index] == null)
            }
lbl7:
            // 1 sources

            return ObjectPool.this.values[this.index] != null;
        }

        @Override
        public T next() {
            if (this.index >= ObjectPool.this.values.length) {
                throw new NoSuchElementException();
            }
            return ObjectPool.this.values[this.index++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("ObjectPool.Itr.remove");
        }
    }
}

