/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eigenbase.util.property.BooleanProperty;
import org.eigenbase.util.property.DoubleProperty;
import org.eigenbase.util.property.IntegerProperty;
import org.eigenbase.util.property.Property;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PropertyUtil {
    public static void main0(String[] args) throws IllegalAccessException {
        Object properties1 = null;
        System.out.println("<PropertyDefinitions>");
        Field[] fieldArray = properties1.getClass().getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            Property o = (Property)field.get(properties1);
            System.out.println("    <PropertyDefinition>");
            System.out.println("        <Name>" + field.getName() + "</Name>");
            System.out.println("        <Path>" + o.getPath() + "</Path>");
            System.out.println("        <Description>" + o.getPath() + "</Description>");
            System.out.println("        <Type>" + (o instanceof BooleanProperty ? "boolean" : (o instanceof IntegerProperty ? "int" : (o instanceof DoubleProperty ? "double" : "String"))) + "</Type>");
            if (o.getDefaultValue() != null) {
                System.out.println("        <Default>" + o.getDefaultValue() + "</Default" + ">");
            }
            System.out.println("    </PropertyDefinition>");
            ++n2;
        }
        System.out.println("</PropertyDefinitions>");
    }

    private static Iterable<Node> iter(final NodeList nodeList) {
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                return new Iterator<Node>(){
                    int pos = 0;

                    @Override
                    public boolean hasNext() {
                        return this.pos < nodeList.getLength();
                    }

                    @Override
                    public Node next() {
                        return nodeList.item(this.pos++);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static void main(String[] args) {
        try {
            new PropertyUtil().generate();
        }
        catch (Throwable e) {
            System.out.println("Error while generating properties files.");
            e.printStackTrace();
        }
    }

    private void generate() {
        TreeMap<String, PropertyDef> propertyDefinitionMap;
        File xmlFile = new File("src/main/mondrian/olap", "MondrianProperties.xml");
        File javaFile = new File("src/main/mondrian/olap", "MondrianProperties.java");
        File propertiesFile = new File("mondrian.properties.template");
        File htmlFile = new File("doc", "properties.html");
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            dbf.setExpandEntityReferences(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(xmlFile);
            Element documentElement = doc.getDocumentElement();
            assert (documentElement.getNodeName().equals("PropertyDefinitions"));
            NodeList propertyDefinitions = documentElement.getChildNodes();
            propertyDefinitionMap = new TreeMap<String, PropertyDef>();
            for (Node element : PropertyUtil.iter(propertyDefinitions)) {
                if (!element.getNodeName().equals("PropertyDefinition")) continue;
                String name = PropertyUtil.getChildCdata(element, "Name");
                String dflt = PropertyUtil.getChildCdata(element, "Default");
                String type = PropertyUtil.getChildCdata(element, "Type");
                String path = PropertyUtil.getChildCdata(element, "Path");
                String category = PropertyUtil.getChildCdata(element, "Category");
                String core = PropertyUtil.getChildCdata(element, "Core");
                String description = PropertyUtil.getChildCdata(element, "Description");
                propertyDefinitionMap.put(name, new PropertyDef(name, path, dflt, category, PropertyType.valueOf(type.toUpperCase()), core == null || Boolean.valueOf(core) != false, description));
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Error while parsing " + xmlFile, e);
        }
        this.doGenerate(Generator.JAVA, propertyDefinitionMap, javaFile);
        this.doGenerate(Generator.HTML, propertyDefinitionMap, htmlFile);
        this.doGenerate(Generator.PROPERTIES, propertyDefinitionMap, propertiesFile);
    }

    void doGenerate(Generator generator, SortedMap<String, PropertyDef> propertyDefinitionMap, File file) {
        OutputStreamWriter fw = null;
        PrintWriter out = null;
        boolean success = false;
        try {
            try {
                System.out.println("Generating " + file);
                if (file.getParentFile() != null) {
                    file.getParentFile().mkdirs();
                }
                fw = new FileWriter(file);
                out = new PrintWriter(fw);
                generator.generate(propertyDefinitionMap, file, out);
                out.close();
                fw.close();
                success = true;
            }
            catch (Throwable e) {
                throw new RuntimeException("Error while generating " + file, e);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException iOException) {}
            }
            if (!success) {
                file.delete();
            }
        }
    }

    private static final void printLines(PrintWriter out, String[] lines) {
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            out.println(line);
            ++n2;
        }
    }

    private static void printJavadoc(PrintWriter out, String prefix, String content) {
        out.println(String.valueOf(prefix) + "/**");
        PropertyUtil.printComments(out, prefix, " *", PropertyUtil.wrapText(content));
        out.println(String.valueOf(prefix) + " */");
    }

    private static void printComments(PrintWriter out, String offset, String prefix, List<String> strings) {
        for (String line : strings) {
            if (line.length() > 0) {
                out.println(String.valueOf(offset) + prefix + " " + line);
                continue;
            }
            out.println(String.valueOf(offset) + prefix);
        }
    }

    private static String quoteHtml(String s) {
        return s.replaceAll("&", "&amp;").replaceAll(">", "&gt;").replaceAll("<", "&lt;");
    }

    private static String stripHtml(String s) {
        String[] strings;
        s = s.replaceAll("<li>", "<li>* ");
        s = s.replaceAll("<h3>", "<h3>### ");
        s = s.replaceAll("</h3>", " ###</h3>");
        String[] stringArray = strings = new String[]{"p", "code", "br", "ul", "li", "blockquote", "h3", "i"};
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            s = s.replaceAll("<" + string + "/>", "");
            s = s.replaceAll("<" + string + ">", "");
            s = s.replaceAll("</" + string + ">", "");
            ++n2;
        }
        s = PropertyUtil.replaceRegion(s, "{@code ", "}");
        s = PropertyUtil.replaceRegion(s, "{@link ", "}");
        s = s.replaceAll("&amp;", "&");
        s = s.replaceAll("&lt;", "<");
        s = s.replaceAll("&gt;", ">");
        return s;
    }

    private static String replaceRegion(String s, String start, String end) {
        int i = 0;
        while ((i = s.indexOf(start, i)) >= 0) {
            int j = s.indexOf(end, i);
            if (j < 0) break;
            s = String.valueOf(s.substring(0, i)) + s.substring(i + start.length(), j) + s.substring(j + 1);
            i = j - start.length() - end.length();
        }
        return s;
    }

    private static List<String> wrapText(String description) {
        description = description.trim();
        return Arrays.asList(description.split("\n"));
    }

    private static String getChildCdata(Node element, String name) {
        for (Node node : PropertyUtil.iter(element.getChildNodes())) {
            if (!node.getNodeName().equals(name)) continue;
            StringBuilder buf = new StringBuilder();
            PropertyUtil.textRecurse(node, buf);
            return buf.toString();
        }
        return null;
    }

    private static void textRecurse(Node node, StringBuilder buf) {
        for (Node node1 : PropertyUtil.iter(node.getChildNodes())) {
            if (node1.getNodeType() == 4 || node1.getNodeType() == 3) {
                buf.append(PropertyUtil.quoteHtml(node1.getTextContent()));
            }
            if (node1.getNodeType() != 1) continue;
            buf.append("<").append(node1.getNodeName()).append(">");
            PropertyUtil.textRecurse(node1, buf);
            buf.append("</").append(node1.getNodeName()).append(">");
        }
    }

    static enum Generator {
        JAVA{

            @Override
            void generate(SortedMap<String, PropertyDef> propertyDefinitionMap, File file, PrintWriter out) {
                out.println("// Generated from MondrianProperties.xml.");
                out.println("package mondrian.olap;");
                out.println();
                out.println("import org.eigenbase.util.property.*;");
                out.println("import java.io.File;");
                out.println();
                PropertyUtil.printJavadoc(out, "", "Configuration properties that determine the\nbehavior of a mondrian instance.\n\n<p>There is a method for property valid in a\n<code>mondrian.properties</code> file. Although it is possible to retrieve\nproperties using the inherited {@link java.util.Properties#getProperty(String)}\nmethod, we recommend that you use methods in this class.</p>\n");
                String[] lines = new String[]{"public class MondrianProperties extends MondrianPropertiesBase {", "    /**", "     * Properties, drawn from {@link System#getProperties},", "     * plus the contents of \"mondrian.properties\" if it", "     * exists. A singleton.", "     */", "    private static final MondrianProperties instance =", "        new MondrianProperties();", "", "    private MondrianProperties() {", "        super(", "            new FilePropertySource(", "                new File(mondrianDotProperties)));", "        populate();", "    }", "", "    /**", "     * Returns the singleton.", "     *", "     * @return Singleton instance", "     */", "    public static MondrianProperties instance() {", "        // NOTE: We used to instantiate on demand, but", "        // synchronization overhead was significant. See", "        // MONDRIAN-978.", "        return instance;", "    }", ""};
                PropertyUtil.printLines(out, lines);
                for (PropertyDef def : propertyDefinitionMap.values()) {
                    if (!def.core) continue;
                    PropertyUtil.printJavadoc(out, "    ", def.description);
                    out.println("    public transient final " + ((PropertyDef)def).propertyType.className + " " + def.name + " =");
                    out.println("        new " + ((PropertyDef)def).propertyType.className + "(");
                    out.println("            this, \"" + def.path + "\", " + def.defaultJava() + ");");
                    out.println();
                }
                out.println("}");
                out.println();
                out.println("// End MondrianProperties.java");
            }
        }
        ,
        HTML{

            @Override
            void generate(SortedMap<String, PropertyDef> propertyDefinitionMap, File file, PrintWriter out) {
                out.println("<table>");
                out.println("    <tr>");
                out.println("    <td><strong>Property</strong></td>");
                out.println("    <td><strong>Type</strong></td>");
                out.println("    <td><strong>Default value</strong></td>");
                out.println("    <td><strong>Description</strong></td>");
                out.println("    </tr>");
                TreeSet<String> categories = new TreeSet<String>();
                for (PropertyDef def : propertyDefinitionMap.values()) {
                    categories.add(def.category);
                }
                for (String category : categories) {
                    out.println("    <tr>");
                    out.println("      <td colspan='4'><b><br>" + category + "</b" + "></td>");
                    out.println("    </tr>");
                    for (PropertyDef def : propertyDefinitionMap.values()) {
                        if (!def.category.equals(category)) continue;
                        out.println("    <tr>");
                        out.println("<td><code><a href='api/mondrian/olap/MondrianProperties.html#" + def.name + "'>" + this.split(def.path) + "</a></code></td>");
                        out.println("<td>" + def.propertyType.name().toLowerCase() + "</td>");
                        out.println("<td>" + this.split(def.defaultHtml()) + "</td>");
                        out.println("<td>" + this.split(def.description) + "</td>");
                        out.println("    </tr>");
                    }
                }
                out.println("<table>");
            }

            String split(String s) {
                if (!(s = s.replaceAll("([,;=.])", "&shy;$1&shy;")).contains("<")) {
                    s = s.replaceAll("(/)", "&shy;$1&shy;");
                }
                return s;
            }
        }
        ,
        PROPERTIES{

            @Override
            void generate(SortedMap<String, PropertyDef> propertyDefinitionMap, File file, PrintWriter out) {
                PropertyUtil.printComments(out, "", "#", PropertyUtil.wrapText("This software is subject to the terms of the Eclipse Public License v1.0\nAgreement, available at the following URL:\nhttp://www.eclipse.org/legal/epl-v10.html.\nYou must accept the terms of that agreement to use this software.\n\nCopyright (C) 2001-2005 Julian Hyde\nCopyright (C) 2005-2011 Pentaho and others\nAll Rights Reserved."));
                out.println();
                char[] chars = new char[79];
                Arrays.fill(chars, '#');
                String commentLine = new String(chars);
                for (PropertyDef def : propertyDefinitionMap.values()) {
                    out.println(commentLine);
                    PropertyUtil.printComments(out, "", "#", PropertyUtil.wrapText(PropertyUtil.stripHtml(def.description)));
                    out.println("#");
                    out.println("#" + def.path + "=" + (def.defaultValue == null ? "" : def.defaultValue));
                    out.println();
                }
                PropertyUtil.printComments(out, "", "#", PropertyUtil.wrapText("End " + file.getName()));
            }
        };


        abstract void generate(SortedMap<String, PropertyDef> var1, File var2, PrintWriter var3);
    }

    private static class PropertyDef {
        private final String name;
        private final String defaultValue;
        private final String category;
        private final PropertyType propertyType;
        private final boolean core;
        private final String description;
        private final String path;

        PropertyDef(String name, String path, String defaultValue, String category, PropertyType propertyType, boolean core, String description) {
            this.name = name;
            this.path = path;
            this.defaultValue = defaultValue;
            this.category = category == null ? "Miscellaneous" : category;
            this.propertyType = propertyType;
            this.core = core;
            this.description = description;
        }

        public String defaultJava() {
            switch (this.propertyType) {
                case STRING: {
                    if (this.defaultValue == null) {
                        return "null";
                    }
                    return "\"" + this.defaultValue.replaceAll("\"", "\\\"") + "\"";
                }
            }
            return this.defaultValue;
        }

        public String defaultHtml() {
            if (this.defaultValue == null) {
                return "-";
            }
            switch (this.propertyType) {
                case INT: 
                case DOUBLE: {
                    return new DecimalFormat("#,###.#").format(new BigDecimal(this.defaultValue));
                }
            }
            return this.defaultValue;
        }
    }

    private static enum PropertyType {
        INT("IntegerProperty"),
        STRING("StringProperty"),
        DOUBLE("DoubleProperty"),
        BOOLEAN("BooleanProperty");

        public final String className;

        private PropertyType(String className) {
            this.className = className;
        }
    }
}

