/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import mondrian.olap.Util;
import mondrian.util.UnsupportedList;

public class TraversalList<T>
extends UnsupportedList<List<T>> {
    private boolean asInternalArray = false;
    private List<T>[] internalArray = null;
    private final List<T>[] lists;
    private final Class<T> clazz;
    private final T[] tmpArray;

    public TraversalList(List<T>[] lists, Class<T> clazz) {
        this.lists = lists;
        this.clazz = clazz;
        this.tmpArray = (Object[])Array.newInstance(clazz, lists.length);
    }

    @Override
    public List<T> get(int index) {
        if (this.asInternalArray) {
            return this.internalArray[index];
        }
        int i = 0;
        while (i < this.lists.length) {
            this.tmpArray[i] = this.lists[i].get(index);
            ++i;
        }
        return Util.flatList((Object[])this.tmpArray.clone());
    }

    @Override
    public Iterator<List<T>> iterator() {
        return new Iterator<List<T>>(){
            private int currentIndex = 0;
            private List<T> precalculated;

            @Override
            public List<T> next() {
                if (this.precalculated != null) {
                    List t = this.precalculated;
                    this.precalculated = null;
                    ++this.currentIndex;
                    return t;
                }
                return TraversalList.this.get(this.currentIndex++);
            }

            @Override
            public boolean hasNext() {
                try {
                    this.precalculated = TraversalList.this.get(this.currentIndex);
                    return true;
                }
                catch (IndexOutOfBoundsException e) {
                    return false;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public ListIterator<List<T>> listIterator(int index) {
        return new UnsupportedList.ListItr(this, index){

            @Override
            public void set(List<T> l) {
                TraversalList.this.set(this.cursor - 1, l);
            }
        };
    }

    @Override
    public ListIterator<List<T>> listIterator() {
        return new UnsupportedList.ListItr(this, 0){

            @Override
            public void set(List<T> l) {
                TraversalList.this.set(this.cursor - 1, l);
            }
        };
    }

    @Override
    public int size() {
        return this.lists[0].size();
    }

    @Override
    public List<List<T>> subList(final int first, final int last) {
        return new AbstractList<List<T>>(){

            @Override
            public List<T> get(int index) {
                return TraversalList.this.get(index + first);
            }

            @Override
            public int size() {
                return last - first;
            }
        };
    }

    private List<T>[] materialize(List<T>[] a) {
        List[] array = a != null && a.length == this.size() && a.getClass().getComponentType() == this.clazz ? a : new List[this.size()];
        int k = 0;
        for (List<T> x : this) {
            array[k++] = x;
        }
        this.asInternalArray = true;
        this.internalArray = array;
        return array;
    }

    @Override
    public <S> S[] toArray(S[] a) {
        return this.materialize((List[])a);
    }

    @Override
    public Object[] toArray() {
        return this.materialize(null);
    }

    @Override
    public List<T> set(int index, List<T> l) {
        if (this.asInternalArray) {
            List<T> previous = this.internalArray[index];
            this.internalArray[index] = l;
            return previous;
        }
        throw new UnsupportedOperationException();
    }
}

