/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import mondrian.olap.Util;

public class UnionIterator<T>
implements Iterator<T> {
    private final Iterator<Iterable<? extends T>> iterableIterator;
    private Iterator<? extends T> iterator;

    public UnionIterator(Iterable<? extends T> ... iterables) {
        List<Iterable<T>> list;
        if (Util.Retrowoven) {
            list = new ArrayList<Iterable<? extends T>>(iterables.length);
            Iterable<? extends T>[] iterableArray = iterables;
            int n = iterables.length;
            int n2 = 0;
            while (n2 < n) {
                Iterable<? extends T> iterable = iterableArray[n2];
                list.add(new MyIterable<T>(iterable));
                ++n2;
            }
        } else {
            list = Arrays.asList(iterables);
        }
        this.iterableIterator = list.iterator();
        this.moveToNext();
    }

    public UnionIterator(Collection<? extends T> ... iterables) {
        ArrayList<MyIterable<? extends T>> list = new ArrayList<MyIterable<? extends T>>(iterables.length);
        Collection<? extends T>[] collectionArray = iterables;
        int n = iterables.length;
        int n2 = 0;
        while (n2 < n) {
            Collection<? extends T> iterable = collectionArray[n2];
            list.add(new MyIterable<T>(iterable));
            ++n2;
        }
        this.iterableIterator = list.iterator();
        this.moveToNext();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public T next() {
        T t = this.iterator.next();
        if (!this.iterator.hasNext()) {
            this.moveToNext();
        }
        return t;
    }

    private void moveToNext() {
        do {
            if (!this.iterableIterator.hasNext()) {
                this.iterator = Collections.emptyList().iterator();
                break;
            }
            this.iterator = this.iterableIterator.next().iterator();
        } while (!this.iterator.hasNext());
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    public static <T> Iterable<T> over(final Iterable<? extends T> ... iterables) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new UnionIterator(iterables);
            }
        };
    }

    public static <T> Iterable<T> over(final Collection<? extends T> ... collections) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new UnionIterator(collections);
            }
        };
    }

    private static class MyIterable<T>
    implements Iterable {
        private final Iterable<T> iterable;

        public MyIterable(Iterable<T> iterable) {
            this.iterable = iterable;
        }

        @Override
        public Iterator<T> iterator() {
            return this.iterable.iterator();
        }
    }
}

