/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapUtil;
import mondrian.util.UtilCompatible;
import org.apache.log4j.Logger;

public class UtilCompatibleJdk14
implements UtilCompatible {
    private static final Logger LOGGER = Logger.getLogger(Util.class);
    private static String previousUuid = "";
    private static final String UUID_BASE = Long.toHexString(new Random().nextLong());

    @Override
    public BigDecimal makeBigDecimalFromDouble(double d) {
        return new BigDecimal(d);
    }

    @Override
    public String quotePattern(String s) {
        int slashEIndex = s.indexOf("\\E");
        if (slashEIndex == -1) {
            return "\\Q" + s + "\\E";
        }
        StringBuilder sb = new StringBuilder(s.length() * 2);
        sb.append("\\Q");
        int current = 0;
        while ((slashEIndex = s.indexOf("\\E", current)) != -1) {
            sb.append(s.substring(current, slashEIndex));
            current = slashEIndex + 2;
            sb.append("\\E\\\\E\\Q");
        }
        sb.append(s.substring(current, s.length()));
        sb.append("\\E");
        return sb.toString();
    }

    @Override
    public <T> T getAnnotation(Method method, String annotationClassName, T defaultValue) {
        return defaultValue;
    }

    @Override
    public String generateUuidString() {
        return UtilCompatibleJdk14.generateUuidStringStatic();
    }

    public static synchronized String generateUuidStringStatic() {
        while (true) {
            String uuid;
            if (!(uuid = String.valueOf(UUID_BASE) + Long.toHexString(System.currentTimeMillis())).equals(previousUuid)) {
                previousUuid = uuid;
                return uuid;
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public <T> T compileScript(Class<T> iface, String script, String engineName) {
        throw new UnsupportedOperationException("Scripting not supported until Java 1.6");
    }

    @Override
    public <T> void threadLocalRemove(ThreadLocal<T> threadLocal) {
    }

    @Override
    public Util.MemoryInfo getMemoryInfo() {
        return new Util.MemoryInfo(){

            @Override
            public Util.MemoryInfo.Usage get() {
                return new Util.MemoryInfo.Usage(){

                    @Override
                    public long getUsed() {
                        return 0L;
                    }

                    @Override
                    public long getCommitted() {
                        return 0L;
                    }

                    @Override
                    public long getMax() {
                        return 0L;
                    }
                };
            }
        };
    }

    @Override
    public Timer newTimer(String name, boolean isDaemon) {
        return new Timer(isDaemon);
    }

    @Override
    public void cancelAndCloseStatement(Statement stmt) {
        block6: {
            block5: {
                try {
                    stmt.cancel();
                }
                catch (SQLException e) {
                    if (e.getMessage().equals("org.apache.commons.dbcp.DelegatingStatement is closed.")) {
                        return;
                    }
                    if (!LOGGER.isDebugEnabled()) break block5;
                    LOGGER.debug((Object)MondrianResource.instance().ExecutionStatementCleanupException.ex(e.getMessage(), e), (Throwable)e);
                }
            }
            try {
                stmt.close();
            }
            catch (SQLException e) {
                if (!LOGGER.isDebugEnabled()) break block6;
                LOGGER.debug((Object)MondrianResource.instance().ExecutionStatementCleanupException.ex(e.getMessage(), e), (Throwable)e);
            }
        }
    }

    @Override
    public <T> Set<T> newIdentityHashSet() {
        return Util.newIdentityHashSetFake();
    }

    @Override
    public <T extends Comparable<T>> int binarySearch(T[] ts, int start, int end, T t) {
        return Collections.binarySearch(Arrays.asList(ts).subList(start, end), t, RolapUtil.ROLAP_COMPARATOR);
    }
}

