/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapUtil;
import mondrian.util.UtilCompatibleJdk15;
import org.apache.log4j.Logger;

public class UtilCompatibleJdk16
extends UtilCompatibleJdk15 {
    private static final Logger LOGGER = Logger.getLogger(Util.class);

    @Override
    public <T> T compileScript(Class<T> iface, String script, String engineName) {
        ScriptEngineManager factory = new ScriptEngineManager();
        ScriptEngine engine = factory.getEngineByName(engineName);
        try {
            engine.eval(script);
            Invocable inv = (Invocable)((Object)engine);
            return inv.getInterface(iface);
        }
        catch (ScriptException e) {
            throw Util.newError(e, "Error while compiling script to implement " + iface + " SPI");
        }
    }

    @Override
    public void cancelAndCloseStatement(Statement stmt) {
        block5: {
            block4: {
                try {
                    stmt.cancel();
                }
                catch (SQLException e) {
                    if (!LOGGER.isDebugEnabled()) break block4;
                    LOGGER.debug((Object)MondrianResource.instance().ExecutionStatementCleanupException.ex(e.getMessage(), e), (Throwable)e);
                }
            }
            try {
                stmt.close();
            }
            catch (SQLException e) {
                if (!LOGGER.isDebugEnabled()) break block5;
                LOGGER.debug((Object)MondrianResource.instance().ExecutionStatementCleanupException.ex(e.getMessage(), e), (Throwable)e);
            }
        }
    }

    @Override
    public <T> Set<T> newIdentityHashSet() {
        return Collections.newSetFromMap(new IdentityHashMap());
    }

    @Override
    public <T extends Comparable<T>> int binarySearch(T[] ts, int start, int end, T t) {
        return Arrays.binarySearch(ts, start, end, t, RolapUtil.ROLAP_COMPARATOR);
    }
}

