/*
 * Decompiled with CFR 0.152.
 */
package mondrian.xmla;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mondrian.olap.Util;
import mondrian.xmla.PropertyDefinition;
import mondrian.xmla.RowsetDefinition;
import mondrian.xmla.SaxWriter;
import mondrian.xmla.XmlaConstants;
import mondrian.xmla.XmlaException;
import mondrian.xmla.XmlaHandler;
import mondrian.xmla.XmlaRequest;
import mondrian.xmla.XmlaResponse;
import mondrian.xmla.XmlaUtil;
import org.apache.log4j.Logger;
import org.olap4j.OlapConnection;
import org.olap4j.impl.LcidLocale;
import org.olap4j.metadata.Catalog;

abstract class Rowset
implements XmlaConstants {
    protected static final Logger LOGGER = Logger.getLogger(Rowset.class);
    protected final RowsetDefinition rowsetDefinition;
    protected final Map<String, Object> restrictions;
    protected final Map<String, String> properties;
    protected final Map<String, String> extraProperties = new HashMap<String, String>();
    protected final XmlaRequest request;
    protected final XmlaHandler handler;
    private final RowsetDefinition.Column[] restrictedColumns;
    protected final boolean deep;

    Rowset(RowsetDefinition definition, XmlaRequest request, XmlaHandler handler) {
        this.rowsetDefinition = definition;
        this.restrictions = request.getRestrictions();
        this.properties = request.getProperties();
        this.request = request;
        this.handler = handler;
        ArrayList<RowsetDefinition.Column> list = new ArrayList<RowsetDefinition.Column>();
        for (Map.Entry<String, Object> restrictionEntry : this.restrictions.entrySet()) {
            String restrictedColumn = restrictionEntry.getKey();
            LOGGER.debug((Object)("Rowset<init>: restrictedColumn=\"" + restrictedColumn + "\""));
            RowsetDefinition.Column column = definition.lookupColumn(restrictedColumn);
            if (column == null) {
                throw Util.newError("Rowset '" + definition.name() + "' does not contain column '" + restrictedColumn + "'");
            }
            if (!column.restriction) {
                throw Util.newError("Rowset '" + definition.name() + "' column '" + restrictedColumn + "' does not allow restrictions");
            }
            Object restriction = restrictionEntry.getValue();
            if (restriction instanceof List && ((List)restriction).size() > 1) {
                RowsetDefinition.Type type = column.type;
                switch (type) {
                    case StringArray: 
                    case EnumerationArray: 
                    case StringSometimesArray: {
                        break;
                    }
                    default: {
                        throw Util.newError("Rowset '" + definition.name() + "' column '" + restrictedColumn + "' can only be restricted on one value at a time");
                    }
                }
            }
            list.add(column);
        }
        list = this.pruneRestrictions(list);
        this.restrictedColumns = list.toArray(new RowsetDefinition.Column[list.size()]);
        boolean deep = false;
        for (Map.Entry<String, String> propertyEntry : this.properties.entrySet()) {
            String propertyName = propertyEntry.getKey();
            PropertyDefinition propertyDef = Util.lookup(PropertyDefinition.class, propertyName);
            if (propertyDef == null) {
                throw Util.newError("Rowset '" + definition.name() + "' does not support property '" + propertyName + "'");
            }
            String propertyValue = propertyEntry.getValue();
            this.setProperty(propertyDef, propertyValue);
            if (propertyDef != PropertyDefinition.Deep) continue;
            deep = Boolean.valueOf(propertyValue);
        }
        this.deep = deep;
    }

    protected ArrayList<RowsetDefinition.Column> pruneRestrictions(ArrayList<RowsetDefinition.Column> list) {
        return list;
    }

    protected void setProperty(PropertyDefinition propertyDef, String value) {
        switch (propertyDef) {
            case Format: {
                break;
            }
            case DataSourceInfo: {
                break;
            }
            case Catalog: {
                break;
            }
            case LocaleIdentifier: {
                if (value != null) {
                    try {
                        short lcid = Short.valueOf(value);
                        Locale locale = LcidLocale.lcidToLocale((short)lcid);
                        if (locale != null) {
                            this.extraProperties.put("locale", locale.toString());
                            return;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        try {
                            Locale locale = Util.parseLocale(value);
                            this.extraProperties.put("locale", locale.toString());
                            return;
                        }
                        catch (RuntimeException runtimeException) {
                            // empty catch block
                        }
                    }
                    return;
                }
            }
            default: {
                LOGGER.warn((Object)("Warning: Rowset '" + this.rowsetDefinition.name() + "' does not support property '" + propertyDef.name() + "' (value is '" + value + "')"));
            }
        }
    }

    public final void unparse(XmlaResponse response) throws XmlaException, SQLException {
        ArrayList<Row> rows = new ArrayList<Row>();
        this.populate(response, null, rows);
        Comparator<Row> comparator = this.rowsetDefinition.getComparator();
        if (comparator != null) {
            Collections.sort(rows, comparator);
        }
        SaxWriter writer = response.getWriter();
        writer.startSequence(null, "row");
        for (Row row : rows) {
            this.emit(row, response);
        }
        writer.endSequence();
    }

    public final void populate(XmlaResponse response, OlapConnection connection, List<Row> rows) throws XmlaException {
        boolean ourConnection = false;
        try {
            try {
                if (this.needConnection() && connection == null) {
                    connection = this.handler.getConnection(this.request, this.extraProperties);
                    ourConnection = true;
                }
                this.populateImpl(response, connection, rows);
            }
            catch (SQLException e) {
                throw new XmlaException("00UE001", "Internal Error", "SqlException:", e);
            }
        }
        finally {
            if (connection != null && ourConnection) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    protected boolean needConnection() {
        return true;
    }

    protected abstract void populateImpl(XmlaResponse var1, OlapConnection var2, List<Row> var3) throws XmlaException, SQLException;

    protected final boolean addRow(Row row, List<Row> rows) throws XmlaException {
        return rows.add(row);
    }

    protected void emit(Row row, XmlaResponse response) throws XmlaException, SQLException {
        SaxWriter writer = response.getWriter();
        writer.startElement("row");
        RowsetDefinition.Column[] columnArray = this.rowsetDefinition.columnDefinitions;
        int n = this.rowsetDefinition.columnDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            Object value1;
            Object values;
            Object[] objectArray;
            RowsetDefinition.Column column = columnArray[n2];
            Object value = row.get(column.name);
            if (value == null) {
                if (!column.nullable) {
                    throw new XmlaException("Client", "00HSBB16", "XMLA SOAP non-nullable column", Util.newInternal("Value required for column " + column.name + " of rowset " + this.rowsetDefinition.name()));
                }
            } else if (value instanceof XmlElement[]) {
                XmlElement[] elements = (XmlElement[])value;
                objectArray = elements;
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object element = objectArray[n4];
                    this.emitXmlElement(writer, (XmlElement)element);
                    ++n4;
                }
            } else if (value instanceof Object[]) {
                values = (Object[])value;
                objectArray = values;
                int n5 = ((Object[])values).length;
                int n6 = 0;
                while (n6 < n5) {
                    value1 = objectArray[n6];
                    writer.startElement(column.name);
                    writer.characters(value1.toString());
                    writer.endElement();
                    ++n6;
                }
            } else if (value instanceof List) {
                values = (List)value;
                Iterator iterator = values.iterator();
                while (iterator.hasNext()) {
                    value1 = iterator.next();
                    if (value1 instanceof XmlElement) {
                        XmlElement xmlElement = (XmlElement)value1;
                        this.emitXmlElement(writer, xmlElement);
                        continue;
                    }
                    writer.startElement(column.name);
                    writer.characters(value1.toString());
                    writer.endElement();
                }
            } else if (value instanceof Rowset) {
                Rowset rowset = (Rowset)value;
                ArrayList<Row> rows = new ArrayList<Row>();
                rowset.populate(response, null, rows);
                writer.startSequence(column.name, "row");
                for (Row row1 : rows) {
                    rowset.emit(row1, response);
                }
                writer.endSequence();
            } else {
                writer.textElement(column.name, value);
            }
            ++n2;
        }
        writer.endElement();
    }

    private void emitXmlElement(SaxWriter writer, XmlElement element) {
        if (element.attributes == null) {
            writer.startElement(element.tag);
        } else {
            writer.startElement(element.tag, element.attributes);
        }
        if (element.text == null) {
            XmlElement[] xmlElementArray = element.children;
            int n = xmlElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                XmlElement aChildren = xmlElementArray[n2];
                this.emitXmlElement(writer, aChildren);
                ++n2;
            }
        } else {
            writer.characters(element.text);
        }
        writer.endElement();
    }

    protected <E> void populate(Class<E> clazz, List<Row> rows, Comparator<E> comparator) throws XmlaException {
        Object[] enumsSortedByName = (Object[])clazz.getEnumConstants().clone();
        Arrays.sort(enumsSortedByName, comparator);
        Object[] objectArray = enumsSortedByName;
        int n = enumsSortedByName.length;
        int n2 = 0;
        while (n2 < n) {
            Object anEnum = objectArray[n2];
            Row row = new Row();
            RowsetDefinition.Column[] columnArray = this.rowsetDefinition.columnDefinitions;
            int n3 = this.rowsetDefinition.columnDefinitions.length;
            int n4 = 0;
            while (n4 < n3) {
                RowsetDefinition.Column column = columnArray[n4];
                row.names.add(column.name);
                row.values.add(column.get(anEnum));
                ++n4;
            }
            rows.add(row);
            ++n2;
        }
    }

    <E> Util.Functor1<Boolean, E> makeCondition(RowsetDefinition.Column column) {
        return this.makeCondition(Util.identityFunctor(), column);
    }

    <E, V> Util.Functor1<Boolean, E> makeCondition(final Util.Functor1<V, ? super E> getter, RowsetDefinition.Column column) {
        Object restriction = this.restrictions.get(column.name);
        if (restriction == null) {
            return Util.trueFunctor();
        }
        if (restriction instanceof XmlaUtil.Wildcard) {
            XmlaUtil.Wildcard wildcard = (XmlaUtil.Wildcard)restriction;
            String regexp = Util.wildcardToRegexp(Collections.singletonList(wildcard.pattern));
            final Matcher matcher = Pattern.compile(regexp).matcher("");
            return new Util.Functor1<Boolean, E>(){

                @Override
                public Boolean apply(E element) {
                    Object value = getter.apply(element);
                    return matcher.reset(String.valueOf(value)).matches();
                }
            };
        }
        if (restriction instanceof List) {
            final List requiredValues = (List)restriction;
            return new Util.Functor1<Boolean, E>(){

                @Override
                public Boolean apply(E element) {
                    if (element == null) {
                        return requiredValues.contains("");
                    }
                    Object value = getter.apply(element);
                    return requiredValues.contains(value);
                }
            };
        }
        throw Util.newInternal("unexpected restriction type: " + restriction.getClass());
    }

    String getRestrictionValueAsString(RowsetDefinition.Column column) {
        List rval;
        Object restriction = this.restrictions.get(column.name);
        if (restriction instanceof List && (rval = (List)restriction).size() == 1) {
            return (String)rval.get(0);
        }
        return null;
    }

    int getRestrictionValueAsInt(RowsetDefinition.Column column) {
        List rval;
        Object restriction = this.restrictions.get(column.name);
        if (restriction instanceof List && (rval = (List)restriction).size() == 1) {
            try {
                return Integer.parseInt((String)rval.get(0));
            }
            catch (NumberFormatException ex) {
                LOGGER.info((Object)("Rowset.getRestrictionValue: bad integer restriction \"" + rval + "\""));
                return -1;
            }
        }
        return -1;
    }

    protected boolean isRestricted(RowsetDefinition.Column column) {
        return this.restrictions.get(column.name) != null;
    }

    protected Util.Functor1<Boolean, Catalog> catNameCond() {
        Map<String, String> properties = this.request.getProperties();
        final String catalogName = properties.get(PropertyDefinition.Catalog.name());
        if (catalogName != null) {
            return new Util.Functor1<Boolean, Catalog>(){

                @Override
                public Boolean apply(Catalog catalog) {
                    return catalog.getName().equals(catalogName);
                }
            };
        }
        return Util.trueFunctor();
    }

    protected static class Row {
        private final ArrayList<String> names = new ArrayList();
        private final ArrayList<Object> values = new ArrayList();

        Row() {
        }

        void set(String name, Object value) {
            this.names.add(name);
            this.values.add(value);
        }

        public Object get(String name) {
            int i = this.names.indexOf(name);
            return i < 0 ? null : this.values.get(i);
        }
    }

    protected static class XmlElement {
        private final String tag;
        private final Object[] attributes;
        private final String text;
        private final XmlElement[] children;

        XmlElement(String tag, Object[] attributes, String text) {
            this(tag, attributes, text, null);
        }

        XmlElement(String tag, Object[] attributes, XmlElement[] children) {
            this(tag, attributes, null, children);
        }

        private XmlElement(String tag, Object[] attributes, String text, XmlElement[] children) {
            assert (attributes == null || attributes.length % 2 == 0);
            this.tag = tag;
            this.attributes = attributes;
            this.text = text;
            this.children = children;
        }
    }
}

