/*
 * Decompiled with CFR 0.152.
 */
package mondrian.xmla;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import mondrian.olap.MondrianProperties;
import mondrian.olap.MondrianServer;
import mondrian.olap.Util;
import mondrian.util.Composite;
import mondrian.xmla.Enumeration;
import mondrian.xmla.PropertyDefinition;
import mondrian.xmla.Rowset;
import mondrian.xmla.SaxWriter;
import mondrian.xmla.XmlaException;
import mondrian.xmla.XmlaHandler;
import mondrian.xmla.XmlaRequest;
import mondrian.xmla.XmlaResponse;
import mondrian.xmla.XmlaUtil;
import org.olap4j.OlapConnection;
import org.olap4j.OlapException;
import org.olap4j.impl.ArrayNamedListImpl;
import org.olap4j.impl.Olap4jUtil;
import org.olap4j.mdx.IdentifierNode;
import org.olap4j.mdx.IdentifierSegment;
import org.olap4j.metadata.Catalog;
import org.olap4j.metadata.Cube;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.Measure;
import org.olap4j.metadata.Member;
import org.olap4j.metadata.MetadataElement;
import org.olap4j.metadata.NamedList;
import org.olap4j.metadata.NamedSet;
import org.olap4j.metadata.Property;
import org.olap4j.metadata.Schema;
import org.olap4j.metadata.XmlaConstant;
import org.olap4j.metadata.XmlaConstants;

public enum RowsetDefinition {
    DISCOVER_DATASOURCES(0, "Returns a list of XML for Analysis data sources available on the server or Web Service.", new Column[]{DiscoverDatasourcesRowset.access$0(), DiscoverDatasourcesRowset.access$1(), DiscoverDatasourcesRowset.access$2(), DiscoverDatasourcesRowset.access$3(), DiscoverDatasourcesRowset.access$4(), DiscoverDatasourcesRowset.access$5(), DiscoverDatasourcesRowset.access$6()}, new Column[]{DiscoverDatasourcesRowset.access$0()}){

        @Override
        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new DiscoverDatasourcesRowset(request, handler);
        }
    }
    ,
    DISCOVER_SCHEMA_ROWSETS(2, "Returns the names, values, and other information of all supported RequestType enumeration values.", new Column[]{DiscoverSchemaRowsetsRowset.access$0(), DiscoverSchemaRowsetsRowset.access$1(), DiscoverSchemaRowsetsRowset.access$2(), DiscoverSchemaRowsetsRowset.access$3()}, null){

        @Override
        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new DiscoverSchemaRowsetsRowset(request, handler);
        }

        @Override
        protected void writeRowsetXmlSchemaRowDef(SaxWriter writer) {
            writer.startElement("xsd:complexType", "name", "row");
            writer.startElement("xsd:sequence");
            Column[] columnArray = this.columnDefinitions;
            int n = this.columnDefinitions.length;
            int n2 = 0;
            while (n2 < n) {
                Column column = columnArray[n2];
                String name = XmlaUtil.ElementNameEncoder.INSTANCE.encode(column.name);
                if (column == DiscoverSchemaRowsetsRowset.Restrictions) {
                    writer.startElement("xsd:element", "sql:field", column.name, "name", name, "minOccurs", 0, "maxOccurs", "unbounded");
                    writer.startElement("xsd:complexType");
                    writer.startElement("xsd:sequence");
                    writer.element("xsd:element", "name", "Name", "type", "xsd:string", "sql:field", "Name");
                    writer.element("xsd:element", "name", "Type", "type", "xsd:string", "sql:field", "Type");
                    writer.endElement();
                    writer.endElement();
                    writer.endElement();
                } else {
                    String xsdType = column.type.columnType;
                    Object[] attrs = column.nullable ? (column.unbounded ? new Object[]{"sql:field", column.name, "name", name, "type", xsdType, "minOccurs", 0, "maxOccurs", "unbounded"} : new Object[]{"sql:field", column.name, "name", name, "type", xsdType, "minOccurs", 0}) : (column.unbounded ? new Object[]{"sql:field", column.name, "name", name, "type", xsdType, "maxOccurs", "unbounded"} : new Object[]{"sql:field", column.name, "name", name, "type", xsdType});
                    writer.element("xsd:element", attrs);
                }
                ++n2;
            }
            writer.endElement();
            writer.endElement();
        }
    }
    ,
    DISCOVER_ENUMERATORS(3, "Returns a list of names, data types, and enumeration values for enumerators supported by the provider of a specific data source.", new Column[]{DiscoverEnumeratorsRowset.access$0(), DiscoverEnumeratorsRowset.access$1(), DiscoverEnumeratorsRowset.access$2(), DiscoverEnumeratorsRowset.access$3(), DiscoverEnumeratorsRowset.access$4(), DiscoverEnumeratorsRowset.access$5()}, null){

        @Override
        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new DiscoverEnumeratorsRowset(request, handler);
        }
    }
    ,
    DISCOVER_PROPERTIES(1, "Returns a list of information and values about the requested properties that are supported by the specified data source provider.", new Column[]{DiscoverPropertiesRowset.access$0(), DiscoverPropertiesRowset.access$1(), DiscoverPropertiesRowset.access$2(), DiscoverPropertiesRowset.access$3(), DiscoverPropertiesRowset.access$4(), DiscoverPropertiesRowset.access$5()}, null){

        @Override
        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new DiscoverPropertiesRowset(request, handler);
        }
    }
    ,
    DISCOVER_KEYWORDS(4, "Returns an XML list of keywords reserved by the provider.", new Column[]{DiscoverKeywordsRowset.access$0()}, null){

        @Override
        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new DiscoverKeywordsRowset(request, handler);
        }
    }
    ,
    DISCOVER_LITERALS(5, "Returns information about literals supported by the provider.", new Column[]{DiscoverLiteralsRowset.access$0(), DiscoverLiteralsRowset.access$1(), DiscoverLiteralsRowset.access$2(), DiscoverLiteralsRowset.access$3(), DiscoverLiteralsRowset.access$4()}, null){

        @Override
        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new DiscoverLiteralsRowset(request, handler);
        }
    }
    ,
    DBSCHEMA_CATALOGS(6, "Identifies the physical attributes associated with catalogs accessible from the provider.", new Column[]{DbschemaCatalogsRowset.access$0(), DbschemaCatalogsRowset.access$1(), DbschemaCatalogsRowset.access$2(), DbschemaCatalogsRowset.access$3()}, new Column[]{DbschemaCatalogsRowset.access$0()}){

        @Override
        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new DbschemaCatalogsRowset(request, handler);
        }
    }
    ,
    DBSCHEMA_COLUMNS(7, null, new Column[]{DbschemaColumnsRowset.access$0(), DbschemaColumnsRowset.access$1(), DbschemaColumnsRowset.access$2(), DbschemaColumnsRowset.access$3(), DbschemaColumnsRowset.access$4(), DbschemaColumnsRowset.access$5(), DbschemaColumnsRowset.access$6(), DbschemaColumnsRowset.access$7(), DbschemaColumnsRowset.access$8(), DbschemaColumnsRowset.access$9(), DbschemaColumnsRowset.access$10(), DbschemaColumnsRowset.access$11(), DbschemaColumnsRowset.access$12()}, new Column[]{DbschemaColumnsRowset.access$0(), DbschemaColumnsRowset.access$1(), DbschemaColumnsRowset.access$2()}){

        @Override
        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new DbschemaColumnsRowset(request, handler);
        }
    }
    ,
    DBSCHEMA_PROVIDER_TYPES(8, null, new Column[]{DbschemaProviderTypesRowset.access$0(), DbschemaProviderTypesRowset.access$1(), DbschemaProviderTypesRowset.access$2(), DbschemaProviderTypesRowset.access$3(), DbschemaProviderTypesRowset.access$4(), DbschemaProviderTypesRowset.access$5(), DbschemaProviderTypesRowset.access$6(), DbschemaProviderTypesRowset.access$7(), DbschemaProviderTypesRowset.access$8(), DbschemaProviderTypesRowset.access$9(), DbschemaProviderTypesRowset.access$10(), DbschemaProviderTypesRowset.access$11(), DbschemaProviderTypesRowset.access$12()}, new Column[]{DbschemaProviderTypesRowset.access$1()}){

        @Override
        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new DbschemaProviderTypesRowset(request, handler);
        }
    }
    ,
    DBSCHEMA_SCHEMATA(8, null, new Column[]{DbschemaSchemataRowset.access$0(), DbschemaSchemataRowset.access$1(), DbschemaSchemataRowset.access$2()}, new Column[]{DbschemaSchemataRowset.access$0(), DbschemaSchemataRowset.access$1(), DbschemaSchemataRowset.access$2()}){

        @Override
        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new DbschemaSchemataRowset(request, handler);
        }
    }
    ,
    DBSCHEMA_TABLES(9, null, new Column[]{DbschemaTablesRowset.access$0(), DbschemaTablesRowset.access$1(), DbschemaTablesRowset.access$2(), DbschemaTablesRowset.access$3(), DbschemaTablesRowset.access$4(), DbschemaTablesRowset.access$5(), DbschemaTablesRowset.access$6(), DbschemaTablesRowset.access$7(), DbschemaTablesRowset.access$8()}, new Column[]{DbschemaTablesRowset.access$3(), DbschemaTablesRowset.access$0(), DbschemaTablesRowset.access$1(), DbschemaTablesRowset.access$2()}){

        @Override
        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new DbschemaTablesRowset(request, handler);
        }
    }
    ,
    DBSCHEMA_TABLES_INFO(10, null, new Column[]{DbschemaTablesInfoRowset.access$0(), DbschemaTablesInfoRowset.access$1(), DbschemaTablesInfoRowset.access$2(), DbschemaTablesInfoRowset.access$3(), DbschemaTablesInfoRowset.access$4(), DbschemaTablesInfoRowset.access$5(), DbschemaTablesInfoRowset.access$6(), DbschemaTablesInfoRowset.access$7(), DbschemaTablesInfoRowset.access$8(), DbschemaTablesInfoRowset.access$9(), DbschemaTablesInfoRowset.access$10(), DbschemaTablesInfoRowset.access$11(), DbschemaTablesInfoRowset.access$12(), DbschemaTablesInfoRowset.access$13()}, null){

        @Override
        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new DbschemaTablesInfoRowset(request, handler);
        }
    }
    ,
    MDSCHEMA_ACTIONS(11, null, new Column[]{MdschemaActionsRowset.access$0(), MdschemaActionsRowset.access$1(), MdschemaActionsRowset.access$2(), MdschemaActionsRowset.access$3(), MdschemaActionsRowset.access$4(), MdschemaActionsRowset.access$5()}, new Column[]{MdschemaActionsRowset.access$0(), MdschemaActionsRowset.access$1(), MdschemaActionsRowset.access$2(), MdschemaActionsRowset.access$3()}){

        @Override
        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new MdschemaActionsRowset(request, handler);
        }
    }
    ,
    MDSCHEMA_CUBES(12, null, new Column[]{MdschemaCubesRowset.access$0(), MdschemaCubesRowset.access$1(), MdschemaCubesRowset.access$2(), MdschemaCubesRowset.access$3(), MdschemaCubesRowset.access$4(), MdschemaCubesRowset.access$5(), MdschemaCubesRowset.access$6(), MdschemaCubesRowset.access$7(), MdschemaCubesRowset.access$8(), MdschemaCubesRowset.access$9(), MdschemaCubesRowset.access$10(), MdschemaCubesRowset.access$11(), MdschemaCubesRowset.access$12(), MdschemaCubesRowset.access$13(), MdschemaCubesRowset.access$14(), MdschemaCubesRowset.access$15(), MdschemaCubesRowset.access$16(), MdschemaCubesRowset.access$17(), MdschemaCubesRowset.access$18()}, new Column[]{MdschemaCubesRowset.access$0(), MdschemaCubesRowset.access$1(), MdschemaCubesRowset.access$2()}){

        @Override
        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new MdschemaCubesRowset(request, handler);
        }
    }
    ,
    MDSCHEMA_DIMENSIONS(13, null, new Column[]{MdschemaDimensionsRowset.access$0(), MdschemaDimensionsRowset.access$1(), MdschemaDimensionsRowset.access$2(), MdschemaDimensionsRowset.access$3(), MdschemaDimensionsRowset.access$4(), MdschemaDimensionsRowset.access$5(), MdschemaDimensionsRowset.access$6(), MdschemaDimensionsRowset.access$7(), MdschemaDimensionsRowset.access$8(), MdschemaDimensionsRowset.access$9(), MdschemaDimensionsRowset.access$10(), MdschemaDimensionsRowset.access$11(), MdschemaDimensionsRowset.access$12(), MdschemaDimensionsRowset.access$13(), MdschemaDimensionsRowset.access$14(), MdschemaDimensionsRowset.access$15(), MdschemaDimensionsRowset.access$16(), MdschemaDimensionsRowset.access$17()}, new Column[]{MdschemaDimensionsRowset.access$0(), MdschemaDimensionsRowset.access$1(), MdschemaDimensionsRowset.access$2(), MdschemaDimensionsRowset.access$3()}){

        @Override
        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new MdschemaDimensionsRowset(request, handler);
        }
    }
    ,
    MDSCHEMA_FUNCTIONS(14, null, new Column[]{MdschemaFunctionsRowset.access$0(), MdschemaFunctionsRowset.access$1(), MdschemaFunctionsRowset.access$2(), MdschemaFunctionsRowset.access$3(), MdschemaFunctionsRowset.access$4(), MdschemaFunctionsRowset.access$5(), MdschemaFunctionsRowset.access$6(), MdschemaFunctionsRowset.access$7()}, new Column[]{MdschemaFunctionsRowset.access$6(), MdschemaFunctionsRowset.access$5(), MdschemaFunctionsRowset.access$0(), MdschemaFunctionsRowset.access$4()}){

        @Override
        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new MdschemaFunctionsRowset(request, handler);
        }
    }
    ,
    MDSCHEMA_HIERARCHIES(15, null, new Column[]{MdschemaHierarchiesRowset.access$0(), MdschemaHierarchiesRowset.access$1(), MdschemaHierarchiesRowset.access$2(), MdschemaHierarchiesRowset.access$3(), MdschemaHierarchiesRowset.access$4(), MdschemaHierarchiesRowset.access$5(), MdschemaHierarchiesRowset.access$6(), MdschemaHierarchiesRowset.access$7(), MdschemaHierarchiesRowset.access$8(), MdschemaHierarchiesRowset.access$9(), MdschemaHierarchiesRowset.access$10(), MdschemaHierarchiesRowset.access$11(), MdschemaHierarchiesRowset.access$12(), MdschemaHierarchiesRowset.access$13(), MdschemaHierarchiesRowset.access$14(), MdschemaHierarchiesRowset.access$15(), MdschemaHierarchiesRowset.access$16(), MdschemaHierarchiesRowset.access$17(), MdschemaHierarchiesRowset.access$18(), MdschemaHierarchiesRowset.access$19(), MdschemaHierarchiesRowset.access$20(), MdschemaHierarchiesRowset.access$21(), MdschemaHierarchiesRowset.access$22()}, new Column[]{MdschemaHierarchiesRowset.access$0(), MdschemaHierarchiesRowset.access$1(), MdschemaHierarchiesRowset.access$2(), MdschemaHierarchiesRowset.access$3(), MdschemaHierarchiesRowset.access$4()}){

        @Override
        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new MdschemaHierarchiesRowset(request, handler);
        }
    }
    ,
    MDSCHEMA_LEVELS(16, null, new Column[]{MdschemaLevelsRowset.access$0(), MdschemaLevelsRowset.access$1(), MdschemaLevelsRowset.access$2(), MdschemaLevelsRowset.access$3(), MdschemaLevelsRowset.access$4(), MdschemaLevelsRowset.access$5(), MdschemaLevelsRowset.access$6(), MdschemaLevelsRowset.access$7(), MdschemaLevelsRowset.access$8(), MdschemaLevelsRowset.access$9(), MdschemaLevelsRowset.access$10(), MdschemaLevelsRowset.access$11(), MdschemaLevelsRowset.access$12(), MdschemaLevelsRowset.access$13(), MdschemaLevelsRowset.access$14(), MdschemaLevelsRowset.access$15()}, new Column[]{MdschemaLevelsRowset.access$0(), MdschemaLevelsRowset.access$1(), MdschemaLevelsRowset.access$2(), MdschemaLevelsRowset.access$3(), MdschemaLevelsRowset.access$4(), MdschemaLevelsRowset.access$9()}){

        @Override
        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new MdschemaLevelsRowset(request, handler);
        }
    }
    ,
    MDSCHEMA_MEASURES(17, null, new Column[]{MdschemaMeasuresRowset.access$0(), MdschemaMeasuresRowset.access$1(), MdschemaMeasuresRowset.access$2(), MdschemaMeasuresRowset.access$3(), MdschemaMeasuresRowset.access$4(), MdschemaMeasuresRowset.access$5(), MdschemaMeasuresRowset.access$6(), MdschemaMeasuresRowset.access$7(), MdschemaMeasuresRowset.access$8(), MdschemaMeasuresRowset.access$9(), MdschemaMeasuresRowset.access$10(), MdschemaMeasuresRowset.access$11(), MdschemaMeasuresRowset.access$12()}, new Column[]{MdschemaMeasuresRowset.access$0(), MdschemaMeasuresRowset.access$1(), MdschemaMeasuresRowset.access$2(), MdschemaMeasuresRowset.access$3()}){

        @Override
        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new MdschemaMeasuresRowset(request, handler);
        }
    }
    ,
    MDSCHEMA_MEMBERS(18, null, new Column[]{MdschemaMembersRowset.access$0(), MdschemaMembersRowset.access$1(), MdschemaMembersRowset.access$2(), MdschemaMembersRowset.access$3(), MdschemaMembersRowset.access$4(), MdschemaMembersRowset.access$5(), MdschemaMembersRowset.access$6(), MdschemaMembersRowset.access$7(), MdschemaMembersRowset.access$8(), MdschemaMembersRowset.access$9(), MdschemaMembersRowset.access$10(), MdschemaMembersRowset.access$11(), MdschemaMembersRowset.access$12(), MdschemaMembersRowset.access$13(), MdschemaMembersRowset.access$14(), MdschemaMembersRowset.access$15(), MdschemaMembersRowset.access$16(), MdschemaMembersRowset.access$17(), MdschemaMembersRowset.access$18()}, new Column[]{MdschemaMembersRowset.access$0(), MdschemaMembersRowset.access$1(), MdschemaMembersRowset.access$2(), MdschemaMembersRowset.access$3(), MdschemaMembersRowset.access$4(), MdschemaMembersRowset.access$5(), MdschemaMembersRowset.access$6(), MdschemaMembersRowset.access$7()}){

        @Override
        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new MdschemaMembersRowset(request, handler);
        }
    }
    ,
    MDSCHEMA_PROPERTIES(19, null, new Column[]{MdschemaPropertiesRowset.access$0(), MdschemaPropertiesRowset.access$1(), MdschemaPropertiesRowset.access$2(), MdschemaPropertiesRowset.access$3(), MdschemaPropertiesRowset.access$4(), MdschemaPropertiesRowset.access$5(), MdschemaPropertiesRowset.access$6(), MdschemaPropertiesRowset.access$7(), MdschemaPropertiesRowset.access$8(), MdschemaPropertiesRowset.access$9(), MdschemaPropertiesRowset.access$10(), MdschemaPropertiesRowset.access$11(), MdschemaPropertiesRowset.access$12()}, null){

        @Override
        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new MdschemaPropertiesRowset(request, handler);
        }
    }
    ,
    MDSCHEMA_SETS(20, null, new Column[]{MdschemaSetsRowset.access$0(), MdschemaSetsRowset.access$1(), MdschemaSetsRowset.access$2(), MdschemaSetsRowset.access$3(), MdschemaSetsRowset.access$4()}, new Column[]{MdschemaSetsRowset.access$0(), MdschemaSetsRowset.access$1(), MdschemaSetsRowset.access$2()}){

        @Override
        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new MdschemaSetsRowset(request, handler);
        }
    };

    final transient Column[] columnDefinitions;
    final transient Column[] sortColumnDefinitions;
    private static final String dateModified = "2005-01-25T17:35:32";
    private final String description;
    static final String UUID_PATTERN = "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}";
    public static final Util.Functor1<String, Catalog> CATALOG_NAME_GETTER;
    public static final Util.Functor1<String, Schema> SCHEMA_NAME_GETTER;
    public static final Util.Functor1<String, MetadataElement> ELEMENT_NAME_GETTER;
    public static final Util.Functor1<String, MetadataElement> ELEMENT_UNAME_GETTER;
    public static final Util.Functor1<Member.Type, Member> MEMBER_TYPE_GETTER;
    public static final Util.Functor1<String, PropertyDefinition> PROPDEF_NAME_GETTER;

    static {
        CATALOG_NAME_GETTER = new Util.Functor1<String, Catalog>(){

            @Override
            public String apply(Catalog catalog) {
                return catalog.getName();
            }
        };
        SCHEMA_NAME_GETTER = new Util.Functor1<String, Schema>(){

            @Override
            public String apply(Schema schema) {
                return schema.getName();
            }
        };
        ELEMENT_NAME_GETTER = new Util.Functor1<String, MetadataElement>(){

            @Override
            public String apply(MetadataElement element) {
                return element.getName();
            }
        };
        ELEMENT_UNAME_GETTER = new Util.Functor1<String, MetadataElement>(){

            @Override
            public String apply(MetadataElement element) {
                return element.getUniqueName();
            }
        };
        MEMBER_TYPE_GETTER = new Util.Functor1<Member.Type, Member>(){

            @Override
            public Member.Type apply(Member member) {
                return member.getMemberType();
            }
        };
        PROPDEF_NAME_GETTER = new Util.Functor1<String, PropertyDefinition>(){

            @Override
            public String apply(PropertyDefinition property) {
                return property.name();
            }
        };
    }

    private RowsetDefinition(int ordinal, String description, Column[] columnDefinitions, Column[] sortColumnDefinitions) {
        Util.discard((int)ordinal);
        this.description = description;
        this.columnDefinitions = columnDefinitions;
        this.sortColumnDefinitions = sortColumnDefinitions;
    }

    public abstract Rowset getRowset(XmlaRequest var1, XmlaHandler var2);

    public Column lookupColumn(String name) {
        Column[] columnArray = this.columnDefinitions;
        int n = this.columnDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            Column columnDefinition = columnArray[n2];
            if (columnDefinition.name.equals(name)) {
                return columnDefinition;
            }
            ++n2;
        }
        return null;
    }

    Comparator<Rowset.Row> getComparator() {
        if (this.sortColumnDefinitions == null) {
            return null;
        }
        return new Comparator<Rowset.Row>(){

            @Override
            public int compare(Rowset.Row row1, Rowset.Row row2) {
                Column[] columnArray = RowsetDefinition.this.sortColumnDefinitions;
                int n = RowsetDefinition.this.sortColumnDefinitions.length;
                int n2 = 0;
                while (n2 < n) {
                    Column sortColumn = columnArray[n2];
                    Comparable val1 = (Comparable)row1.get(sortColumn.name);
                    Comparable val2 = (Comparable)row2.get(sortColumn.name);
                    if (val1 != null || val2 != null) {
                        int v;
                        if (val1 == null) {
                            return -1;
                        }
                        if (val2 == null) {
                            return 1;
                        }
                        if (val1 instanceof String && val2 instanceof String ? (v = ((String)((Object)val1)).compareToIgnoreCase((String)((Object)val2))) != 0 : (v = val1.compareTo(val2)) != 0) {
                            return v;
                        }
                    }
                    ++n2;
                }
                return 0;
            }
        };
    }

    void writeRowsetXmlSchema(SaxWriter writer) {
        this.writeRowsetXmlSchemaTop(writer);
        this.writeRowsetXmlSchemaRowDef(writer);
        this.writeRowsetXmlSchemaBottom(writer);
    }

    protected void writeRowsetXmlSchemaTop(SaxWriter writer) {
        writer.startElement("xsd:schema", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema", "xmlns", "urn:schemas-microsoft-com:xml-analysis:rowset", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance", "xmlns:sql", "urn:schemas-microsoft-com:xml-sql", "targetNamespace", "urn:schemas-microsoft-com:xml-analysis:rowset", "elementFormDefault", "qualified");
        writer.startElement("xsd:element", "name", "root");
        writer.startElement("xsd:complexType");
        writer.startElement("xsd:sequence");
        writer.element("xsd:element", "name", "row", "type", "row", "minOccurs", 0, "maxOccurs", "unbounded");
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.startElement("xsd:simpleType", "name", "uuid");
        writer.startElement("xsd:restriction", "base", "xsd:string");
        writer.element("xsd:pattern", "value", UUID_PATTERN);
        writer.endElement();
        writer.endElement();
    }

    protected void writeRowsetXmlSchemaRowDef(SaxWriter writer) {
        writer.startElement("xsd:complexType", "name", "row");
        writer.startElement("xsd:sequence");
        Column[] columnArray = this.columnDefinitions;
        int n = this.columnDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            Column column = columnArray[n2];
            String name = XmlaUtil.ElementNameEncoder.INSTANCE.encode(column.name);
            String xsdType = column.type.columnType;
            Object[] attrs = column.nullable ? (column.unbounded ? new Object[]{"sql:field", column.name, "name", name, "type", xsdType, "minOccurs", 0, "maxOccurs", "unbounded"} : new Object[]{"sql:field", column.name, "name", name, "type", xsdType, "minOccurs", 0}) : (column.unbounded ? new Object[]{"sql:field", column.name, "name", name, "type", xsdType, "maxOccurs", "unbounded"} : new Object[]{"sql:field", column.name, "name", name, "type", xsdType});
            writer.element("xsd:element", attrs);
            ++n2;
        }
        writer.endElement();
        writer.endElement();
    }

    protected void writeRowsetXmlSchemaBottom(SaxWriter writer) {
        writer.endElement();
    }

    private static XmlaConstants.DBType getDBTypeFromProperty(Property prop) {
        switch (prop.getDatatype()) {
            case STRING: {
                return XmlaConstants.DBType.WSTR;
            }
            case INTEGER: 
            case DOUBLE: 
            case UNSIGNED_INTEGER: {
                return XmlaConstants.DBType.R8;
            }
            case BOOLEAN: {
                return XmlaConstants.DBType.BOOL;
            }
        }
        return XmlaConstants.DBType.WSTR;
    }

    public String getDescription() {
        return this.description;
    }

    static int getDimensionType(Dimension dim) throws OlapException {
        switch (dim.getDimensionType()) {
            case MEASURE: {
                return 2;
            }
            case TIME: {
                return 1;
            }
        }
        return 3;
    }

    static void serialize(StringBuilder buf, Collection<String> strings) {
        int k = 0;
        for (String name : Util.sort(strings)) {
            if (k++ > 0) {
                buf.append(',');
            }
            buf.append(name);
        }
    }

    private static Level lookupLevel(Cube cube, String levelUniqueName) {
        for (Dimension dimension : cube.getDimensions()) {
            for (Hierarchy hierarchy : dimension.getHierarchies()) {
                for (Level level : hierarchy.getLevels()) {
                    if (!level.getUniqueName().equals(levelUniqueName)) continue;
                    return level;
                }
            }
        }
        return null;
    }

    static Iterable<Cube> sortedCubes(Schema schema) throws OlapException {
        return Util.sort(schema.getCubes(), new Comparator<Cube>(){

            @Override
            public int compare(Cube o1, Cube o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
    }

    static Iterable<Cube> filteredCubes(Schema schema, Util.Functor1<Boolean, Cube> cubeNameCond) throws OlapException {
        Iterable<Cube> iterable = Util.filter(RowsetDefinition.sortedCubes(schema), cubeNameCond);
        if (!cubeNameCond.apply(new SharedDimensionHolderCube(schema)).booleanValue()) {
            return iterable;
        }
        return Composite.of(Collections.singletonList(new SharedDimensionHolderCube(schema)), iterable);
    }

    private static String getHierarchyName(Hierarchy hierarchy) {
        String hierarchyName = hierarchy.getName();
        if (MondrianProperties.instance().SsasCompatibleNaming.get() && !hierarchyName.equals(hierarchy.getDimension().getName())) {
            hierarchyName = String.valueOf(hierarchy.getDimension().getName()) + "." + hierarchyName;
        }
        return hierarchyName;
    }

    private static XmlaRequest wrapRequest(XmlaRequest request, Map<Column, String> map) {
        final HashMap<String, Object> restrictionsMap = new HashMap<String, Object>(request.getRestrictions());
        for (Map.Entry<Column, String> entry : map.entrySet()) {
            restrictionsMap.put(entry.getKey().name, Collections.singletonList(entry.getValue()));
        }
        return new DelegatingXmlaRequest(request){

            @Override
            public Map<String, Object> getRestrictions() {
                return restrictionsMap;
            }
        };
    }

    private static Iterable<Catalog> catIter(final OlapConnection connection, final Util.Functor1<Boolean, Catalog> ... conds) {
        return new Iterable<Catalog>(){

            @Override
            public Iterator<Catalog> iterator() {
                try {
                    return new Iterator<Catalog>(conds){
                        final Iterator<Catalog> catalogIter;
                        {
                            this.catalogIter = Util.filter(olapConnection.getOlapCatalogs(), functor1Array).iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.catalogIter.hasNext();
                        }

                        @Override
                        public Catalog next() {
                            Catalog catalog = this.catalogIter.next();
                            try {
                                connection.setCatalog(catalog.getName());
                            }
                            catch (SQLException e) {
                                throw new RuntimeException(e);
                            }
                            return catalog;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
                catch (OlapException e) {
                    throw new RuntimeException("Failed to obtain a list of catalogs form the connection object.", e);
                }
            }
        };
    }

    /* synthetic */ RowsetDefinition(String string, int n, int n2, String string2, Column[] columnArray, Column[] columnArray2, RowsetDefinition rowsetDefinition) {
        this(n2, string2, columnArray, columnArray2);
    }

    static class Column {
        static final boolean RESTRICTION = true;
        static final boolean NOT_RESTRICTION = false;
        static final boolean REQUIRED = false;
        static final boolean OPTIONAL = true;
        static final boolean ONE_MAX = false;
        static final boolean UNBOUNDED = true;
        final String name;
        final Type type;
        final Enumeration enumeration;
        final String description;
        final boolean restriction;
        final boolean nullable;
        final boolean unbounded;

        Column(String name, Type type, Enumeration enumeratedType, boolean restriction, boolean nullable, String description) {
            this(name, type, enumeratedType, restriction, nullable, false, description);
        }

        Column(String name, Type type, Enumeration enumeratedType, boolean restriction, boolean nullable, boolean unbounded, String description) {
            assert (type != null);
            assert ((type == Type.Enumeration || type == Type.EnumerationArray || type == Type.EnumString) == (enumeratedType != null));
            assert (description == null || description.indexOf(13) == -1);
            this.name = name;
            this.type = type;
            this.enumeration = enumeratedType;
            this.description = description;
            this.restriction = restriction;
            this.nullable = nullable;
            this.unbounded = unbounded;
        }

        protected Object get(Object row) {
            return this.getFromAccessor(row);
        }

        protected final Object getFromField(Object row) {
            try {
                String javaFieldName = String.valueOf(this.name.substring(0, 1).toLowerCase()) + this.name.substring(1);
                Field field = row.getClass().getField(javaFieldName);
                return field.get(row);
            }
            catch (NoSuchFieldException e) {
                throw Util.newInternal(e, "Error while accessing rowset column " + this.name);
            }
            catch (SecurityException e) {
                throw Util.newInternal(e, "Error while accessing rowset column " + this.name);
            }
            catch (IllegalAccessException e) {
                throw Util.newInternal(e, "Error while accessing rowset column " + this.name);
            }
        }

        protected final Object getFromAccessor(Object row) {
            try {
                String javaMethodName = "get" + this.name;
                Method method = row.getClass().getMethod(javaMethodName, new Class[0]);
                return method.invoke(row, new Object[0]);
            }
            catch (SecurityException e) {
                throw Util.newInternal(e, "Error while accessing rowset column " + this.name);
            }
            catch (IllegalAccessException e) {
                throw Util.newInternal(e, "Error while accessing rowset column " + this.name);
            }
            catch (NoSuchMethodException e) {
                throw Util.newInternal(e, "Error while accessing rowset column " + this.name);
            }
            catch (InvocationTargetException e) {
                throw Util.newInternal(e, "Error while accessing rowset column " + this.name);
            }
        }

        public String getColumnType() {
            if (this.type.isEnum()) {
                return this.enumeration.type.columnType;
            }
            return this.type.columnType;
        }
    }

    static class DbschemaCatalogsRowset
    extends Rowset {
        private final Util.Functor1<Boolean, Catalog> catalogNameCond = this.makeCondition(CATALOG_NAME_GETTER, CatalogName);
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, false, "Catalog name. Cannot be NULL.");
        private static final Column Description = new Column("DESCRIPTION", Type.String, null, false, false, "Human-readable description of the catalog.");
        private static final Column Roles = new Column("ROLES", Type.String, null, false, false, "A comma delimited list of roles to which the current user belongs. An asterisk (*) is included as a role if the current user is a server or database administrator. Username is appended to ROLES if one of the roles uses dynamic security.");
        private static final Column DateModified = new Column("DATE_MODIFIED", Type.DateTime, null, false, true, "The date that the catalog was last modified.");

        DbschemaCatalogsRowset(XmlaRequest request, XmlaHandler handler) {
            super(DBSCHEMA_CATALOGS, request, handler);
        }

        @Override
        public void populateImpl(XmlaResponse response, OlapConnection connection, List<Rowset.Row> rows) throws XmlaException, SQLException {
            for (Catalog catalog : RowsetDefinition.catIter(connection, new Util.Functor1[]{this.catNameCond(), this.catalogNameCond})) {
                for (Schema schema : catalog.getSchemas()) {
                    Rowset.Row row = new Rowset.Row();
                    row.set(DbschemaCatalogsRowset.CatalogName.name, catalog.getName());
                    row.set(DbschemaCatalogsRowset.Description.name, "No description available");
                    StringBuilder buf = new StringBuilder(100);
                    List<String> roleNames = XmlaHandler.getExtra(connection).getSchemaRoleNames(schema);
                    RowsetDefinition.serialize(buf, roleNames);
                    row.set(DbschemaCatalogsRowset.Roles.name, buf.toString());
                    this.addRow(row, rows);
                }
            }
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$0() {
            return CatalogName;
        }

        static /* synthetic */ Column access$1() {
            return Description;
        }

        static /* synthetic */ Column access$2() {
            return Roles;
        }

        static /* synthetic */ Column access$3() {
            return DateModified;
        }
    }

    static class DbschemaColumnsRowset
    extends Rowset {
        private final Util.Functor1<Boolean, Catalog> tableCatalogCond = this.makeCondition(CATALOG_NAME_GETTER, TableCatalog);
        private final Util.Functor1<Boolean, Cube> tableNameCond = this.makeCondition(ELEMENT_NAME_GETTER, TableName);
        private final Util.Functor1<Boolean, String> columnNameCond = this.makeCondition(ColumnName);
        private static final Column TableCatalog = new Column("TABLE_CATALOG", Type.String, null, true, false, "The name of the Database.");
        private static final Column TableSchema = new Column("TABLE_SCHEMA", Type.String, null, true, true, null);
        private static final Column TableName = new Column("TABLE_NAME", Type.String, null, true, false, "The name of the cube.");
        private static final Column ColumnName = new Column("COLUMN_NAME", Type.String, null, true, false, "The name of the attribute hierarchy or measure.");
        private static final Column OrdinalPosition = new Column("ORDINAL_POSITION", Type.UnsignedInteger, null, false, false, "The position of the column, beginning with 1.");
        private static final Column ColumnHasDefault = new Column("COLUMN_HAS_DEFAULT", Type.Boolean, null, false, true, "Not supported.");
        private static final Column ColumnFlags = new Column("COLUMN_FLAGS", Type.UnsignedInteger, null, false, false, "A DBCOLUMNFLAGS bitmask indicating column properties.");
        private static final Column IsNullable = new Column("IS_NULLABLE", Type.Boolean, null, false, false, "Always returns false.");
        private static final Column DataType = new Column("DATA_TYPE", Type.UnsignedShort, null, false, false, "The data type of the column. Returns a string for dimension columns and a variant for measures.");
        private static final Column CharacterMaximumLength = new Column("CHARACTER_MAXIMUM_LENGTH", Type.UnsignedInteger, null, false, true, "The maximum possible length of a value within the column.");
        private static final Column CharacterOctetLength = new Column("CHARACTER_OCTET_LENGTH", Type.UnsignedInteger, null, false, true, "The maximum possible length of a value within the column, in bytes, for character or binary columns.");
        private static final Column NumericPrecision = new Column("NUMERIC_PRECISION", Type.UnsignedShort, null, false, true, "The maximum precision of the column for numeric data types other than DBTYPE_VARNUMERIC.");
        private static final Column NumericScale = new Column("NUMERIC_SCALE", Type.Short, null, false, true, "The number of digits to the right of the decimal point for DBTYPE_DECIMAL, DBTYPE_NUMERIC, DBTYPE_VARNUMERIC. Otherwise, this is NULL.");

        DbschemaColumnsRowset(XmlaRequest request, XmlaHandler handler) {
            super(DBSCHEMA_COLUMNS, request, handler);
        }

        @Override
        public void populateImpl(XmlaResponse response, OlapConnection connection, List<Rowset.Row> rows) throws XmlaException, OlapException {
            for (Catalog catalog : RowsetDefinition.catIter(connection, new Util.Functor1[]{this.catNameCond(), this.tableCatalogCond})) {
                Schema schema = (Schema)catalog.getSchemas().get(0);
                boolean emitInvisibleMembers = XmlaUtil.shouldEmitInvisibleMembers(this.request);
                int ordinalPosition = 1;
                for (Cube cube : Util.filter(RowsetDefinition.sortedCubes(schema), this.tableNameCond)) {
                    for (Dimension dimension : cube.getDimensions()) {
                        for (Hierarchy hierarchy : dimension.getHierarchies()) {
                            ordinalPosition = this.populateHierarchy(cube, hierarchy, ordinalPosition, rows);
                        }
                    }
                    List rms = cube.getMeasures();
                    int k = 1;
                    while (k < rms.size()) {
                        String memberName;
                        String columnName;
                        Measure member = (Measure)rms.get(k);
                        Boolean visible = (Boolean)member.getPropertyValue((Property)Property.StandardMemberProperty.$visible);
                        if (visible == null) {
                            visible = true;
                        }
                        if ((emitInvisibleMembers || visible.booleanValue()) && this.columnNameCond.apply(columnName = "Measures:" + (memberName = member.getName())).booleanValue()) {
                            Rowset.Row row = new Rowset.Row();
                            row.set(DbschemaColumnsRowset.TableCatalog.name, catalog.getName());
                            row.set(DbschemaColumnsRowset.TableName.name, cube.getName());
                            row.set(DbschemaColumnsRowset.ColumnName.name, columnName);
                            row.set(DbschemaColumnsRowset.OrdinalPosition.name, ordinalPosition++);
                            row.set(DbschemaColumnsRowset.ColumnHasDefault.name, false);
                            row.set(DbschemaColumnsRowset.ColumnFlags.name, 0);
                            row.set(DbschemaColumnsRowset.IsNullable.name, false);
                            row.set(DbschemaColumnsRowset.DataType.name, XmlaConstants.DBType.R8.xmlaOrdinal());
                            row.set(DbschemaColumnsRowset.NumericPrecision.name, 16);
                            row.set(DbschemaColumnsRowset.NumericScale.name, 255);
                            this.addRow(row, rows);
                        }
                        ++k;
                    }
                }
            }
        }

        private int populateHierarchy(Cube cube, Hierarchy hierarchy, int ordinalPosition, List<Rowset.Row> rows) {
            String schemaName = cube.getSchema().getName();
            String cubeName = cube.getName();
            String hierarchyName = hierarchy.getName();
            if (hierarchy.hasAll()) {
                Rowset.Row row = new Rowset.Row();
                row.set(DbschemaColumnsRowset.TableCatalog.name, schemaName);
                row.set(DbschemaColumnsRowset.TableName.name, cubeName);
                row.set(DbschemaColumnsRowset.ColumnName.name, String.valueOf(hierarchyName) + ":(All)!NAME");
                row.set(DbschemaColumnsRowset.OrdinalPosition.name, ordinalPosition++);
                row.set(DbschemaColumnsRowset.ColumnHasDefault.name, false);
                row.set(DbschemaColumnsRowset.ColumnFlags.name, 0);
                row.set(DbschemaColumnsRowset.IsNullable.name, false);
                row.set(DbschemaColumnsRowset.DataType.name, XmlaConstants.DBType.WSTR.xmlaOrdinal());
                row.set(DbschemaColumnsRowset.CharacterMaximumLength.name, 0);
                row.set(DbschemaColumnsRowset.CharacterOctetLength.name, 0);
                this.addRow(row, rows);
                row = new Rowset.Row();
                row.set(DbschemaColumnsRowset.TableCatalog.name, schemaName);
                row.set(DbschemaColumnsRowset.TableName.name, cubeName);
                row.set(DbschemaColumnsRowset.ColumnName.name, String.valueOf(hierarchyName) + ":(All)!UNIQUE_NAME");
                row.set(DbschemaColumnsRowset.OrdinalPosition.name, ordinalPosition++);
                row.set(DbschemaColumnsRowset.ColumnHasDefault.name, false);
                row.set(DbschemaColumnsRowset.ColumnFlags.name, 0);
                row.set(DbschemaColumnsRowset.IsNullable.name, false);
                row.set(DbschemaColumnsRowset.DataType.name, XmlaConstants.DBType.WSTR.xmlaOrdinal());
                row.set(DbschemaColumnsRowset.CharacterMaximumLength.name, 0);
                row.set(DbschemaColumnsRowset.CharacterOctetLength.name, 0);
                this.addRow(row, rows);
            }
            for (Level level : hierarchy.getLevels()) {
                ordinalPosition = this.populateLevel(cube, hierarchy, level, ordinalPosition, rows);
            }
            return ordinalPosition;
        }

        private int populateLevel(Cube cube, Hierarchy hierarchy, Level level, int ordinalPosition, List<Rowset.Row> rows) {
            String schemaName = cube.getSchema().getName();
            String cubeName = cube.getName();
            String hierarchyName = hierarchy.getName();
            String levelName = level.getName();
            Rowset.Row row = new Rowset.Row();
            row.set(DbschemaColumnsRowset.TableCatalog.name, schemaName);
            row.set(DbschemaColumnsRowset.TableName.name, cubeName);
            row.set(DbschemaColumnsRowset.ColumnName.name, String.valueOf(hierarchyName) + ':' + levelName + "!NAME");
            row.set(DbschemaColumnsRowset.OrdinalPosition.name, ordinalPosition++);
            row.set(DbschemaColumnsRowset.ColumnHasDefault.name, false);
            row.set(DbschemaColumnsRowset.ColumnFlags.name, 0);
            row.set(DbschemaColumnsRowset.IsNullable.name, false);
            row.set(DbschemaColumnsRowset.DataType.name, XmlaConstants.DBType.WSTR.xmlaOrdinal());
            row.set(DbschemaColumnsRowset.CharacterMaximumLength.name, 0);
            row.set(DbschemaColumnsRowset.CharacterOctetLength.name, 0);
            this.addRow(row, rows);
            row = new Rowset.Row();
            row.set(DbschemaColumnsRowset.TableCatalog.name, schemaName);
            row.set(DbschemaColumnsRowset.TableName.name, cubeName);
            row.set(DbschemaColumnsRowset.ColumnName.name, String.valueOf(hierarchyName) + ':' + levelName + "!UNIQUE_NAME");
            row.set(DbschemaColumnsRowset.OrdinalPosition.name, ordinalPosition++);
            row.set(DbschemaColumnsRowset.ColumnHasDefault.name, false);
            row.set(DbschemaColumnsRowset.ColumnFlags.name, 0);
            row.set(DbschemaColumnsRowset.IsNullable.name, false);
            row.set(DbschemaColumnsRowset.DataType.name, XmlaConstants.DBType.WSTR.xmlaOrdinal());
            row.set(DbschemaColumnsRowset.CharacterMaximumLength.name, 0);
            row.set(DbschemaColumnsRowset.CharacterOctetLength.name, 0);
            this.addRow(row, rows);
            NamedList props = level.getProperties();
            for (Property prop : props) {
                String propName = prop.getName();
                row = new Rowset.Row();
                row.set(DbschemaColumnsRowset.TableCatalog.name, schemaName);
                row.set(DbschemaColumnsRowset.TableName.name, cubeName);
                row.set(DbschemaColumnsRowset.ColumnName.name, String.valueOf(hierarchyName) + ':' + levelName + '!' + propName);
                row.set(DbschemaColumnsRowset.OrdinalPosition.name, ordinalPosition++);
                row.set(DbschemaColumnsRowset.ColumnHasDefault.name, false);
                row.set(DbschemaColumnsRowset.ColumnFlags.name, 0);
                row.set(DbschemaColumnsRowset.IsNullable.name, false);
                XmlaConstants.DBType dbType = RowsetDefinition.getDBTypeFromProperty(prop);
                row.set(DbschemaColumnsRowset.DataType.name, dbType.xmlaOrdinal());
                switch (prop.getDatatype()) {
                    case STRING: {
                        row.set(DbschemaColumnsRowset.CharacterMaximumLength.name, 0);
                        row.set(DbschemaColumnsRowset.CharacterOctetLength.name, 0);
                        break;
                    }
                    case INTEGER: 
                    case DOUBLE: 
                    case UNSIGNED_INTEGER: {
                        row.set(DbschemaColumnsRowset.NumericPrecision.name, 16);
                        row.set(DbschemaColumnsRowset.NumericScale.name, 255);
                        break;
                    }
                    case BOOLEAN: {
                        row.set(DbschemaColumnsRowset.NumericPrecision.name, 255);
                        row.set(DbschemaColumnsRowset.NumericScale.name, 255);
                        break;
                    }
                    default: {
                        row.set(DbschemaColumnsRowset.CharacterMaximumLength.name, 0);
                        row.set(DbschemaColumnsRowset.CharacterOctetLength.name, 0);
                    }
                }
                this.addRow(row, rows);
            }
            return ordinalPosition;
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$0() {
            return TableCatalog;
        }

        static /* synthetic */ Column access$1() {
            return TableSchema;
        }

        static /* synthetic */ Column access$2() {
            return TableName;
        }

        static /* synthetic */ Column access$3() {
            return ColumnName;
        }

        static /* synthetic */ Column access$4() {
            return OrdinalPosition;
        }

        static /* synthetic */ Column access$5() {
            return ColumnHasDefault;
        }

        static /* synthetic */ Column access$6() {
            return ColumnFlags;
        }

        static /* synthetic */ Column access$7() {
            return IsNullable;
        }

        static /* synthetic */ Column access$8() {
            return DataType;
        }

        static /* synthetic */ Column access$9() {
            return CharacterMaximumLength;
        }

        static /* synthetic */ Column access$10() {
            return CharacterOctetLength;
        }

        static /* synthetic */ Column access$11() {
            return NumericPrecision;
        }

        static /* synthetic */ Column access$12() {
            return NumericScale;
        }
    }

    static class DbschemaProviderTypesRowset
    extends Rowset {
        private final Util.Functor1<Boolean, Integer> dataTypeCond = this.makeCondition(DataType);
        private static final Column TypeName = new Column("TYPE_NAME", Type.String, null, false, false, "The provider-specific data type name.");
        private static final Column DataType = new Column("DATA_TYPE", Type.UnsignedShort, null, true, false, "The indicator of the data type.");
        private static final Column ColumnSize = new Column("COLUMN_SIZE", Type.UnsignedInteger, null, false, false, "The length of a non-numeric column. If the data type is numeric, this is the upper bound on the maximum precision of the data type.");
        private static final Column LiteralPrefix = new Column("LITERAL_PREFIX", Type.String, null, false, true, "The character or characters used to prefix a literal of this type in a text command.");
        private static final Column LiteralSuffix = new Column("LITERAL_SUFFIX", Type.String, null, false, true, "The character or characters used to suffix a literal of this type in a text command.");
        private static final Column IsNullable = new Column("IS_NULLABLE", Type.Boolean, null, false, true, "A Boolean that indicates whether the data type is nullable. NULL-- indicates that it is not known whether the data type is nullable.");
        private static final Column CaseSensitive = new Column("CASE_SENSITIVE", Type.Boolean, null, false, true, "A Boolean that indicates whether the data type is a characters type and case-sensitive.");
        private static final Column Searchable = new Column("SEARCHABLE", Type.UnsignedInteger, null, false, true, "An integer indicating how the data type can be used in searches if the provider supports ICommandText; otherwise, NULL.");
        private static final Column UnsignedAttribute = new Column("UNSIGNED_ATTRIBUTE", Type.Boolean, null, false, true, "A Boolean that indicates whether the data type is unsigned.");
        private static final Column FixedPrecScale = new Column("FIXED_PREC_SCALE", Type.Boolean, null, false, true, "A Boolean that indicates whether the data type has a fixed precision and scale.");
        private static final Column AutoUniqueValue = new Column("AUTO_UNIQUE_VALUE", Type.Boolean, null, false, true, "A Boolean that indicates whether the data type is autoincrementing.");
        private static final Column IsLong = new Column("IS_LONG", Type.Boolean, null, false, true, "A Boolean that indicates whether the data type is a binary large object (BLOB) and has very long data.");
        private static final Column BestMatch = new Column("BEST_MATCH", Type.Boolean, null, true, true, "A Boolean that indicates whether the data type is a best match.");

        DbschemaProviderTypesRowset(XmlaRequest request, XmlaHandler handler) {
            super(DBSCHEMA_PROVIDER_TYPES, request, handler);
        }

        @Override
        protected boolean needConnection() {
            return false;
        }

        @Override
        public void populateImpl(XmlaResponse response, OlapConnection connection, List<Rowset.Row> rows) throws XmlaException {
            Rowset.Row row;
            Integer dt = XmlaConstants.DBType.I4.xmlaOrdinal();
            if (this.dataTypeCond.apply(dt).booleanValue()) {
                row = new Rowset.Row();
                row.set(DbschemaProviderTypesRowset.TypeName.name, XmlaConstants.DBType.I4.userName);
                row.set(DbschemaProviderTypesRowset.DataType.name, dt);
                row.set(DbschemaProviderTypesRowset.ColumnSize.name, 8);
                row.set(DbschemaProviderTypesRowset.IsNullable.name, true);
                row.set(DbschemaProviderTypesRowset.Searchable.name, null);
                row.set(DbschemaProviderTypesRowset.UnsignedAttribute.name, false);
                row.set(DbschemaProviderTypesRowset.FixedPrecScale.name, false);
                row.set(DbschemaProviderTypesRowset.AutoUniqueValue.name, false);
                row.set(DbschemaProviderTypesRowset.IsLong.name, false);
                row.set(DbschemaProviderTypesRowset.BestMatch.name, true);
                this.addRow(row, rows);
            }
            if (this.dataTypeCond.apply(dt = Integer.valueOf(XmlaConstants.DBType.R8.xmlaOrdinal())).booleanValue()) {
                row = new Rowset.Row();
                row.set(DbschemaProviderTypesRowset.TypeName.name, XmlaConstants.DBType.R8.userName);
                row.set(DbschemaProviderTypesRowset.DataType.name, dt);
                row.set(DbschemaProviderTypesRowset.ColumnSize.name, 16);
                row.set(DbschemaProviderTypesRowset.IsNullable.name, true);
                row.set(DbschemaProviderTypesRowset.Searchable.name, null);
                row.set(DbschemaProviderTypesRowset.UnsignedAttribute.name, false);
                row.set(DbschemaProviderTypesRowset.FixedPrecScale.name, false);
                row.set(DbschemaProviderTypesRowset.AutoUniqueValue.name, false);
                row.set(DbschemaProviderTypesRowset.IsLong.name, false);
                row.set(DbschemaProviderTypesRowset.BestMatch.name, true);
                this.addRow(row, rows);
            }
            if (this.dataTypeCond.apply(dt = Integer.valueOf(XmlaConstants.DBType.CY.xmlaOrdinal())).booleanValue()) {
                row = new Rowset.Row();
                row.set(DbschemaProviderTypesRowset.TypeName.name, XmlaConstants.DBType.CY.userName);
                row.set(DbschemaProviderTypesRowset.DataType.name, dt);
                row.set(DbschemaProviderTypesRowset.ColumnSize.name, 8);
                row.set(DbschemaProviderTypesRowset.IsNullable.name, true);
                row.set(DbschemaProviderTypesRowset.Searchable.name, null);
                row.set(DbschemaProviderTypesRowset.UnsignedAttribute.name, false);
                row.set(DbschemaProviderTypesRowset.FixedPrecScale.name, false);
                row.set(DbschemaProviderTypesRowset.AutoUniqueValue.name, false);
                row.set(DbschemaProviderTypesRowset.IsLong.name, false);
                row.set(DbschemaProviderTypesRowset.BestMatch.name, true);
                this.addRow(row, rows);
            }
            if (this.dataTypeCond.apply(dt = Integer.valueOf(XmlaConstants.DBType.BOOL.xmlaOrdinal())).booleanValue()) {
                row = new Rowset.Row();
                row.set(DbschemaProviderTypesRowset.TypeName.name, XmlaConstants.DBType.BOOL.userName);
                row.set(DbschemaProviderTypesRowset.DataType.name, dt);
                row.set(DbschemaProviderTypesRowset.ColumnSize.name, 1);
                row.set(DbschemaProviderTypesRowset.IsNullable.name, true);
                row.set(DbschemaProviderTypesRowset.Searchable.name, null);
                row.set(DbschemaProviderTypesRowset.UnsignedAttribute.name, false);
                row.set(DbschemaProviderTypesRowset.FixedPrecScale.name, false);
                row.set(DbschemaProviderTypesRowset.AutoUniqueValue.name, false);
                row.set(DbschemaProviderTypesRowset.IsLong.name, false);
                row.set(DbschemaProviderTypesRowset.BestMatch.name, true);
                this.addRow(row, rows);
            }
            if (this.dataTypeCond.apply(dt = Integer.valueOf(XmlaConstants.DBType.I8.xmlaOrdinal())).booleanValue()) {
                row = new Rowset.Row();
                row.set(DbschemaProviderTypesRowset.TypeName.name, XmlaConstants.DBType.I8.userName);
                row.set(DbschemaProviderTypesRowset.DataType.name, dt);
                row.set(DbschemaProviderTypesRowset.ColumnSize.name, 16);
                row.set(DbschemaProviderTypesRowset.IsNullable.name, true);
                row.set(DbschemaProviderTypesRowset.Searchable.name, null);
                row.set(DbschemaProviderTypesRowset.UnsignedAttribute.name, false);
                row.set(DbschemaProviderTypesRowset.FixedPrecScale.name, false);
                row.set(DbschemaProviderTypesRowset.AutoUniqueValue.name, false);
                row.set(DbschemaProviderTypesRowset.IsLong.name, false);
                row.set(DbschemaProviderTypesRowset.BestMatch.name, true);
                this.addRow(row, rows);
            }
            if (this.dataTypeCond.apply(dt = Integer.valueOf(XmlaConstants.DBType.WSTR.xmlaOrdinal())).booleanValue()) {
                row = new Rowset.Row();
                row.set(DbschemaProviderTypesRowset.TypeName.name, XmlaConstants.DBType.WSTR.userName);
                row.set(DbschemaProviderTypesRowset.DataType.name, dt);
                row.set(DbschemaProviderTypesRowset.ColumnSize.name, 255);
                row.set(DbschemaProviderTypesRowset.LiteralPrefix.name, "\"");
                row.set(DbschemaProviderTypesRowset.LiteralSuffix.name, "\"");
                row.set(DbschemaProviderTypesRowset.IsNullable.name, true);
                row.set(DbschemaProviderTypesRowset.CaseSensitive.name, false);
                row.set(DbschemaProviderTypesRowset.Searchable.name, null);
                row.set(DbschemaProviderTypesRowset.FixedPrecScale.name, false);
                row.set(DbschemaProviderTypesRowset.AutoUniqueValue.name, false);
                row.set(DbschemaProviderTypesRowset.IsLong.name, false);
                row.set(DbschemaProviderTypesRowset.BestMatch.name, true);
                this.addRow(row, rows);
            }
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$0() {
            return TypeName;
        }

        static /* synthetic */ Column access$1() {
            return DataType;
        }

        static /* synthetic */ Column access$2() {
            return ColumnSize;
        }

        static /* synthetic */ Column access$3() {
            return LiteralPrefix;
        }

        static /* synthetic */ Column access$4() {
            return LiteralSuffix;
        }

        static /* synthetic */ Column access$5() {
            return IsNullable;
        }

        static /* synthetic */ Column access$6() {
            return CaseSensitive;
        }

        static /* synthetic */ Column access$7() {
            return Searchable;
        }

        static /* synthetic */ Column access$8() {
            return UnsignedAttribute;
        }

        static /* synthetic */ Column access$9() {
            return FixedPrecScale;
        }

        static /* synthetic */ Column access$10() {
            return AutoUniqueValue;
        }

        static /* synthetic */ Column access$11() {
            return IsLong;
        }

        static /* synthetic */ Column access$12() {
            return BestMatch;
        }
    }

    static class DbschemaSchemataRowset
    extends Rowset {
        private final Util.Functor1<Boolean, Catalog> catalogNameCond = this.makeCondition(CATALOG_NAME_GETTER, CatalogName);
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, false, "The provider-specific data type name.");
        private static final Column SchemaName = new Column("SCHEMA_NAME", Type.String, null, true, false, "The indicator of the data type.");
        private static final Column SchemaOwner = new Column("SCHEMA_OWNER", Type.String, null, true, false, "The length of a non-numeric column. If the data type is numeric, this is the upper bound on the maximum precision of the data type.");

        DbschemaSchemataRowset(XmlaRequest request, XmlaHandler handler) {
            super(DBSCHEMA_SCHEMATA, request, handler);
        }

        @Override
        public void populateImpl(XmlaResponse response, OlapConnection connection, List<Rowset.Row> rows) throws XmlaException, OlapException {
            for (Catalog catalog : RowsetDefinition.catIter(connection, new Util.Functor1[]{this.catalogNameCond, this.catNameCond()})) {
                for (Schema schema : catalog.getSchemas()) {
                    Rowset.Row row = new Rowset.Row();
                    row.set(DbschemaSchemataRowset.CatalogName.name, catalog.getName());
                    row.set(DbschemaSchemataRowset.SchemaName.name, schema.getName());
                    row.set(DbschemaSchemataRowset.SchemaOwner.name, "");
                    this.addRow(row, rows);
                }
            }
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$0() {
            return CatalogName;
        }

        static /* synthetic */ Column access$1() {
            return SchemaName;
        }

        static /* synthetic */ Column access$2() {
            return SchemaOwner;
        }
    }

    static class DbschemaTablesInfoRowset
    extends Rowset {
        private static final Column TableCatalog = new Column("TABLE_CATALOG", Type.String, null, true, true, "Catalog name. NULL if the provider does not support catalogs.");
        private static final Column TableSchema = new Column("TABLE_SCHEMA", Type.String, null, true, true, "Unqualified schema name. NULL if the provider does not support schemas.");
        private static final Column TableName = new Column("TABLE_NAME", Type.String, null, true, false, "Table name.");
        private static final Column TableType = new Column("TABLE_TYPE", Type.String, null, true, false, "Table type. One of the following or a provider-specific value: ALIAS, TABLE, SYNONYM, SYSTEM TABLE, VIEW, GLOBAL TEMPORARY, LOCAL TEMPORARY, EXTERNAL TABLE, SYSTEM VIEW");
        private static final Column TableGuid = new Column("TABLE_GUID", Type.UUID, null, false, true, "GUID that uniquely identifies the table. Providers that do not use GUIDs to identify tables should return NULL in this column.");
        private static final Column Bookmarks = new Column("BOOKMARKS", Type.Boolean, null, false, false, "Whether this table supports bookmarks. Allways is false.");
        private static final Column BookmarkType = new Column("BOOKMARK_TYPE", Type.Integer, null, false, true, "Default bookmark type supported on this table.");
        private static final Column BookmarkDataType = new Column("BOOKMARK_DATATYPE", Type.UnsignedShort, null, false, true, "The indicator of the bookmark's native data type.");
        private static final Column BookmarkMaximumLength = new Column("BOOKMARK_MAXIMUM_LENGTH", Type.UnsignedInteger, null, false, true, "Maximum length of the bookmark in bytes.");
        private static final Column BookmarkInformation = new Column("BOOKMARK_INFORMATION", Type.UnsignedInteger, null, false, true, "A bitmask specifying additional information about bookmarks over the rowset. ");
        private static final Column TableVersion = new Column("TABLE_VERSION", Type.Long, null, false, true, "Version number for this table or NULL if the provider does not support returning table version information.");
        private static final Column Cardinality = new Column("CARDINALITY", Type.UnsignedLong, null, false, false, "Cardinality (number of rows) of the table.");
        private static final Column Description = new Column("DESCRIPTION", Type.String, null, false, true, "Human-readable description of the table.");
        private static final Column TablePropId = new Column("TABLE_PROPID", Type.UnsignedInteger, null, false, true, "Property ID of the table. Return null.");

        DbschemaTablesInfoRowset(XmlaRequest request, XmlaHandler handler) {
            super(DBSCHEMA_TABLES_INFO, request, handler);
        }

        @Override
        public void populateImpl(XmlaResponse response, OlapConnection connection, List<Rowset.Row> rows) throws XmlaException, OlapException {
            for (Catalog catalog : RowsetDefinition.catIter(connection, new Util.Functor1[]{this.catNameCond()})) {
                Schema schema = (Schema)catalog.getSchemas().get(0);
                for (Cube cube : RowsetDefinition.sortedCubes(schema)) {
                    String cubeName = cube.getName();
                    String desc = cube.getDescription();
                    if (desc == null) {
                        desc = String.valueOf(catalog.getName()) + " - " + cubeName + " Cube";
                    }
                    int cardinality = 1000000;
                    String version = "null";
                    Rowset.Row row = new Rowset.Row();
                    row.set(DbschemaTablesInfoRowset.TableCatalog.name, catalog.getName());
                    row.set(DbschemaTablesInfoRowset.TableName.name, cubeName);
                    row.set(DbschemaTablesInfoRowset.TableType.name, "TABLE");
                    row.set(DbschemaTablesInfoRowset.Bookmarks.name, false);
                    row.set(DbschemaTablesInfoRowset.TableVersion.name, version);
                    row.set(DbschemaTablesInfoRowset.Cardinality.name, cardinality);
                    row.set(DbschemaTablesInfoRowset.Description.name, desc);
                    this.addRow(row, rows);
                }
            }
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$0() {
            return TableCatalog;
        }

        static /* synthetic */ Column access$1() {
            return TableSchema;
        }

        static /* synthetic */ Column access$2() {
            return TableName;
        }

        static /* synthetic */ Column access$3() {
            return TableType;
        }

        static /* synthetic */ Column access$4() {
            return TableGuid;
        }

        static /* synthetic */ Column access$5() {
            return Bookmarks;
        }

        static /* synthetic */ Column access$6() {
            return BookmarkType;
        }

        static /* synthetic */ Column access$7() {
            return BookmarkDataType;
        }

        static /* synthetic */ Column access$8() {
            return BookmarkMaximumLength;
        }

        static /* synthetic */ Column access$9() {
            return BookmarkInformation;
        }

        static /* synthetic */ Column access$10() {
            return TableVersion;
        }

        static /* synthetic */ Column access$11() {
            return Cardinality;
        }

        static /* synthetic */ Column access$12() {
            return Description;
        }

        static /* synthetic */ Column access$13() {
            return TablePropId;
        }
    }

    static class DbschemaTablesRowset
    extends Rowset {
        private final Util.Functor1<Boolean, Catalog> tableCatalogCond = this.makeCondition(CATALOG_NAME_GETTER, TableCatalog);
        private final Util.Functor1<Boolean, Cube> tableNameCond = this.makeCondition(ELEMENT_NAME_GETTER, TableName);
        private final Util.Functor1<Boolean, String> tableTypeCond = this.makeCondition(TableType);
        private static final Column TableCatalog = new Column("TABLE_CATALOG", Type.String, null, true, false, "The name of the catalog to which this object belongs.");
        private static final Column TableSchema = new Column("TABLE_SCHEMA", Type.String, null, true, true, "The name of the cube to which this object belongs.");
        private static final Column TableName = new Column("TABLE_NAME", Type.String, null, true, false, "The name of the object, if TABLE_TYPE is TABLE.");
        private static final Column TableType = new Column("TABLE_TYPE", Type.String, null, true, false, "The type of the table. TABLE indicates the object is a measure group. SYSTEM TABLE indicates the object is a dimension.");
        private static final Column TableGuid = new Column("TABLE_GUID", Type.UUID, null, false, true, "Not supported.");
        private static final Column Description = new Column("DESCRIPTION", Type.String, null, false, true, "A human-readable description of the object.");
        private static final Column TablePropId = new Column("TABLE_PROPID", Type.UnsignedInteger, null, false, true, "Not supported.");
        private static final Column DateCreated = new Column("DATE_CREATED", Type.DateTime, null, false, true, "Not supported.");
        private static final Column DateModified = new Column("DATE_MODIFIED", Type.DateTime, null, false, true, "The date the object was last modified.");

        DbschemaTablesRowset(XmlaRequest request, XmlaHandler handler) {
            super(DBSCHEMA_TABLES, request, handler);
        }

        @Override
        public void populateImpl(XmlaResponse response, OlapConnection connection, List<Rowset.Row> rows) throws XmlaException, OlapException {
            for (Catalog catalog : RowsetDefinition.catIter(connection, new Util.Functor1[]{this.catNameCond(), this.tableCatalogCond})) {
                Schema schema = (Schema)catalog.getSchemas().get(0);
                for (Cube cube : Util.filter(RowsetDefinition.sortedCubes(schema), this.tableNameCond)) {
                    String desc = cube.getDescription();
                    if (desc == null) {
                        desc = String.valueOf(catalog.getName()) + " - " + cube.getName() + " Cube";
                    }
                    if (this.tableTypeCond.apply("TABLE").booleanValue()) {
                        Rowset.Row row = new Rowset.Row();
                        row.set(DbschemaTablesRowset.TableCatalog.name, catalog.getName());
                        row.set(DbschemaTablesRowset.TableName.name, cube.getName());
                        row.set(DbschemaTablesRowset.TableType.name, "TABLE");
                        row.set(DbschemaTablesRowset.Description.name, desc);
                        this.addRow(row, rows);
                    }
                    if (!this.tableTypeCond.apply("SYSTEM TABLE").booleanValue()) continue;
                    for (Dimension dimension : cube.getDimensions()) {
                        if (dimension.getDimensionType() == Dimension.Type.MEASURE) continue;
                        for (Hierarchy hierarchy : dimension.getHierarchies()) {
                            this.populateHierarchy(cube, hierarchy, rows);
                        }
                    }
                }
            }
        }

        private void populateHierarchy(Cube cube, Hierarchy hierarchy, List<Rowset.Row> rows) {
            for (Level level : hierarchy.getLevels()) {
                this.populateLevel(cube, hierarchy, level, rows);
            }
        }

        private void populateLevel(Cube cube, Hierarchy hierarchy, Level level, List<Rowset.Row> rows) {
            String schemaName = cube.getSchema().getName();
            String cubeName = cube.getName();
            String hierarchyName = RowsetDefinition.getHierarchyName(hierarchy);
            String levelName = level.getName();
            String tableName = String.valueOf(cubeName) + ':' + hierarchyName + ':' + levelName;
            String desc = level.getDescription();
            if (desc == null) {
                desc = String.valueOf(schemaName) + " - " + cubeName + " Cube - " + hierarchyName + " Hierarchy - " + levelName + " Level";
            }
            Rowset.Row row = new Rowset.Row();
            row.set(DbschemaTablesRowset.TableCatalog.name, schemaName);
            row.set(DbschemaTablesRowset.TableName.name, tableName);
            row.set(DbschemaTablesRowset.TableType.name, "SYSTEM TABLE");
            row.set(DbschemaTablesRowset.Description.name, desc);
            this.addRow(row, rows);
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$0() {
            return TableCatalog;
        }

        static /* synthetic */ Column access$1() {
            return TableSchema;
        }

        static /* synthetic */ Column access$2() {
            return TableName;
        }

        static /* synthetic */ Column access$3() {
            return TableType;
        }

        static /* synthetic */ Column access$4() {
            return TableGuid;
        }

        static /* synthetic */ Column access$5() {
            return Description;
        }

        static /* synthetic */ Column access$6() {
            return TablePropId;
        }

        static /* synthetic */ Column access$7() {
            return DateCreated;
        }

        static /* synthetic */ Column access$8() {
            return DateModified;
        }
    }

    private static class DelegatingXmlaRequest
    implements XmlaRequest {
        protected final XmlaRequest request;

        public DelegatingXmlaRequest(XmlaRequest request) {
            this.request = request;
        }

        @Override
        public XmlaConstants.Method getMethod() {
            return this.request.getMethod();
        }

        @Override
        public Map<String, String> getProperties() {
            return this.request.getProperties();
        }

        @Override
        public Map<String, Object> getRestrictions() {
            return this.request.getRestrictions();
        }

        @Override
        public String getStatement() {
            return this.request.getStatement();
        }

        @Override
        public String getRoleName() {
            return this.request.getRoleName();
        }

        @Override
        public String getRequestType() {
            return this.request.getRequestType();
        }

        @Override
        public boolean isDrillThrough() {
            return this.request.isDrillThrough();
        }

        @Override
        public String getUsername() {
            return this.request.getUsername();
        }

        @Override
        public String getPassword() {
            return this.request.getPassword();
        }

        @Override
        public String getSessionId() {
            return this.request.getSessionId();
        }
    }

    static class DiscoverDatasourcesRowset
    extends Rowset {
        private static final Column DataSourceName = new Column("DataSourceName", Type.String, null, true, false, "The name of the data source, such as FoodMart 2000.");
        private static final Column DataSourceDescription = new Column("DataSourceDescription", Type.String, null, false, true, "A description of the data source, as entered by the publisher.");
        private static final Column URL = new Column("URL", Type.String, null, true, true, "The unique path that shows where to invoke the XML for Analysis methods for that data source.");
        private static final Column DataSourceInfo = new Column("DataSourceInfo", Type.String, null, false, true, "A string containing any additional information required to connect to the data source. This can include the Initial Catalog property or other information for the provider.\nExample: \"Provider=MSOLAP;Data Source=Local;\"");
        private static final Column ProviderName = new Column("ProviderName", Type.String, null, true, true, "The name of the provider behind the data source.\nExample: \"MSDASQL\"");
        private static final Column ProviderType = new Column("ProviderType", Type.EnumerationArray, Enumeration.PROVIDER_TYPE, true, false, true, "The types of data supported by the provider. May include one or more of the following types. Example follows this table.\nTDP: tabular data provider.\nMDP: multidimensional data provider.\nDMP: data mining provider. A DMP provider implements the OLE DB for Data Mining specification.");
        private static final Column AuthenticationMode = new Column("AuthenticationMode", Type.EnumString, Enumeration.AUTHENTICATION_MODE, true, false, "Specification of what type of security mode the data source uses. Values can be one of the following:\nUnauthenticated: no user ID or password needs to be sent.\nAuthenticated: User ID and Password must be included in the information required for the connection.\nIntegrated: the data source uses the underlying security to determine authorization, such as Integrated Security provided by Microsoft Internet Information Services (IIS).");
        private static final Column[] columns = new Column[]{DataSourceName, DataSourceDescription, URL, DataSourceInfo, ProviderName, ProviderType, AuthenticationMode};

        public DiscoverDatasourcesRowset(XmlaRequest request, XmlaHandler handler) {
            super(DISCOVER_DATASOURCES, request, handler);
        }

        @Override
        public void populateImpl(XmlaResponse response, OlapConnection connection, List<Rowset.Row> rows) throws XmlaException, SQLException {
            if (this.needConnection()) {
                XmlaHandler.XmlaExtra extra = XmlaHandler.getExtra(connection);
                for (Map<String, Object> ds : extra.getDataSources(connection)) {
                    Rowset.Row row = new Rowset.Row();
                    Column[] columnArray = columns;
                    int n = columns.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Column column = columnArray[n2];
                        row.set(column.name, ds.get(column.name));
                        ++n2;
                    }
                    this.addRow(row, rows);
                }
            } else {
                Rowset.Row row = new Rowset.Row();
                Map<String, Object> map = this.handler.connectionFactory.getPreConfiguredDiscoverDatasourcesResponse();
                Column[] columnArray = columns;
                int n = columns.length;
                int n3 = 0;
                while (n3 < n) {
                    Column column = columnArray[n3];
                    row.set(column.name, map.get(column.name));
                    ++n3;
                }
                this.addRow(row, rows);
            }
        }

        @Override
        protected boolean needConnection() {
            return this.handler.connectionFactory.getPreConfiguredDiscoverDatasourcesResponse() == null;
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$0() {
            return DataSourceName;
        }

        static /* synthetic */ Column access$1() {
            return DataSourceDescription;
        }

        static /* synthetic */ Column access$2() {
            return URL;
        }

        static /* synthetic */ Column access$3() {
            return DataSourceInfo;
        }

        static /* synthetic */ Column access$4() {
            return ProviderName;
        }

        static /* synthetic */ Column access$5() {
            return ProviderType;
        }

        static /* synthetic */ Column access$6() {
            return AuthenticationMode;
        }
    }

    static class DiscoverEnumeratorsRowset
    extends Rowset {
        private static final Column EnumName = new Column("EnumName", Type.StringArray, null, true, false, "The name of the enumerator that contains a set of values.");
        private static final Column EnumDescription = new Column("EnumDescription", Type.String, null, false, true, "A localizable description of the enumerator.");
        private static final Column EnumType = new Column("EnumType", Type.String, null, false, false, "The data type of the Enum values.");
        private static final Column ElementName = new Column("ElementName", Type.String, null, false, false, "The name of one of the value elements in the enumerator set.\nExample: TDP");
        private static final Column ElementDescription = new Column("ElementDescription", Type.String, null, false, true, "A localizable description of the element (optional).");
        private static final Column ElementValue = new Column("ElementValue", Type.String, null, false, true, "The value of the element.\nExample: 01");

        DiscoverEnumeratorsRowset(XmlaRequest request, XmlaHandler handler) {
            super(DISCOVER_ENUMERATORS, request, handler);
        }

        @Override
        public void populateImpl(XmlaResponse response, OlapConnection connection, List<Rowset.Row> rows) throws XmlaException {
            List<Enumeration> enumerators = DiscoverEnumeratorsRowset.getEnumerators();
            for (Enumeration enumerator : enumerators) {
                List<? extends Enum> values = enumerator.getValues();
                for (Enum enum_ : values) {
                    String description;
                    Rowset.Row row = new Rowset.Row();
                    row.set(DiscoverEnumeratorsRowset.EnumName.name, enumerator.name);
                    row.set(DiscoverEnumeratorsRowset.EnumDescription.name, enumerator.description);
                    row.set(DiscoverEnumeratorsRowset.EnumType.name, "string");
                    String name = enum_ instanceof XmlaConstant ? ((XmlaConstant)enum_).xmlaName() : enum_.name();
                    row.set(DiscoverEnumeratorsRowset.ElementName.name, name);
                    String string = enum_ instanceof XmlaConstant ? ((XmlaConstant)enum_).getDescription() : (description = enum_ instanceof XmlaConstants.EnumWithDesc ? ((XmlaConstants.EnumWithDesc)enum_).getDescription() : null);
                    if (description != null) {
                        row.set(DiscoverEnumeratorsRowset.ElementDescription.name, description);
                    }
                    switch (enumerator.type) {
                        case String: 
                        case StringArray: {
                            break;
                        }
                        default: {
                            int ordinal = enum_ instanceof XmlaConstant && ((XmlaConstant)enum_).xmlaOrdinal() != -1 ? ((XmlaConstant)enum_).xmlaOrdinal() : enum_.ordinal();
                            row.set(DiscoverEnumeratorsRowset.ElementValue.name, ordinal);
                        }
                    }
                    this.addRow(row, rows);
                }
            }
        }

        private static List<Enumeration> getEnumerators() {
            TreeSet<Enumeration> enumeratorSet = new TreeSet<Enumeration>(new Comparator<Enumeration>(){

                @Override
                public int compare(Enumeration o1, Enumeration o2) {
                    return o1.name.compareTo(o2.name);
                }
            });
            RowsetDefinition[] rowsetDefinitionArray = (RowsetDefinition[])RowsetDefinition.class.getEnumConstants();
            int n = rowsetDefinitionArray.length;
            int n2 = 0;
            while (n2 < n) {
                RowsetDefinition rowsetDefinition = rowsetDefinitionArray[n2];
                Column[] columnArray = rowsetDefinition.columnDefinitions;
                int n3 = rowsetDefinition.columnDefinitions.length;
                int n4 = 0;
                while (n4 < n3) {
                    Column column = columnArray[n4];
                    if (column.enumeration != null) {
                        enumeratorSet.add(column.enumeration);
                    }
                    ++n4;
                }
                ++n2;
            }
            return new ArrayList<Enumeration>(enumeratorSet);
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$0() {
            return EnumName;
        }

        static /* synthetic */ Column access$1() {
            return EnumDescription;
        }

        static /* synthetic */ Column access$2() {
            return EnumType;
        }

        static /* synthetic */ Column access$3() {
            return ElementName;
        }

        static /* synthetic */ Column access$4() {
            return ElementDescription;
        }

        static /* synthetic */ Column access$5() {
            return ElementValue;
        }
    }

    static class DiscoverKeywordsRowset
    extends Rowset {
        private static final Column Keyword = new Column("Keyword", Type.StringSometimesArray, null, true, false, "A list of all the keywords reserved by a provider.\nExample: AND");

        DiscoverKeywordsRowset(XmlaRequest request, XmlaHandler handler) {
            super(DISCOVER_KEYWORDS, request, handler);
        }

        @Override
        public void populateImpl(XmlaResponse response, OlapConnection connection, List<Rowset.Row> rows) throws XmlaException {
            MondrianServer mondrianServer = MondrianServer.forId(null);
            for (String keyword : mondrianServer.getKeywords()) {
                Rowset.Row row = new Rowset.Row();
                row.set(DiscoverKeywordsRowset.Keyword.name, keyword);
                this.addRow(row, rows);
            }
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$0() {
            return Keyword;
        }
    }

    static class DiscoverLiteralsRowset
    extends Rowset {
        private static final Column LiteralName = new Column("LiteralName", Type.StringSometimesArray, null, true, false, "The name of the literal described in the row.\nExample: DBLITERAL_LIKE_PERCENT");
        private static final Column LiteralValue = new Column("LiteralValue", Type.String, null, false, true, "Contains the actual literal value.\nExample, if LiteralName is DBLITERAL_LIKE_PERCENT and the percent character (%) is used to match zero or more characters in a LIKE clause, this column's value would be \"%\".");
        private static final Column LiteralInvalidChars = new Column("LiteralInvalidChars", Type.String, null, false, true, "The characters, in the literal, that are not valid.\nFor example, if table names can contain anything other than a numeric character, this string would be \"0123456789\".");
        private static final Column LiteralInvalidStartingChars = new Column("LiteralInvalidStartingChars", Type.String, null, false, true, "The characters that are not valid as the first character of the literal. If the literal can start with any valid character, this is null.");
        private static final Column LiteralMaxLength = new Column("LiteralMaxLength", Type.Integer, null, false, true, "The maximum number of characters in the literal. If there is no maximum or the maximum is unknown, the value is ?1.");

        DiscoverLiteralsRowset(XmlaRequest request, XmlaHandler handler) {
            super(DISCOVER_LITERALS, request, handler);
        }

        @Override
        public void populateImpl(XmlaResponse response, OlapConnection connection, List<Rowset.Row> rows) throws XmlaException {
            this.populate(XmlaConstants.Literal.class, rows, new Comparator<XmlaConstants.Literal>(){

                @Override
                public int compare(XmlaConstants.Literal o1, XmlaConstants.Literal o2) {
                    return o1.name().compareTo(o2.name());
                }
            });
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$0() {
            return LiteralName;
        }

        static /* synthetic */ Column access$1() {
            return LiteralValue;
        }

        static /* synthetic */ Column access$2() {
            return LiteralInvalidChars;
        }

        static /* synthetic */ Column access$3() {
            return LiteralInvalidStartingChars;
        }

        static /* synthetic */ Column access$4() {
            return LiteralMaxLength;
        }
    }

    static class DiscoverPropertiesRowset
    extends Rowset {
        private final Util.Functor1<Boolean, PropertyDefinition> propNameCond = this.makeCondition(PROPDEF_NAME_GETTER, PropertyName);
        private static final Column PropertyName = new Column("PropertyName", Type.StringSometimesArray, null, true, false, "The name of the property.");
        private static final Column PropertyDescription = new Column("PropertyDescription", Type.String, null, false, false, "A localizable text description of the property.");
        private static final Column PropertyType = new Column("PropertyType", Type.String, null, false, false, "The XML data type of the property.");
        private static final Column PropertyAccessType = new Column("PropertyAccessType", Type.EnumString, Enumeration.ACCESS, false, false, "Access for the property. The value can be Read, Write, or ReadWrite.");
        private static final Column IsRequired = new Column("IsRequired", Type.Boolean, null, false, false, "True if a property is required, false if it is not required.");
        private static final Column Value = new Column("Value", Type.String, null, false, false, "The current value of the property.");

        DiscoverPropertiesRowset(XmlaRequest request, XmlaHandler handler) {
            super(DISCOVER_PROPERTIES, request, handler);
        }

        @Override
        protected boolean needConnection() {
            return false;
        }

        @Override
        public void populateImpl(XmlaResponse response, OlapConnection connection, List<Rowset.Row> rows) throws XmlaException {
            PropertyDefinition[] propertyDefinitionArray = (PropertyDefinition[])PropertyDefinition.class.getEnumConstants();
            int n = propertyDefinitionArray.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDefinition propertyDefinition = propertyDefinitionArray[n2];
                if (this.propNameCond.apply(propertyDefinition).booleanValue()) {
                    Rowset.Row row = new Rowset.Row();
                    row.set(DiscoverPropertiesRowset.PropertyName.name, propertyDefinition.name());
                    row.set(DiscoverPropertiesRowset.PropertyDescription.name, propertyDefinition.description);
                    row.set(DiscoverPropertiesRowset.PropertyType.name, propertyDefinition.type.getName());
                    row.set(DiscoverPropertiesRowset.PropertyAccessType.name, propertyDefinition.access);
                    row.set(DiscoverPropertiesRowset.IsRequired.name, false);
                    row.set(DiscoverPropertiesRowset.Value.name, propertyDefinition.value);
                    this.addRow(row, rows);
                }
                ++n2;
            }
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$0() {
            return PropertyName;
        }

        static /* synthetic */ Column access$1() {
            return PropertyDescription;
        }

        static /* synthetic */ Column access$2() {
            return PropertyType;
        }

        static /* synthetic */ Column access$3() {
            return PropertyAccessType;
        }

        static /* synthetic */ Column access$4() {
            return IsRequired;
        }

        static /* synthetic */ Column access$5() {
            return Value;
        }
    }

    static class DiscoverSchemaRowsetsRowset
    extends Rowset {
        private static final Column SchemaName = new Column("SchemaName", Type.StringArray, null, true, false, "The name of the schema/request. This returns the values in the RequestTypes enumeration, plus any additional types supported by the provider. The provider defines rowset structures for the additional types");
        private static final Column SchemaGuid = new Column("SchemaGuid", Type.UUID, null, false, true, "The GUID of the schema.");
        private static final Column Restrictions = new Column("Restrictions", Type.Array, null, false, false, "An array of the restrictions suppoted by provider. An example follows this table.");
        private static final Column Description = new Column("Description", Type.String, null, false, false, "A localizable description of the schema");

        public DiscoverSchemaRowsetsRowset(XmlaRequest request, XmlaHandler handler) {
            super(DISCOVER_SCHEMA_ROWSETS, request, handler);
        }

        @Override
        public void populateImpl(XmlaResponse response, OlapConnection connection, List<Rowset.Row> rows) throws XmlaException {
            RowsetDefinition[] rowsetDefinitions = (RowsetDefinition[])((RowsetDefinition[])RowsetDefinition.class.getEnumConstants()).clone();
            Arrays.sort(rowsetDefinitions, new Comparator<RowsetDefinition>(){

                @Override
                public int compare(RowsetDefinition o1, RowsetDefinition o2) {
                    return o1.name().compareTo(o2.name());
                }
            });
            RowsetDefinition[] rowsetDefinitionArray = rowsetDefinitions;
            int n = rowsetDefinitions.length;
            int n2 = 0;
            while (n2 < n) {
                RowsetDefinition rowsetDefinition = rowsetDefinitionArray[n2];
                Rowset.Row row = new Rowset.Row();
                row.set(DiscoverSchemaRowsetsRowset.SchemaName.name, rowsetDefinition.name());
                row.set(DiscoverSchemaRowsetsRowset.Restrictions.name, this.getRestrictions(rowsetDefinition));
                String desc = rowsetDefinition.getDescription();
                row.set(DiscoverSchemaRowsetsRowset.Description.name, desc == null ? "" : desc);
                this.addRow(row, rows);
                ++n2;
            }
        }

        private List<Rowset.XmlElement> getRestrictions(RowsetDefinition rowsetDefinition) {
            Column[] columns;
            ArrayList<Rowset.XmlElement> restrictionList = new ArrayList<Rowset.XmlElement>();
            Column[] columnArray = columns = rowsetDefinition.columnDefinitions;
            int n = columns.length;
            int n2 = 0;
            while (n2 < n) {
                Column column = columnArray[n2];
                if (column.restriction) {
                    restrictionList.add(new Rowset.XmlElement(DiscoverSchemaRowsetsRowset.Restrictions.name, null, new Rowset.XmlElement[]{new Rowset.XmlElement("Name", null, column.name), new Rowset.XmlElement("Type", null, column.getColumnType())}));
                }
                ++n2;
            }
            return restrictionList;
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$0() {
            return SchemaName;
        }

        static /* synthetic */ Column access$1() {
            return SchemaGuid;
        }

        static /* synthetic */ Column access$3() {
            return Description;
        }
    }

    static class MdschemaActionsRowset
    extends Rowset {
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, true, "The name of the catalog to which this action belongs.");
        private static final Column SchemaName = new Column("SCHEMA_NAME", Type.String, null, true, true, "The name of the schema to which this action belongs.");
        private static final Column CubeName = new Column("CUBE_NAME", Type.String, null, true, false, "The name of the cube to which this action belongs.");
        private static final Column ActionName = new Column("ACTION_NAME", Type.String, null, true, false, "The name of the action.");
        private static final Column Coordinate = new Column("COORDINATE", Type.String, null, true, false, null);
        private static final Column CoordinateType = new Column("COORDINATE_TYPE", Type.Integer, null, true, false, null);

        MdschemaActionsRowset(XmlaRequest request, XmlaHandler handler) {
            super(MDSCHEMA_ACTIONS, request, handler);
        }

        @Override
        public void populateImpl(XmlaResponse response, OlapConnection connection, List<Rowset.Row> rows) throws XmlaException {
        }

        static /* synthetic */ Column access$0() {
            return CatalogName;
        }

        static /* synthetic */ Column access$1() {
            return SchemaName;
        }

        static /* synthetic */ Column access$2() {
            return CubeName;
        }

        static /* synthetic */ Column access$3() {
            return ActionName;
        }

        static /* synthetic */ Column access$4() {
            return Coordinate;
        }

        static /* synthetic */ Column access$5() {
            return CoordinateType;
        }
    }

    public static class MdschemaCubesRowset
    extends Rowset {
        private final Util.Functor1<Boolean, Catalog> catalogNameCond = this.makeCondition(CATALOG_NAME_GETTER, CatalogName);
        private final Util.Functor1<Boolean, Schema> schemaNameCond = this.makeCondition(SCHEMA_NAME_GETTER, SchemaName);
        private final Util.Functor1<Boolean, Cube> cubeNameCond = this.makeCondition(ELEMENT_NAME_GETTER, CubeName);
        public static final String MD_CUBTYPE_CUBE = "CUBE";
        public static final String MD_CUBTYPE_VIRTUAL_CUBE = "VIRTUAL CUBE";
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, true, "The name of the catalog to which this cube belongs.");
        private static final Column SchemaName = new Column("SCHEMA_NAME", Type.String, null, true, true, "The name of the schema to which this cube belongs.");
        private static final Column CubeName = new Column("CUBE_NAME", Type.String, null, true, false, "Name of the cube.");
        private static final Column CubeType = new Column("CUBE_TYPE", Type.String, null, true, false, "Cube type.");
        private static final Column CubeGuid = new Column("CUBE_GUID", Type.UUID, null, false, true, "Cube type.");
        private static final Column CreatedOn = new Column("CREATED_ON", Type.DateTime, null, false, true, "Date and time of cube creation.");
        private static final Column LastSchemaUpdate = new Column("LAST_SCHEMA_UPDATE", Type.DateTime, null, false, true, "Date and time of last schema update.");
        private static final Column SchemaUpdatedBy = new Column("SCHEMA_UPDATED_BY", Type.String, null, false, true, "User ID of the person who last updated the schema.");
        private static final Column LastDataUpdate = new Column("LAST_DATA_UPDATE", Type.DateTime, null, false, true, "Date and time of last data update.");
        private static final Column DataUpdatedBy = new Column("DATA_UPDATED_BY", Type.String, null, false, true, "User ID of the person who last updated the data.");
        private static final Column IsDrillthroughEnabled = new Column("IS_DRILLTHROUGH_ENABLED", Type.Boolean, null, false, false, "Describes whether DRILLTHROUGH can be performed on the members of a cube");
        private static final Column IsWriteEnabled = new Column("IS_WRITE_ENABLED", Type.Boolean, null, false, false, "Describes whether a cube is write-enabled");
        private static final Column IsLinkable = new Column("IS_LINKABLE", Type.Boolean, null, false, false, "Describes whether a cube can be used in a linked cube");
        private static final Column IsSqlEnabled = new Column("IS_SQL_ENABLED", Type.Boolean, null, false, false, "Describes whether or not SQL can be used on the cube");
        private static final Column CubeCaption = new Column("CUBE_CAPTION", Type.String, null, false, true, "The caption of the cube.");
        private static final Column Description = new Column("DESCRIPTION", Type.String, null, false, true, "A user-friendly description of the dimension.");
        private static final Column Dimensions = new Column("DIMENSIONS", Type.Rowset, null, false, true, "Dimensions in this cube.");
        private static final Column Sets = new Column("SETS", Type.Rowset, null, false, true, "Sets in this cube.");
        private static final Column Measures = new Column("MEASURES", Type.Rowset, null, false, true, "Measures in this cube.");

        MdschemaCubesRowset(XmlaRequest request, XmlaHandler handler) {
            super(MDSCHEMA_CUBES, request, handler);
        }

        @Override
        public void populateImpl(XmlaResponse response, OlapConnection connection, List<Rowset.Row> rows) throws XmlaException, SQLException {
            for (Catalog catalog : RowsetDefinition.catIter(connection, new Util.Functor1[]{this.catNameCond(), this.catalogNameCond})) {
                for (Schema schema : Util.filter(catalog.getSchemas(), new Util.Functor1[]{this.schemaNameCond})) {
                    for (Cube cube : Util.filter(RowsetDefinition.sortedCubes(schema), this.cubeNameCond)) {
                        String desc = cube.getDescription();
                        if (desc == null) {
                            desc = String.valueOf(catalog.getName()) + " Schema - " + cube.getName() + " Cube";
                        }
                        Rowset.Row row = new Rowset.Row();
                        row.set(MdschemaCubesRowset.CatalogName.name, catalog.getName());
                        row.set(MdschemaCubesRowset.SchemaName.name, schema.getName());
                        row.set(MdschemaCubesRowset.CubeName.name, cube.getName());
                        XmlaHandler.XmlaExtra extra = XmlaHandler.getExtra(connection);
                        row.set(MdschemaCubesRowset.CubeType.name, extra.getCubeType(cube));
                        row.set(MdschemaCubesRowset.IsDrillthroughEnabled.name, true);
                        row.set(MdschemaCubesRowset.IsWriteEnabled.name, false);
                        row.set(MdschemaCubesRowset.IsLinkable.name, false);
                        row.set(MdschemaCubesRowset.IsSqlEnabled.name, false);
                        row.set(MdschemaCubesRowset.CubeCaption.name, cube.getCaption());
                        row.set(MdschemaCubesRowset.Description.name, desc);
                        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                        String formattedDate = formatter.format((Object)extra.getSchemaLoadDate(schema));
                        row.set(MdschemaCubesRowset.LastSchemaUpdate.name, formattedDate);
                        if (this.deep) {
                            row.set(MdschemaCubesRowset.Dimensions.name, new MdschemaDimensionsRowset(RowsetDefinition.wrapRequest(this.request, Olap4jUtil.mapOf((Object)MdschemaDimensionsRowset.CatalogName, (Object)catalog.getName(), (Object[])new Object[]{MdschemaDimensionsRowset.SchemaName, schema.getName(), MdschemaDimensionsRowset.CubeName, cube.getName()})), this.handler));
                            row.set(MdschemaCubesRowset.Sets.name, new MdschemaSetsRowset(RowsetDefinition.wrapRequest(this.request, Olap4jUtil.mapOf((Object)MdschemaSetsRowset.CatalogName, (Object)catalog.getName(), (Object[])new Object[]{MdschemaSetsRowset.SchemaName, schema.getName(), MdschemaSetsRowset.CubeName, cube.getName()})), this.handler));
                            row.set(MdschemaCubesRowset.Measures.name, new MdschemaMeasuresRowset(RowsetDefinition.wrapRequest(this.request, Olap4jUtil.mapOf((Object)MdschemaMeasuresRowset.CatalogName, (Object)catalog.getName(), (Object[])new Object[]{MdschemaMeasuresRowset.SchemaName, schema.getName(), MdschemaMeasuresRowset.CubeName, cube.getName()})), this.handler));
                        }
                        this.addRow(row, rows);
                    }
                }
            }
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$0() {
            return CatalogName;
        }

        static /* synthetic */ Column access$1() {
            return SchemaName;
        }

        static /* synthetic */ Column access$2() {
            return CubeName;
        }

        static /* synthetic */ Column access$3() {
            return CubeType;
        }

        static /* synthetic */ Column access$4() {
            return CubeGuid;
        }

        static /* synthetic */ Column access$5() {
            return CreatedOn;
        }

        static /* synthetic */ Column access$6() {
            return LastSchemaUpdate;
        }

        static /* synthetic */ Column access$7() {
            return SchemaUpdatedBy;
        }

        static /* synthetic */ Column access$8() {
            return LastDataUpdate;
        }

        static /* synthetic */ Column access$9() {
            return DataUpdatedBy;
        }

        static /* synthetic */ Column access$10() {
            return IsDrillthroughEnabled;
        }

        static /* synthetic */ Column access$11() {
            return IsWriteEnabled;
        }

        static /* synthetic */ Column access$12() {
            return IsLinkable;
        }

        static /* synthetic */ Column access$13() {
            return IsSqlEnabled;
        }

        static /* synthetic */ Column access$14() {
            return CubeCaption;
        }

        static /* synthetic */ Column access$15() {
            return Description;
        }

        static /* synthetic */ Column access$16() {
            return Dimensions;
        }

        static /* synthetic */ Column access$17() {
            return Sets;
        }

        static /* synthetic */ Column access$18() {
            return Measures;
        }
    }

    static class MdschemaDimensionsRowset
    extends Rowset {
        private final Util.Functor1<Boolean, Catalog> catalogNameCond = this.makeCondition(CATALOG_NAME_GETTER, CatalogName);
        private final Util.Functor1<Boolean, Schema> schemaNameCond = this.makeCondition(SCHEMA_NAME_GETTER, SchemaName);
        private final Util.Functor1<Boolean, Cube> cubeNameCond = this.makeCondition(ELEMENT_NAME_GETTER, CubeName);
        private final Util.Functor1<Boolean, Dimension> dimensionUnameCond = this.makeCondition(ELEMENT_UNAME_GETTER, DimensionUniqueName);
        private final Util.Functor1<Boolean, Dimension> dimensionNameCond = this.makeCondition(ELEMENT_NAME_GETTER, DimensionName);
        public static final int MD_DIMTYPE_OTHER = 3;
        public static final int MD_DIMTYPE_MEASURE = 2;
        public static final int MD_DIMTYPE_TIME = 1;
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, true, "The name of the database.");
        private static final Column SchemaName = new Column("SCHEMA_NAME", Type.String, null, true, true, "Not supported.");
        private static final Column CubeName = new Column("CUBE_NAME", Type.String, null, true, false, "The name of the cube.");
        private static final Column DimensionName = new Column("DIMENSION_NAME", Type.String, null, true, false, "The name of the dimension.");
        private static final Column DimensionUniqueName = new Column("DIMENSION_UNIQUE_NAME", Type.String, null, true, false, "The unique name of the dimension.");
        private static final Column DimensionGuid = new Column("DIMENSION_GUID", Type.UUID, null, false, true, "Not supported.");
        private static final Column DimensionCaption = new Column("DIMENSION_CAPTION", Type.String, null, false, false, "The caption of the dimension.");
        private static final Column DimensionOrdinal = new Column("DIMENSION_ORDINAL", Type.UnsignedInteger, null, false, false, "The position of the dimension within the cube.");
        private static final Column DimensionType = new Column("DIMENSION_TYPE", Type.Short, null, false, false, "The type of the dimension.");
        private static final Column DimensionCardinality = new Column("DIMENSION_CARDINALITY", Type.UnsignedInteger, null, false, false, "The number of members in the key attribute.");
        private static final Column DefaultHierarchy = new Column("DEFAULT_HIERARCHY", Type.String, null, false, false, "A hierarchy from the dimension. Preserved for backwards compatibility.");
        private static final Column Description = new Column("DESCRIPTION", Type.String, null, false, true, "A user-friendly description of the dimension.");
        private static final Column IsVirtual = new Column("IS_VIRTUAL", Type.Boolean, null, false, true, "Always FALSE.");
        private static final Column IsReadWrite = new Column("IS_READWRITE", Type.Boolean, null, false, true, "A Boolean that indicates whether the dimension is write-enabled.");
        private static final Column DimensionUniqueSettings = new Column("DIMENSION_UNIQUE_SETTINGS", Type.Integer, null, false, true, "A bitmap that specifies which columns contain unique values if the dimension contains only members with unique names.");
        private static final Column DimensionMasterUniqueName = new Column("DIMENSION_MASTER_UNIQUE_NAME", Type.String, null, false, true, "Always NULL.");
        private static final Column DimensionIsVisible = new Column("DIMENSION_IS_VISIBLE", Type.Boolean, null, false, true, "Always TRUE.");
        private static final Column Hierarchies = new Column("HIERARCHIES", Type.Rowset, null, false, true, "Hierarchies in this dimension.");

        MdschemaDimensionsRowset(XmlaRequest request, XmlaHandler handler) {
            super(MDSCHEMA_DIMENSIONS, request, handler);
        }

        @Override
        public void populateImpl(XmlaResponse response, OlapConnection connection, List<Rowset.Row> rows) throws XmlaException, SQLException {
            for (Catalog catalog : RowsetDefinition.catIter(connection, new Util.Functor1[]{this.catNameCond(), this.catalogNameCond})) {
                this.populateCatalog(connection, catalog, rows);
            }
        }

        protected void populateCatalog(OlapConnection connection, Catalog catalog, List<Rowset.Row> rows) throws XmlaException, SQLException {
            for (Schema schema : Util.filter(catalog.getSchemas(), new Util.Functor1[]{this.schemaNameCond})) {
                for (Cube cube : RowsetDefinition.filteredCubes(schema, this.cubeNameCond)) {
                    this.populateCube(connection, catalog, cube, rows);
                }
            }
        }

        protected void populateCube(OlapConnection connection, Catalog catalog, Cube cube, List<Rowset.Row> rows) throws XmlaException, SQLException {
            for (Dimension dimension : Util.filter(cube.getDimensions(), new Util.Functor1[]{this.dimensionNameCond, this.dimensionUnameCond})) {
                this.populateDimension(connection, catalog, cube, dimension, rows);
            }
        }

        protected void populateDimension(OlapConnection connection, Catalog catalog, Cube cube, Dimension dimension, List<Rowset.Row> rows) throws XmlaException, SQLException {
            String desc = dimension.getDescription();
            if (desc == null) {
                desc = String.valueOf(cube.getName()) + " Cube - " + dimension.getName() + " Dimension";
            }
            Rowset.Row row = new Rowset.Row();
            row.set(MdschemaDimensionsRowset.CatalogName.name, catalog.getName());
            row.set(MdschemaDimensionsRowset.SchemaName.name, cube.getSchema().getName());
            row.set(MdschemaDimensionsRowset.CubeName.name, cube.getName());
            row.set(MdschemaDimensionsRowset.DimensionName.name, dimension.getName());
            row.set(MdschemaDimensionsRowset.DimensionUniqueName.name, dimension.getUniqueName());
            row.set(MdschemaDimensionsRowset.DimensionCaption.name, dimension.getCaption());
            row.set(MdschemaDimensionsRowset.DimensionOrdinal.name, cube.getDimensions().indexOf((Object)dimension));
            row.set(MdschemaDimensionsRowset.DimensionType.name, RowsetDefinition.getDimensionType(dimension));
            Hierarchy firstHierarchy = (Hierarchy)dimension.getHierarchies().get(0);
            NamedList levels = firstHierarchy.getLevels();
            Level lastLevel = (Level)levels.get(levels.size() - 1);
            int n = XmlaHandler.getExtra(connection).getLevelCardinality(lastLevel);
            row.set(MdschemaDimensionsRowset.DimensionCardinality.name, n + 1);
            row.set(MdschemaDimensionsRowset.DefaultHierarchy.name, dimension.getUniqueName());
            row.set(MdschemaDimensionsRowset.Description.name, desc);
            row.set(MdschemaDimensionsRowset.IsVirtual.name, false);
            row.set(MdschemaDimensionsRowset.IsReadWrite.name, false);
            row.set(MdschemaDimensionsRowset.DimensionUniqueSettings.name, 0);
            row.set(MdschemaDimensionsRowset.DimensionIsVisible.name, dimension.isVisible());
            if (this.deep) {
                row.set(MdschemaDimensionsRowset.Hierarchies.name, new MdschemaHierarchiesRowset(RowsetDefinition.wrapRequest(this.request, Olap4jUtil.mapOf((Object)MdschemaHierarchiesRowset.CatalogName, (Object)catalog.getName(), (Object[])new Object[]{MdschemaHierarchiesRowset.SchemaName, cube.getSchema().getName(), MdschemaHierarchiesRowset.CubeName, cube.getName(), MdschemaHierarchiesRowset.DimensionUniqueName, dimension.getUniqueName()})), this.handler));
            }
            this.addRow(row, rows);
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$3() {
            return DimensionName;
        }

        static /* synthetic */ Column access$4() {
            return DimensionUniqueName;
        }

        static /* synthetic */ Column access$5() {
            return DimensionGuid;
        }

        static /* synthetic */ Column access$6() {
            return DimensionCaption;
        }

        static /* synthetic */ Column access$7() {
            return DimensionOrdinal;
        }

        static /* synthetic */ Column access$8() {
            return DimensionType;
        }

        static /* synthetic */ Column access$9() {
            return DimensionCardinality;
        }

        static /* synthetic */ Column access$10() {
            return DefaultHierarchy;
        }

        static /* synthetic */ Column access$11() {
            return Description;
        }

        static /* synthetic */ Column access$12() {
            return IsVirtual;
        }

        static /* synthetic */ Column access$13() {
            return IsReadWrite;
        }

        static /* synthetic */ Column access$14() {
            return DimensionUniqueSettings;
        }

        static /* synthetic */ Column access$15() {
            return DimensionMasterUniqueName;
        }

        static /* synthetic */ Column access$16() {
            return DimensionIsVisible;
        }

        static /* synthetic */ Column access$17() {
            return Hierarchies;
        }
    }

    public static class MdschemaFunctionsRowset
    extends Rowset {
        private final Util.Functor1<Boolean, String> functionNameCond = this.makeCondition(FunctionName);
        private static final Column FunctionName = new Column("FUNCTION_NAME", Type.String, null, true, false, "The name of the function.");
        private static final Column Description = new Column("DESCRIPTION", Type.String, null, false, true, "A description of the function.");
        private static final Column ParameterList = new Column("PARAMETER_LIST", Type.String, null, false, true, "A comma delimited list of parameters.");
        private static final Column ReturnType = new Column("RETURN_TYPE", Type.Integer, null, false, false, "The VARTYPE of the return data type of the function.");
        private static final Column Origin = new Column("ORIGIN", Type.Integer, null, true, false, "The origin of the function:  1 for MDX functions.  2 for user-defined functions.");
        private static final Column InterfaceName = new Column("INTERFACE_NAME", Type.String, null, true, false, "The name of the interface for user-defined functions");
        private static final Column LibraryName = new Column("LIBRARY_NAME", Type.String, null, true, true, "The name of the type library for user-defined functions. NULL for MDX functions.");
        private static final Column Caption = new Column("CAPTION", Type.String, null, false, true, "The display caption for the function.");

        MdschemaFunctionsRowset(XmlaRequest request, XmlaHandler handler) {
            super(MDSCHEMA_FUNCTIONS, request, handler);
        }

        @Override
        public void populateImpl(XmlaResponse response, OlapConnection connection, List<Rowset.Row> rows) throws XmlaException, SQLException {
            XmlaHandler.XmlaExtra extra = XmlaHandler.getExtra(connection);
            for (Catalog catalog : RowsetDefinition.catIter(connection, new Util.Functor1[]{this.catNameCond()})) {
                Schema schema = (Schema)catalog.getSchemas().get(0);
                ArrayList<XmlaHandler.XmlaExtra.FunctionDefinition> funDefs = new ArrayList<XmlaHandler.XmlaExtra.FunctionDefinition>();
                extra.getSchemaFunctionList(funDefs, schema, this.functionNameCond);
                for (XmlaHandler.XmlaExtra.FunctionDefinition funDef : funDefs) {
                    Rowset.Row row = new Rowset.Row();
                    row.set(MdschemaFunctionsRowset.FunctionName.name, funDef.functionName);
                    row.set(MdschemaFunctionsRowset.Description.name, funDef.description);
                    row.set(MdschemaFunctionsRowset.ParameterList.name, funDef.parameterList);
                    row.set(MdschemaFunctionsRowset.ReturnType.name, funDef.returnType);
                    row.set(MdschemaFunctionsRowset.Origin.name, funDef.origin);
                    row.set(MdschemaFunctionsRowset.InterfaceName.name, funDef.interfaceName);
                    row.set(MdschemaFunctionsRowset.Caption.name, funDef.caption);
                    this.addRow(row, rows);
                }
            }
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$0() {
            return FunctionName;
        }

        static /* synthetic */ Column access$1() {
            return Description;
        }

        static /* synthetic */ Column access$2() {
            return ParameterList;
        }

        static /* synthetic */ Column access$3() {
            return ReturnType;
        }

        static /* synthetic */ Column access$4() {
            return Origin;
        }

        static /* synthetic */ Column access$5() {
            return InterfaceName;
        }

        static /* synthetic */ Column access$6() {
            return LibraryName;
        }

        static /* synthetic */ Column access$7() {
            return Caption;
        }

        public static enum VarType {
            Empty("Uninitialized (default)"),
            Null("Contains no valid data"),
            Integer("Integer subtype"),
            Long("Long subtype"),
            Single("Single subtype"),
            Double("Double subtype"),
            Currency("Currency subtype"),
            Date("Date subtype"),
            String("String subtype"),
            Object("Object subtype"),
            Error("Error subtype"),
            Boolean("Boolean subtype"),
            Variant("Variant subtype"),
            DataObject("DataObject subtype"),
            Decimal("Decimal subtype"),
            Byte("Byte subtype"),
            Array("Array subtype");


            public static VarType forCategory(int category) {
                switch (category) {
                    case 0: {
                        return Empty;
                    }
                    case 1: {
                        return Array;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: 
                    case 8: 
                    case 10: 
                    case 12: 
                    case 13: {
                        return Variant;
                    }
                    case 5: {
                        return Boolean;
                    }
                    case 7: {
                        return Double;
                    }
                    case 9: 
                    case 11: 
                    case 64: {
                        return String;
                    }
                    case 18: {
                        return Date;
                    }
                    case 15: 
                    case 31: {
                        return Integer;
                    }
                }
                return Empty;
            }

            private VarType(String description) {
                Util.discard((Object)description);
            }
        }
    }

    static class MdschemaHierarchiesRowset
    extends Rowset {
        private final Util.Functor1<Boolean, Catalog> catalogCond = this.makeCondition(CATALOG_NAME_GETTER, CatalogName);
        private final Util.Functor1<Boolean, Schema> schemaNameCond = this.makeCondition(SCHEMA_NAME_GETTER, SchemaName);
        private final Util.Functor1<Boolean, Cube> cubeNameCond = this.makeCondition(ELEMENT_NAME_GETTER, CubeName);
        private final Util.Functor1<Boolean, Dimension> dimensionUnameCond = this.makeCondition(ELEMENT_UNAME_GETTER, DimensionUniqueName);
        private final Util.Functor1<Boolean, Hierarchy> hierarchyUnameCond = this.makeCondition(ELEMENT_UNAME_GETTER, HierarchyUniqueName);
        private final Util.Functor1<Boolean, Hierarchy> hierarchyNameCond = this.makeCondition(ELEMENT_NAME_GETTER, HierarchyName);
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, true, "The name of the catalog to which this hierarchy belongs.");
        private static final Column SchemaName = new Column("SCHEMA_NAME", Type.String, null, true, true, "Not supported");
        private static final Column CubeName = new Column("CUBE_NAME", Type.String, null, true, false, "The name of the cube to which this hierarchy belongs.");
        private static final Column DimensionUniqueName = new Column("DIMENSION_UNIQUE_NAME", Type.String, null, true, false, "The unique name of the dimension to which this hierarchy belongs.");
        private static final Column HierarchyName = new Column("HIERARCHY_NAME", Type.String, null, true, false, "The name of the hierarchy. Blank if there is only a single hierarchy in the dimension.");
        private static final Column HierarchyUniqueName = new Column("HIERARCHY_UNIQUE_NAME", Type.String, null, true, false, "The unique name of the hierarchy.");
        private static final Column HierarchyGuid = new Column("HIERARCHY_GUID", Type.UUID, null, false, true, "Hierarchy GUID.");
        private static final Column HierarchyCaption = new Column("HIERARCHY_CAPTION", Type.String, null, false, false, "A label or a caption associated with the hierarchy.");
        private static final Column DimensionType = new Column("DIMENSION_TYPE", Type.Short, null, false, false, "The type of the dimension.");
        private static final Column HierarchyCardinality = new Column("HIERARCHY_CARDINALITY", Type.UnsignedInteger, null, false, false, "The number of members in the hierarchy.");
        private static final Column DefaultMember = new Column("DEFAULT_MEMBER", Type.String, null, false, true, "The default member for this hierarchy.");
        private static final Column AllMember = new Column("ALL_MEMBER", Type.String, null, false, true, "The member at the highest level of rollup in the hierarchy.");
        private static final Column Description = new Column("DESCRIPTION", Type.String, null, false, true, "A human-readable description of the hierarchy. NULL if no description exists.");
        private static final Column Structure = new Column("STRUCTURE", Type.Short, null, false, false, "The structure of the hierarchy.");
        private static final Column IsVirtual = new Column("IS_VIRTUAL", Type.Boolean, null, false, false, "Always returns False.");
        private static final Column IsReadWrite = new Column("IS_READWRITE", Type.Boolean, null, false, false, "A Boolean that indicates whether the Write Back to dimension column is enabled.");
        private static final Column DimensionUniqueSettings = new Column("DIMENSION_UNIQUE_SETTINGS", Type.Integer, null, false, false, "Always returns MDDIMENSIONS_MEMBER_KEY_UNIQUE (1).");
        private static final Column DimensionIsVisible = new Column("DIMENSION_IS_VISIBLE", Type.Boolean, null, false, false, "A Boolean that indicates whether the parent dimension is visible.");
        private static final Column HierarchyIsVisible = new Column("HIERARCHY_IS_VISIBLE", Type.Boolean, null, false, false, "A Boolean that indicates whether the hieararchy is visible.");
        private static final Column HierarchyOrdinal = new Column("HIERARCHY_ORDINAL", Type.UnsignedInteger, null, false, false, "The ordinal number of the hierarchy across all hierarchies of the cube.");
        private static final Column DimensionIsShared = new Column("DIMENSION_IS_SHARED", Type.Boolean, null, false, false, "Always returns true.");
        private static final Column Levels = new Column("LEVELS", Type.Rowset, null, false, true, "Levels in this hierarchy.");
        private static final Column ParentChild = new Column("PARENT_CHILD", Type.Boolean, null, false, true, "Is hierarchy a parent.");

        MdschemaHierarchiesRowset(XmlaRequest request, XmlaHandler handler) {
            super(MDSCHEMA_HIERARCHIES, request, handler);
        }

        @Override
        public void populateImpl(XmlaResponse response, OlapConnection connection, List<Rowset.Row> rows) throws XmlaException, SQLException {
            for (Catalog catalog : RowsetDefinition.catIter(connection, new Util.Functor1[]{this.catNameCond(), this.catalogCond})) {
                this.populateCatalog(connection, catalog, rows);
            }
        }

        protected void populateCatalog(OlapConnection connection, Catalog catalog, List<Rowset.Row> rows) throws XmlaException, SQLException {
            for (Schema schema : Util.filter(catalog.getSchemas(), new Util.Functor1[]{this.schemaNameCond})) {
                for (Cube cube : RowsetDefinition.filteredCubes(schema, this.cubeNameCond)) {
                    this.populateCube(connection, catalog, cube, rows);
                }
            }
        }

        protected void populateCube(OlapConnection connection, Catalog catalog, Cube cube, List<Rowset.Row> rows) throws XmlaException, SQLException {
            int ordinal = 0;
            for (Dimension dimension : cube.getDimensions()) {
                boolean genOutput = this.dimensionUnameCond.apply(dimension);
                if (genOutput) {
                    this.populateDimension(connection, catalog, cube, dimension, ordinal, rows);
                }
                ordinal += dimension.getHierarchies().size();
            }
        }

        protected void populateDimension(OlapConnection connection, Catalog catalog, Cube cube, Dimension dimension, int ordinal, List<Rowset.Row> rows) throws XmlaException, SQLException {
            NamedList hierarchies = dimension.getHierarchies();
            for (Hierarchy hierarchy : Util.filter(hierarchies, new Util.Functor1[]{this.hierarchyNameCond, this.hierarchyUnameCond})) {
                this.populateHierarchy(connection, catalog, cube, dimension, hierarchy, ordinal + hierarchies.indexOf((Object)hierarchy), rows);
            }
        }

        protected void populateHierarchy(OlapConnection connection, Catalog catalog, Cube cube, Dimension dimension, Hierarchy hierarchy, int ordinal, List<Rowset.Row> rows) throws XmlaException, SQLException {
            XmlaHandler.XmlaExtra extra = XmlaHandler.getExtra(connection);
            String desc = hierarchy.getDescription();
            if (desc == null) {
                desc = String.valueOf(cube.getName()) + " Cube - " + RowsetDefinition.getHierarchyName(hierarchy) + " Hierarchy";
            }
            Rowset.Row row = new Rowset.Row();
            row.set(MdschemaHierarchiesRowset.CatalogName.name, catalog.getName());
            row.set(MdschemaHierarchiesRowset.SchemaName.name, cube.getSchema().getName());
            row.set(MdschemaHierarchiesRowset.CubeName.name, cube.getName());
            row.set(MdschemaHierarchiesRowset.DimensionUniqueName.name, dimension.getUniqueName());
            row.set(MdschemaHierarchiesRowset.HierarchyName.name, hierarchy.getName());
            row.set(MdschemaHierarchiesRowset.HierarchyUniqueName.name, hierarchy.getUniqueName());
            row.set(MdschemaHierarchiesRowset.HierarchyCaption.name, hierarchy.getCaption());
            row.set(MdschemaHierarchiesRowset.DimensionType.name, RowsetDefinition.getDimensionType(dimension));
            int cardinality = extra.getHierarchyCardinality(hierarchy);
            row.set(MdschemaHierarchiesRowset.HierarchyCardinality.name, cardinality);
            row.set(MdschemaHierarchiesRowset.DefaultMember.name, hierarchy.getDefaultMember().getUniqueName());
            if (hierarchy.hasAll()) {
                row.set(MdschemaHierarchiesRowset.AllMember.name, ((Member)hierarchy.getRootMembers().get(0)).getUniqueName());
            }
            row.set(MdschemaHierarchiesRowset.Description.name, desc);
            row.set(MdschemaHierarchiesRowset.Structure.name, extra.getHierarchyStructure(hierarchy));
            row.set(MdschemaHierarchiesRowset.IsVirtual.name, false);
            row.set(MdschemaHierarchiesRowset.IsReadWrite.name, false);
            row.set(MdschemaHierarchiesRowset.DimensionUniqueSettings.name, 0);
            row.set(MdschemaHierarchiesRowset.DimensionIsVisible.name, dimension.isVisible());
            row.set(MdschemaHierarchiesRowset.HierarchyIsVisible.name, hierarchy.isVisible());
            row.set(MdschemaHierarchiesRowset.HierarchyOrdinal.name, ordinal);
            row.set(MdschemaHierarchiesRowset.DimensionIsShared.name, true);
            row.set(MdschemaHierarchiesRowset.ParentChild.name, extra.isHierarchyParentChild(hierarchy));
            if (this.deep) {
                row.set(MdschemaHierarchiesRowset.Levels.name, new MdschemaLevelsRowset(RowsetDefinition.wrapRequest(this.request, Olap4jUtil.mapOf((Object)MdschemaLevelsRowset.CatalogName, (Object)catalog.getName(), (Object[])new Object[]{MdschemaLevelsRowset.SchemaName, cube.getSchema().getName(), MdschemaLevelsRowset.CubeName, cube.getName(), MdschemaLevelsRowset.DimensionUniqueName, dimension.getUniqueName(), MdschemaLevelsRowset.HierarchyUniqueName, hierarchy.getUniqueName()})), this.handler));
            }
            this.addRow(row, rows);
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$4() {
            return HierarchyName;
        }

        static /* synthetic */ Column access$5() {
            return HierarchyUniqueName;
        }

        static /* synthetic */ Column access$6() {
            return HierarchyGuid;
        }

        static /* synthetic */ Column access$7() {
            return HierarchyCaption;
        }

        static /* synthetic */ Column access$8() {
            return DimensionType;
        }

        static /* synthetic */ Column access$9() {
            return HierarchyCardinality;
        }

        static /* synthetic */ Column access$10() {
            return DefaultMember;
        }

        static /* synthetic */ Column access$11() {
            return AllMember;
        }

        static /* synthetic */ Column access$12() {
            return Description;
        }

        static /* synthetic */ Column access$13() {
            return Structure;
        }

        static /* synthetic */ Column access$14() {
            return IsVirtual;
        }

        static /* synthetic */ Column access$15() {
            return IsReadWrite;
        }

        static /* synthetic */ Column access$16() {
            return DimensionUniqueSettings;
        }

        static /* synthetic */ Column access$17() {
            return DimensionIsVisible;
        }

        static /* synthetic */ Column access$18() {
            return HierarchyIsVisible;
        }

        static /* synthetic */ Column access$19() {
            return HierarchyOrdinal;
        }

        static /* synthetic */ Column access$20() {
            return DimensionIsShared;
        }

        static /* synthetic */ Column access$21() {
            return ParentChild;
        }

        static /* synthetic */ Column access$22() {
            return Levels;
        }
    }

    static class MdschemaLevelsRowset
    extends Rowset {
        private final Util.Functor1<Boolean, Catalog> catalogCond = this.makeCondition(CATALOG_NAME_GETTER, CatalogName);
        private final Util.Functor1<Boolean, Schema> schemaNameCond = this.makeCondition(SCHEMA_NAME_GETTER, SchemaName);
        private final Util.Functor1<Boolean, Cube> cubeNameCond = this.makeCondition(ELEMENT_NAME_GETTER, CubeName);
        private final Util.Functor1<Boolean, Dimension> dimensionUnameCond = this.makeCondition(ELEMENT_UNAME_GETTER, DimensionUniqueName);
        private final Util.Functor1<Boolean, Hierarchy> hierarchyUnameCond = this.makeCondition(ELEMENT_UNAME_GETTER, HierarchyUniqueName);
        private final Util.Functor1<Boolean, Level> levelUnameCond = this.makeCondition(ELEMENT_UNAME_GETTER, LevelUniqueName);
        private final Util.Functor1<Boolean, Level> levelNameCond = this.makeCondition(ELEMENT_NAME_GETTER, LevelName);
        public static final int MDLEVEL_TYPE_UNKNOWN = 0;
        public static final int MDLEVEL_TYPE_REGULAR = 0;
        public static final int MDLEVEL_TYPE_ALL = 1;
        public static final int MDLEVEL_TYPE_CALCULATED = 2;
        public static final int MDLEVEL_TYPE_TIME = 4;
        public static final int MDLEVEL_TYPE_RESERVED1 = 8;
        public static final int MDLEVEL_TYPE_TIME_YEARS = 20;
        public static final int MDLEVEL_TYPE_TIME_HALF_YEAR = 36;
        public static final int MDLEVEL_TYPE_TIME_QUARTERS = 68;
        public static final int MDLEVEL_TYPE_TIME_MONTHS = 132;
        public static final int MDLEVEL_TYPE_TIME_WEEKS = 260;
        public static final int MDLEVEL_TYPE_TIME_DAYS = 516;
        public static final int MDLEVEL_TYPE_TIME_HOURS = 772;
        public static final int MDLEVEL_TYPE_TIME_MINUTES = 1028;
        public static final int MDLEVEL_TYPE_TIME_SECONDS = 2052;
        public static final int MDLEVEL_TYPE_TIME_UNDEFINED = 4100;
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, true, "The name of the catalog to which this level belongs.");
        private static final Column SchemaName = new Column("SCHEMA_NAME", Type.String, null, true, true, "The name of the schema to which this level belongs.");
        private static final Column CubeName = new Column("CUBE_NAME", Type.String, null, true, false, "The name of the cube to which this level belongs.");
        private static final Column DimensionUniqueName = new Column("DIMENSION_UNIQUE_NAME", Type.String, null, true, false, "The unique name of the dimension to which this level belongs.");
        private static final Column HierarchyUniqueName = new Column("HIERARCHY_UNIQUE_NAME", Type.String, null, true, false, "The unique name of the hierarchy.");
        private static final Column LevelName = new Column("LEVEL_NAME", Type.String, null, true, false, "The name of the level.");
        private static final Column LevelUniqueName = new Column("LEVEL_UNIQUE_NAME", Type.String, null, true, false, "The properly escaped unique name of the level.");
        private static final Column LevelGuid = new Column("LEVEL_GUID", Type.UUID, null, false, true, "Level GUID.");
        private static final Column LevelCaption = new Column("LEVEL_CAPTION", Type.String, null, false, false, "A label or caption associated with the hierarchy.");
        private static final Column LevelNumber = new Column("LEVEL_NUMBER", Type.UnsignedInteger, null, false, false, "The distance of the level from the root of the hierarchy. Root level is zero (0).");
        private static final Column LevelCardinality = new Column("LEVEL_CARDINALITY", Type.UnsignedInteger, null, false, false, "The number of members in the level. This value can be an approximation of the real cardinality.");
        private static final Column LevelType = new Column("LEVEL_TYPE", Type.Integer, null, false, false, "Type of the level");
        private static final Column CustomRollupSettings = new Column("CUSTOM_ROLLUP_SETTINGS", Type.Integer, null, false, false, "A bitmap that specifies the custom rollup options.");
        private static final Column LevelUniqueSettings = new Column("LEVEL_UNIQUE_SETTINGS", Type.Integer, null, false, false, "A bitmap that specifies which columns contain unique values, if the level only has members with unique names or keys.");
        private static final Column LevelIsVisible = new Column("LEVEL_IS_VISIBLE", Type.Boolean, null, false, false, "A Boolean that indicates whether the level is visible.");
        private static final Column Description = new Column("DESCRIPTION", Type.String, null, false, true, "A human-readable description of the level. NULL if no description exists.");

        MdschemaLevelsRowset(XmlaRequest request, XmlaHandler handler) {
            super(MDSCHEMA_LEVELS, request, handler);
        }

        @Override
        public void populateImpl(XmlaResponse response, OlapConnection connection, List<Rowset.Row> rows) throws XmlaException, SQLException {
            for (Catalog catalog : RowsetDefinition.catIter(connection, new Util.Functor1[]{this.catNameCond(), this.catalogCond})) {
                this.populateCatalog(connection, catalog, rows);
            }
        }

        protected void populateCatalog(OlapConnection connection, Catalog catalog, List<Rowset.Row> rows) throws XmlaException, SQLException {
            for (Schema schema : Util.filter(catalog.getSchemas(), new Util.Functor1[]{this.schemaNameCond})) {
                for (Cube cube : RowsetDefinition.filteredCubes(schema, this.cubeNameCond)) {
                    this.populateCube(connection, catalog, cube, rows);
                }
            }
        }

        protected void populateCube(OlapConnection connection, Catalog catalog, Cube cube, List<Rowset.Row> rows) throws XmlaException, SQLException {
            for (Dimension dimension : Util.filter(cube.getDimensions(), new Util.Functor1[]{this.dimensionUnameCond})) {
                this.populateDimension(connection, catalog, cube, dimension, rows);
            }
        }

        protected void populateDimension(OlapConnection connection, Catalog catalog, Cube cube, Dimension dimension, List<Rowset.Row> rows) throws XmlaException, SQLException {
            for (Hierarchy hierarchy : Util.filter(dimension.getHierarchies(), new Util.Functor1[]{this.hierarchyUnameCond})) {
                this.populateHierarchy(connection, catalog, cube, hierarchy, rows);
            }
        }

        protected void populateHierarchy(OlapConnection connection, Catalog catalog, Cube cube, Hierarchy hierarchy, List<Rowset.Row> rows) throws XmlaException, SQLException {
            for (Level level : Util.filter(hierarchy.getLevels(), new Util.Functor1[]{this.levelUnameCond, this.levelNameCond})) {
                this.outputLevel(connection, catalog, cube, hierarchy, level, rows);
            }
        }

        protected boolean outputLevel(OlapConnection connection, Catalog catalog, Cube cube, Hierarchy hierarchy, Level level, List<Rowset.Row> rows) throws XmlaException, SQLException {
            XmlaHandler.XmlaExtra extra = XmlaHandler.getExtra(connection);
            String desc = level.getDescription();
            if (desc == null) {
                desc = String.valueOf(cube.getName()) + " Cube - " + RowsetDefinition.getHierarchyName(hierarchy) + " Hierarchy - " + level.getName() + " Level";
            }
            Rowset.Row row = new Rowset.Row();
            row.set(MdschemaLevelsRowset.CatalogName.name, catalog.getName());
            row.set(MdschemaLevelsRowset.SchemaName.name, cube.getSchema().getName());
            row.set(MdschemaLevelsRowset.CubeName.name, cube.getName());
            row.set(MdschemaLevelsRowset.DimensionUniqueName.name, hierarchy.getDimension().getUniqueName());
            row.set(MdschemaLevelsRowset.HierarchyUniqueName.name, hierarchy.getUniqueName());
            row.set(MdschemaLevelsRowset.LevelName.name, level.getName());
            row.set(MdschemaLevelsRowset.LevelUniqueName.name, level.getUniqueName());
            row.set(MdschemaLevelsRowset.LevelCaption.name, level.getCaption());
            row.set(MdschemaLevelsRowset.LevelNumber.name, level.getDepth());
            int n = extra.getLevelCardinality(level);
            row.set(MdschemaLevelsRowset.LevelCardinality.name, n);
            row.set(MdschemaLevelsRowset.LevelType.name, this.getLevelType(level));
            row.set(MdschemaLevelsRowset.CustomRollupSettings.name, 0);
            int uniqueSettings = 0;
            if (level.getLevelType() == Level.Type.ALL) {
                uniqueSettings |= 2;
            }
            if (extra.isLevelUnique(level)) {
                uniqueSettings |= 1;
            }
            row.set(MdschemaLevelsRowset.LevelUniqueSettings.name, uniqueSettings);
            row.set(MdschemaLevelsRowset.LevelIsVisible.name, level.isVisible());
            row.set(MdschemaLevelsRowset.Description.name, desc);
            this.addRow(row, rows);
            return true;
        }

        private int getLevelType(Level lev) {
            int ret = 0;
            switch (lev.getLevelType()) {
                case ALL: {
                    ret |= 1;
                    break;
                }
                case REGULAR: {
                    ret |= 0;
                    break;
                }
                case TIME_YEARS: {
                    ret |= 0x14;
                    break;
                }
                case TIME_HALF_YEAR: {
                    ret |= 0x24;
                    break;
                }
                case TIME_QUARTERS: {
                    ret |= 0x44;
                    break;
                }
                case TIME_MONTHS: {
                    ret |= 0x84;
                    break;
                }
                case TIME_WEEKS: {
                    ret |= 0x104;
                    break;
                }
                case TIME_DAYS: {
                    ret |= 0x204;
                    break;
                }
                case TIME_HOURS: {
                    ret |= 0x304;
                    break;
                }
                case TIME_MINUTES: {
                    ret |= 0x404;
                    break;
                }
                case TIME_SECONDS: {
                    ret |= 0x804;
                    break;
                }
                case TIME_UNDEFINED: {
                    ret |= 0x1004;
                    break;
                }
                default: {
                    ret |= 0;
                }
            }
            return ret;
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$5() {
            return LevelName;
        }

        static /* synthetic */ Column access$6() {
            return LevelUniqueName;
        }

        static /* synthetic */ Column access$7() {
            return LevelGuid;
        }

        static /* synthetic */ Column access$8() {
            return LevelCaption;
        }

        static /* synthetic */ Column access$9() {
            return LevelNumber;
        }

        static /* synthetic */ Column access$10() {
            return LevelCardinality;
        }

        static /* synthetic */ Column access$11() {
            return LevelType;
        }

        static /* synthetic */ Column access$12() {
            return CustomRollupSettings;
        }

        static /* synthetic */ Column access$13() {
            return LevelUniqueSettings;
        }

        static /* synthetic */ Column access$14() {
            return LevelIsVisible;
        }

        static /* synthetic */ Column access$15() {
            return Description;
        }
    }

    public static class MdschemaMeasuresRowset
    extends Rowset {
        public static final int MDMEASURE_AGGR_UNKNOWN = 0;
        public static final int MDMEASURE_AGGR_SUM = 1;
        public static final int MDMEASURE_AGGR_COUNT = 2;
        public static final int MDMEASURE_AGGR_MIN = 3;
        public static final int MDMEASURE_AGGR_MAX = 4;
        public static final int MDMEASURE_AGGR_AVG = 5;
        public static final int MDMEASURE_AGGR_VAR = 6;
        public static final int MDMEASURE_AGGR_STD = 7;
        public static final int MDMEASURE_AGGR_CALCULATED = 127;
        private final Util.Functor1<Boolean, Catalog> catalogCond = this.makeCondition(CATALOG_NAME_GETTER, CatalogName);
        private final Util.Functor1<Boolean, Schema> schemaNameCond = this.makeCondition(SCHEMA_NAME_GETTER, SchemaName);
        private final Util.Functor1<Boolean, Cube> cubeNameCond = this.makeCondition(ELEMENT_NAME_GETTER, CubeName);
        private final Util.Functor1<Boolean, Measure> measureUnameCond;
        private final Util.Functor1<Boolean, Measure> measureNameCond = this.makeCondition(ELEMENT_NAME_GETTER, MeasureName);
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, true, "The name of the catalog to which this measure belongs.");
        private static final Column SchemaName = new Column("SCHEMA_NAME", Type.String, null, true, true, "The name of the schema to which this measure belongs.");
        private static final Column CubeName = new Column("CUBE_NAME", Type.String, null, true, false, "The name of the cube to which this measure belongs.");
        private static final Column MeasureName = new Column("MEASURE_NAME", Type.String, null, true, false, "The name of the measure.");
        private static final Column MeasureUniqueName = new Column("MEASURE_UNIQUE_NAME", Type.String, null, true, false, "The Unique name of the measure.");
        private static final Column MeasureCaption = new Column("MEASURE_CAPTION", Type.String, null, false, false, "A label or caption associated with the measure.");
        private static final Column MeasureGuid = new Column("MEASURE_GUID", Type.UUID, null, false, true, "Measure GUID.");
        private static final Column MeasureAggregator = new Column("MEASURE_AGGREGATOR", Type.Integer, null, false, false, "How a measure was derived.");
        private static final Column DataType = new Column("DATA_TYPE", Type.UnsignedShort, null, false, false, "Data type of the measure.");
        private static final Column MeasureIsVisible = new Column("MEASURE_IS_VISIBLE", Type.Boolean, null, false, false, "A Boolean that always returns True. If the measure is not visible, it will not be included in the schema rowset.");
        private static final Column LevelsList = new Column("LEVELS_LIST", Type.String, null, false, true, "A string that always returns NULL. EXCEPT that SQL Server returns non-null values!!!");
        private static final Column Description = new Column("DESCRIPTION", Type.String, null, false, true, "A human-readable description of the measure.");
        private static final Column FormatString = new Column("DEFAULT_FORMAT_STRING", Type.String, null, false, true, "The default format string for the measure.");

        MdschemaMeasuresRowset(XmlaRequest request, XmlaHandler handler) {
            super(MDSCHEMA_MEASURES, request, handler);
            this.measureUnameCond = this.makeCondition(ELEMENT_UNAME_GETTER, MeasureUniqueName);
        }

        @Override
        public void populateImpl(XmlaResponse response, OlapConnection connection, List<Rowset.Row> rows) throws XmlaException, SQLException {
            for (Catalog catalog : RowsetDefinition.catIter(connection, new Util.Functor1[]{this.catNameCond(), this.catalogCond})) {
                this.populateCatalog(connection, catalog, rows);
            }
        }

        protected void populateCatalog(OlapConnection connection, Catalog catalog, List<Rowset.Row> rows) throws XmlaException, SQLException {
            StringBuilder buf = new StringBuilder(100);
            for (Schema schema : Util.filter(catalog.getSchemas(), new Util.Functor1[]{this.schemaNameCond})) {
                for (Cube cube : RowsetDefinition.filteredCubes(schema, this.cubeNameCond)) {
                    buf.setLength(0);
                    int j = 0;
                    for (Dimension dimension : cube.getDimensions()) {
                        if (dimension.getDimensionType() == Dimension.Type.MEASURE) continue;
                        for (Hierarchy hierarchy : dimension.getHierarchies()) {
                            NamedList levels = hierarchy.getLevels();
                            Level lastLevel = (Level)levels.get(levels.size() - 1);
                            if (j++ > 0) {
                                buf.append(',');
                            }
                            buf.append(lastLevel.getUniqueName());
                        }
                    }
                    String levelListStr = buf.toString();
                    ArrayList<Measure> calcMembers = new ArrayList<Measure>();
                    for (Measure measure : Util.filter(cube.getMeasures(), this.measureNameCond, this.measureUnameCond)) {
                        if (measure.isCalculated()) {
                            calcMembers.add(measure);
                            continue;
                        }
                        this.populateMember(connection, catalog, (Member)measure, cube, levelListStr, rows);
                    }
                    for (Member member : calcMembers) {
                        this.populateMember(connection, catalog, member, cube, null, rows);
                    }
                }
            }
        }

        private void populateMember(OlapConnection connection, Catalog catalog, Member member, Cube cube, String levelListStr, List<Rowset.Row> rows) throws SQLException {
            Boolean visible = (Boolean)member.getPropertyValue((Property)Property.StandardMemberProperty.$visible);
            if (visible == null) {
                visible = true;
            }
            if (!visible.booleanValue() && !XmlaUtil.shouldEmitInvisibleMembers(this.request)) {
                return;
            }
            String desc = member.getDescription();
            if (desc == null) {
                desc = String.valueOf(cube.getName()) + " Cube - " + member.getName() + " Member";
            }
            String formatString = (String)member.getPropertyValue((Property)Property.StandardCellProperty.FORMAT_STRING);
            Rowset.Row row = new Rowset.Row();
            row.set(MdschemaMeasuresRowset.CatalogName.name, catalog.getName());
            row.set(MdschemaMeasuresRowset.SchemaName.name, cube.getSchema().getName());
            row.set(MdschemaMeasuresRowset.CubeName.name, cube.getName());
            row.set(MdschemaMeasuresRowset.MeasureName.name, member.getName());
            row.set(MdschemaMeasuresRowset.MeasureUniqueName.name, member.getUniqueName());
            row.set(MdschemaMeasuresRowset.MeasureCaption.name, member.getCaption());
            XmlaHandler.XmlaExtra extra = XmlaHandler.getExtra(connection);
            row.set(MdschemaMeasuresRowset.MeasureAggregator.name, extra.getMeasureAggregator(member));
            XmlaConstants.DBType dbType = XmlaConstants.DBType.WSTR;
            String datatype = (String)member.getPropertyValue((Property)Property.StandardCellProperty.DATATYPE);
            if (datatype != null) {
                dbType = datatype.equals("Integer") ? XmlaConstants.DBType.I4 : (datatype.equals("Numeric") ? XmlaConstants.DBType.R8 : XmlaConstants.DBType.WSTR);
            }
            row.set(MdschemaMeasuresRowset.DataType.name, dbType.xmlaOrdinal());
            row.set(MdschemaMeasuresRowset.MeasureIsVisible.name, visible);
            if (levelListStr != null) {
                row.set(MdschemaMeasuresRowset.LevelsList.name, levelListStr);
            }
            row.set(MdschemaMeasuresRowset.Description.name, desc);
            row.set(MdschemaMeasuresRowset.FormatString.name, formatString);
            this.addRow(row, rows);
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$3() {
            return MeasureName;
        }

        static /* synthetic */ Column access$4() {
            return MeasureUniqueName;
        }

        static /* synthetic */ Column access$5() {
            return MeasureCaption;
        }

        static /* synthetic */ Column access$6() {
            return MeasureGuid;
        }

        static /* synthetic */ Column access$7() {
            return MeasureAggregator;
        }

        static /* synthetic */ Column access$8() {
            return DataType;
        }

        static /* synthetic */ Column access$9() {
            return MeasureIsVisible;
        }

        static /* synthetic */ Column access$10() {
            return LevelsList;
        }

        static /* synthetic */ Column access$11() {
            return Description;
        }

        static /* synthetic */ Column access$12() {
            return FormatString;
        }
    }

    static class MdschemaMembersRowset
    extends Rowset {
        private final Util.Functor1<Boolean, Catalog> catalogCond = this.makeCondition(CATALOG_NAME_GETTER, CatalogName);
        private final Util.Functor1<Boolean, Schema> schemaNameCond = this.makeCondition(SCHEMA_NAME_GETTER, SchemaName);
        private final Util.Functor1<Boolean, Cube> cubeNameCond = this.makeCondition(ELEMENT_NAME_GETTER, CubeName);
        private final Util.Functor1<Boolean, Dimension> dimensionUnameCond = this.makeCondition(ELEMENT_UNAME_GETTER, DimensionUniqueName);
        private final Util.Functor1<Boolean, Hierarchy> hierarchyUnameCond = this.makeCondition(ELEMENT_UNAME_GETTER, HierarchyUniqueName);
        private final Util.Functor1<Boolean, Member> memberNameCond = this.makeCondition(ELEMENT_NAME_GETTER, MemberName);
        private final Util.Functor1<Boolean, Member> memberUnameCond = this.makeCondition(ELEMENT_UNAME_GETTER, MemberUniqueName);
        private final Util.Functor1<Boolean, Member> memberTypeCond = this.makeCondition(MEMBER_TYPE_GETTER, MemberType);
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, true, "The name of the catalog to which this member belongs.");
        private static final Column SchemaName = new Column("SCHEMA_NAME", Type.String, null, true, true, "The name of the schema to which this member belongs.");
        private static final Column CubeName = new Column("CUBE_NAME", Type.String, null, true, false, "Name of the cube to which this member belongs.");
        private static final Column DimensionUniqueName = new Column("DIMENSION_UNIQUE_NAME", Type.String, null, true, false, "Unique name of the dimension to which this member belongs.");
        private static final Column HierarchyUniqueName = new Column("HIERARCHY_UNIQUE_NAME", Type.String, null, true, false, "Unique name of the hierarchy. If the member belongs to more than one hierarchy, there is one row for each hierarchy to which it belongs.");
        private static final Column LevelUniqueName = new Column("LEVEL_UNIQUE_NAME", Type.String, null, true, false, " Unique name of the level to which the member belongs.");
        private static final Column LevelNumber = new Column("LEVEL_NUMBER", Type.UnsignedInteger, null, true, false, "The distance of the member from the root of the hierarchy.");
        private static final Column MemberOrdinal = new Column("MEMBER_ORDINAL", Type.UnsignedInteger, null, false, false, "Ordinal number of the member. Sort rank of the member when members of this dimension are sorted in their natural sort order. If providers do not have the concept of natural ordering, this should be the rank when sorted by MEMBER_NAME.");
        private static final Column MemberName = new Column("MEMBER_NAME", Type.String, null, true, false, "Name of the member.");
        private static final Column MemberUniqueName = new Column("MEMBER_UNIQUE_NAME", Type.StringSometimesArray, null, true, false, " Unique name of the member.");
        private static final Column MemberType = new Column("MEMBER_TYPE", Type.Integer, null, true, false, "Type of the member.");
        private static final Column MemberGuid = new Column("MEMBER_GUID", Type.UUID, null, false, true, "Memeber GUID.");
        private static final Column MemberCaption = new Column("MEMBER_CAPTION", Type.String, null, true, false, "A label or caption associated with the member.");
        private static final Column ChildrenCardinality = new Column("CHILDREN_CARDINALITY", Type.UnsignedInteger, null, false, false, "Number of children that the member has.");
        private static final Column ParentLevel = new Column("PARENT_LEVEL", Type.UnsignedInteger, null, false, false, "The distance of the member's parent from the root level of the hierarchy.");
        private static final Column ParentUniqueName = new Column("PARENT_UNIQUE_NAME", Type.String, null, false, true, "Unique name of the member's parent.");
        private static final Column ParentCount = new Column("PARENT_COUNT", Type.UnsignedInteger, null, false, false, "Number of parents that this member has.");
        private static final Column TreeOp_ = new Column("TREE_OP", Type.Enumeration, Enumeration.TREE_OP, true, true, "Tree Operation");
        private static final Column Depth = new Column("DEPTH", Type.Integer, null, false, true, "depth");

        MdschemaMembersRowset(XmlaRequest request, XmlaHandler handler) {
            super(MDSCHEMA_MEMBERS, request, handler);
        }

        @Override
        public void populateImpl(XmlaResponse response, OlapConnection connection, List<Rowset.Row> rows) throws XmlaException, SQLException {
            for (Catalog catalog : RowsetDefinition.catIter(connection, new Util.Functor1[]{this.catNameCond(), this.catalogCond})) {
                this.populateCatalog(connection, catalog, rows);
            }
        }

        protected void populateCatalog(OlapConnection connection, Catalog catalog, List<Rowset.Row> rows) throws XmlaException, SQLException {
            for (Schema schema : Util.filter(catalog.getSchemas(), new Util.Functor1[]{this.schemaNameCond})) {
                for (Cube cube : RowsetDefinition.filteredCubes(schema, this.cubeNameCond)) {
                    if (this.isRestricted(MemberUniqueName)) {
                        this.outputUniqueMemberName(connection, catalog, cube, rows);
                        continue;
                    }
                    this.populateCube(connection, catalog, cube, rows);
                }
            }
        }

        protected void populateCube(OlapConnection connection, Catalog catalog, Cube cube, List<Rowset.Row> rows) throws XmlaException, SQLException {
            if (this.isRestricted(LevelUniqueName)) {
                String levelUniqueName = this.getRestrictionValueAsString(LevelUniqueName);
                if (levelUniqueName == null) {
                    return;
                }
                Level level = RowsetDefinition.lookupLevel(cube, levelUniqueName);
                if (level != null) {
                    List members = level.getMembers();
                    this.outputMembers(connection, members, catalog, cube, rows);
                }
            } else {
                for (Dimension dimension : Util.filter(cube.getDimensions(), new Util.Functor1[]{this.dimensionUnameCond})) {
                    this.populateDimension(connection, catalog, cube, dimension, rows);
                }
            }
        }

        protected void populateDimension(OlapConnection connection, Catalog catalog, Cube cube, Dimension dimension, List<Rowset.Row> rows) throws XmlaException, SQLException {
            for (Hierarchy hierarchy : Util.filter(dimension.getHierarchies(), new Util.Functor1[]{this.hierarchyUnameCond})) {
                this.populateHierarchy(connection, catalog, cube, hierarchy, rows);
            }
        }

        protected void populateHierarchy(OlapConnection connection, Catalog catalog, Cube cube, Hierarchy hierarchy, List<Rowset.Row> rows) throws XmlaException, SQLException {
            if (this.isRestricted(LevelNumber)) {
                int levelNumber = this.getRestrictionValueAsInt(LevelNumber);
                if (levelNumber == -1) {
                    LOGGER.warn((Object)"RowsetDefinition.populateHierarchy: LevelNumber invalid");
                    return;
                }
                NamedList levels = hierarchy.getLevels();
                if (levelNumber >= levels.size()) {
                    LOGGER.warn((Object)("RowsetDefinition.populateHierarchy: LevelNumber (" + levelNumber + ") is greater than number of levels (" + levels.size() + ") for hierarchy \"" + hierarchy.getUniqueName() + "\""));
                    return;
                }
                Level level = (Level)levels.get(levelNumber);
                List members = level.getMembers();
                this.outputMembers(connection, members, catalog, cube, rows);
            } else {
                for (Level level : hierarchy.getLevels()) {
                    this.outputMembers(connection, level.getMembers(), catalog, cube, rows);
                }
            }
        }

        private static boolean mask(int value, int mask) {
            return (value & mask) == mask;
        }

        private void populateMember(OlapConnection connection, Catalog catalog, Cube cube, Member member, int treeOp, List<Rowset.Row> rows) throws SQLException {
            Member parent;
            if (MdschemaMembersRowset.mask(treeOp, Member.TreeOp.SELF.xmlaOrdinal())) {
                this.outputMember(connection, member, catalog, cube, rows);
            }
            if (MdschemaMembersRowset.mask(treeOp, Member.TreeOp.SIBLINGS.xmlaOrdinal())) {
                Member parent2 = member.getParentMember();
                NamedList siblings = parent2 == null ? member.getHierarchy().getRootMembers() : Olap4jUtil.cast((NamedList)parent2.getChildMembers());
                for (Member sibling : siblings) {
                    if (sibling.equals(member)) continue;
                    this.populateMember(connection, catalog, cube, sibling, Member.TreeOp.SELF.xmlaOrdinal(), rows);
                }
            }
            if (MdschemaMembersRowset.mask(treeOp, Member.TreeOp.DESCENDANTS.xmlaOrdinal())) {
                for (Member child : member.getChildMembers()) {
                    this.populateMember(connection, catalog, cube, child, Member.TreeOp.SELF.xmlaOrdinal() | Member.TreeOp.DESCENDANTS.xmlaOrdinal(), rows);
                }
            } else if (MdschemaMembersRowset.mask(treeOp, Member.TreeOp.CHILDREN.xmlaOrdinal())) {
                for (Member child : member.getChildMembers()) {
                    this.populateMember(connection, catalog, cube, child, Member.TreeOp.SELF.xmlaOrdinal(), rows);
                }
            }
            if (MdschemaMembersRowset.mask(treeOp, Member.TreeOp.ANCESTORS.xmlaOrdinal())) {
                parent = member.getParentMember();
                if (parent != null) {
                    this.populateMember(connection, catalog, cube, parent, Member.TreeOp.SELF.xmlaOrdinal() | Member.TreeOp.ANCESTORS.xmlaOrdinal(), rows);
                }
            } else if (MdschemaMembersRowset.mask(treeOp, Member.TreeOp.PARENT.xmlaOrdinal()) && (parent = member.getParentMember()) != null) {
                this.populateMember(connection, catalog, cube, parent, Member.TreeOp.SELF.xmlaOrdinal(), rows);
            }
        }

        @Override
        protected ArrayList<Column> pruneRestrictions(ArrayList<Column> list) {
            if (list.contains(TreeOp_)) {
                list.remove(TreeOp_);
                list.remove(MemberUniqueName);
            }
            return list;
        }

        private void outputMembers(OlapConnection connection, List<Member> members, Catalog catalog, Cube cube, List<Rowset.Row> rows) throws SQLException {
            for (Member member : members) {
                this.outputMember(connection, member, catalog, cube, rows);
            }
        }

        private void outputUniqueMemberName(OlapConnection connection, Catalog catalog, Cube cube, List<Rowset.Row> rows) throws SQLException {
            Object unameRestrictions = this.restrictions.get(MdschemaMembersRowset.MemberUniqueName.name);
            List<String> list = unameRestrictions instanceof String ? Collections.singletonList((String)unameRestrictions) : (List<String>)unameRestrictions;
            for (String memberUniqueName : list) {
                IdentifierNode identifierNode = IdentifierNode.parseIdentifier((String)memberUniqueName);
                Member member = cube.lookupMember(identifierNode.getSegmentList());
                if (member == null) {
                    return;
                }
                if (this.isRestricted(TreeOp_)) {
                    int treeOp = this.getRestrictionValueAsInt(TreeOp_);
                    if (treeOp == -1) {
                        return;
                    }
                    this.populateMember(connection, catalog, cube, member, treeOp, rows);
                    continue;
                }
                this.outputMember(connection, member, catalog, cube, rows);
            }
        }

        private void outputMember(OlapConnection connection, Member member, Catalog catalog, Cube cube, List<Rowset.Row> rows) throws SQLException {
            if (!this.memberNameCond.apply(member).booleanValue()) {
                return;
            }
            if (!this.memberTypeCond.apply(member).booleanValue()) {
                return;
            }
            XmlaHandler.getExtra(connection).checkMemberOrdinal(member);
            Boolean visible = (Boolean)member.getPropertyValue((Property)Property.StandardMemberProperty.$visible);
            if (visible == null) {
                visible = true;
            }
            if (!visible.booleanValue() && !XmlaUtil.shouldEmitInvisibleMembers(this.request)) {
                return;
            }
            Level level = member.getLevel();
            Hierarchy hierarchy = level.getHierarchy();
            Dimension dimension = hierarchy.getDimension();
            int adjustedLevelDepth = level.getDepth();
            Rowset.Row row = new Rowset.Row();
            row.set(MdschemaMembersRowset.CatalogName.name, catalog.getName());
            row.set(MdschemaMembersRowset.SchemaName.name, cube.getSchema().getName());
            row.set(MdschemaMembersRowset.CubeName.name, cube.getName());
            row.set(MdschemaMembersRowset.DimensionUniqueName.name, dimension.getUniqueName());
            row.set(MdschemaMembersRowset.HierarchyUniqueName.name, hierarchy.getUniqueName());
            row.set(MdschemaMembersRowset.LevelUniqueName.name, level.getUniqueName());
            row.set(MdschemaMembersRowset.LevelNumber.name, adjustedLevelDepth);
            row.set(MdschemaMembersRowset.MemberOrdinal.name, member.getOrdinal());
            row.set(MdschemaMembersRowset.MemberName.name, member.getName());
            row.set(MdschemaMembersRowset.MemberUniqueName.name, member.getUniqueName());
            row.set(MdschemaMembersRowset.MemberType.name, member.getMemberType().ordinal());
            row.set(MdschemaMembersRowset.MemberCaption.name, member.getCaption());
            row.set(MdschemaMembersRowset.ChildrenCardinality.name, member.getPropertyValue((Property)Property.StandardMemberProperty.CHILDREN_CARDINALITY));
            row.set(MdschemaMembersRowset.ChildrenCardinality.name, 100);
            if (adjustedLevelDepth == 0) {
                row.set(MdschemaMembersRowset.ParentLevel.name, 0);
            } else {
                row.set(MdschemaMembersRowset.ParentLevel.name, adjustedLevelDepth - 1);
                Member parentMember = member.getParentMember();
                if (parentMember != null) {
                    row.set(MdschemaMembersRowset.ParentUniqueName.name, parentMember.getUniqueName());
                }
            }
            row.set(MdschemaMembersRowset.ParentCount.name, member.getParentMember() == null ? 0 : 1);
            row.set(MdschemaMembersRowset.Depth.name, member.getDepth());
            this.addRow(row, rows);
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$0() {
            return CatalogName;
        }

        static /* synthetic */ Column access$1() {
            return SchemaName;
        }

        static /* synthetic */ Column access$2() {
            return CubeName;
        }

        static /* synthetic */ Column access$3() {
            return DimensionUniqueName;
        }

        static /* synthetic */ Column access$4() {
            return HierarchyUniqueName;
        }

        static /* synthetic */ Column access$5() {
            return LevelUniqueName;
        }

        static /* synthetic */ Column access$6() {
            return LevelNumber;
        }

        static /* synthetic */ Column access$7() {
            return MemberOrdinal;
        }

        static /* synthetic */ Column access$8() {
            return MemberName;
        }

        static /* synthetic */ Column access$9() {
            return MemberUniqueName;
        }

        static /* synthetic */ Column access$10() {
            return MemberType;
        }

        static /* synthetic */ Column access$11() {
            return MemberGuid;
        }

        static /* synthetic */ Column access$12() {
            return MemberCaption;
        }

        static /* synthetic */ Column access$13() {
            return ChildrenCardinality;
        }

        static /* synthetic */ Column access$14() {
            return ParentLevel;
        }

        static /* synthetic */ Column access$15() {
            return ParentUniqueName;
        }

        static /* synthetic */ Column access$16() {
            return ParentCount;
        }

        static /* synthetic */ Column access$17() {
            return TreeOp_;
        }

        static /* synthetic */ Column access$18() {
            return Depth;
        }
    }

    static class MdschemaPropertiesRowset
    extends Rowset {
        private final Util.Functor1<Boolean, Catalog> catalogCond = this.makeCondition(CATALOG_NAME_GETTER, CatalogName);
        private final Util.Functor1<Boolean, Schema> schemaNameCond = this.makeCondition(SCHEMA_NAME_GETTER, SchemaName);
        private final Util.Functor1<Boolean, Cube> cubeNameCond = this.makeCondition(ELEMENT_NAME_GETTER, CubeName);
        private final Util.Functor1<Boolean, Dimension> dimensionUnameCond = this.makeCondition(ELEMENT_UNAME_GETTER, DimensionUniqueName);
        private final Util.Functor1<Boolean, Hierarchy> hierarchyUnameCond = this.makeCondition(ELEMENT_UNAME_GETTER, HierarchyUniqueName);
        private final Util.Functor1<Boolean, Property> propertyNameCond = this.makeCondition(ELEMENT_NAME_GETTER, PropertyName);
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, true, "The name of the database.");
        private static final Column SchemaName = new Column("SCHEMA_NAME", Type.String, null, true, true, "The name of the schema to which this property belongs.");
        private static final Column CubeName = new Column("CUBE_NAME", Type.String, null, true, true, "The name of the cube.");
        private static final Column DimensionUniqueName = new Column("DIMENSION_UNIQUE_NAME", Type.String, null, true, true, "The unique name of the dimension.");
        private static final Column HierarchyUniqueName = new Column("HIERARCHY_UNIQUE_NAME", Type.String, null, true, true, "The unique name of the hierarchy.");
        private static final Column LevelUniqueName = new Column("LEVEL_UNIQUE_NAME", Type.String, null, true, true, "The unique name of the level to which this property belongs.");
        private static final Column MemberUniqueName = new Column("MEMBER_UNIQUE_NAME", Type.String, null, true, true, "The unique name of the member to which the property belongs.");
        private static final Column PropertyName = new Column("PROPERTY_NAME", Type.String, null, true, false, "Name of the property.");
        private static final Column PropertyType = new Column("PROPERTY_TYPE", Type.Short, null, true, false, "A bitmap that specifies the type of the property");
        private static final Column PropertyCaption = new Column("PROPERTY_CAPTION", Type.String, null, false, false, "A label or caption associated with the property, used primarily for display purposes.");
        private static final Column DataType = new Column("DATA_TYPE", Type.UnsignedShort, null, false, false, "Data type of the property.");
        private static final Column PropertyContentType = new Column("PROPERTY_CONTENT_TYPE", Type.Short, null, true, true, "The type of the property.");
        private static final Column Description = new Column("DESCRIPTION", Type.String, null, false, true, "A human-readable description of the measure.");

        MdschemaPropertiesRowset(XmlaRequest request, XmlaHandler handler) {
            super(MDSCHEMA_PROPERTIES, request, handler);
        }

        @Override
        protected boolean needConnection() {
            return false;
        }

        @Override
        public void populateImpl(XmlaResponse response, OlapConnection connection, List<Rowset.Row> rows) throws XmlaException, SQLException {
            List list = (List)this.restrictions.get(MdschemaPropertiesRowset.PropertyType.name);
            Set typeFlags = list == null ? Olap4jUtil.enumSetOf((Enum)Property.TypeFlag.MEMBER, (Enum[])new Property.TypeFlag[0]) : Property.TypeFlag.getDictionary().forMask(Integer.valueOf((String)list.get(0)).intValue());
            for (Property.TypeFlag typeFlag : typeFlags) {
                switch (typeFlag) {
                    case MEMBER: {
                        this.populateMember(rows);
                        break;
                    }
                    case CELL: {
                        this.populateCell(rows);
                        break;
                    }
                }
            }
        }

        private void populateCell(List<Rowset.Row> rows) {
            Property.StandardCellProperty[] standardCellPropertyArray = Property.StandardCellProperty.values();
            int n = standardCellPropertyArray.length;
            int n2 = 0;
            while (n2 < n) {
                Property.StandardCellProperty property = standardCellPropertyArray[n2];
                Rowset.Row row = new Rowset.Row();
                row.set(MdschemaPropertiesRowset.PropertyType.name, Property.TypeFlag.getDictionary().toMask(property.getType()));
                row.set(MdschemaPropertiesRowset.PropertyName.name, property.name());
                row.set(MdschemaPropertiesRowset.PropertyCaption.name, property.getCaption());
                row.set(MdschemaPropertiesRowset.DataType.name, property.getDatatype().xmlaOrdinal());
                this.addRow(row, rows);
                ++n2;
            }
        }

        private void populateMember(List<Rowset.Row> rows) throws SQLException {
            OlapConnection connection = this.handler.getConnection(this.request, Collections.<String, String>emptyMap());
            for (Catalog catalog : RowsetDefinition.catIter(connection, new Util.Functor1[]{this.catNameCond(), this.catalogCond})) {
                this.populateCatalog(catalog, rows);
            }
        }

        protected void populateCatalog(Catalog catalog, List<Rowset.Row> rows) throws XmlaException, SQLException {
            for (Schema schema : Util.filter(catalog.getSchemas(), new Util.Functor1[]{this.schemaNameCond})) {
                for (Cube cube : RowsetDefinition.filteredCubes(schema, this.cubeNameCond)) {
                    this.populateCube(catalog, cube, rows);
                }
            }
        }

        protected void populateCube(Catalog catalog, Cube cube, List<Rowset.Row> rows) throws XmlaException, SQLException {
            if (cube instanceof SharedDimensionHolderCube) {
                return;
            }
            if (this.isRestricted(LevelUniqueName)) {
                String levelUniqueName = this.getRestrictionValueAsString(LevelUniqueName);
                if (levelUniqueName == null) {
                    return;
                }
                Level level = RowsetDefinition.lookupLevel(cube, levelUniqueName);
                if (level == null) {
                    return;
                }
                this.populateLevel(catalog, cube, level, rows);
            } else {
                for (Dimension dimension : Util.filter(cube.getDimensions(), new Util.Functor1[]{this.dimensionUnameCond})) {
                    this.populateDimension(catalog, cube, dimension, rows);
                }
            }
        }

        private void populateDimension(Catalog catalog, Cube cube, Dimension dimension, List<Rowset.Row> rows) throws SQLException {
            for (Hierarchy hierarchy : Util.filter(dimension.getHierarchies(), new Util.Functor1[]{this.hierarchyUnameCond})) {
                this.populateHierarchy(catalog, cube, hierarchy, rows);
            }
        }

        private void populateHierarchy(Catalog catalog, Cube cube, Hierarchy hierarchy, List<Rowset.Row> rows) throws SQLException {
            for (Level level : hierarchy.getLevels()) {
                this.populateLevel(catalog, cube, level, rows);
            }
        }

        private void populateLevel(Catalog catalog, Cube cube, Level level, List<Rowset.Row> rows) throws SQLException {
            XmlaHandler.XmlaExtra extra = XmlaHandler.getExtra(catalog.getMetaData().getConnection());
            for (Property property : Util.filter(extra.getLevelProperties(level), this.propertyNameCond)) {
                if (extra.isPropertyInternal(property)) continue;
                this.outputProperty(property, catalog, cube, level, rows);
            }
        }

        private void outputProperty(Property property, Catalog catalog, Cube cube, Level level, List<Rowset.Row> rows) {
            Hierarchy hierarchy = level.getHierarchy();
            Dimension dimension = hierarchy.getDimension();
            String propertyName = property.getName();
            Rowset.Row row = new Rowset.Row();
            row.set(MdschemaPropertiesRowset.CatalogName.name, catalog.getName());
            row.set(MdschemaPropertiesRowset.SchemaName.name, cube.getSchema().getName());
            row.set(MdschemaPropertiesRowset.CubeName.name, cube.getName());
            row.set(MdschemaPropertiesRowset.DimensionUniqueName.name, dimension.getUniqueName());
            row.set(MdschemaPropertiesRowset.HierarchyUniqueName.name, hierarchy.getUniqueName());
            row.set(MdschemaPropertiesRowset.LevelUniqueName.name, level.getUniqueName());
            row.set(MdschemaPropertiesRowset.PropertyName.name, propertyName);
            row.set(MdschemaPropertiesRowset.PropertyType.name, Property.TypeFlag.MEMBER.xmlaOrdinal());
            row.set(MdschemaPropertiesRowset.PropertyContentType.name, Property.ContentType.REGULAR.xmlaOrdinal());
            row.set(MdschemaPropertiesRowset.PropertyCaption.name, property.getCaption());
            XmlaConstants.DBType dbType = RowsetDefinition.getDBTypeFromProperty(property);
            row.set(MdschemaPropertiesRowset.DataType.name, dbType.xmlaOrdinal());
            String desc = String.valueOf(cube.getName()) + " Cube - " + RowsetDefinition.getHierarchyName(hierarchy) + " Hierarchy - " + level.getName() + " Level - " + property.getName() + " Property";
            row.set(MdschemaPropertiesRowset.Description.name, desc);
            this.addRow(row, rows);
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$0() {
            return CatalogName;
        }

        static /* synthetic */ Column access$1() {
            return SchemaName;
        }

        static /* synthetic */ Column access$2() {
            return CubeName;
        }

        static /* synthetic */ Column access$3() {
            return DimensionUniqueName;
        }

        static /* synthetic */ Column access$4() {
            return HierarchyUniqueName;
        }

        static /* synthetic */ Column access$5() {
            return LevelUniqueName;
        }

        static /* synthetic */ Column access$6() {
            return MemberUniqueName;
        }

        static /* synthetic */ Column access$7() {
            return PropertyName;
        }

        static /* synthetic */ Column access$8() {
            return PropertyCaption;
        }

        static /* synthetic */ Column access$9() {
            return PropertyType;
        }

        static /* synthetic */ Column access$10() {
            return DataType;
        }

        static /* synthetic */ Column access$11() {
            return PropertyContentType;
        }

        static /* synthetic */ Column access$12() {
            return Description;
        }
    }

    static class MdschemaSetsRowset
    extends Rowset {
        private final Util.Functor1<Boolean, Catalog> catalogCond = this.makeCondition(CATALOG_NAME_GETTER, CatalogName);
        private final Util.Functor1<Boolean, Schema> schemaNameCond = this.makeCondition(SCHEMA_NAME_GETTER, SchemaName);
        private final Util.Functor1<Boolean, Cube> cubeNameCond = this.makeCondition(ELEMENT_NAME_GETTER, CubeName);
        private final Util.Functor1<Boolean, NamedSet> setUnameCond = this.makeCondition(ELEMENT_UNAME_GETTER, SetName);
        private static final String GLOBAL_SCOPE = "1";
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, true, null);
        private static final Column SchemaName = new Column("SCHEMA_NAME", Type.String, null, true, true, null);
        private static final Column CubeName = new Column("CUBE_NAME", Type.String, null, true, false, null);
        private static final Column SetName = new Column("SET_NAME", Type.String, null, true, false, null);
        private static final Column SetCaption = new Column("SET_CAPTION", Type.String, null, true, true, null);
        private static final Column Scope = new Column("SCOPE", Type.Integer, null, true, false, null);
        private static final Column Description = new Column("DESCRIPTION", Type.String, null, false, true, "A human-readable description of the measure.");

        MdschemaSetsRowset(XmlaRequest request, XmlaHandler handler) {
            super(MDSCHEMA_SETS, request, handler);
        }

        @Override
        public void populateImpl(XmlaResponse response, OlapConnection connection, List<Rowset.Row> rows) throws XmlaException, OlapException {
            for (Catalog catalog : RowsetDefinition.catIter(connection, new Util.Functor1[]{this.catNameCond(), this.catalogCond})) {
                this.processCatalog(connection, catalog, rows);
            }
        }

        private void processCatalog(OlapConnection connection, Catalog catalog, List<Rowset.Row> rows) throws OlapException {
            for (Schema schema : Util.filter(catalog.getSchemas(), new Util.Functor1[]{this.schemaNameCond})) {
                for (Cube cube : Util.filter(RowsetDefinition.sortedCubes(schema), this.cubeNameCond)) {
                    this.populateNamedSets(cube, catalog, rows);
                }
            }
        }

        private void populateNamedSets(Cube cube, Catalog catalog, List<Rowset.Row> rows) {
            for (NamedSet namedSet : Util.filter(cube.getSets(), new Util.Functor1[]{this.setUnameCond})) {
                Rowset.Row row = new Rowset.Row();
                row.set(MdschemaSetsRowset.CatalogName.name, catalog.getName());
                row.set(MdschemaSetsRowset.SchemaName.name, cube.getSchema().getName());
                row.set(MdschemaSetsRowset.CubeName.name, cube.getName());
                row.set(MdschemaSetsRowset.SetName.name, namedSet.getUniqueName());
                row.set(MdschemaSetsRowset.Scope.name, GLOBAL_SCOPE);
                row.set(MdschemaSetsRowset.Description.name, namedSet.getDescription());
                this.addRow(row, rows);
            }
        }

        static /* synthetic */ Column access$3() {
            return SetName;
        }

        static /* synthetic */ Column access$4() {
            return Scope;
        }
    }

    private static class SharedDimensionHolderCube
    implements Cube {
        private final Schema schema;

        public SharedDimensionHolderCube(Schema schema) {
            this.schema = schema;
        }

        public Schema getSchema() {
            return this.schema;
        }

        public NamedList<Dimension> getDimensions() {
            try {
                return this.schema.getSharedDimensions();
            }
            catch (OlapException e) {
                throw new RuntimeException(e);
            }
        }

        public NamedList<Hierarchy> getHierarchies() {
            ArrayNamedListImpl<Hierarchy> hierarchyList = new ArrayNamedListImpl<Hierarchy>(){

                public String getName(Object hierarchy) {
                    return ((Hierarchy)hierarchy).getName();
                }
            };
            for (Dimension dimension : this.getDimensions()) {
                hierarchyList.addAll((Collection)dimension.getHierarchies());
            }
            return hierarchyList;
        }

        public List<Measure> getMeasures() {
            return Collections.emptyList();
        }

        public NamedList<NamedSet> getSets() {
            throw new UnsupportedOperationException();
        }

        public Collection<Locale> getSupportedLocales() {
            throw new UnsupportedOperationException();
        }

        public Member lookupMember(List<IdentifierSegment> identifierSegments) throws OlapException {
            throw new UnsupportedOperationException();
        }

        public List<Member> lookupMembers(Set<Member.TreeOp> treeOps, List<IdentifierSegment> identifierSegments) throws OlapException {
            throw new UnsupportedOperationException();
        }

        public boolean isDrillThroughEnabled() {
            return false;
        }

        public String getName() {
            return "";
        }

        public String getUniqueName() {
            return "";
        }

        public String getCaption() {
            return "";
        }

        public String getDescription() {
            return "";
        }

        public boolean isVisible() {
            return false;
        }
    }

    static enum Type {
        String("xsd:string"),
        StringArray("xsd:string"),
        Array("xsd:string"),
        Enumeration("xsd:string"),
        EnumerationArray("xsd:string"),
        EnumString("xsd:string"),
        Boolean("xsd:boolean"),
        StringSometimesArray("xsd:string"),
        Integer("xsd:int"),
        UnsignedInteger("xsd:unsignedInt"),
        DateTime("xsd:dateTime"),
        Rowset(null),
        Short("xsd:short"),
        UUID("uuid"),
        UnsignedShort("xsd:unsignedShort"),
        Long("xsd:long"),
        UnsignedLong("xsd:unsignedLong");

        public final String columnType;

        private Type(String columnType) {
            this.columnType = columnType;
        }

        boolean isEnum() {
            return this == Enumeration || this == EnumerationArray || this == EnumString;
        }

        String getName() {
            return this == String ? "string" : this.name();
        }
    }
}

