/*
 * Decompiled with CFR 0.152.
 */
package mondrian.xmla;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import mondrian.olap.MondrianException;
import mondrian.olap.Util;
import mondrian.xmla.Enumeration;
import mondrian.xmla.PropertyDefinition;
import mondrian.xmla.Rowset;
import mondrian.xmla.RowsetDefinition;
import mondrian.xmla.XmlaConstants;
import mondrian.xmla.XmlaException;
import mondrian.xmla.XmlaHandler;
import mondrian.xmla.XmlaRequest;
import mondrian.xmla.impl.DefaultXmlaResponse;
import org.olap4j.OlapConnection;
import org.olap4j.OlapException;
import org.olap4j.metadata.XmlaConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class XmlaUtil
implements XmlaConstants {
    private static final String[] CHAR_TABLE = new String[256];
    private static final Pattern LOWERCASE_PATTERN = Pattern.compile(".*[a-z].*");

    static {
        XmlaUtil.initCharTable(" \t\r\n(){}[]+/*%!,?");
    }

    private static void initCharTable(String charStr) {
        char[] chars;
        char[] cArray = chars = charStr.toCharArray();
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            XmlaUtil.CHAR_TABLE[c] = XmlaUtil.encodeChar(c);
            ++n2;
        }
    }

    private static String encodeChar(char c) {
        StringBuilder buf = new StringBuilder();
        buf.append("_x");
        String str = Integer.toHexString(c);
        int i = 4 - str.length();
        while (i > 0) {
            buf.append("0");
            --i;
        }
        return buf.append(str).append("_").toString();
    }

    private static String encodeElementName(String name) {
        char[] nameChars;
        StringBuilder buf = new StringBuilder();
        char[] cArray = nameChars = name.toCharArray();
        int n = nameChars.length;
        int n2 = 0;
        while (n2 < n) {
            String encodedStr;
            char ch = cArray[n2];
            String string = encodedStr = ch >= CHAR_TABLE.length ? null : CHAR_TABLE[ch];
            if (encodedStr == null) {
                buf.append(ch);
            } else {
                buf.append(encodedStr);
            }
            ++n2;
        }
        return buf.toString();
    }

    public static void element2Text(Element elem, StringWriter writer) throws XmlaException {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.transform(new DOMSource(elem), new StreamResult(writer));
        }
        catch (Exception e) {
            throw new XmlaException("Client", "00USMC02", "DOM parse errors occur", e);
        }
    }

    public static Element text2Element(String text) throws XmlaException {
        return XmlaUtil._2Element(new InputSource(new StringReader(text)));
    }

    public static Element stream2Element(InputStream stream) throws XmlaException {
        return XmlaUtil._2Element(new InputSource(stream));
    }

    private static Element _2Element(InputSource source) throws XmlaException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringElementContentWhitespace(true);
            factory.setIgnoringComments(true);
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(source);
            return doc.getDocumentElement();
        }
        catch (Exception e) {
            throw new XmlaException("Client", "00USMC02", "DOM parse errors occur", e);
        }
    }

    public static Element[] filterChildElements(Element parent, String ns, String lname) {
        ArrayList<Element> elems = new ArrayList<Element>();
        NodeList nlst = parent.getChildNodes();
        int i = 0;
        int nlen = nlst.getLength();
        while (i < nlen) {
            Node n = nlst.item(i);
            if (n instanceof Element) {
                Element e = (Element)n;
                if ((ns == null || ns.equals(e.getNamespaceURI())) && (lname == null || lname.equals(e.getLocalName()))) {
                    elems.add(e);
                }
            }
            ++i;
        }
        return elems.toArray(new Element[elems.size()]);
    }

    public static String textInElement(Element elem) {
        StringBuilder buf = new StringBuilder(100);
        elem.normalize();
        NodeList nlst = elem.getChildNodes();
        int i = 0;
        int nlen = nlst.getLength();
        while (i < nlen) {
            Node n = nlst.item(i);
            if (n instanceof Text) {
                String data = ((Text)n).getData();
                buf.append(data);
            }
            ++i;
        }
        return buf.toString();
    }

    public static Throwable rootThrowable(Throwable throwable) {
        Throwable rootThrowable = throwable.getCause();
        if (rootThrowable != null && rootThrowable instanceof MondrianException) {
            return XmlaUtil.rootThrowable(rootThrowable);
        }
        return throwable;
    }

    public static String normalizeNumericString(String numericStr) {
        int index = numericStr.indexOf(46);
        if (index > 0) {
            if (numericStr.indexOf(101) != -1) {
                return numericStr;
            }
            if (numericStr.indexOf(69) != -1) {
                return numericStr;
            }
            boolean found = false;
            int p = numericStr.length();
            char c = numericStr.charAt(p - 1);
            while (c == '0') {
                found = true;
                c = numericStr.charAt(--p - 1);
            }
            if (c == '.') {
                --p;
            }
            if (found) {
                return numericStr.substring(0, p);
            }
        }
        return numericStr;
    }

    public static MetadataRowset getMetadataRowset(final OlapConnection connection, String methodName, final Map<String, Object> restrictionMap) throws OlapException {
        RowsetDefinition rowsetDefinition = RowsetDefinition.valueOf(methodName);
        XmlaHandler.ConnectionFactory connectionFactory = new XmlaHandler.ConnectionFactory(){

            @Override
            public OlapConnection getConnection(String catalog, String schema, String roleName, Properties props) throws SQLException {
                return connection;
            }

            @Override
            public Map<String, Object> getPreConfiguredDiscoverDatasourcesResponse() {
                return null;
            }
        };
        XmlaRequest request = new XmlaRequest(){

            @Override
            public XmlaConstants.Method getMethod() {
                return XmlaConstants.Method.DISCOVER;
            }

            @Override
            public Map<String, String> getProperties() {
                return Collections.emptyMap();
            }

            @Override
            public Map<String, Object> getRestrictions() {
                return restrictionMap;
            }

            @Override
            public String getStatement() {
                return null;
            }

            @Override
            public String getRoleName() {
                return null;
            }

            @Override
            public String getRequestType() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isDrillThrough() {
                throw new UnsupportedOperationException();
            }

            public XmlaConstants.Format getFormat() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getUsername() {
                return null;
            }

            @Override
            public String getPassword() {
                return null;
            }

            @Override
            public String getSessionId() {
                return null;
            }
        };
        Rowset rowset = rowsetDefinition.getRowset(request, new XmlaHandler(connectionFactory, "xmla"){

            @Override
            public OlapConnection getConnection(XmlaRequest request, Map<String, String> propMap) {
                return connection;
            }
        });
        ArrayList<Rowset.Row> rowList = new ArrayList<Rowset.Row>();
        rowset.populate(new DefaultXmlaResponse(new ByteArrayOutputStream(), Charset.defaultCharset().name(), Enumeration.ResponseMimeType.SOAP), connection, rowList);
        MetadataRowset result = new MetadataRowset();
        ArrayList<RowsetDefinition.Column> colDefs = new ArrayList<RowsetDefinition.Column>();
        RowsetDefinition.Column[] columnArray = rowsetDefinition.columnDefinitions;
        int n = rowsetDefinition.columnDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            RowsetDefinition.Column columnDefinition = columnArray[n2];
            if (columnDefinition.type != RowsetDefinition.Type.Rowset) {
                colDefs.add(columnDefinition);
            }
            ++n2;
        }
        for (Rowset.Row row : rowList) {
            Object[] values = new Object[colDefs.size()];
            int k = -1;
            for (RowsetDefinition.Column colDef : colDefs) {
                Object o = row.get(colDef.name);
                if (o instanceof List) {
                    o = XmlaUtil.toString((List)o);
                } else if (o instanceof String[]) {
                    o = XmlaUtil.toString(Arrays.asList((String[])o));
                }
                values[++k] = o;
            }
            result.rowList.add(Arrays.asList(values));
        }
        for (RowsetDefinition.Column colDef : colDefs) {
            String columnName = colDef.name;
            if (LOWERCASE_PATTERN.matcher(columnName).matches()) {
                columnName = Util.camelToUpper(columnName);
            }
            if (columnName.equals("VALUE")) {
                columnName = "PROPERTY_VALUE";
            }
            result.headerList.add(columnName);
        }
        return result;
    }

    private static <T> String toString(List<T> list) {
        StringBuilder buf = new StringBuilder();
        int k = -1;
        for (T t : list) {
            if (++k > 0) {
                buf.append(", ");
            }
            buf.append(t);
        }
        return buf.toString();
    }

    public static Enumeration.ResponseMimeType chooseResponseMimeType(String accept) {
        String[] stringArray = accept.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enumeration.ResponseMimeType mimeType;
            String s = stringArray[n2];
            int semicolon = (s = s.trim()).indexOf(";");
            if (semicolon >= 0) {
                s = s.substring(0, semicolon);
            }
            if ((mimeType = Enumeration.ResponseMimeType.MAP.get(s)) != null) {
                return mimeType;
            }
            ++n2;
        }
        return null;
    }

    public static boolean shouldEmitInvisibleMembers(XmlaRequest request) {
        String value = request.getProperties().get(PropertyDefinition.EmitInvisibleMembers.name());
        return Boolean.parseBoolean(value);
    }

    public static class ElementNameEncoder {
        private final Map<String, String> map = new ConcurrentHashMap<String, String>();
        public static final ElementNameEncoder INSTANCE = new ElementNameEncoder();

        public String encode(String name) {
            String encoded = this.map.get(name);
            if (encoded == null) {
                encoded = XmlaUtil.encodeElementName(name);
                this.map.put(name, encoded);
            }
            return encoded;
        }
    }

    public static class MetadataRowset {
        public final List<String> headerList = new ArrayList<String>();
        public final List<List<Object>> rowList = new ArrayList<List<Object>>();
    }

    public static class Wildcard {
        public final String pattern;

        public Wildcard(String pattern) {
            this.pattern = pattern;
        }
    }
}

