/*
 * Decompiled with CFR 0.152.
 */
package mondrian.xmla.impl;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.regex.Pattern;
import mondrian.util.ArrayStack;
import mondrian.xmla.SaxWriter;
import org.eigenbase.xom.XMLUtil;
import org.eigenbase.xom.XOMUtil;
import org.xml.sax.Attributes;

public class DefaultSaxWriter
implements SaxWriter {
    private static final int STATE_IN_TAG = 0;
    private static final int STATE_END_ELEMENT = 1;
    private static final int STATE_AFTER_TAG = 2;
    private static final int STATE_CHARACTERS = 3;
    private final PrintWriter writer;
    private int indent;
    private String indentStr = "  ";
    private final ArrayStack<String> stack = new ArrayStack();
    private int state = 1;
    private static final Pattern nlPattern = Pattern.compile("\\r\\n|\\r|\\n");
    private static final Attributes EmptyAttributes = new Attributes(){

        @Override
        public int getLength() {
            return 0;
        }

        @Override
        public String getURI(int index) {
            return null;
        }

        @Override
        public String getLocalName(int index) {
            return null;
        }

        @Override
        public String getQName(int index) {
            return null;
        }

        @Override
        public String getType(int index) {
            return null;
        }

        @Override
        public String getValue(int index) {
            return null;
        }

        @Override
        public int getIndex(String uri, String localName) {
            return 0;
        }

        @Override
        public int getIndex(String qName) {
            return 0;
        }

        @Override
        public String getType(String uri, String localName) {
            return null;
        }

        @Override
        public String getType(String qName) {
            return null;
        }

        @Override
        public String getValue(String uri, String localName) {
            return null;
        }

        @Override
        public String getValue(String qName) {
            return null;
        }
    };

    public DefaultSaxWriter(OutputStream stream) {
        this(new OutputStreamWriter(stream));
    }

    public DefaultSaxWriter(OutputStream stream, String xmlEncoding) throws UnsupportedEncodingException {
        this(new OutputStreamWriter(stream, xmlEncoding));
    }

    public DefaultSaxWriter(Writer writer) {
        this(new PrintWriter(writer), 0);
    }

    public DefaultSaxWriter(PrintWriter writer, int initialIndent) {
        this.writer = writer;
        this.indent = initialIndent;
    }

    private void _startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        this._checkTag();
        if (this.indent > 0) {
            this.writer.println();
        }
        int i = 0;
        while (i < this.indent) {
            this.writer.write(this.indentStr);
            ++i;
        }
        ++this.indent;
        this.writer.write(60);
        this.writer.write(qName);
        i = 0;
        while (i < atts.getLength()) {
            XMLUtil.printAtt((PrintWriter)this.writer, (String)atts.getQName(i), (String)atts.getValue(i));
            ++i;
        }
        this.state = 0;
    }

    private void _checkTag() {
        if (this.state == 0) {
            this.state = 2;
            this.writer.print(">");
        }
    }

    private void _endElement(String namespaceURI, String localName, String qName) {
        --this.indent;
        if (this.state == 0) {
            this.writer.write("/>");
        } else {
            if (this.state != 3) {
                this.writer.println();
                int i = 0;
                while (i < this.indent) {
                    this.writer.write(this.indentStr);
                    ++i;
                }
            }
            this.writer.write("</");
            this.writer.write(qName);
            this.writer.write(62);
        }
        this.state = 1;
    }

    private void _characters(char[] ch, int start, int length) {
        this._checkTag();
        String s = new String(ch, start, length);
        if (XOMUtil.stringHasXMLSpecials((String)s)) {
            XMLUtil.stringEncodeXML((String)s, (PrintWriter)this.writer);
        } else {
            this.writer.print(s);
        }
        this.state = 3;
    }

    @Override
    public void characters(String s) {
        if (s != null && s.length() > 0) {
            this._characters(s.toCharArray(), 0, s.length());
        }
    }

    @Override
    public void startSequence(String name, String subName) {
        if (name != null) {
            this.startElement(name);
        } else {
            this.stack.push(null);
        }
    }

    @Override
    public void endSequence() {
        if (this.stack.peek() == null) {
            this.stack.pop();
        } else {
            this.endElement();
        }
    }

    @Override
    public final void textElement(String name, Object data) {
        this.startElement(name);
        this.characters(nlPattern.matcher(data.toString()).replaceAll(" "));
        this.endElement();
    }

    @Override
    public void element(String tagName, Object ... attributes) {
        this.startElement(tagName, attributes);
        this.endElement();
    }

    @Override
    public void startElement(String tagName) {
        this._startElement(null, null, tagName, EmptyAttributes);
        this.stack.add(tagName);
    }

    @Override
    public void startElement(String tagName, Object ... attributes) {
        this._startElement(null, null, tagName, new StringAttributes(attributes));
        assert (tagName != null);
        this.stack.add(tagName);
    }

    @Override
    public void endElement() {
        String tagName = this.stack.pop();
        this._endElement(null, null, tagName);
    }

    @Override
    public void startDocument() {
        if (this.stack.size() != 0) {
            throw new IllegalStateException("Document already started");
        }
    }

    @Override
    public void endDocument() {
        if (this.stack.size() != 0) {
            throw new IllegalStateException("Document may have unbalanced elements");
        }
        this.writer.flush();
    }

    @Override
    public void completeBeforeElement(String tagName) {
        if (this.stack.indexOf(tagName) == -1) {
            return;
        }
        String currentTagName = this.stack.peek();
        while (!tagName.equals(currentTagName)) {
            this._endElement(null, null, currentTagName);
            this.stack.pop();
            currentTagName = this.stack.peek();
        }
    }

    @Override
    public void verbatim(String text) {
        this._checkTag();
        this.writer.print(text);
    }

    @Override
    public void flush() {
        this.writer.flush();
    }

    public static class StringAttributes
    implements Attributes {
        private final Object[] strings;

        public StringAttributes(Object[] strings) {
            this.strings = strings;
        }

        @Override
        public int getLength() {
            return this.strings.length / 2;
        }

        @Override
        public String getURI(int index) {
            return null;
        }

        @Override
        public String getLocalName(int index) {
            return null;
        }

        @Override
        public String getQName(int index) {
            return (String)this.strings[index * 2];
        }

        @Override
        public String getType(int index) {
            return null;
        }

        @Override
        public String getValue(int index) {
            return StringAttributes.stringValue(this.strings[index * 2 + 1]);
        }

        @Override
        public int getIndex(String uri, String localName) {
            return -1;
        }

        @Override
        public int getIndex(String qName) {
            int count = this.strings.length / 2;
            int i = 0;
            while (i < count) {
                String string = (String)this.strings[i * 2];
                if (string.equals(qName)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        @Override
        public String getType(String uri, String localName) {
            return null;
        }

        @Override
        public String getType(String qName) {
            return null;
        }

        @Override
        public String getValue(String uri, String localName) {
            return null;
        }

        @Override
        public String getValue(String qName) {
            int index = this.getIndex(qName);
            if (index < 0) {
                return null;
            }
            return StringAttributes.stringValue(this.strings[index * 2 + 1]);
        }

        private static String stringValue(Object s) {
            return s == null ? null : s.toString();
        }
    }
}

