/*
 * Decompiled with CFR 0.152.
 */
package mondrian.xmla.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mondrian.olap.Util;
import mondrian.xmla.XmlaConstants;
import mondrian.xmla.XmlaException;
import mondrian.xmla.XmlaRequest;
import mondrian.xmla.XmlaUtil;
import org.apache.log4j.Logger;
import org.olap4j.metadata.XmlaConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultXmlaRequest
implements XmlaRequest,
XmlaConstants {
    private static final Logger LOGGER = Logger.getLogger(DefaultXmlaRequest.class);
    private static final String MSG_INVALID_XMLA = "Invalid XML/A message";
    private XmlaConstants.Method method;
    private Map<String, String> properties;
    private final String roleName;
    private String statement;
    private boolean drillthrough;
    private String requestType;
    private Map<String, Object> restrictions;
    private final String username;
    private final String password;
    private final String sessionId;

    public DefaultXmlaRequest(Element xmlaRoot, String roleName, String username, String password, String sessionId) throws XmlaException {
        this.init(xmlaRoot);
        this.roleName = roleName;
        this.username = username;
        this.password = password;
        this.sessionId = sessionId;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public XmlaConstants.Method getMethod() {
        return this.method;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public Map<String, Object> getRestrictions() {
        if (this.method != XmlaConstants.Method.DISCOVER) {
            throw new IllegalStateException("Only METHOD_DISCOVER has restrictions");
        }
        return this.restrictions;
    }

    @Override
    public String getStatement() {
        if (this.method != XmlaConstants.Method.EXECUTE) {
            throw new IllegalStateException("Only METHOD_EXECUTE has statement");
        }
        return this.statement;
    }

    @Override
    public String getRoleName() {
        return this.roleName;
    }

    @Override
    public String getRequestType() {
        if (this.method != XmlaConstants.Method.DISCOVER) {
            throw new IllegalStateException("Only METHOD_DISCOVER has requestType");
        }
        return this.requestType;
    }

    @Override
    public boolean isDrillThrough() {
        if (this.method != XmlaConstants.Method.EXECUTE) {
            throw new IllegalStateException("Only METHOD_EXECUTE determines drillthrough");
        }
        return this.drillthrough;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void init(Element xmlaRoot) throws XmlaException {
        if (!"urn:schemas-microsoft-com:xml-analysis".equals(xmlaRoot.getNamespaceURI())) {
            StringBuilder buf = new StringBuilder(100);
            buf.append(MSG_INVALID_XMLA);
            buf.append(": Bad namespace url \"");
            buf.append(xmlaRoot.getNamespaceURI());
            buf.append("\"");
            throw new XmlaException("Client", "00HSBB03", "XMLA SOAP bad method namespace", Util.newError(buf.toString()));
        }
        String lname = xmlaRoot.getLocalName();
        if ("Discover".equals(lname)) {
            this.method = XmlaConstants.Method.DISCOVER;
            this.initDiscover(xmlaRoot);
            return;
        }
        if ("Execute".equals(lname)) {
            this.method = XmlaConstants.Method.EXECUTE;
            this.initExecute(xmlaRoot);
            return;
        }
        StringBuilder buf = new StringBuilder(100);
        buf.append(MSG_INVALID_XMLA);
        buf.append(": Bad method name \"");
        buf.append(lname);
        buf.append("\"");
        throw new XmlaException("Client", "00HSBB02", "XMLA SOAP bad method", Util.newError(buf.toString()));
    }

    private void initDiscover(Element discoverRoot) throws XmlaException {
        Element[] childElems = XmlaUtil.filterChildElements(discoverRoot, "urn:schemas-microsoft-com:xml-analysis", "RequestType");
        if (childElems.length != 1) {
            StringBuilder buf = new StringBuilder(100);
            buf.append(MSG_INVALID_XMLA);
            buf.append(": Wrong number of RequestType elements: ");
            buf.append(childElems.length);
            throw new XmlaException("Client", "00HSBB04", "XMLA SOAP bad Discover RequestType element", Util.newError(buf.toString()));
        }
        this.requestType = XmlaUtil.textInElement(childElems[0]);
        childElems = XmlaUtil.filterChildElements(discoverRoot, "urn:schemas-microsoft-com:xml-analysis", "Properties");
        if (childElems.length != 1) {
            StringBuilder buf = new StringBuilder(100);
            buf.append(MSG_INVALID_XMLA);
            buf.append(": Wrong number of Properties elements: ");
            buf.append(childElems.length);
            throw new XmlaException("Client", "00HSBB06", "XMLA SOAP bad Discover or Execute Properties element", Util.newError(buf.toString()));
        }
        this.initProperties(childElems[0]);
        childElems = XmlaUtil.filterChildElements(discoverRoot, "urn:schemas-microsoft-com:xml-analysis", "Restrictions");
        if (childElems.length != 1) {
            StringBuilder buf = new StringBuilder(100);
            buf.append(MSG_INVALID_XMLA);
            buf.append(": Wrong number of Restrictions elements: ");
            buf.append(childElems.length);
            throw new XmlaException("Client", "00HSBB05", "XMLA SOAP bad Discover Restrictions element", Util.newError(buf.toString()));
        }
        this.initRestrictions(childElems[0]);
    }

    private void initExecute(Element executeRoot) throws XmlaException {
        Element[] childElems = XmlaUtil.filterChildElements(executeRoot, "urn:schemas-microsoft-com:xml-analysis", "Command");
        if (childElems.length != 1) {
            StringBuilder buf = new StringBuilder(100);
            buf.append(MSG_INVALID_XMLA);
            buf.append(": Wrong number of Command elements: ");
            buf.append(childElems.length);
            throw new XmlaException("Client", "00HSBB07", "XMLA SOAP bad Execute Command element", Util.newError(buf.toString()));
        }
        this.initCommand(childElems[0]);
        childElems = XmlaUtil.filterChildElements(executeRoot, "urn:schemas-microsoft-com:xml-analysis", "Properties");
        if (childElems.length != 1) {
            StringBuilder buf = new StringBuilder(100);
            buf.append(MSG_INVALID_XMLA);
            buf.append(": Wrong number of Properties elements: ");
            buf.append(childElems.length);
            throw new XmlaException("Client", "00HSBB06", "XMLA SOAP bad Discover or Execute Properties element", Util.newError(buf.toString()));
        }
        this.initProperties(childElems[0]);
    }

    private void initRestrictions(Element restrictionsRoot) throws XmlaException {
        HashMap restrictions = new HashMap();
        Element[] childElems = XmlaUtil.filterChildElements(restrictionsRoot, "urn:schemas-microsoft-com:xml-analysis", "RestrictionList");
        if (childElems.length == 1) {
            NodeList nlst = childElems[0].getChildNodes();
            int i = 0;
            int nlen = nlst.getLength();
            while (i < nlen) {
                Element e;
                Node n = nlst.item(i);
                if (n instanceof Element && "urn:schemas-microsoft-com:xml-analysis".equals((e = (Element)n).getNamespaceURI())) {
                    List<String> values;
                    String key = e.getLocalName();
                    String value = XmlaUtil.textInElement(e);
                    if (restrictions.containsKey(key)) {
                        values = (List)restrictions.get(key);
                    } else {
                        values = new ArrayList();
                        restrictions.put(key, values);
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("DefaultXmlaRequest.initRestrictions:  key=\"" + key + "\", value=\"" + value + "\""));
                    }
                    values.add(value);
                }
                ++i;
            }
        } else if (childElems.length > 1) {
            StringBuilder buf = new StringBuilder(100);
            buf.append(MSG_INVALID_XMLA);
            buf.append(": Wrong number of RestrictionList elements: ");
            buf.append(childElems.length);
            throw new XmlaException("Client", "00HSBB08", "XMLA SOAP too many Discover RestrictionList element", Util.newError(buf.toString()));
        }
        String key = XmlaConstants.Literal.CATALOG_NAME.name();
        if (this.properties.containsKey(key) && !restrictions.containsKey(key)) {
            ArrayList values = new ArrayList();
            restrictions.put(this.properties.get(key), values);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("DefaultXmlaRequest.initRestrictions:  key=\"" + key + "\", value=\"" + this.properties.get(key) + "\""));
            }
        }
        this.restrictions = Collections.unmodifiableMap(restrictions);
    }

    private void initProperties(Element propertiesRoot) throws XmlaException {
        HashMap<String, String> properties = new HashMap<String, String>();
        Element[] childElems = XmlaUtil.filterChildElements(propertiesRoot, "urn:schemas-microsoft-com:xml-analysis", "PropertyList");
        if (childElems.length == 1) {
            NodeList nlst = childElems[0].getChildNodes();
            int i = 0;
            int nlen = nlst.getLength();
            while (i < nlen) {
                Element e;
                Node n = nlst.item(i);
                if (n instanceof Element && "urn:schemas-microsoft-com:xml-analysis".equals((e = (Element)n).getNamespaceURI())) {
                    String key = e.getLocalName();
                    String value = XmlaUtil.textInElement(e);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("DefaultXmlaRequest.initProperties:  key=\"" + key + "\", value=\"" + value + "\""));
                    }
                    properties.put(key, value);
                }
                ++i;
            }
        } else if (childElems.length > 1) {
            StringBuilder buf = new StringBuilder(100);
            buf.append(MSG_INVALID_XMLA);
            buf.append(": Wrong number of PropertyList elements: ");
            buf.append(childElems.length);
            throw new XmlaException("Client", "00HSBB09", "XMLA SOAP bad Discover or Execute PropertyList element", Util.newError(buf.toString()));
        }
        this.properties = Collections.unmodifiableMap(properties);
    }

    private void initCommand(Element commandRoot) throws XmlaException {
        Element[] childElems = XmlaUtil.filterChildElements(commandRoot, "urn:schemas-microsoft-com:xml-analysis", "Statement");
        if (childElems.length != 1) {
            StringBuilder buf = new StringBuilder(100);
            buf.append(MSG_INVALID_XMLA);
            buf.append(": Wrong number of Statement elements: ");
            buf.append(childElems.length);
            throw new XmlaException("Client", "00HSBB10", "XMLA SOAP bad Execute Statement element", Util.newError(buf.toString()));
        }
        this.statement = XmlaUtil.textInElement(childElems[0]).replaceAll("\\r", "");
        this.drillthrough = this.statement.toUpperCase().indexOf("DRILLTHROUGH") != -1;
    }
}

