/*
 * Decompiled with CFR 0.152.
 */
package mondrian.xmla.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import mondrian.olap.Util;
import mondrian.util.ArrayStack;
import mondrian.xmla.SaxWriter;

class JsonSaxWriter
implements SaxWriter {
    private final StringBuilder buf = new StringBuilder();
    private int indent;
    private String[] indentStrings = INITIAL_INDENT_STRINGS;
    private String indentString = this.indentStrings[0];
    private final ArrayStack<Frame> stack = new ArrayStack();
    private OutputStream outputStream;
    private static final String[] INITIAL_INDENT_STRINGS = new String[]{"", "  ", "    ", "      ", "        ", "          ", "            ", "              ", "                ", "                  "};

    public JsonSaxWriter(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public void startDocument() {
        this.stack.push(new Frame(null));
    }

    @Override
    public void endDocument() {
        this.stack.pop();
        this.flush();
    }

    @Override
    public void startSequence(String name, String subName) {
        this.comma();
        this.buf.append(this.indentString);
        if (name == null) {
            name = subName;
        }
        if (this.stack.peek().name != null) {
            assert (name.equals(this.stack.peek().name)) : "In sequence [" + this.stack.peek() + "], element name [" + name + "]";
            this.buf.append("[");
        } else {
            Util.quoteForMdx(this.buf, name);
            this.buf.append(": [");
        }
        assert (subName != null);
        this.stack.push(new Frame(subName));
        this.indent();
    }

    @Override
    public void endSequence() {
        assert (this.stack.peek() != null) : "not in sequence";
        this.stack.pop();
        this.outdent();
        this.buf.append("\n");
        this.buf.append(this.indentString);
        this.buf.append("]");
    }

    @Override
    public void startElement(String name) {
        this.comma();
        this.buf.append(this.indentString);
        if (this.stack.peek().name != null) {
            assert (name.equals(this.stack.peek().name)) : "In sequence [" + this.stack.peek() + "], element name [" + name + "]";
            this.buf.append("{");
        } else {
            Util.quoteForMdx(this.buf, name);
            this.buf.append(": {");
        }
        this.stack.push(new Frame(null));
        this.indent();
    }

    @Override
    public void startElement(String name, Object ... attrs) {
        this.startElement(name);
        int i = 0;
        while (i < attrs.length) {
            if (i > 0) {
                this.buf.append(",\n");
            } else {
                this.buf.append("\n");
            }
            String attr = (String)attrs[i++];
            this.buf.append(this.indentString);
            Util.quoteForMdx(this.buf, attr);
            this.buf.append(": ");
            Object value = attrs[i++];
            this.value(value);
        }
        this.stack.peek().ordinal = attrs.length / 2;
    }

    @Override
    public void endElement() {
        Frame prev = this.stack.pop();
        assert (prev.name == null) : "Ended an element, but in sequence " + prev.name;
        this.buf.append("\n");
        this.outdent();
        this.buf.append(this.indentString);
        this.buf.append("}");
    }

    @Override
    public void element(String name, Object ... attrs) {
        this.startElement(name, attrs);
        this.endElement();
    }

    @Override
    public void characters(String data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void textElement(String name, Object data) {
        this.comma();
        this.buf.append(this.indentString);
        Util.quoteForMdx(this.buf, name);
        this.buf.append(": ");
        this.value(data);
    }

    @Override
    public void completeBeforeElement(String tagName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void verbatim(String text) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void flush() {
        try {
            this.outputStream.write(this.buf.toString().substring(1).getBytes());
        }
        catch (IOException e) {
            throw Util.newError(e, "While encoding JSON response");
        }
    }

    private void indent() {
        ++this.indent;
        if (this.indent >= this.indentStrings.length) {
            int newLength = this.indentStrings.length * 2 + 1;
            int INDENT = 2;
            assert (this.indentStrings[1].length() == 2);
            char[] chars = new char[newLength * 2];
            Arrays.fill(chars, ' ');
            String s = new String(chars);
            this.indentStrings = new String[newLength];
            int i = 0;
            while (i < newLength) {
                this.indentStrings[i] = s.substring(0, i * 2);
                ++i;
            }
        }
        this.indentString = this.indentStrings[this.indent];
    }

    private void outdent() {
        this.indentString = this.indentStrings[--this.indent];
    }

    private void value(Object value) {
        if (value instanceof String) {
            String s = (String)value;
            Util.quoteForMdx(this.buf, s);
        } else {
            this.buf.append(value);
        }
    }

    private void comma() {
        if (this.stack.peek().ordinal++ > 0) {
            this.buf.append(",\n");
        } else {
            this.buf.append("\n");
        }
    }

    private static class Frame {
        final String name;
        int ordinal;

        Frame(String name) {
            this.name = name;
        }
    }
}

