﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace BaiduPlayerExtensions
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        string dirStr = @"E:\temp\BaiduMusic\cache";
        string searchPattern = "*.dat";
        string dstDirStr = @"E:\temp\BaiduMusic\cache\justin";
        private void Form1_Load(object sender, EventArgs e)
        {
        }


        public List<MP3FileInfo> GetAllMp3Files(string dirStr, string searchPattern)
        {
            DirectoryInfo dir = new DirectoryInfo(dirStr);

            List<MP3FileInfo> mp3List = new List<MP3FileInfo>();
            if (dir.Exists)
            {
                IEnumerable<string> fs = dir.GetFiles(searchPattern).Select(r => r.FullName);
                foreach (var item in fs)
                {
                    MP3FileInfo mp3 = new MP3FileInfo(item);
                    if (mp3.LoadDetails())
                    {
                        mp3List.Add(mp3);
                    }
                }
            }
            return mp3List;
        }

        private void btnLoadMp3Files_Click(object sender, EventArgs e)
        {
            dataGridView1.DataSource = GetAllMp3Files(txtDirStr.Text, txtSearchPattern.Text);
        }

        private void btnSaveAs_Click(object sender, EventArgs e)
        {
            List<MP3FileInfo> mp3List = GetAllMp3Files(txtDirStr.Text, txtSearchPattern.Text);

            foreach (var item in mp3List)
            {
                string fileName = item.Title + ".mp3";
                if (!validFileName(fileName))
                {
                    fileName = fixedFileName(fileName);
                }
                string dstFile = Path.Combine(dstDirStr, fileName);

                if (!File.Exists(dstFile))
                {
                    File.Copy(item.FileFullName, dstFile);
                }
            }

            MessageBox.Show("OK");

        }


        /// <summary>
        /// 判断文件名是否合法
        /// </summary>
        /// <param name="fileName">文件名</param>
        /// <returns>ture，合法；false，非法</returns>
        public bool validFileName(string fileName)
        {
            if (!string.IsNullOrEmpty(fileName))
            {
                char[] errChars = Path.GetInvalidFileNameChars();
                foreach (char ch in errChars)
                {
                    if (fileName.Contains(ch.ToString()))
                        return false;
                }
            }
            else
            {
                return false;
            }
            return true;
        }
        /// <summary>
        /// 除掉文件名中的非法字符
        /// </summary>
        /// <param name="fileName"></param>
        /// <returns>合法的文件名</returns>
        public string fixedFileName(string fileName)
        {
            char[] errChars = Path.GetInvalidFileNameChars();
            StringBuilder fileNameBuilder = new StringBuilder(fileName);
            foreach (char ch in errChars)
            {
                fileNameBuilder.Replace(ch.ToString(), string.Empty);
            }
            return fileNameBuilder.ToString();
        }




    }
}
