﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;

namespace BaiduPlayerExtensions
{
    public class MP3FileInfo
    {
        private string MP3Flag { get; set; }
        public string Title { get; private set; }
        public string Singer { get; private set; }
        public string Album { get; private set; }
        public string Year { get; private set; }
        public string Comment { get; private set; }
        public string FileName { get { return Path.GetFileName(FileFullName); } }
        public string FileFullName { get; private set; }
        public MP3FileInfo(string fileFullName)
        {
            FileFullName = fileFullName;
        }
        public bool LoadDetails()
        {
            bool isSet = false;
            byte[] b = new byte[128];
            try
            {
                FileStream fs = new FileStream(FileFullName, FileMode.Open);
                fs.Seek(-128, SeekOrigin.End);
                fs.Read(b, 0, 128);
                this.MP3Flag = System.Text.Encoding.Default.GetString(b, 0, 3);
                if (this.MP3Flag.CompareTo("TAG") == 0)
                {
                    //检查是否设置了标签 
                    isSet = true;
                    this.Title = System.Text.Encoding.Default.GetString(b, 3, 30).RemoveSpace();
                    this.Singer = System.Text.Encoding.Default.GetString(b, 33, 30).RemoveSpace();
                    this.Album = System.Text.Encoding.Default.GetString(b, 63, 30).RemoveSpace();
                    this.Year = System.Text.Encoding.Default.GetString(b, 93, 4).RemoveSpace();
                    this.Comment = System.Text.Encoding.Default.GetString(b, 97, 30).RemoveSpace();
                }
                fs.Close();
            }
            catch (Exception e)
            {
                System.Console.WriteLine(e.Message);
            }
            return isSet;
        }

    }


    public static class Extensions
    {
        public static string RemoveSpace(this string instance)
        {
            return instance.Replace("\0", "");
        }
    }
}