﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Configuration;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using ICSharpCode.TextEditor.Document;
using Justin.Controls.Executer;
using Justin.Core;
using Justin.FrameWork.Settings;
using Justin.FrameWork.WinForm.Models;
using Microsoft.AnalysisServices.AdomdClient;

namespace Justin.Toolbox
{
    public partial class MdxExecutor : JForm, IFile
    {
        public MdxExecutor()
        {
            InitializeComponent();
            this.mdxExecuterCtrl1.FileChanged += this.OnFileChanged;
            this.LoadAction = (fileName) => { this.mdxExecuterCtrl1.LoadFile(fileName); };
            this.SaveAction = (fileName) => { this.mdxExecuterCtrl1.SaveFile(fileName, this.Extension); };
            this.FormClosing += MdxExecutor_FormClosing;
        }

        void MdxExecutor_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (e.CloseReason == CloseReason.MdiFormClosing) e.Cancel = true;

            bool save = JSetting.ReadAppSetting<bool>("SaveFileWhenExit");
            if (save && (e.CloseReason == CloseReason.ApplicationExitCall || e.CloseReason == CloseReason.UserClosing))
                this.mdxExecuterCtrl1.SaveFile(this.FileName, this.Extension);
        }
        /// <summary>
        ///     
        /// </summary>
        /// <param name="args" type="string[]">
        ///     <para>
        ///           0:fileName
        ///           1:Connection
        ///     </para>
        /// </param>
        public MdxExecutor(string[] args)
            : this()
        {
            if (args != null)
            {
                this.FileName = args[0];
                if (args.Length > 1 && !string.IsNullOrEmpty(args[1]))
                    this.ConnStr = args[1];

            }
        }

        private void MdxExecutor_Load(object sender, EventArgs e)
        {
            this.LoadFile(this.FileName);
            try
            {
                JSetting.SetUseAppSetting("OLAPConnStr", "OLAPConnStr");
                //MdxExecuterCtrlSetting.DefaultConnStr = ConfigurationManager.AppSettings["OLAPConnStr"];
            }
            catch { }

        }

        #region 继承

        protected override string GetPersistString()
        {
            return string.Format("{1}{0}{2}{0}{3}", Constants.Splitor, GetType().ToString(), this.FileName, this.ConnStr);
        }

        public override string ConnStr
        {
            get
            {
                return this.mdxExecuterCtrl1.ConnStr;
            }
            set
            {
                this.mdxExecuterCtrl1.ConnStr = value;
                base.ConnStr = value;
            }
        }

        protected override string FileName
        {
            get
            {
                return mdxExecuterCtrl1.FileName;
            }
            set
            {
                mdxExecuterCtrl1.FileName = value;
            }
        }
        public string Extension
        {
            get { return this.mdxExecuterCtrl1.Extension; }
        }

        #endregion



    }
}
