﻿Public Class FrmMain
    Dim water1 As Integer = -1
    Dim water2 As Integer = -1

#Region "文件菜单"

    Private Sub mnuOpenFile_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuOpenFile.Click
        If DialogResult.OK = Me.openFileDialog.ShowDialog(Me) Then
            Me.AxUdPdf1.LoadFromFile(Me.openFileDialog.FileName)
        End If
    End Sub

    Private Sub mnuOpenResource_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuOpenResource.Click
        Dim assembleName As String = Me.GetType().Assembly.GetName().Name
        Dim stream As System.IO.Stream = Me.GetType().Assembly.GetManifestResourceStream(assembleName & ".PDFSample.pdf")

        Dim buf As Byte()
        ReDim buf(stream.Length)
        stream.Read(buf, 0, buf.Length)
        stream.Close()

        Me.AxUdPdf1.LoadFromData(buf)
    End Sub

    Private Sub mnuPrint_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuPrint.Click
        Me.AxUdPdf1.Print()
    End Sub

    Private Sub mnuClose_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuClose.Click
        Me.AxUdPdf1.Close()
    End Sub

    Private Sub mnuExit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuExit.Click
        Me.Close()
    End Sub

#End Region

#Region "查看菜单"

    Private Sub mnuZoomFitWidth_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuZoomFitWidth.Click
        Me.AxUdPdf1.ZoomFitWidth()
    End Sub

    Private Sub mnuZoomFitPage_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuZoomFitPage.Click
        Me.AxUdPdf1.ZoomFitPage()
    End Sub

    Private Sub mnuZoomActual_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuZoomActual.Click
        Me.AxUdPdf1.ZoomActual()
    End Sub

    Private Sub mnuZoomIn_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuZoomIn.Click
        Me.AxUdPdf1.ZoomIn()
    End Sub

    Private Sub mnuZoomOut_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuZoomOut.Click
        Me.AxUdPdf1.ZoomOut()
    End Sub

    Private Sub mnuRotateLeft_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuRotateLeft.Click
        Me.AxUdPdf1.RotateLeft()
    End Sub

    Private Sub mnuRotateRight_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuRotateRight.Click
        Me.AxUdPdf1.RotateRight()
    End Sub

    Private Sub mnuGotoFirstPage_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuGotoFirstPage.Click
        Me.AxUdPdf1.GoToFirstPage()
    End Sub

    Private Sub mnuGotoPrevPage_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuGotoPrevPage.Click
        Me.AxUdPdf1.GoToPrevPage()
    End Sub

    Private Sub mnuGotoNextPage_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuGotoNextPage.Click
        Me.AxUdPdf1.GoToNextPage()
    End Sub

    Private Sub mnuGotoLastPage_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuGotoLastPage.Click
        Me.AxUdPdf1.GoToLastPage()
    End Sub

    Private Sub mnuToolBar_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuToolBar.Click
        Me.mnuToolBar.Checked = Not Me.mnuToolBar.Checked
        Me.AxUdPdf1.ToolbarVisible = Me.mnuToolBar.Checked
    End Sub

    Private Sub mnuBookmark_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuBookmark.Click
        Me.mnuBookmark.Checked = Not Me.mnuBookmark.Checked
        Me.AxUdPdf1.BookmarkVisible = Me.mnuBookmark.Checked
    End Sub

    Private Sub mnuFullScreen_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuFullScreen.Click
        Me.AxUdPdf1.ToggleFullScreen()
    End Sub

#End Region

#Region "安全菜单"

    Private Sub mnuAllowCopy_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuAllowCopy.Click
        Me.mnuAllowCopy.Checked = Not Me.mnuAllowCopy.Checked
        Me.AxUdPdf1.EnableCopy = Me.mnuAllowCopy.Checked
    End Sub

    Private Sub mnuAllowPrint_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuAllowPrint.Click
        Me.mnuAllowPrint.Checked = Not Me.mnuAllowPrint.Checked
        Me.mnuPrint.Enabled = Me.mnuAllowPrint.Checked
        Me.AxUdPdf1.EnablePrint = Me.mnuAllowPrint.Checked
    End Sub

    Private Sub mnuAllowCapture_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuAllowCapture.Click
        Me.mnuAllowCapture.Checked = Not Me.mnuAllowCapture.Checked
        Me.AxUdPdf1.EnableCapture = Me.mnuAllowCapture.Checked
    End Sub

    Private Sub mnuWaterMark_Click(sender As System.Object, e As System.EventArgs) Handles mnuWaterMark.Click
        If water1 > -1 Then
            Me.AxUdPdf1.RemoveWaterMark(water1)
            water1 = -1
        Else
            Me.AxUdPdf1.SetWaterFont("宋体", 20, 100, True, False, False, False)
            water1 = AxUdPdf1.AddWaterText("这里是动态添加的水印", 20, 100)
        End If

        If water2 > -1 Then
            AxUdPdf1.RemoveWaterMark(water2)
            water2 = -1
        Else
            AxUdPdf1.SetWaterFont("宋体", 40, 300, False, False, False, False)
            water2 = AxUdPdf1.AddWaterText("斜体的水印文字", 100, 300, 50, 45, 0, 0)
        End If

        mnuWaterMark.Checked = Not mnuWaterMark.Checked
    End Sub

#End Region

    Private Sub mnuAbout_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuAbout.Click
        Dim br As String = Chr(10) + Chr(13)
        MessageBox.Show("UUDoc PDF Control Sample for Windows" & br & br & "(C)2013 珠海市优道信息科技有限公司", "关于", MessageBoxButtons.OK, MessageBoxIcon.Information)
    End Sub

    Private Sub mnuWebSite_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuWebSite.Click
        System.Diagnostics.Process.Start("http://www.uudoc.com")
    End Sub


    Private Sub AxUdPdf1_OnReady(sender As System.Object, e As System.EventArgs) Handles AxUdPdf1.OnReady
        Me.mnuBookmark.Enabled = Me.AxUdPdf1.HasBookmark
        Me.mnuBookmark.Checked = Me.AxUdPdf1.HasBookmark
        Me.AxUdPdf1.BookmarkVisible = Me.AxUdPdf1.HasBookmark
    End Sub
End Class
