﻿Imports System.Data.OleDb
Imports System.IO

Partial Public Class Encrypt
    Inherits System.Web.UI.Page

    '加密密码，可自定义
    Const PASSWORD As String = "123abc"

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

    End Sub

    Protected Sub btnEncrypt_Click(ByVal sender As Object, ByVal e As EventArgs) Handles btnEncrypt.Click
        If Request.Files("upload").ContentLength = 0 Then
            lblInfo.Text = "<font color='red'>请先上传文件</font>"
        Else
            Dim fileName As String '上传文件的名称
            Dim pdfFile As String 'PDF文件的绝对路径名
            Dim encFile As String '加密后的文件名
            Dim encCmd As String '加密程序路径
            Dim args As String '加密传入参数
            Dim strOutput As String

            lblInfo.Text = ""

            fileName = Path.GetFileNameWithoutExtension(Request.Files("upload").FileName)
            pdfFile = Server.MapPath("upload/" & fileName & ".pdf")
            encFile = Server.MapPath("upload/" & fileName & ".enpdf")
            encCmd = Server.MapPath("UdPdf/UdPdfTools.exe")
            args = String.Format("-input {0} -password {1}", pdfFile, PASSWORD)

            Request.Files("upload").SaveAs(pdfFile)

            Dim p As System.Diagnostics.Process = New System.Diagnostics.Process() '进程对象
            p.StartInfo.FileName = encCmd
            p.StartInfo.Arguments = args
            p.StartInfo.UseShellExecute = False
            p.StartInfo.RedirectStandardOutput = True '由调用程序获取输出信息
            p.StartInfo.CreateNoWindow = True '不显示程序窗口
            p.Start()
            p.WaitForExit()
            strOutput = p.StandardOutput.ReadToEnd()
            If p.ExitCode = 0 Then
                SaveFile(encFile)
                System.IO.File.Delete(pdfFile)
                System.IO.File.Delete(encFile)
                If lblInfo.Text.Length = 0 Then
                    lblInfo.Text = "上传加密成功，<a href='Default.aspx'>点这里查看加密文件</a>"
                End If
            Else
                lblInfo.Text = "<font color='red'>加密失败，错误码：" & p.ExitCode & "<br>" & strOutput & "</font>"
            End If
            End If

    End Sub

    '将文件存储到数据库
    Sub SaveFile(ByVal fileName As String)

        Dim connStr As String
        connStr = "Provider=Microsoft.Jet.OLEDB.4.0;User ID=Admin;Data Source=" & Server.MapPath("App_Data/database.mdb")

        Dim stream As FileStream
        Dim buffer As Byte()

        Dim conn As OleDbConnection = New OleDbConnection(connStr)
        Dim cmd As OleDbCommand
        stream = New FileStream(fileName, FileMode.Open, FileAccess.Read)

        Try
            conn.Open()

            ReDim buffer(stream.Length)
            stream.Read(buffer, 0, stream.Length)
            cmd = New OleDbCommand("INSERT INTO T_FILES(FileName,FileDate,FileContent,FileSize)values(@name,@date,@contnet,@size)", conn)

            Dim pName As OleDbParameter = New OleDbParameter("@name", Path.GetFileName(fileName))
            Dim pDate As OleDbParameter = New OleDbParameter("@date", OleDbType.Date)
            pDate.Value = System.DateTime.Now
            Dim pContent As OleDbParameter = New OleDbParameter("@content", OleDbType.VarBinary)
            pContent.Value = buffer

            Dim pSize As OleDbParameter = New OleDbParameter("@size", OleDbType.Integer)
            pSize.Value = stream.Length
                   
            cmd.Parameters.Add(pName)
            cmd.Parameters.Add(pDate)
            cmd.Parameters.Add(pContent)
            cmd.Parameters.Add(pSize)
            cmd.ExecuteNonQuery()

        Catch ex As Exception
            lblInfo.Text = "<font color='red'>写入数据库失败：" & ex.Message & "</font>"
        Finally
            stream.Close()
            conn.Close()
        End Try


    End Sub
End Class