﻿using System;
using System.Collections.Generic;
using System.Web;
using FangPage.Template;
using TeachBookManagerModel;
using TeachBookManagerBLL;

namespace TeachBookManager
{
    public partial class bookout : SysPage
    {
        /// <summary>
        /// 入库单的书本id
        /// </summary>
        protected int id;
        /// <summary>
        /// 当前页
        /// </summary>
        protected int pageid;
        /// <summary>
        /// 记录总数
        /// </summary>
        protected int total;
        /// <summary>
        /// 每页多少条记录
        /// </summary>
        protected int pagesize = 10;
        /// <summary>
        /// 总页数
        /// </summary>
        protected int pagecount;
        /// <summary>
        /// 查询关键词
        /// </summary>
        protected string keyword = "";
        /// <summary>
        /// 出库表
        /// </summary>
        protected List<BookOutList> bookoutlist = new List<BookOutList>();
        /// <summary>
        /// 入库单的实体
        /// </summary>
        protected BookStore bookstore = new BookStore();
        /// <summary>
        /// 实例化入库业务逻辑层
        /// </summary>
        BookOutBLL bookoutbll = new BookOutBLL();
        /// <summary>
        /// 实例化入库业务逻辑层
        /// </summary>
        BookStoreBLL bookstorebll = new BookStoreBLL();

        protected override void ShowPage()
        {
            id = FPRequest.GetInt("id", 0);

            keyword = FPRequest.GetString("keyword");

            pageid = FPRequest.GetInt("pageid", 1);

            bookstore = bookstorebll.GetBookStoreInfo(id);

            //删除
            if (ispost)
            {
                string idlist = FPRequest.GetString("del");//1,2,4

                if (!string.IsNullOrEmpty(idlist))
                {
                    foreach (string sid in idlist.Split(','))
                    {
                        bookoutbll.DeleteBookOut(int.Parse(sid));
                    }
                }

                Response.Redirect("bookout.aspx?id="+id.ToString());

                return;
            }

            total = bookoutbll.GetBookOutCount(keyword,id);

            pagecount = total / pagesize;

            if (total % pagesize > 0)
            {
                pagecount++;
            }

            bookoutlist = bookoutbll.GetBookOutList(pagesize, pageid, keyword,id);
        }

    }
}