﻿using System;
using System.Collections.Generic;
using System.Web;
using TeachBookManagerModel;
using TeachBookManagerBLL;
using FangPage.Template;

namespace TeachBookManager
{
    public partial class bookoutedit : SysPage
    {
        protected int id;

        protected int bookid;

        protected BookStore bookstore = new BookStore();

        protected BookOut bookoutinfo = new BookOut();

        BookStoreBLL bookstorebll = new BookStoreBLL();

        BookOutBLL booksoutbll = new BookOutBLL();

        protected override void ShowPage()
        {
            id = FPRequest.GetInt("id", 0);

            bookid = FPRequest.GetInt("bookid", 0);

            bookoutinfo = booksoutbll.GetBookOutInfo(id);

            //处理错误
            if (bookoutinfo == null)
            {
                AddErr("出库单已被删除或者不存在");
                ShowMsg("错误", msg);
                return;
            }

            bookstore = bookstorebll.GetBookStoreInfo(bookoutinfo.bookid);

            if (ispost)
            {
                bookoutinfo.counts = FPRequest.GetInt("counts", 0);
                bookoutinfo.datetime = Convert.ToDateTime(FPRequest.GetString("datetime"));
                bookoutinfo.student = FPRequest.GetString("student");
                bookoutinfo.stucla = FPRequest.GetString("class");
                bookoutinfo.signer = FPRequest.GetString("signer");
                bookoutinfo.note = FPRequest.GetString("note");

                if (booksoutbll.UpdateBookOut(bookoutinfo) > 0)
                {
                    Response.Redirect("bookout.aspx?id="+bookid);
                }
                else
                {
                    AddErr("更新失败，请检查输入是否正确");
                    ShowMsg("更新失败", msg);
                }
            }
        }
    }
}