﻿using System;
using System.Collections.Generic;
using System.Web;
using FangPage.Template;
using TeachBookManagerModel;
using TeachBookManagerBLL;

namespace TeachBookManager
{
    public partial class index : SysPage
    {
        //当前页
        protected int pageid ;
        //总数
        protected int total;
        //每页多少条记录
        protected int pagesize=10;
        //总页数
        protected int pagecount;
        //查询关键时
        protected string keyword = "";
        //入库表
        protected List<BookStore> bookstorelist = new List<BookStore>();
        //实例化入库业务逻辑层
        BookStoreBLL bookstorebll = new BookStoreBLL();
        //实例化出库业务逻辑层
        BookOutBLL bookoutbll = new BookOutBLL();

        protected override void ShowPage()
        {
            keyword = FPRequest.GetString("keyword");

            pageid = FPRequest.GetInt("pageid", 1);

            //删除
            if (ispost)
            {
                string idlist = FPRequest.GetString("del");//1,2,4

                if (!string.IsNullOrEmpty(idlist))
                {
                    foreach (string sid in idlist.Split(','))
                    {
                        //删除对应的出库单
                        bookoutbll.DeleteBookOutBy(int.Parse(sid));

                        //删除入库单
                        bookstorebll.DeleteBookStore(int.Parse(sid));
                    }
                }

                Response.Redirect("index.aspx");

                return;
            }

            total = bookstorebll.GetBookStoreCount();

            pagecount = total / pagesize;

            if (total % pagesize > 0)
            {
                pagecount++;
            }

            bookstorelist = bookstorebll.GetBookStoreList(pagesize, pageid,keyword);
        }
    }
}