﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using TeachBookManagerModel;
using TeachBookManagerDAL;
using System.Data;

namespace TeachBookManagerBLL
{
    public class BookOutBLL
    {
        BookOutDAL bookstoredal = new BookOutDAL();

        BookStoreBLL bookstorebll = new BookStoreBLL();

        /// <summary>
        /// 添加出库单
        /// </summary>
        /// <param name="bookout"></param>
        /// <returns></returns>
        public int AddBookOut(BookOut bookout)
        {
            int issuccess = bookstoredal.AddBookOut(bookout);

            if (issuccess > 0)
            {
                BookStore bookstore = bookstorebll.GetBookStoreInfo(bookout.bookid);

                bookstore.outs += bookout.counts;

                bookstorebll.UpdateBookStore(bookstore);
            }

            return issuccess;
        }

        /// <summary>
        /// 更改出库单
        /// </summary>
        /// <param name="bookout"></param>
        /// <returns></returns>
        public int UpdateBookOut(BookOut bookout)
        {
            BookStore bookstore = bookstorebll.GetBookStoreInfo(bookout.bookid);

            BookOut oldbookout = GetBookOutInfo(bookout.id);

            bookstore.outs = (bookstore.outs - oldbookout.counts) + bookout.counts;

            int issuccess = bookstoredal.UpdateBookOut(bookout);

            if (issuccess > 0)
            {
                bookstorebll.UpdateBookStore(bookstore);
            }

            return issuccess;
        }

        /// <summary>
        /// 删除出库单
        /// </summary>
        /// <param name="id"></param>
        public void DeleteBookOut(int id)
        {
            BookOut bookout = GetBookOutInfo(id);

            BookStore bookstore = bookstorebll.GetBookStoreInfo(bookout.bookid);

            bookstore.outs -= bookout.counts;

            bookstorebll.UpdateBookStore(bookstore);

            bookstoredal.DeleteBookOut(id);
        }

        /// <summary>
        /// 删除出库单通过bookid 
        /// </summary>
        /// <param name="id"></param>
        public void DeleteBookOutBy(int bookid)
        {
            bookstoredal.DeleteBookOutBy(bookid);
        }

        /// <summary>
        /// 获取出库表
        /// </summary>
        /// <param name="pagesize"></param>
        /// <param name="pageindex"></param>
        /// <returns></returns>
        public List<BookOutList> GetBookOutList(int pagesize, int pageindex,string keyword,int bookid)
        {
            return bookstoredal.GetBookOutList(pagesize, pageindex,keyword,bookid);
        }

        /// <summary>
        /// 获取出库单总数
        /// </summary>
        /// <returns></returns>
        public int GetBookOutCount(string keyword,int bookid)
        {
            return bookstoredal.GetBookOutCount(keyword,bookid);
        }

        /// <summary>
        /// 获取新闻信息
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public BookOut GetBookOutInfo(int id)
        {
            return bookstoredal.GetBookOutInfo(id);
        }
    }
}
