﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using TeachBookManagerModel;
using System.Data;

namespace TeachBookManagerDAL
{
    public  class BookStoreDAL
    {

        /// <summary>
        /// 添加入库单
        /// </summary>
        /// <param name="bookstore"></param>
        /// <returns></returns>
        public int AddBookStore(BookStore bookstore)
        {
            using (TeachBookManagerEntities ef = new TeachBookManagerEntities())
            {
                ef.BookStore.AddObject(bookstore);
                return ef.SaveChanges();
            }
        }

        /// <summary>
        /// 更改入库单
        /// </summary>
        /// <param name="bookstore"></param>
        /// <returns></returns>
        public int UpdateBookStore(BookStore bookstore)
        {
            using (TeachBookManagerEntities ef = new TeachBookManagerEntities())
            {
                ef.BookStore.Attach(bookstore);
                ef.ObjectStateManager.ChangeObjectState(bookstore, EntityState.Modified);

                return ef.SaveChanges();
            }
        }

        /// <summary>
        /// 删除入库单
        /// </summary>
        /// <param name="id"></param>
        public void DeleteBookStore(int id)
        {
            using (TeachBookManagerEntities ef = new TeachBookManagerEntities())
            {
                BookStore bookstore = ef.BookStore.Where(item => item.id == id).FirstOrDefault();

                ef.BookStore.DeleteObject(bookstore);
                ef.SaveChanges();
            }
        }

        /// <summary>
        /// 获取入库表
        /// </summary>
        /// <param name="pagesize"></param>
        /// <param name="pageindex"></param>
        /// <returns></returns>
        public List<BookStore> GetBookStoreList(int pagesize, int pageindex,string keyword)
        {
            using (TeachBookManagerEntities ef = new TeachBookManagerEntities())
            {
                return ef.BookStore.Where(item=>item.bookname.Contains(keyword)).OrderByDescending(item => item.id).Skip((pageindex - 1) * pagesize).Take(pagesize).ToList();
            }
        }

        /// <summary>
        /// 获取入库单总数
        /// </summary>
        /// <returns></returns>
        public int GetBookStoreCount()
        {
            using (TeachBookManagerEntities ef = new TeachBookManagerEntities())
            {
                return ef.BookStore.Count();
            }
        }

        /// <summary>
        /// 获取入库单信息
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public BookStore GetBookStoreInfo(int id)
        {
            using (TeachBookManagerEntities ef = new TeachBookManagerEntities())
            {
                return ef.BookStore.Where(item => item.id == id).FirstOrDefault();
            }
        }
    }
}
