﻿namespace PageTool
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using System.Web.UI;
    using System.Web.UI.HtmlControls;
    using System.Web.UI.WebControls;

    [ToolboxData("<{0}:PageTool runat=server></{0}:PageTool>")]
    public class PageTool : Control
    {
        private string color = "black";
        private string keyword = "";
        private HtmlAnchor next = new HtmlAnchor();
        private int number = 7;
        private int pageSize = 15;
        private PlaceHolder phpage = new PlaceHolder();
        private HtmlAnchor pre = new HtmlAnchor();
        private int state = 1;
        private string url;

        private void Button_Click()
        {
            List<HtmlAnchor> mlist = new List<HtmlAnchor>();
            int tip = Convert.ToInt32(this.Page.Request.QueryString["number"]);
            if (this.state > 0)
            {
                if (tip == 0)
                {
                    tip = this.center;
                }
                mlist = AcountUtil.ButtonDynamicLogic(this.Number, this.center, this.state, tip, this.pageSize, this.keyword, this.url);
                this.placeHolderClearOrAddControls(mlist);
            }
        }

        private List<HtmlAnchor> getInitMyButtonList()
        {
            int paramSize = 0;
            if (this.Number <= this.pageSize)
            {
                paramSize = this.Number;
            }
            else
            {
                paramSize = this.pageSize;
            }
            return ButtonService.GetButtonListByParamSize(paramSize, this.keyword, this.url);
        }

        protected override void OnInit(EventArgs e)
        {
            if (!base.DesignMode)
            {
                try
                {
                    if (this.Page.Request.QueryString["page"] != null)
                    {
                        int num = Convert.ToInt32(this.Page.Request.QueryString["page"]);
                        if (num > 0)
                        {
                            this.state = num;
                        }
                        else
                        {
                            this.state = 1;
                        }
                    }
                    if (this.Page.Request.QueryString["keyword"] != null)
                    {
                        this.keyword = this.Page.Request.QueryString["keyword"].ToString();
                    }
                }
                catch
                {
                    this.state = 1;
                }
            }
        }

        private void phpageAddMyButton(List<HtmlAnchor> hllist)
        {
            this.phpage.Controls.Clear();
            if (hllist != null)
            {
                for (int i = 0; i < hllist.Count; i++)
                {
                    this.phpage.Controls.Add(hllist[i]);
                }
            }
        }

        private void placeHolderClearOrAddControls(List<HtmlAnchor> mlist)
        {
            this.phpageAddMyButton(mlist);
        }

        protected override void Render(HtmlTextWriter writer)
        {
            int num;
            Exception exception;
            if (this.state > this.pageSize)
            {
                this.state = this.pageSize;
            }
            this.pre.InnerHtml = "[上一页]";
            if (this.state == 1)
            {
                this.pre.HRef = string.Concat(new object[] { this.url, "?keyword=", this.keyword, "&page=", this.state });
                this.pre.Visible = false;
            }
            else
            {
                this.pre.HRef = string.Concat(new object[] { this.url, "?keyword=", this.keyword, "&page=", this.state - 1 });
            }
            this.next.InnerHtml = "[下一页]";
            if (this.state == this.pageSize)
            {
                this.next.HRef = string.Concat(new object[] { this.url, "?keyword=", this.keyword, "&page=", this.pageSize });
                this.next.Visible = false;
            }
            else
            {
                this.next.HRef = string.Concat(new object[] { this.url, "?keyword=", this.keyword, "&page=", this.state + 1 });
            }
            this.thisObjectAddControlByAttribute();
            writer.AddAttribute("ID", this.ID);
            writer.RenderBeginTag(HtmlTextWriterTag.Table);
            writer.RenderBeginTag(HtmlTextWriterTag.Tr);
            if (!base.DesignMode)
            {
                try
                {
                    this.Button_Click();
                    writer.AddStyleAttribute("padding-left", "7px");
                    writer.RenderBeginTag(HtmlTextWriterTag.Td);
                    this.pre.RenderControl(writer);
                    writer.RenderEndTag();
                    for (num = 0; num < this.phpage.Controls.Count; num++)
                    {
                        HtmlAnchor anchor = (HtmlAnchor) this.phpage.Controls[num];
                        string str = anchor.InnerHtml.Substring(1, anchor.InnerHtml.LastIndexOf("]") - 1);
                        if (str == this.state.ToString())
                        {
                            anchor.InnerHtml = str;
                            writer.AddStyleAttribute("padding-left", "7px");
                            writer.RenderBeginTag(HtmlTextWriterTag.Td);
                            anchor.Attributes.Add("style", "color:" + this.color);
                            anchor.RenderControl(writer);
                            writer.RenderEndTag();
                        }
                        else
                        {
                            writer.AddStyleAttribute("padding-left", "7px");
                            writer.RenderBeginTag(HtmlTextWriterTag.Td);
                            this.phpage.Controls[num].RenderControl(writer);
                            writer.RenderEndTag();
                        }
                    }
                    writer.AddStyleAttribute("padding-left", "7px");
                    writer.RenderBeginTag(HtmlTextWriterTag.Td);
                    this.next.RenderControl(writer);
                    writer.RenderEndTag();
                }
                catch (Exception exception2)
                {
                    exception = exception2;
                    writer.RenderBeginTag(HtmlTextWriterTag.Td);
                    writer.Write(exception.Message);
                    writer.RenderEndTag();
                }
                writer.RenderEndTag();
                writer.RenderEndTag();
            }
            else
            {
                try
                {
                    writer.AddStyleAttribute("padding-left", "7px");
                    writer.RenderBeginTag(HtmlTextWriterTag.Td);
                    this.pre.RenderControl(writer);
                    writer.RenderEndTag();
                    for (num = 0; num < this.phpage.Controls.Count; num++)
                    {
                        writer.AddStyleAttribute("padding-left", "7px");
                        writer.RenderBeginTag(HtmlTextWriterTag.Td);
                        this.phpage.Controls[num].RenderControl(writer);
                        writer.RenderEndTag();
                    }
                    writer.AddStyleAttribute("padding-left", "7px");
                    writer.RenderBeginTag(HtmlTextWriterTag.Td);
                    this.next.RenderControl(writer);
                    writer.RenderEndTag();
                }
                catch (Exception exception3)
                {
                    exception = exception3;
                    writer.RenderBeginTag(HtmlTextWriterTag.Td);
                    writer.Write(exception.Message);
                    writer.RenderEndTag();
                }
                writer.RenderEndTag();
                writer.RenderEndTag();
            }
        }

        private void thisObjectAddControlByAttribute()
        {
            this.phpage.Controls.Clear();
            this.phpageAddMyButton(this.getInitMyButtonList());
        }

        private int center
        {
            get
            {
                if (this.number != 0)
                {
                    if ((this.number % 2) == 0)
                    {
                        return (this.number / 2);
                    }
                    if (this.number == 1)
                    {
                        return 1;
                    }
                    return (((this.number - 1) / 2) + 1);
                }
                return 0;
            }
        }

        [Description("此控件的当前页的颜色"), Browsable(true)]
        public string Color
        {
            get
            {
                return this.color;
            }
            set
            {
                this.color = value;
            }
        }

        [Description("此控件的关键字"), Browsable(true)]
        public string Keyword
        {
            get
            {
                return this.keyword;
            }
            set
            {
                this.keyword = value;
            }
        }

        [Browsable(true), Description("些控件选择页数的个数")]
        public int Number
        {
            get
            {
                if (this.number >= this.pageSize)
                {
                    this.number = this.pageSize;
                }
                return this.number;
            }
            set
            {
                if (value >= 0)
                {
                    this.number = value;
                }
                else
                {
                    this.number = 1;
                }
            }
        }

        [Description("此控件的页大小"), Browsable(true)]
        public int PageSize
        {
            get
            {
                return this.pageSize;
            }
            set
            {
                if (value < 0)
                {
                    this.pageSize = 1;
                }
                else
                {
                    this.pageSize = value;
                }
            }
        }

        [Browsable(true), Description("此控件当前页")]
        public int State
        {
            get
            {
                return this.state;
            }
            set
            {
                if (value > 0)
                {
                    this.state = value;
                }
                else
                {
                    this.state = 1;
                }
            }
        }

        [Description("此控件分页控件的URL"), Browsable(true)]
        public string Url
        {
            get
            {
                return this.url;
            }
            set
            {
                this.url = value;
            }
        }
    }
}

