﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.Text.RegularExpressions;
using System.Data.SqlClient;
using TapeManager.csfiles;

namespace TapeManager
{
    public partial class LogClear : System.Web.UI.Page
    {        
        static string[][] datyp={new string[]{"View_Tape_transfer","View_Tape_Oplog","BatchInfo"},new string[]{"Tape_transfer","TapeOplog","BatchInfo"}};

        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["username"] != null)
            {
                string username = Session["username"].ToString();
                string UserRole = Session["qx"].ToString();

                if (CheckUser.CheckUserRole(UserRole, "日志清理"))
                {                    
                    SqlDataReader sqldr1 = CheckUser.GetUserRoleReader(UserRole);
                    string userManageChnName = sqldr1["ManageChnName"].ToString();
                    sqldr1.Close();
                    sqldr1.Dispose();
                    if (!IsPostBack)
                    {//……                        
                        Regex r = new Regex("\\b全部频道\\b");//DateTime.Now.toString("yyyy-MM-dd")
                        if (r.Match(userManageChnName).Success)   //如果是全部频道 采用绑定方式
                        {
                            DropDownList1.DataSource = SqlDataSource1;
                            DropDownList1.DataTextField = "strChnName";
                            DropDownList1.DataValueField = "strChnName";
                            DropDownList1.DataBind();
                        }
                        else //添加可用频道到下拉列表
                        {
                            string[] ChnArray = Regex.Split(userManageChnName, ",", RegexOptions.IgnoreCase);
                            for (int i = 0; i < ChnArray.Length; i++)
                            {
                                DropDownList1.Items.Add(new ListItem(ChnArray[i], ChnArray[i]));
                            }
                        }
                        BtnConfirmIn.Attributes.Add("onclick", "return confirm('您确定要删除当前查询的所有记录吗？');");
                        delcheck.Attributes.Add("onclick", "return confirm('您确定要删除选中记录吗？');");//添加删除确认
                    }
                }
                else
                    Response.Redirect("UserRoleError.htm");
            }
            else
            {//导向登陆界面                
                Response.Redirect("login.aspx?linkname=日志清理");

            }
        }
        
        protected void Btn_Query_Click(object sender, EventArgs e)
        {//点击“查询”按钮
            ViewState["sel"] = DpType.SelectedIndex;
            string chn = DropDownList1.Text.Trim();
            string reserved = txtAirDate.Text.Trim();
            Lbl1.Text = DpType.Text + "列表";
            ViewState["SI"] = null;            
            string sqlstr = "";
            if (chn != "全部频道")
                sqlstr = " where Channel like '%" + chn + "%'";
            if (!string.IsNullOrEmpty(reserved))
            {
                if (string.IsNullOrEmpty(sqlstr))
                    sqlstr = " where OpTime <= '" + reserved + "'";
                else
                    sqlstr += " and OpTime <= '" + reserved + "'";
            };
            ViewState["query"] = datyp[0][DpType.SelectedIndex] + sqlstr; 
            Bind();                     
        }

        private bool Del1(int rown)
        {
            int sel = (int)ViewState["sel"];
            DateTime time = Convert.ToDateTime(GridView1.Rows[rown].Cells[3].Text);
            if (time < DateTime.Now.AddMonths(-1))
            {
                string key = GridView1.Rows[rown].Cells[4].Text.Trim();
                CmdExecute.Execute("delete from " + datyp[1][sel] + " where ID = "+key);
                return true;
            }
            return false;
        }

        protected void DelChecked(object sender, EventArgs e)
        {
            //CollectSelected();
            string alstr;
            if (ViewState["query"] == null)
                alstr = "请先查询记录";
            else
            {
                int count = 0, ncount = 0;
                for (int i = 0; i < GridView1.Rows.Count; i++)
                {
                    //string key = GridView1.Rows[i].Cells[4].Text;
                    CheckBox cb = GridView1.Rows[i].FindControl("CheckBox1") as CheckBox;
                    if (cb.Checked)
                    {
                        if (Del1(i))
                            count++;
                        else
                            ncount++;
                    }
                }
                alstr = "已清除" + count.ToString() + "条记录";
                if (ncount > 0)
                    alstr += "，有" + ncount.ToString() + "条近一月内记录予以保留";
                Bind();
            }
            ScriptManager.RegisterClientScriptBlock(UpdatePanel1, typeof(UpdatePanel), "323", "alert('" + alstr + "');", true);            
            ViewState["SI"] = null;
            Lbl3.Text = alstr;
        }

        protected void On_BtnCI_Click(object sender, EventArgs e)
        {
            int sel = Convert.ToInt32(ViewState["sel"]);
            string alstr = "已清除当前查询的记录，最近一月内的记录予以保留";
            if (ViewState["query"] == null)
                alstr = "请先查询记录";
            else
            {
                CmdExecute.Execute("delete from " + datyp[1][sel] + " where Optime <'" + DateTime.Now.AddMonths(-1) + "' and ID in (select ID from " + ViewState["query"].ToString() + ")");
                Bind();
                ViewState["SI"] = null;
            }
            //CmdExecute.Execute("delete from TapeOpLog where OpTime <"+DateTime.Now.AddYears(-1).ToString()); //删除一年前操作记录            
            ScriptManager.RegisterClientScriptBlock(UpdatePanel1, typeof(UpdatePanel), "223", "alert('"+alstr+"');", true);            
            Lbl3.Text = alstr;
        }

        protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {
            ViewState["SI"] = Check.CollectSelected(this.GridView1.Rows, 4, (ArrayList)ViewState["SI"]);            
            if (!Del1(e.RowIndex))
                ScriptManager.RegisterClientScriptBlock(UpdatePanel1, typeof(UpdatePanel), "123", "alert('删除失败，必须保留近一月的记录');", true);
            Bind();
        }

        protected void DropDownList1_DataBound(object sender, EventArgs e)
        {
            DropDownList1.Items.Insert(0, new ListItem(" 全部频道", "全部频道"));
        }

        private void Bind()
        {
            int sel = Convert.ToInt32(ViewState["sel"]);
            DataSet ds = CmdExecute.ExecuteDataSet("select * from " + ViewState["query"].ToString(), "query");
            DataTable tb = new DataTable();            
            tb.Columns.Add("所属频道", typeof(string));
            tb.Columns.Add("操作时间", typeof(DateTime));
            tb.Columns.Add("ID", typeof(int));
            //DataRow newRow = tb.NewRow();
            switch (sel)
            {
                case 0:                    
                    tb.Columns.Add("磁带条码", typeof(string));
                    tb.Columns.Add("操作者", typeof(string));
                    tb.Columns.Add("节目名称", typeof(string));
                    tb.Columns.Add("源位置", typeof(string));
                    tb.Columns.Add("目标位置", typeof(string));
                    for (int i = 0; i < ds.Tables[0].Rows.Count; i++)
                    {
                        DataRow newRow = tb.NewRow();
                        newRow[0] = ds.Tables[0].Rows[i]["Channel"].ToString();
                        newRow[1] = Convert.ToDateTime(ds.Tables[0].Rows[i]["OpTime"]);
                        newRow[2] = ds.Tables[0].Rows[i]["ID"].ToString();
                        newRow[3] = ds.Tables[0].Rows[i]["strTapeGuid"].ToString();
                        newRow[4] = ds.Tables[0].Rows[i]["Opuser"];
                        newRow[5] = ds.Tables[0].Rows[i]["strClipName"];
                        newRow[6] = ds.Tables[0].Rows[i]["srcLocation"];
                        newRow[7] = ds.Tables[0].Rows[i]["DesLocation"];
                        tb.Rows.Add(newRow.ItemArray);
                    }
                    break;
                case 1:
                    tb.Columns.Add("磁带条码", typeof(string));
                    tb.Columns.Add("节目名称", typeof(string));
                    tb.Columns.Add("操作者", typeof(string));
                    tb.Columns.Add("操作类型", typeof(string));
                    for (int i = 0; i < ds.Tables[0].Rows.Count; i++)
                    {
                        DataRow newRow = tb.NewRow();
                        newRow[0] = ds.Tables[0].Rows[i]["Channel"].ToString();
                        newRow[1] = Convert.ToDateTime(ds.Tables[0].Rows[i]["OpTime"]);
                        newRow[2] = ds.Tables[0].Rows[i]["ID"].ToString();
                        newRow[3] = ds.Tables[0].Rows[i]["TapeGuid"].ToString();
                        newRow[4] = ds.Tables[0].Rows[i]["strClipName"];
                        newRow[5] = ds.Tables[0].Rows[i]["OpUser"];
                        newRow[6] = ds.Tables[0].Rows[i]["OpName"].ToString();
                        tb.Rows.Add(newRow.ItemArray);
                    }
                    break;
                case 2:
                    tb.Columns.Add("入库磁带数量", typeof(int));
                    tb.Columns.Add("送带人", typeof(string));
                    for (int i = 0; i < ds.Tables[0].Rows.Count; i++)
                    {
                        DataRow newRow = tb.NewRow();
                        newRow[0] = ds.Tables[0].Rows[i]["Channel"].ToString();
                        newRow[1] = ds.Tables[0].Rows[i]["OpTime"];//Convert.ToDateTime(ds.Tables[0].Rows[i]["Time"]);
                        newRow[2] = ds.Tables[0].Rows[i]["ID"].ToString();
                        newRow[3] = Convert.ToInt32(ds.Tables[0].Rows[i]["LastIn"])-Convert.ToInt32(ds.Tables[0].Rows[i]["FirstIn"]) + 1;
                        newRow[4] = ds.Tables[0].Rows[i]["Sender"].ToString();
                        tb.Rows.Add(newRow.ItemArray);                        
                    }
                    try
                    {
                        tb.PrimaryKey = new DataColumn[] { tb.Columns["入库批次编号"] };
                    }
                    catch { };
                    break;
            }

            GridView1.DataSource = tb;
            GridView1.DataBind();            
            ds.Dispose();
            Lbl2.Text = "共计：" + tb.Rows.Count.ToString() + "条记录,共：" + GridView1.PageCount.ToString() + "页";
            Lbl3.Text = "";
            /*for (i = tb.Columns.Count; i > 2; i--)
                tb.Columns.RemoveAt(i);
            tb.Columns.RemoveAt(0);
            ViewState["tb"] = tb;*/
            tb.Dispose();
        }        
        
        protected void GridView1_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            GridView1.PageIndex = e.NewPageIndex;
            Bind();
        }
        
        protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
        {
           if (e.Row.RowType == DataControlRowType.DataRow)
            {
                //为GridView数据行添加onmouseover事件JavaScript事件处理脚本
                // 使鼠标悬停时首先使用变量记录当前数据行背景色，再将数据行背景色变为天蓝色
                 //e.Row.Attributes.Add("onmouseover", "oldColor=this.style.backgroundColor;this.style.backgroundColor='skyblue';this.style.cursor='hand'");
               e.Row.Attributes.Add("onmouseover", "this.style.cursor='hand'");
               try
               {//获取当前数据行中第1列的第一个控件 即删除链接    
                   LinkButton btn = e.Row.Cells[0].Controls[0] as LinkButton;
                   btn.Attributes.Add("onclick", "return confirm('您确定要删除该行数据吗？');");//添加弹出询问对话框的JavaScript脚本

               }
               catch { };
             }            
            //e.Row.Attributes.Add("onclick", "javascirpt:__doPostBack('GridView1','Select$" + e.Row.RowIndex + "')");//*/
           
            if (e.Row.Cells.Count > 4)
                     e.Row.Cells[4].Style.Add("display", "none");
            Check.RDB(e.Row, (ArrayList)ViewState["SI"], 2);//Check.RDB(e.Row, (ArrayList)ViewState["SI"],"ID");
        }

        protected void GridView1_SelectedIndexChanged(object sender, EventArgs e)
        {

        }

    }
}
