﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.Text.RegularExpressions;
using System.Data.SqlClient;
using TapeManager.csfiles;

namespace TapeManager
{
    public partial class WebForm3 : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["username"] != null)
            {
                //string username = Session["username"].ToString();
                string UserRole = Session["qx"].ToString();

                if (CheckUser.CheckUserRole(UserRole, "入库批次查询"))
                {
                    SqlDataReader sqldr1 = CheckUser.GetUserRoleReader(UserRole);
                    string userManageChnName = sqldr1["ManageChnName"].ToString();
                    sqldr1.Close();
                    sqldr1.Dispose();
                    if (!IsPostBack)
                    {
                        Regex r = new Regex("\\b全部频道\\b");
                        if (r.Match(userManageChnName).Success)   //如果是全部频道 采用绑定方式
                        {
                            DrpChnName.DataSource = SqlDataSource2;
                            DrpChnName.DataTextField = "strChnName";
                            DrpChnName.DataValueField = "strChnName";
                            DrpChnName.DataBind();
                        }
                        else
                        {
                            string[] ChnArray = Regex.Split(userManageChnName, ",", RegexOptions.IgnoreCase);

                            for (int i = 0; i < ChnArray.Length; i++)
                            {
                                DrpChnName.Items.Add(new ListItem(ChnArray[i], ChnArray[i]));
                            };
                        }
                        Btn_Query.Attributes.Add("OnClick", "checkdate();");
                    }
                }
                else
                {
                    Response.Redirect("UserRoleError.htm");
                }
            }
            else
            {
                //导向登陆界面
                Response.Redirect("login.aspx?linkname=入库批次查询");

            }
        }

        protected void DrpChnName_DataBound(object sender, EventArgs e)
        {
            DrpChnName.Items.Insert(0, new ListItem("全部频道", "全部频道"));
        }

        protected void Btn_Query_Click(object sender, EventArgs e)
        {            
            Bind();
        }

        protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                //为GridView数据行添加onmouseover事件JavaScript事件处理脚本
                // 使鼠标悬停时首先使用变量记录当前数据行背景色，再将数据行背景色变为天蓝色
                //e.Row.Attributes.Add("onmouseover", "oldColor=this.style.backgroundColor;this.style.backgroundColor='skyblue';this.style.cursor='hand'");
                e.Row.Attributes.Add("onmouseover", "this.style.cursor='hand'");
                e.Row.Attributes.Add("onclick", "selectx(this);");//e.Row.ClientID.ToString() + ".checked=true;
            }
            
            if (e.Row.Cells.Count > 1) //GridView1.Columns[1].Visible = false;                
            {
                e.Row.Cells[0].Style.Add("display", "none");
                e.Row.Cells[1].Style.Add("display", "none");
            }
        }

        protected void GridView1_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            GridView1.PageIndex = e.NewPageIndex;
            Bind();
        }

        private void Bind()
        {
            string sqlstr = "";
            DataTable tb = new DataTable();
            if (DrpChnName.Text.ToString() != "全部频道")
                sqlstr = " Channel like '%" + DrpChnName.Text.ToString() + "%'";
            if (!string.IsNullOrEmpty(BDate.Text.Trim()))
            {
                if (string.IsNullOrEmpty(sqlstr))
                    sqlstr = " OpTime >='" + BDate.Text.ToString() + "'";
                else
                    sqlstr = sqlstr + " and OpTime >='" + BDate.Text.ToString() + "'";
            };
            if (!string.IsNullOrEmpty(txtAirDate.Text.Trim()))
            {
                DateTime rd = DateTime.Now;
                try
                {
                    rd = (Convert.ToDateTime(txtAirDate.Text)).AddDays(1);
                }
                catch { };
                if (string.IsNullOrEmpty(sqlstr))
                    sqlstr = " OpTime <='" + rd + "'";
                else
                    sqlstr = sqlstr + " and OpTime <= '" + rd + "'";
            }                     
            if (!string.IsNullOrEmpty(sqlstr)) 
                sqlstr = "where" + sqlstr;
            sqlstr = "select * from Batchinfo " + sqlstr + " order by OpTime Desc";
            DataSet ds = CmdExecute.ExecuteDataSet(sqlstr, "batch");
            tb.Columns.Add("First", typeof(int));
            tb.Columns.Add("Last", typeof(int));
            tb.Columns.Add("入库磁带数量", typeof(int));
            tb.Columns.Add("所属频道", typeof(string));
            tb.Columns.Add("入库时间", typeof(DateTime));
            tb.Columns.Add("送带人", typeof(string));
            for (int i = 0; i < ds.Tables[0].Rows.Count; i++)
            {
                DataRow newRow = tb.NewRow();
                newRow[0] = Convert.ToInt32(ds.Tables[0].Rows[i]["FirstIn"]);
                newRow[1] = Convert.ToInt32(ds.Tables[0].Rows[i]["LastIn"]);
                newRow[2] = Convert.ToInt32(newRow[1]) - Convert.ToInt32(newRow[0]) + 1;
                newRow[3] = ds.Tables[0].Rows[i]["Channel"].ToString();
                newRow[4] = Convert.ToDateTime(ds.Tables[0].Rows[i]["OpTime"]);
                newRow[5] = ds.Tables[0].Rows[i]["Sender"].ToString();
                tb.Rows.Add(newRow.ItemArray);
            }        
            ViewState["tb"] = tb;
            GridView1.DataSource = tb;
            GridView1.DataBind();
            ds.Dispose();
        }
        

        protected void On_BC(object sender, EventArgs e)
        {
            string sqlstr = "select * from Tape where ID between " + hf1.Value.ToString() + " and " + hf2.Value.ToString();
            DataSet ds = CmdExecute.ExecuteDataSet(sqlstr, "tape");
            GridView2.DataSource = ds;
            GridView2.DataBind();
            DataTable tb = (DataTable)ViewState["tb"];
            GridView1.DataSource = tb;
            GridView1.DataBind();
            ds.Dispose();
        }
    }
}
