﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.Text.RegularExpressions;
using System.Data.SqlClient;
using TapeManager.csfiles;

namespace TapeManager
{
    public partial class WebForm1 : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["username"] != null)
            {

                string username = Session["username"].ToString();
                string UserRole=Session["qx"].ToString();

                tbTape.Style.Add("display", "none");  
                if (CheckUser.CheckUserRole(UserRole, "日志查询"))
                {
                    SqlDataReader sqldr1 = CheckUser.GetUserRoleReader(UserRole);
                    string userManageChnName = sqldr1["ManageChnName"].ToString();
                    sqldr1.Close();
                    sqldr1.Dispose();
                    if (!IsPostBack)
                    {
                        Regex r = new Regex("\\b全部频道\\b");
                        if (r.Match(userManageChnName).Success)   //如果是全部频道 采用绑定方式
                        {
                            DrpChnName.DataSource = SqlDataSource2;
                            DrpChnName.DataTextField = "strChnName";
                            DrpChnName.DataValueField = "strChnName";
                            DrpChnName.DataBind();
                        }
                        else
                        {
                            string[] ChnArray = Regex.Split(userManageChnName, ",", RegexOptions.IgnoreCase);

                            for (int i = 0; i < ChnArray.Length; i++)
                            {
                                DrpChnName.Items.Add(new ListItem(ChnArray[i], ChnArray[i]));
                            };
                        }
                        Btn_Query.Attributes.Add("OnClick", "checkdate();");
                        //rb1.Attributes.Add("OnCheckedChanged", "rb1_changed();");
                    }
                }
                else
                {
                    Response.Redirect("UserRoleError.htm");
                }
            }
            else
            {

                //导向登陆界面
                Response.Redirect("login.aspx?linkname=日志查询");

            }
        }

        protected void DrpChnName_DataBound(object sender, EventArgs e)
        {
            DrpChnName.Items.Insert(0, new ListItem("全部频道", "全部频道"));
        }

        protected void Btn_Query_Click(object sender, EventArgs e)
        {
            tbTape.Style.Add("display", "none");
            Bind();
        }

        protected void Rb_Changed(object sender, EventArgs e)
        {
            if (rb1.Checked)
            {
                header.Text = "磁带入库批次记录";
                sp1.Visible = false;
                //sp1.Style.Add("display", "none");
            }
            else
            {
                header.Text = "磁带操作记录（不含调拨）";
                sp1.Visible = true;
                //sp1.Style.Remove("display");
            }        
        }

        protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                //为GridView数据行添加onmouseover事件JavaScript事件处理脚本
                // 使鼠标悬停时首先使用变量记录当前数据行背景色，再将数据行背景色变为天蓝色
                //e.Row.Attributes.Add("onmouseover", "oldColor=this.style.backgroundColor;this.style.backgroundColor='skyblue';this.style.cursor='hand'");
                e.Row.Attributes.Add("onmouseover", "this.style.cursor='hand'");
                e.Row.Attributes.Add("onclick", "selectx(this);");
            }
            
            if (rb1.Checked && e.Row.Cells.Count>1) //GridView1.Columns[1].Visible = false;                
            {
                e.Row.Cells[0].Style.Add("display", "none");
                e.Row.Cells[1].Style.Add("display", "none");
            }
        }

        protected void GridView1_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            GridView1.PageIndex = e.NewPageIndex;
            Bind();
        }

        private void Bind()
        {
            string sqlstr= "";            
            DataSet ds;
            DataTable tb = new DataTable();
            if (DrpChnName.Text.ToString() != "全部频道")
                sqlstr = " Channel like '%" + DrpChnName.Text.ToString() + "%'";
            if (!string.IsNullOrEmpty(BDate.Text.Trim()))
            {
                if (string.IsNullOrEmpty(sqlstr))
                    sqlstr = " OpTime >='" + BDate.Text.ToString() + "'"; 
                else
                    sqlstr = sqlstr + " and OpTime >='" + BDate.Text.ToString() + "'";
            };
            if (!string.IsNullOrEmpty(txtAirDate.Text.Trim()))
            {
                DateTime rd=DateTime.Now;
                try
                {
                    rd = (Convert.ToDateTime(txtAirDate.Text)).AddDays(1);
                }
                catch { };
                if (string.IsNullOrEmpty(sqlstr))
                    sqlstr = " OpTime <='" + rd + "'";
                else
                    sqlstr = sqlstr + " and OpTime <= '" + rd + "'";
            };
            if (rb1.Checked)
            {
                if (!string.IsNullOrEmpty(sqlstr)) sqlstr = "where" + sqlstr;
                sqlstr = "select * from Batchinfo " + sqlstr + " order by OpTime Desc";
                ds = CmdExecute.ExecuteDataSet(sqlstr, "batch");
                //ViewState["ID"] = ds.Tables[0].Rows[0]["ID"].ToString();
                tb.Columns.Add("First", typeof(int));
                tb.Columns.Add("Last", typeof(int));
                tb.Columns.Add("入库磁带数量", typeof(int));
                tb.Columns.Add("所属频道", typeof(string));
                tb.Columns.Add("入库时间", typeof(DateTime));
                for (int i = 0; i < ds.Tables[0].Rows.Count; i++)
                {
                    DataRow newRow = tb.NewRow();
                    newRow[0] = Convert.ToInt32(ds.Tables[0].Rows[i]["FirstIn"]);
                    newRow[1] = Convert.ToInt32(ds.Tables[0].Rows[i]["LastIn"]);
                    newRow[2] = Convert.ToInt32(newRow[1]) - Convert.ToInt32(newRow[0]) + 1;
                    newRow[3] = ds.Tables[0].Rows[i]["Channel"].ToString();
                    newRow[4] = Convert.ToDateTime(ds.Tables[0].Rows[i]["OpTime"]);
                    tb.Rows.Add(newRow.ItemArray);
                }
            }
            else
            {
                if (string.IsNullOrEmpty(txtstrTapeGuid.Text.Trim()))
                {//如果磁带条码为空，那么按照查询条件查询                
                    if (!string.IsNullOrEmpty(Txtkeyword.Text.Trim()))
                    {
                        if (string.IsNullOrEmpty(sqlstr))
                            sqlstr = " OpUser like '%" + Txtkeyword.Text.ToString().Trim() + "%'";
                        else
                            sqlstr = sqlstr + " and OpUser like '%" + Txtkeyword.Text.ToString().Trim() + "%'";
                    }
                    if (DrpOpcls.Text.ToString().Trim() != "所有")
                    {
                        if (string.IsNullOrEmpty(sqlstr))
                            sqlstr = " OpName = '" + DrpOpcls.Text.ToString().Trim() + "'";
                        else
                            sqlstr = sqlstr + " and OpName = '" + DrpOpcls.Text.ToString().Trim() + "'";
                    }
                    if (!string.IsNullOrEmpty(sqlstr)) sqlstr = "where" + sqlstr;
                }
                else//以磁带条码进行查询
                    sqlstr = "where TapeGuid ='" + txtstrTapeGuid.Text + "'";
                sqlstr = "select * from View_Tape_OpLog " + sqlstr + " order by OpTime Desc";
                ds = CmdExecute.ExecuteDataSet(sqlstr, "batch");
                tb.Columns.Add("磁带条码", typeof(string));
                tb.Columns.Add("操作者", typeof(string));
                tb.Columns.Add("操作时间", typeof(DateTime));
                tb.Columns.Add("操作类型", typeof(string));
                tb.Columns.Add("所属频道", typeof(string));
                for (int i = 0; i < ds.Tables[0].Rows.Count; i++)
                {
                    DataRow newRow = tb.NewRow();
                    newRow[0] = ds.Tables[0].Rows[i]["TapeGuid"].ToString();
                    newRow[1] = ds.Tables[0].Rows[i]["OpUser"];                    
                    newRow[2] = Convert.ToDateTime(ds.Tables[0].Rows[i]["OpTime"]);
                    newRow[3] = ds.Tables[0].Rows[i]["OpName"].ToString();
                    newRow[4] = ds.Tables[0].Rows[i]["Channel"].ToString();
                    tb.Rows.Add(newRow.ItemArray);
                }    
            }
            ViewState["tb"]= tb;
            GridView1.DataSource = tb;
            GridView1.DataBind();
            ds.Dispose();
        }

        protected void On_BC(object sender, EventArgs e)
        {            
            string sqlstr = "";
            if (rb1.Checked)
            {
                sqlstr = "select * from Tape where ID between " + hf1.Value.ToString() + " and " + hf2.Value.ToString();
            }
            else sqlstr = "select * from Tape where strTapeGuid ='" + hf1.Value + "'";
            //string t = bc1.Text;
            DataSet ds = CmdExecute.ExecuteDataSet(sqlstr, "tape");
            tbTape.Style.Remove("display");
            GridView2.DataSource = ds;
            GridView2.DataBind();
            DataTable tb = (DataTable)ViewState["tb"];
            GridView1.DataSource = tb;
            GridView1.DataBind();
            ds.Dispose();
        }

        protected void DrpOpcls_SelectedIndexChanged(object sender, EventArgs e)
        {

        }

        /*
        protected void OnNextClick(object sender, EventArgs e)
        {
        }

        protected void OnPrevClick(object sender, EventArgs e)
        {
        }
         
         <tr><td>

  </td></tr>*/
    }
}

