﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.Data.SqlClient;
using System.Text.RegularExpressions;
using TapeManager.csfiles;

namespace TapeManager
{
    public partial class QueryTapeInfo : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["username"] != null)
            {
                string username = Session["username"].ToString();
                string UserRole = Session["qx"].ToString();

                if (CheckUser.CheckUserRole(UserRole, "磁带状态查询"))
                {
                    SqlDataReader sqldr1 = CheckUser.GetUserRoleReader(UserRole);
                    string userManageChnName = sqldr1["ManageChnName"].ToString();
                    sqldr1.Close();
                    sqldr1.Dispose();
                    if (!IsPostBack)
                    {
                        Regex r = new Regex("\\b全部频道\\b");
                        if (r.Match(userManageChnName).Success)   //如果是全部频道 采用绑定方式
                        {
                            DropDownList1.DataSource = SqlDataSource1;
                            DropDownList1.DataTextField = "strChnName";
                            DropDownList1.DataValueField = "strChnName";
                            DropDownList1.DataBind();
                        }
                        else
                        {
                            string[] ChnArray = Regex.Split(userManageChnName, ",", RegexOptions.IgnoreCase);


                            for (int i = 0; i < ChnArray.Length; i++)
                            {

                                DropDownList1.Items.Add(new ListItem(ChnArray[i], ChnArray[i]));
                            }
                        }
                    }

                    LblTile.Text = "您好：【 " + username + "】   欢迎使用磁带管理系统";
                }
                else
                {
                    Response.Redirect("UserRoleError.htm");

                }

            }
            else
            {

                //导向登陆界面

                Response.Redirect("login.aspx?linkname=磁带状态查询");

            }
        }
        protected void Btn_Query_Click(object sender, EventArgs e)
        {

            Bind();
        }

        private void Bind()
        {

            string sqlstr;
            sqlstr = "select * from Tape";
            //  Label1.Text = DropDownList1.Items[0].ToString();
            if (!string.IsNullOrEmpty(txtstrTapeGuid.Text.Trim()))
                sqlstr += " where strTapeGuid ='" + txtstrTapeGuid.Text.Trim() + "'";
            else if ((DropDownList1.Text != "全部频道") || (string.IsNullOrEmpty(txtAirDate.Text)) || (string.IsNullOrEmpty(Txtkeyword.Text)))
            {
                int i = 0;
                sqlstr += " where";
                if (DropDownList1.Text != "全部频道")
                {
                    sqlstr = sqlstr + " strChnName='" + DropDownList1.Text.ToString() + "'";
                    i++;
                };
                if (!string.IsNullOrEmpty(txtAirDate.Text.Trim()))
                {
                    if (i == 0)
                    { sqlstr = sqlstr + " tPlayDate='" + txtAirDate.Text.ToString() + "'"; }
                    else
                    {
                        sqlstr = sqlstr + " and tPlayDate='" + txtAirDate.Text.ToString() + "'";
                    }
                    i++;
                };
                if (!string.IsNullOrEmpty(Txtkeyword.Text.Trim()))
                {
                    if (i == 0)
                    { sqlstr = sqlstr + " strClipName like '%" + Txtkeyword.Text.ToString() + "%'"; }
                    else
                    {
                        sqlstr = sqlstr + " and strClipName like '%" + Txtkeyword.Text.ToString() + "%'";
                    }
                    i++;
                };
            };
            SqlConnection sqlcon = new SqlConnection(System.Configuration.ConfigurationManager.ConnectionStrings["TapeManageConnectionString"].ToString());
            sqlcon.Open();
            SqlDataAdapter adp = new SqlDataAdapter(sqlstr, sqlcon);
            //  adp.SelectCommand=sqlstr;
            DataSet ds = new DataSet();
            adp.Fill(ds, "Tape");
            System.Threading.Thread.Sleep(1000);
            GridView1.DataSource = ds;
            GridView1.DataBind();
            ds.Dispose();
            adp.Dispose();
            sqlcon.Close();
            sqlcon.Dispose();
            Label1.Text = "共计：" + ds.Tables[0].Rows.Count.ToString() + "条记录,共：" + GridView1.PageCount.ToString() + "页";
        }

        protected void GridView1_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            GridView1.PageIndex = e.NewPageIndex;
            Bind();
        }

        protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                //为GridView数据行添加onmouseover事件JavaScript事件处理脚本
                // 使鼠标悬停时首先使用变量记录当前数据行背景色，再将数据行背景色变为天蓝色
                e.Row.Attributes.Add("onmouseover", "oldColor=this.style.backgroundColor;this.style.backgroundColor='skyblue';this.style.cursor='hand'");
               //当鼠标移出当前数据行时  使数据行背景色恢复为原来的颜色
                e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=oldColor;");
            }         
        }

    }

}
