﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.Text.RegularExpressions;
using System.Data.SqlClient;
using TapeManager.csfiles;

namespace TapeManager
{
    public partial class TapeClear : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["username"] != null)
            {
                string username = Session["username"].ToString();
                string UserRole = Session["qx"].ToString();
                if (CheckUser.CheckUserRole(UserRole, "过期节目清理"))
                {
                    SqlDataReader sqldr1 = CheckUser.GetUserRoleReader(UserRole);
                    string userManageChnName = sqldr1["ManageChnName"].ToString();
                    sqldr1.Close();
                    sqldr1.Dispose();
                    if (!IsPostBack)
                    {
                        Regex r = new Regex("\\b全部频道\\b");
                        if (r.Match(userManageChnName).Success)   //如果是全部频道 采用绑定方式
                        {
                            DropDownList1.DataSource = SqlDataSource1;
                            DropDownList1.DataTextField = "strChnName";
                            DropDownList1.DataValueField = "strChnName";
                            DropDownList1.DataBind();
                        }
                        else //添加可用频道到下拉列表
                        {
                            string[] ChnArray = Regex.Split(userManageChnName, ",", RegexOptions.IgnoreCase);
                            for (int i = 0; i < ChnArray.Length; i++)
                                DropDownList1.Items.Add(new ListItem(ChnArray[i], ChnArray[i]));
                        }
                        DropDownList1.Items.Insert(0, new ListItem(" 全部频道", "全部频道"));//DropDownList1_DataBound()
                        ClearCheck.Attributes.Add("onclick", "return confirm('您确定要完全删除选中记录吗？');");
                        LblTile.Text = "您好：【 " + username + "】   欢迎使用磁带管理系统";
                    }                    
                    BtnConfirmIn.Attributes.Add("onclick", "return confirm('您确定要完全删除当前查询的所有记录吗？');");                    
                }
                else
                    Response.Redirect("UserRoleError.htm");
            }
            else//导向登陆界面
                Response.Redirect("login.aspx?linkname=过期节目清理 ");
        }

        private void Bind()
        {
            DataSet ds = CmdExecute.ExecuteDataSet("select * from Tape" + ViewState["sqlquerysta"].ToString(), "query");            
            GridView1.DataSource = ds;
            GridView1.DataBind();
            Lbl2.Text = "共计：" + ds.Tables[0].Rows.Count.ToString() + "条记录,共：" + GridView1.PageCount.ToString() + "页";
            ds.Dispose();            
        }

        protected void Btn_Query_Click(object sender, EventArgs e)
        {//点击“查询”按钮            
            ViewState["SI"] = null;
            string sel,sqlstr = "";
            string chn = DropDownList1.Text.Trim();
            string reserved = txtAirDate.Text.Trim();
            string keyword = Txtkeyword.Text.Trim();

            if (rb1.Checked)
            {//处理正常素材
                delcheck.Text = "删除选中至回收站";
                ButtonCl.Text = "删除至回收站";
                sel = "<>";
            }
            else
            {//处理回收站素材
                delcheck.Text = "恢复选中";
                ButtonCl.Text = "从回收站恢复";
                sel = "=";
            }
            ViewState["sel"] = sel;
            if (chn != "全部频道")
                sqlstr = " where strChnName like '%" + chn + "%'";
            if (!string.IsNullOrEmpty(reserved))
            {
                if (string.IsNullOrEmpty(sqlstr))
                    sqlstr = " where tPlayDate <= '" + reserved + "'";
                else
                    sqlstr += " and tPlayDate <= '" + reserved + "'";
            };
            if (!string.IsNullOrEmpty(keyword))
            {
                if (string.IsNullOrEmpty(sqlstr))
                    sqlstr = " where strClipName like '%" + keyword + "%'";//
                else
                    sqlstr += " and strClipName like '%" + keyword + "%'";
            }
            if (string.IsNullOrEmpty(sqlstr))
                sqlstr = " where strTapeState " + sel+" '已删除'";//"";
            else
                sqlstr += " and strTapeState " + sel + " '已删除'";
            ViewState["sqlquerysta"] = sqlstr;
            Bind();
        }

        protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                e.Row.Attributes.Add("onmouseover", "this.style.cursor='hand'");               
                try
                {
                    LinkButton btn = e.Row.Cells[12].Controls[0] as LinkButton;
                    string alstr = (e.Row.Cells[2].FindControl("LblClipName") as Label).Text;
                    //添加弹出询问对话框的JavaScript脚本
                    if (ViewState["sel"].ToString() == "<>")
                        alstr = "要删除【" + alstr + "】至回收站吗？');";
                    else
                        alstr = "要完全删除【" + alstr + "】吗？');";
                    btn.Attributes.Add("onclick", "return confirm('您确定"+alstr);
                }
                catch { };               
                //e.Row.Attributes.Add("onclick", e.Row.ClientID.ToString() + ".checked=true;");
            }
            Check.RDB(e.Row, (ArrayList)ViewState["SI"], "ID");
        }


        protected void GridView1_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            GridView1.PageIndex = e.NewPageIndex;
            Bind();
        }

        protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {
            ViewState["SI"] = Check.CollectSelected(this.GridView1.Rows, 10, (ArrayList)ViewState["SI"]);
            string alstr="";
            if (ViewState["sel"].ToString() == "=")//回收站内记录，彻底清除
            {
                if (checkin(true))
                {
                    int result = Clear1(e.RowIndex);                    
                    switch (result)
                    {
                        case 1:
                            alstr = "数据格式错误，";
                            break;
                        case 2:
                            alstr = "未到保留时间,";
                            break;
                        case 3:
                            alstr = "必须保留播出时间三个月内的记录，";
                            break;
                        case 4:
                            alstr = "数据库操作错误,";
                            break;
                    }                    
                }
            }
            else
            {
                if (!Del1(e.RowIndex))
                    alstr = "网页数据错误，";
            }
            if (string.IsNullOrEmpty(alstr))
                Bind();
            else
                ScriptManager.RegisterClientScriptBlock(UpdatePanel1, typeof(UpdatePanel), "123", "alert('" + alstr + "删除失败');", true);
        }

        protected void On_BtnCI_Click(object sender, EventArgs e)
        {            
            if (checkin(false))
            {
                string alstr;
                ViewState["SI"] = null;
                int count = 0, ncount = 0;
                DataSet ds = CmdExecute.ExecuteDataSet("select * from Tape" + ViewState["sqlquerysta"].ToString(), "query");
                DataTable tb = ds.Tables[0];
                if (ViewState["sel"].ToString() == "=")//处理回收站记录
                {
                    for (int i = tb.Rows.Count - 1; i >= 0; i--)
                    {
                        string id = tb.Rows[i]["ID"].ToString();
                        string lid = tb.Rows[i]["strLogicID"].ToString();
                        if (Recycle1(id, lid))
                        {
                            count++;
                            tb.Rows.RemoveAt(i);
                        }
                        else
                            ncount++;
                    }
                    alstr = "已回收" + count + "条记录" + (ncount > 0 ? ",有" + ncount + "条记录操作失败，未能回收" : "");
                    GridView1.DataSource = tb;
                    GridView1.DataBind();
                }
                else
                {//删除全部至回收站
                    for (int i = 0; i < tb.Rows.Count; i++)
                    {
                        try
                        {
                            string key = tb.Rows[i]["ID"].ToString();//["ID"];            
                            string strLID = tb.Rows[i]["strLogicID"].ToString().Trim();//原节目ID
                            string orist = tb.Rows[i]["strTapeState"].ToString().Trim();//原状态                
                            CmdExecute.Execute("update Tape set strTapeState='已删除',strLogicID='" + Check.newid(key, strLID, orist) + "' where ID=" + key);
                            count++;
                        }
                        catch
                        {
                            ncount++;
                        }
                    }
                    alstr = "已删除" + count + "条记录" + (ncount > 0 ? ",有" + ncount + "条记录操作失败，未能删除" : "");
                    Bind();
                }
                ds.Dispose();
                ScriptManager.RegisterClientScriptBlock(UpdatePanel1, typeof(UpdatePanel), "423", "alert('" + alstr + "');", true);
                Lbl1.Text = alstr;  
            }                      
        }

        protected void DelChecked(object sender, EventArgs e)
        {
            
            if (checkin(false))
            {
                int count = 0, ncount = 0;
                string alstr;
                ViewState["SI"] = null;

                if (ViewState["sel"].ToString() == "=")//回收
                {
                    for (int i = 0; i < GridView1.Rows.Count; i++)
                    {
                        CheckBox cb = GridView1.Rows[i].FindControl("CheckBox1") as CheckBox;
                        if (cb.Checked)
                        {
                            string id, lid;
                            try
                            {
                                id = ((DataBoundLiteralControl)GridView1.Rows[i].Cells[10].Controls[0]).Text.Trim();
                                lid = (GridView1.Rows[i].Cells[9].Controls[0] as DataBoundLiteralControl).Text.Trim();
                            }
                            catch
                            {
                                ncount++;
                                continue;
                            }
                            if (Recycle1(id, lid))
                                count++;
                            else
                                ncount++;
                        }
                    }
                    alstr = "已回收" + count + "条记录" + (ncount > 0 ? ",有" + ncount + "条记录因操作失败未能回收" : "");
                }
                else
                {//删除选中至回收站
                    for (int i = 0; i < GridView1.Rows.Count; i++)
                    {
                        CheckBox cb = GridView1.Rows[i].FindControl("CheckBox1") as CheckBox;
                        if (cb.Checked)
                        {
                            if (Del1(i))
                                count++;
                            else
                                ncount++;
                        }
                    }
                    alstr = "已删除" + count + "条记录" + (ncount > 0 ? ",有" + ncount + "条记录因操作失败未能删除" : "");
                }
                Bind();
                ScriptManager.RegisterClientScriptBlock(UpdatePanel1, typeof(UpdatePanel), "423", "alert('" + alstr + "');", true);
                Lbl1.Text = alstr;  
            }                                  
        }

        protected void ClearAll(object sender, EventArgs e)
        {
            ViewState["SI"] = null;
            if (checkin(true))
            {
                string sqlstr="from Tape" + ViewState["sqlquerysta"].ToString() + " and tPlayDate < '"
                     + (DateTime.Now.AddMonths(-3)).ToString() + "' and tReserveDate < '" + DateTime.Now.ToString() + "'";
                CmdExecute.Execute("delete from Tape_transfer where strTapeGuid in (select strTapeGuid " + sqlstr + ")");
                CmdExecute.Execute("delete from TapeOpLog where TapeGuid in (select strTapeGuid " + sqlstr + ")");
                CmdExecute.Execute("delete " + sqlstr);            
                ScriptManager.RegisterClientScriptBlock(UpdatePanel1, typeof(UpdatePanel), "623", "alert('已完全删除当前查询的所有记录, 近三个月内播出及未到保留时间的记录予以保留');", true);//*/
                Bind();
                Lbl1.Text = "完全删除完成";
            }
        }

        protected void ClearChecked(object sender, EventArgs e)
        {
            ViewState["SI"] = null;            
            int[] count = new int[] { 0, 0, 0, 0, 0 };
            if (checkin(true))
            {                
                for (int i = 0; i < GridView1.Rows.Count; i++)
                {
                    CheckBox cb = GridView1.Rows[i].FindControl("CheckBox1") as CheckBox;
                    if (cb.Checked)
                        count[Clear1(i)]++;
                }
                string alstr = "";
                if (count[1]>0)
                    alstr += ",有" + count[1] + "条记录因数据格式错误";
                if (count[2]>0)
                    alstr += ",有" + count[2] + "条记录因未到保留时间";
                if (count[3]>0)
                    alstr += ",有" + count[3] + "条记录因距播出时间不足三个月";
                if (count[4]>0)
                    alstr += ",有" + count[4] + "条记录因数据库操作错误";
                if (!string.IsNullOrEmpty(alstr))
                    alstr += ",未能删除";
                alstr = "已成功删除" + count[0] + "条记录" + alstr;
                ScriptManager.RegisterClientScriptBlock(UpdatePanel1, typeof(UpdatePanel), "523", "alert('" + alstr + "');", true);
                Bind();
                Lbl1.Text = alstr;
            }            
        }

        protected bool checkin(bool arg1)
        {
            string alstr = "无当前记录，请先查询";
            if (ViewState["sqlquerysta"] != null)
                return true;
            if (arg1)
            {
                if ((string.IsNullOrEmpty(txtRecvGuid.Text.Trim())) && (string.IsNullOrEmpty(Username2.Text.Trim())))
                    alstr = "完全删除磁带信息必须认证确认人员！";
                else
                {
                    SqlDataReader sqldr = CheckUser.CheckUserLogin(txtRecvGuid.Text, Username2.Text, Password2.Text);
                    if (sqldr == null)
                        alstr = "确认人员认证失败，请确认用户条码或者用户名密码正确！";
                    else
                        return true;
                }
            }
            ScriptManager.RegisterClientScriptBlock(UpdatePanel1, typeof(UpdatePanel), "323", "alert('" + alstr + "');", true);
            return false;
        }

        private bool Del1(int rown)
        {
            try
            {
                string key = ((DataBoundLiteralControl)GridView1.Rows[rown].Cells[10].Controls[0]).Text.Trim();//= GridView1.DataKeys[rown]["ID"].ToString();            
                string strLID = (GridView1.Rows[rown].Cells[9].Controls[0] as DataBoundLiteralControl).Text.Trim();//原节目ID
                string orist = (GridView1.Rows[rown].Cells[8].Controls[0] as DataBoundLiteralControl).Text.Trim();//原状态                
                CmdExecute.Execute("update Tape set strTapeState='已删除',strLogicID='" + Check.newid(key, strLID, orist) + "' where ID=" + key);
            }
            catch
            {
                return false;
            }
            return true;
        }

        private int Clear1(int rown)
        {//清除一条
            DateTime PlayDate,ReseDate;
            string id,strGuid;
            try
            {
                id = ((DataBoundLiteralControl)GridView1.Rows[rown].Cells[10].Controls[0]).Text.Trim();
                string dat = (GridView1.Rows[rown].Cells[1].Controls[0] as DataBoundLiteralControl).Text;
                PlayDate = Convert.ToDateTime(dat.Remove(dat.LastIndexOf('&')).Trim());
                ReseDate = Convert.ToDateTime((GridView1.Rows[rown].Cells[11].Controls[0] as DataBoundLiteralControl).Text.Trim());
                strGuid = (GridView1.Rows[rown].Cells[3].Controls[0] as DataBoundLiteralControl).Text.Trim();
            }
            catch
            {
                return 4;
            }
            if (PlayDate > DateTime.Now.AddMonths(-3))
                return 3;
            if (ReseDate > DateTime.Now)
                return 2;
            try
            {
                CmdExecute.Execute("delete from Tape where ID = " + id);
                CmdExecute.Execute("delete from Tape_transfer where strTapeGuid = '" + strGuid + "'");
                CmdExecute.Execute("delete from TapeOpLog where TapeGuid = '" + strGuid + "'");
            }
            catch { return 1; }
            return 0;                
        }

        private static bool Recycle1(string id,string strLID)
        {//回收一条
            try
            {                
                int loca = strLID.Length - 3;
                string nstate, sign="";
                if (loca >= 0)
                {
                    sign = strLID.Substring(loca + 1);
                    if (strLID.LastIndexOf('@') == loca)
                        strLID = strLID.Remove(loca);
                }
                switch (sign)
                {
                    case "tp":
                        nstate = "待处理"; break;
                    case "aa":
                        nstate = "可调拨"; break;
                    case "pt":
                        nstate = "问题带"; break;
                    case "et":
                        nstate = "已退带"; break;
                    default:
                        nstate = "已退带"; break;
                }
                CmdExecute.Execute("update Tape set strTapeState='" + nstate + "',strLogicID='" + strLID + "' where ID = " + id);
            }
            catch { return false; }
            return true;
        }
    }
}
