﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.Data.SqlClient;
using System.Text.RegularExpressions;
using TapeManager.csfiles;

namespace TapeManager.admin
{
    public partial class TapeInput : System.Web.UI.Page
    {
        protected ArrayList SelectedItems
        {
            get
            {
                return (ViewState["mySelectedItems"] != null) ? (ArrayList)ViewState["mySelectedItems"] : null;
            }
            set
            {
                ViewState["mySelectedItems"] = value;
            }
        }

        protected void Page_Load(object sender, EventArgs e)
        {

            if (Session["username"] != null)
            {             
                string username = Session["username"].ToString();
                string UserRole = Session["qx"].ToString();
                if (CheckUser.CheckUserRole(UserRole, "磁带入库"))
                {
                    SqlDataReader sqldr1 = CheckUser.GetUserRoleReader(UserRole);
                    string userManageChnName = sqldr1["ManageChnName"].ToString();
                    sqldr1.Close();
                    sqldr1.Dispose();
                    if (!IsPostBack)
                    {
                        Regex r = new Regex("\\b全部频道\\b");
                        if (r.Match(userManageChnName).Success)   //如果是全部频道 采用绑定方式
                        {
                            DropDownList1.DataSource = SqlDataSource1;
                            DropDownList1.DataTextField = "strChnName";
                            DropDownList1.DataValueField = "strChnName";
                            DropDownList1.DataBind();
                        }
                        else //添加可用频道到下拉列表
                        {
                            string[] ChnArray = Regex.Split(userManageChnName, ",", RegexOptions.IgnoreCase);

                            for (int i = 0; i < ChnArray.Length; i++)
                            {

                                DropDownList1.Items.Add(new ListItem(ChnArray[i], ChnArray[i]));
                            }
                        }
                    }
                    delcheck.Attributes.Add("onclick", "return confirm('您确定要删除选中记录吗？');");
                    Button1.Attributes.Add("onclick", "return checkform()");
                    Button2.Attributes.Add("onclick", "return checkform()");
                    LblTile.Text = "您好：【 " + username + "】   欢迎使用磁带管理系统";
                }
                else
                {
                    Response.Redirect("UserRoleError.htm");
                
                }

            }
            else
            {//导向登陆界面

                Response.Redirect("login.aspx?linkname=磁带入库");            
            }

        }

        protected void Btn_Query_Click(object sender, EventArgs e)
        {//点击“查询”按钮
            Bind();
        }

        /*protected void OnPDChanged(object sender, EventArgs e)
        {
            try
            {
                string pd = txttPlayDate.Text;
                if ((txtstrClipName.Text.Trim() == "") && (pd.Length == 10))
                {
                    txtstrClipName.Text = pd.Substring(2, 2) + pd.Substring(5, 2) + pd.Substring(8, 2) + " ";
                    txtstrClipName.Focus();
                }
            }
            catch { }                     
            Bind2();
        }*/

        private void Bind2()
        {
            DataTable tb = (DataTable)ViewState["tb"];
            CollectSelected();
            if (GridView1.Rows.Count != 0) Bind();
            if (tb != null)
            {                
                GridView2.DataSource = tb;
                GridView2.DataBind();
                Label2.Text = "已有" + tb.Rows.Count.ToString() + "条磁带记录待确认，" + GridView2.PageCount.ToString() + "页";
                tb.Dispose();
            }
            else
                GridView2.DataBind();
        }

        private void Bind()
        {
            string sqlstr;
            sqlstr = "select * from Tape";
            //  Label1.Text = DropDownList1.Items[0].ToString();
            if ((DropDownList1.Text != "全部频道") || (!string.IsNullOrEmpty(txtAirDate.Text.Trim())) || (!string.IsNullOrEmpty(Txtkeyword.Text.Trim())))
            {
                int i = 0;
                sqlstr += " where";
                if (DropDownList1.Text != "全部频道")
                {
                    sqlstr = sqlstr + " strChnName='" + DropDownList1.Text.ToString() + "'";
                    i++;
                };
                if (!string.IsNullOrEmpty(txtAirDate.Text.Trim()))
                {
                    if (i == 0)
                    { sqlstr = sqlstr + " tPlayDate='" + txtAirDate.Text.ToString() + "'"; }
                    else
                    {
                        sqlstr = sqlstr + " and tPlayDate='" + txtAirDate.Text.ToString() + "'";
                    }
                    i+=1;
                };
                if (!string.IsNullOrEmpty(Txtkeyword.Text.Trim()))
                {
                    if (i == 0)
                    { sqlstr = sqlstr + " strClipName like '%" + Txtkeyword.Text.ToString() + "%'"; }
                    else
                    {
                        sqlstr = sqlstr + " and strClipName like '%" + Txtkeyword.Text.ToString() + "%'";
                    }
                }
                sqlstr += " and strTapeState <> '已删除'";
            }
            else
                sqlstr += " where strTapeState <> '已删除'";
            SqlConnection sqlcon = new SqlConnection(System.Configuration.ConfigurationManager.ConnectionStrings["TapeManageConnectionString"].ToString());
            sqlcon.Open();
            SqlDataAdapter adp = new SqlDataAdapter(sqlstr, sqlcon);
            //  adp.SelectCommand=sqlstr;
            DataSet ds = new DataSet();
            adp.Fill(ds, "Tape");
            System.Threading.Thread.Sleep(1000);
            GridView1.DataSource = ds;
            GridView1.DataBind();            
            ds.Dispose();
            adp.Dispose();
            sqlcon.Close();
            sqlcon.Dispose();            

            Label1.Text = "共计："+ds.Tables[0].Rows.Count.ToString()+"条记录,共："+GridView1.PageCount.ToString()+"页";
        }        

        protected void GridView1_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            GridView1.PageIndex = e.NewPageIndex;
            Bind();
        }

        protected void GridView2_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            GridView2.PageIndex = e.NewPageIndex;
            Bind2();
        }

        protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                //为GridView数据行添加onmouseover事件JavaScript事件处理脚本
                // 使鼠标悬停时首先使用变量记录当前数据行背景色，再将数据行背景色变为天蓝色
                //e.Row.Attributes.Add("onmouseover", "oldColor=this.style.backgroundColor;this.style.backgroundColor='skyblue';this.style.cursor='hand'");
                e.Row.Attributes.Add("onmouseover", "this.style.cursor='hand'");
                e.Row.Attributes.Add("onclick", "selectx(this);");
            }                         
           
         /*     //为GridView数据行添加onmouseout事件JavaScript事件处理脚本
                //当鼠标移出当前数据行时  使数据行背景色恢复为原来的颜色
              e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=oldColor;");
             
                if (e.Row.RowIndex == GridView1.EditIndex)
                {
                    DropDownList drplst1 = e.Row.FindControl("txtChnName") as DropDownList;

                    drplst1.Text = ((Label)e.Row.FindControl("LbChnName")).Text;
                }
            }
           
          //e.Row.Attributes.Add("onclick", "javascirpt:__doPostBack('GridView1','Select$" + e.Row.RowIndex + "')");*/
  
          
        }

        protected void GridView2_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                e.Row.Attributes.Add("onmouseover", "this.style.cursor='hand'");
                e.Row.Cells[1].Attributes.Add("class", "text");
                for (int i=2;i<e.Row.Cells.Count;i++)
                    e.Row.Cells[i].Attributes.Add("onclick","selecty(this.parentElement);");
                //e.Row.Attributes.Add("onclick", e.Row.ClientID.ToString() + ".checked=true;selecty(this);");
                try
                {//获取当前数据行中第1列的第一个控件 即删除链接    
                    LinkButton btn = e.Row.Cells[0].Controls[0] as LinkButton;
                    btn.Attributes.Add("onclick", "return confirm('您确定要删除该行数据吗？');");//添加弹出询问对话框的JavaScript脚本
                }
                catch { };
            }                
            
            //e.Row.Attributes.Add("onclick", "javascirpt:__doPostBack('GridView2','Select$" + e.Row.RowIndex + "')");
            
            if (e.Row.RowIndex > -1 && this.SelectedItems != null)
            {//回显之前选中的情况
                DataRowView row = e.Row.DataItem as DataRowView;
                CheckBox cb = e.Row.FindControl("CheckBox1") as CheckBox;
                if (this.SelectedItems.Contains(row["磁带条码"].ToString()))
                    cb.Checked = true;
                else
                    cb.Checked = false;
            }//*/
        }

        protected void CollectSelected()
        {/// 收集选中项的情况
            ArrayList selectedItems = null;
            if (this.SelectedItems == null)
                selectedItems = new ArrayList();
            else
                selectedItems = this.SelectedItems;
            for (int i = 0; i < this.GridView2.Rows.Count; i++)
            {
                string guid = this.GridView2.Rows[i].Cells[4].Text;
                CheckBox cb = this.GridView2.Rows[i].FindControl("CheckBox1") as CheckBox;
                if (selectedItems.Contains(guid) && !cb.Checked)
                    selectedItems.Remove(guid);
                if (!selectedItems.Contains(guid) && cb.Checked)
                    selectedItems.Add(guid);
            }
            this.SelectedItems = selectedItems;
        }

        protected void DelChecked(object sender, EventArgs e)
        {
            DataTable tb = (DataTable)ViewState["tb"];
            //CollectSelected();
            if (tb != null && tb.Rows.Count != 0)
            {
                for (int i = 0,j=0; i < GridView2.Rows.Count; i++)
                {
                    //string guid = GridView2.Rows[i].Cells[4].Text;
                    CheckBox cb = GridView2.Rows[i].FindControl("CheckBox1") as CheckBox;
                    if (cb.Checked)
                    {
                        tb.Rows.RemoveAt(i-j);
                        j++;
                    }
                }
                tb.AcceptChanges();
                ViewState["tb"] = tb;
                tb.Dispose();
            }
            Bind2();
            this.SelectedItems = null;
        }

        protected void GridView2_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {
            /*try
            {
                string strCL = GridView2.DataKeys[e.RowIndex]["节目名称"].ToString();
            }catch { }*/            
            DataTable tb = (DataTable)ViewState["tb"];
            if (tb != null && tb.Rows.Count != 0)
            {
                tb.Rows[e.RowIndex].Delete();
                tb.AcceptChanges();
                ViewState["tb"] = tb;                
                tb.Dispose();
                CollectSelected();                
            }
            Bind2();                 
        }

        /*      protected void GridView1_SelectedIndexChanged(object sender, EventArgs e)
                {
                   // Label1.Text = e.ToString();
                }

                protected void GridView1_RowCancelingEdit(object sender, GridViewCancelEditEventArgs e)
                {
                    this.GridView1.EditIndex = -1;
                    Bind();

                }

                protected void GridView1_RowEditing(object sender, GridViewEditEventArgs e)
                {
                    this.GridView1.EditIndex = e.NewEditIndex;
                    Bind();

                }
         
                protected void GridView1_SelectedIndexChanging(object sender, GridViewSelectEventArgs e)
                {
                    //Label1.Text = "asdsadasd";
                }

                private void GridEdit(string strLogicID, string Editstring, int RowIndex)
                {           
                    strLogicID = strLogicID.Trim();
                    SqlConnection sqlcon = new SqlConnection(System.Configuration.ConfigurationManager.ConnectionStrings["TapeManageConnectionString"].ToString());
                    sqlcon.Open();
                    string sqlstr = "select * from Tape where strLogicID='" + strLogicID + "'";
                    SqlDataAdapter adp = new SqlDataAdapter(sqlstr, sqlcon);
                   SqlCommandBuilder builder = new SqlCommandBuilder(adp);
                    builder.QuotePrefix = "[";
                    builder.QuoteSuffix = "]";
                    DataSet ds = new DataSet();
                    adp.Fill(ds, "Tape");
                    // Label1.Text = sqlstr;
                    if (ds.Tables[0].Rows.Count == 1)
                    {
                        if (Editstring == "Edit")
                        {
                            GridViewRow gvr = GridView1.Rows[RowIndex];
                            ds.Tables[0].Rows[0]["strClipName"] = (gvr.FindControl("txtStrClipName") as TextBox).Text;
                            ds.Tables[0].Rows[0]["strDuration"] = (gvr.FindControl("txtstrDuration") as TextBox).Text;
                            ds.Tables[0].Rows[0]["strChnName"] = (gvr.FindControl("txtChnName") as DropDownList).Text;
                            ds.Tables[0].Rows[0]["strTapeID"] = (gvr.FindControl("txtstrTapeID") as TextBox).Text;
                            ds.Tables[0].Rows[0]["strTapeGuid"] = (gvr.FindControl("txtstrTapeGuid") as TextBox).Text;
                            ds.Tables[0].Rows[0]["tPlayDate"] = Convert.ToDateTime((gvr.FindControl("txttPlayDate") as TextBox).Text);

                        }
                        else
                        {
                            ds.Tables[0].Rows[0].Delete();
                        }
                    }
                    ;
                    GridView1.EditIndex = -1;
                    //  adp.UpdateCommand = new SqlCommand("update Tape set strClipName=@strClipName,strDuration=@strDuration,strChnName=@strChnName,strTapeID=@strTapeID,txtstrTapeGuid=@txtstrTapeGuid,tPlayDate=@tPlayDate where");

                    adp.Update(ds, "Tape");
                    Bind();

                }
                */

        protected void DropDownList1_DataBound(object sender, EventArgs e)
        {
            DropDownList1.Items.Insert(0, new ListItem(" 全部频道", "全部频道"));
        }

        protected void GridView1_RowCreated(object sender, GridViewRowEventArgs e)
        {
        }        

        protected void Button2_Click(object sender, EventArgs e)
        {//修改记录
            Rowin(true);            
            Bind2();
        }
        
        protected void Button1_Click(object sender, EventArgs e)
        {//新增记录
                                
            Rowin(false);                
            Bind2();      

            /*string strID = txtID.Text.Trim();//判断，如果strID为空那么执行Insert，否则Update
            /* if (strID != "") {
            }else  //strID为空那么执行Insert操作            {} 
            
             * sqlstr = "update Tape set strTapeGuid='" + txtTapeGuid.Text + "',strTapeID='" + txtTapeID.Text + "',strClipName='" + txtstrClipName.Text
                      + "',tPlayDate='" + txttPlayDate.Text + "',tReserveDate='" + txttReserveDate.Text + "',tPlayTime='" + tPlayTime + "',strDuration='" + duration + "',strChnName='"
                      + DrpChnName.Text + "',sendusername='" + receiver + "',strTapeLocation='" + DrpBase.SelectedItem.Text + "' where ID=" + strID;
                    sqlstr2 = "insert into Tape_transfer (strTapeGuid,Opuser,ConfirmUser,OpTime,srcLocation,DesLocation) values ('" + txtTapeGuid.Text
                      + "','" + sender + "','" + Session["username"].ToString() + "','" + DateTime.Now + "','频道','" + DrpBase.SelectedItem.Text + "')";
             *           
            SqlDataAdapter adpt = new SqlDataAdapter();
            DataSet ds = new DataSet();
            DataTable tb = new DataTable();
            adpt.SelectCommand = sqlcmd;
            adpt.Fill(ds, "SelectTape");
            
            if (ds.Tables[0].Rows.Count != 1)//只处理一档节目
            {
                Label1.Text = "未查到该磁带信息，请确定该节目已登记";
            }
            else
            {
                Label1.Text = "";
                DataRow dr = ds.Tables[0].NewRow();
                for (int i = 0; i < ds.Tables[0].Columns.Count; i++)
                {
                    dr[i] = ds.Tables[0].Rows[0][i];
                }}*/
        }

        private void Rowin(bool alt)
        {            
            string strTapeGuid = txtTapeGuid.Text.Trim();
            string strClipName = txtstrClipName.Text.Trim();
            string rmsg="磁带条码或节目名称已存在，请检查！";
            string tPlayTime = string.IsNullOrEmpty(txttPlayTimeH.Text.Trim())?"":(txttPlayTimeH.Text + ":" + txttPlayTimeM.Text + ":" + txttPlayTimeS.Text);
            DateTime pd,rd;            
            try
            {
                pd = Convert.ToDateTime(txttPlayDate.Text);
                rd = Convert.ToDateTime(txttReserveDate.Text);
                if (pd < DateTime.Now.Date)
                    rmsg = "播出日期不能早于当前日期！！";
                else if (pd > rd)
                    rmsg = "保留日期不能早于播出日期！！";
            }
            catch (FormatException err)
            {
                ScriptManager.RegisterClientScriptBlock(UpdatePanel1, typeof(UpdatePanel), "123", "alert('日期格式输入有误，请检查！"+ err.ToString() + "');", true);
                txttPlayDate.Focus();
                return;
            }         
            
            if (Check.CheckClip(strClipName, strTapeGuid, ""))
            {//如果数据库中不存在重复记录
                DataTable tb = new DataTable("TB");
                int i,sel=-1;                
                
                if ((DataTable)ViewState["tb"] == null)
                {//首次初始化表结构                    
                    tb.Columns.Add("计划播出时间", typeof(string));
                    tb.Columns.Add("节目名称", typeof(string));
                    tb.Columns.Add("磁带条码", typeof(string));
                    tb.Columns.Add("磁带号", typeof(string));
                    tb.Columns.Add("节目时长", typeof(string));
                    tb.Columns.Add("所属频道", typeof(string));
                    tb.Columns.Add("播出日期", typeof(string));
                    tb.Columns.Add("保留日期", typeof(string));
                    //tb.Columns.Add("选中", typeof(bool));
                    //tb.Columns.Add("序号", typeof(int));tb.Columns["序号"].AutoIncrement = true;
                }
                else tb = (DataTable)ViewState["tb"];                
                for (i = 0; i < tb.Rows.Count; i++)
                {
                    if (txtID.Text.Trim() == Convert.ToString(i+1)) sel = i;//(txtID.Text.Trim() == tb.Rows[i]["序号"].ToString()) //
                    if (((tb.Rows[i]["磁带条码"].ToString() == strTapeGuid) || (tb.Rows[i]["节目名称"].ToString() == strClipName)) && !(alt && (sel == i)))
                        break;                    
                }
                if (i == tb.Rows.Count)
                {                    
                    //string duration = txtstrDurationH.Text + ":" + txtstrDurationM.Text + ":" + txtstrDurationS.Text;
                    DataRow newRow = tb.NewRow();                   
                    newRow[0] = tPlayTime;
                    newRow[1] = strClipName;
                    newRow[2] = strTapeGuid;
                    newRow[3] = txtTapeID.Text;
                    newRow[4] = string.IsNullOrEmpty(txtstrDurationH.Text.Trim()) ? "" : (txtstrDurationH.Text + ":" + txtstrDurationM.Text + ":" + txtstrDurationS.Text);
                    newRow[5] = DrpChnName.Text;
                    newRow[6] = txttPlayDate.Text.Trim();
                    newRow[7] = txttReserveDate.Text.Trim();
                    if (alt)
                    {//替换                        
                        for (i = 0; i < tb.Columns.Count; i++)
                            tb.Rows[sel][i] = newRow[i];
                    }
                    else tb.Rows.Add(newRow.ItemArray);

                    CollectSelected();
                    ViewState["tb"] = tb;                    
                    tb.Dispose();
                    txtTapeGuid.Text = "";
                    txtAirDate.Text = "";
                    txtstrClipName.Text = "";
                    txttPlayDate.Text = "";
                    DrpChnName.SelectedIndex = 0;
                    txttPlayTimeH.Text = "";
                    txttPlayTimeM.Text = "";
                    txttPlayTimeS.Text = "";
                    txtstrDurationH.Text = "";
                    txtstrDurationH.Text = "";
                    txtstrDurationH.Text = "";                    
                    ScriptManager.RegisterClientScriptBlock(UpdatePanel1, typeof(UpdatePanel), "113", "setdisplay(1);", true);  
                    return;
                }
            }          
            ScriptManager.RegisterClientScriptBlock(UpdatePanel1, typeof(UpdatePanel), "123", "alert('"+rmsg+"');", true);            
        }
        
        protected void DrpChnName_DataBound(object sender, EventArgs e)
        {
            DrpChnName.Items.Insert(0, new ListItem("", ""));
        }

        protected void On_BtnCI_Click(object sender, EventArgs e)
        {
            string sqlstr, sqlstr2, chaname, chns = "";

            SqlDataReader sqldr = CheckUser.CheckUserLogin(txtSenderGuid.Text, txtUserName.Text, txtPassword.Text);
            string alstr= "";
            string strsender = "";
            string receiver = "";
            string Clipnames = "";
            
            if (sqldr == null)
                alstr = "送带人员认证失败，请确认用户条码或者用户名密码正确！";
            else
                strsender = sqldr["username"].ToString();
            //if ((txtRecvGuid.Text != "") || (Username2.Text != ""))
            //{
                sqldr = CheckUser.CheckUserLogin(txtRecvGuid.Text, Username2.Text, Password2.Text);
                if (sqldr == null)
                    alstr = "收带人员认证失败，请确认用户条码或者用户名密码正确！";
                else
                    receiver = sqldr["username"].ToString();
            //}
            //else receiver = Session["username"].ToString();
            DataTable tb = (DataTable)ViewState["tb"];
            ArrayList channels = new ArrayList();
            if ((tb == null) || (tb.Rows.Count == 0))
                alstr = "请先录入磁带信息！";
            if (string.IsNullOrEmpty(alstr))
            {
                string first = tb.Rows[0]["磁带条码"].ToString();
                
                for (int i = 0; i < tb.Rows.Count; i++)
                {
                    chaname = tb.Rows[i]["所属频道"].ToString();
                    sqlstr = "insert into Tape (strTapeGuid,strTapeID,TapeInTime,tPlayTime,strClipName,tPlayDate,tReserveDate,strDuration,strChnName,sendusername,strTapeLocation,strTapeState)"
                         + " values ('" + tb.Rows[i]["磁带条码"].ToString() + "','" + tb.Rows[i]["磁带号"].ToString() + "','" + DateTime.Now + "','"
                         + tb.Rows[i]["计划播出时间"].ToString() + "','" + tb.Rows[i]["节目名称"].ToString() + "','" + tb.Rows[i]["播出日期"] + "','" + tb.Rows[i]["保留日期"] + "','"
                         + tb.Rows[i]["节目时长"].ToString() + "','" + chaname + "','" + strsender + "','导播科','待处理')";
                    sqlstr2 = "insert into Tape_transfer (strTapeGuid,Opuser,ConfirmUser,OpTime,srcLocation,DesLocation) values ('" + tb.Rows[i]["磁带条码"].ToString() +
                     "','" + strsender + "','" + receiver + "','" + DateTime.Now + "','频道','导播科')";
                    CmdExecute.Execute(sqlstr);
                    CmdExecute.Execute(sqlstr2);
                    System.Threading.Thread.Sleep(100);
                    Clipnames += tb.Rows[i]["节目名称"].ToString() + ",";
                    if (!channels.Contains(chaname))
                        channels.Add(chaname);
                }
                alstr = "已完成以下" + tb.Rows.Count.ToString() + "盘磁带的入库操作";
                Label2.Text = alstr;
                ViewState["tbb"] = tb;
                ViewState["tb"] = null;                
                /*SqlConnection sqlcon = new SqlConnection(System.Configuration.ConfigurationManager.ConnectionStrings["TapeManageConnectionString"].ToString());
                SqlCommand com = sqlcon.CreateCommand();
                com.CommandText = "select * from Tape where strClipName='" + first + "'";//
                sqldr = com.ExecuteReader();
                if (sqldr.Read()) first = sqldr["ID"].ToString();//first = ds.Tables[0].Rows[0]["ID"].ToString();
                com.CommandText = "select * from Tape where strClipName='" + last + "'";
                sqldr = com.ExecuteReader();//
                if (sqldr.Read()) last = sqldr["ID"].ToString();//*/
                DataSet ds=new DataSet();
                do
                {
                    System.Threading.Thread.Sleep(1000);
                    ds = CmdExecute.ExecuteDataSet("select * from Tape where strTapeGuid ='" + first + "'", "tapeid");
                }while (ds.Tables[0].Rows.Count < 1);                                
                first = ds.Tables[0].Rows[0]["ID"].ToString();
                string last = Convert.ToString(Convert.ToInt32(first) + tb.Rows.Count - 1);
                Clipnames=Clipnames.Remove(Clipnames.Length - 1);
                foreach (object tobj in channels)
                {
                    chns += tobj.ToString() + ",";
                }
                chns=chns.Remove(chns.Length - 1);
                CmdExecute.Execute("insert into BatchInfo (FirstIn,LastIn,Clipnames,Channel,OpTime,Sender) values ('" + first + "','"
                    + last + "','" + Clipnames + "','" + chns + "','" + DateTime.Now + "','" + strsender + "')");//更新 批次信息
                sqldr.Close();
                sqldr.Dispose();
                tb.Dispose();
                ds.Dispose();
                Bind();
            }
            ScriptManager.RegisterClientScriptBlock(UpdatePanel1, typeof(UpdatePanel), "234", "alert('" + alstr + "');", true);   
        }

        protected void GridView2_SelectedIndexChanged(object sender, EventArgs e)
        {
        }

        protected void Btn_ExportClick(object sender, EventArgs e)
        {
            DataTable tb = (DataTable)ViewState["tb"];
            if (tb == null) tb = (DataTable)ViewState["tbb"];
            if (tb != null)
            {
                string style = @"<style> .text { mso-number-format:\@; } </style> ";                
                System.Web.HttpContext curContext = System.Web.HttpContext.Current;
                //Response.Charset = "UTF-8";//设置字符集
                curContext.Response.ClearContent();
                curContext.Response.AddHeader("content-disposition", "attachment; filename=MyExcelFile.xls");                        

                System.IO.StringWriter sw = new System.IO.StringWriter();
                HtmlTextWriter htw = new HtmlTextWriter(sw);
                curContext.Response.ContentType = "application/vnd.ms-excel"; 
                curContext.Response.ContentEncoding =System.Text.Encoding.UTF8; //设置编码集
                curContext.Response.Charset = "";
                System.Web.UI.WebControls.DataGrid dgExport = new System.Web.UI.WebControls.DataGrid(); 
                dgExport.DataSource = tb.DefaultView; 
                dgExport.AllowPaging = false; 
                dgExport.DataBind();
                dgExport.RenderControl(htw);
                curContext.Response.Write(style);// Style is added dynamically    
                curContext.Response.Write(sw.ToString());
                curContext.Response.End();
                ViewState["tbb"] = null;
            }
            else Response.Write("<script>alert('请先录入磁带信息！');</script>");
        }

        public override void VerifyRenderingInServerForm(Control control)
        {
        }


    }
}
/*
<asp:TemplateField HeaderStyle-CssClass="hidden" HeaderText="ID" 
                    ItemStyle-CssClass="hidden">
                    <ItemTemplate>
                        <%# Eval("ID")%>
                    </ItemTemplate>                    
                </asp:TemplateField>

//checkform()
var current = new Date();
	var yy = current.getFullYear();
	var mm = current.getMonth()+1;
	var dd = current.getDate();
	var sdate;
	if (mm<10) 
		sdate= yy.toString() +"-0"+mm.toString()+ "-"+dd.toString();
	else
		sdate= yy.toString()+"-" +mm.toString()+"-"+ dd.toString();		
   var pd = trim(document.getElementById("txttPlayDate").value);
   var rd = trim(document.getElementById("txttReserveDate").value);
   
   alert(sdate+pd+rd);  
   
   if (pd == "")
   {
      alert("播出日期不能为空！！");  
      document.getElementById("txttPlayDate").focus();          
      return false;      
   }
   
   if (sdate < pd)
   	{
      alert("播出日期不能早于当前日期！！"); 
      document.getElementById("txttPlayDate").focus();          
      return false;      
    }    
               
   if (rd == "")       
      document.getElementById("txttReserveDate") = pd;
   else if (rd < pd)
   	{
      alert("保留日期不能早于播出日期！！");  
      document.getElementById("txttReserveDate").focus();          
      return false;      
    }

//时长、时间格式检测



*/