﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.Text.RegularExpressions;
using System.Data.SqlClient;
using TapeManager.csfiles;

namespace TapeManager
{
    public partial class Tape_transferStat : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["username"] != null)
            {

                //string username = Session["username"].ToString();
                string UserRole=Session["qx"].ToString();
 
                if (CheckUser.CheckUserRole(UserRole, "调拨状态查询"))
                {
                    SqlDataReader sqldr1 = CheckUser.GetUserRoleReader(UserRole);
                    string userManageChnName = sqldr1["ManageChnName"].ToString();
                    sqldr1.Close();
                    sqldr1.Dispose();
                    if (!IsPostBack)
                    {
                        Regex r = new Regex("\\b全部频道\\b");
                        if (r.Match(userManageChnName).Success)   //如果是全部频道 采用绑定方式
                        {
                            DrpChnName.DataSource = SqlDataSource2;
                            DrpChnName.DataTextField = "strChnName";
                            DrpChnName.DataValueField = "strChnName";
                            DrpChnName.DataBind();
                        }
                        else
                        {
                            string[] ChnArray = Regex.Split(userManageChnName, ",", RegexOptions.IgnoreCase);


                            for (int i = 0; i < ChnArray.Length; i++)
                            {

                                DrpChnName.Items.Add(new ListItem(ChnArray[i], ChnArray[i]));
                            };
                        }
                    }
                }
                else
                {
                    Response.Redirect("UserRoleError.htm");
                }
            }
            else
            {

                //导向登陆界面
                Response.Redirect("login.aspx?linkname=调拨状态查询");

            }
        }

        protected void DrpChnName_DataBound(object sender, EventArgs e)
        {
            DrpChnName.Items.Insert(0, new ListItem("全部频道", "全部频道"));
        }

        protected void Btn_Query_Click(object sender, EventArgs e)
        {
            Bind();
        }

        protected void GridView1_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            GridView1.PageIndex = e.NewPageIndex;
            Bind();
        }

        private void Bind()
        {
            string sqlstr;
            sqlstr = "select * from View_Tape_transfer";
            if (string.IsNullOrEmpty(txtstrTapeGuid.Text.Trim()))
            {
                //如果磁带条码为空，那么按照查询条件查询
                if ((DrpChnName.Text != "全部频道") || (!string.IsNullOrEmpty(txtAirDate.Text.Trim())) || (!string.IsNullOrEmpty(Txtkeyword.Text.Trim())))
                {
                    int i = 0;
                    sqlstr += " where";
                    if (DrpChnName.Text != "全部频道")
                    {
                        sqlstr = sqlstr + " Channel='" + DrpChnName.Text.ToString() + "'";
                        i++;
                    };
                    if (!string.IsNullOrEmpty(txtAirDate.Text.Trim()))
                    {
                        if (i == 0)
                        { sqlstr = sqlstr + " tPlayDate='" + txtAirDate.Text.ToString() + "'"; }
                        else
                        {
                            sqlstr = sqlstr + " and tPlayDate='" + txtAirDate.Text.ToString() + "'";
                        }
                        i++;
                    };
                    if (!string.IsNullOrEmpty(Txtkeyword.Text.Trim()))
                    {
                        if (i == 0)
                        { sqlstr = sqlstr + " strClipName like '%" + Txtkeyword.Text.ToString() + "%'"; }
                        else
                        {
                            sqlstr = sqlstr + " and strClipName like '%" + Txtkeyword.Text.ToString() + "%'";
                        }
                        i++;
                    };
                };
            }
            else
            {
                //以磁带条码进行查询
                sqlstr = "select * from View_Tape_transfer where strTapeGuid ='" + txtstrTapeGuid.Text + "'";
            }
            sqlstr = sqlstr + " order by strTapeGuid Desc,OpTime";
            DataSet ds = CmdExecute.ExecuteDataSet(sqlstr, "Tape_transfer");
            GridView1.DataSource = ds;
            GridView1.DataBind();
            ds.Dispose();
        
        }

    }
}
