﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.IO;
using System.Data.OleDb;
using System.Data.SqlClient;
using TapeManager.csfiles;

namespace TapeManager
{
    public partial class TapeIn : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["username"] != null)
            {
                string username = Session["username"].ToString();
                string UserRole = Session["qx"].ToString();

                if (CheckUser.CheckUserRole(UserRole, "从Excel导入"))
                {
                    LblTitle.Text = "您好：【 " + username + "】   欢迎使用磁带管理系统";
                }
                else
                {
                    Response.Redirect("../UserRoleError.htm");

                }
                Btn_Submit.Attributes.Add("onclick", "return checkform()");
            }
            else
            {
                Response.Redirect("../login.aspx?linkname=从Excel导入");
            }

        }
        protected Boolean UploadExcel()
        {
            string fileName = this.FileUpload1.FileName;
            if (fileName == null)
            {
                Response.Write("<script language='javascript'>alert('请选择文件');</script>");
              return false;           
            }
                
            string suffix = fileName.Substring(fileName.LastIndexOf(".")+1);
            if (suffix != "xls")
            {
                Response.Write("<script language='javascript'>alert('所选的文件类型只能是Excel表！');</script>");
                Label1.Text = "所选的文件类型只能是Excel表！" + suffix;
                return false;
            };
            try
            {
                string tempPath = this.Server.MapPath("../CliptoDub") + "\\" + this.FileUpload1.FileName;
                string path = File.Exists(tempPath) ? this.GetUniqueFileName(tempPath) : tempPath;//当前上传的文件已存在时即重命名
                this.FileUpload1.PostedFile.SaveAs(path);
            }
            catch(Exception e)
            {
                Response.Write("<script language='javascript'>alert('打开文件出错！内部错误信息："+e.ToString()+"');</script>");
            }
            return true;
        
        }


        protected void Button1_Click(object sender, EventArgs e)
        {
            if (UploadExcel())
            {
                string Path = this.Server.MapPath("../CliptoDub") + "\\" + this.FileUpload1.FileName;
                //上传完毕后读取Excel表写入
                // string excelUrl = this.Server.MapPath(@"App_data\demo.xls");
                //组装连接Excel文件的连接字符串并实例化连接
                OleDbConnection con = new OleDbConnection("Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" + Path + ";Extended Properties=\"Excel 8.0;HDR=NO;IMEX=0\"");
                OleDbCommand com = con.CreateCommand();
                //查询工作簿Sheet1
                com.CommandText = "SELECT * FROM [Sheet1$] where 素材名称 <>''";

                //实例化数据适配器
               OleDbDataAdapter adpt = new OleDbDataAdapter();
               DataSet ds = new DataSet();
               DataTable tb = new DataTable();
                adpt.SelectCommand = com;
                //填充DataSet
                try
                {
                    adpt.Fill(ds, "UploadtoDunTb");
                    tb = ds.Tables[0];
                }
                catch
                {
                    Label1.Text = "导入失败，表中不含有效数据，请检查！！";
                    return;
                }                
                try
                {
                    tb.PrimaryKey = new DataColumn[] { tb.Columns["素材名称"] };
                }
                catch
                {
                    Label1.Text = "导入失败，节目名称有重复，请检查！！";
                    return;
                };
                if (tb != null)
                {
                    ViewState["tb"] = tb;
                    ViewState["tb_old"] = tb;
                    try
                    {
                        GridView1.DataSource = ds;
                        GridView1.DataBind();
                    }
                    catch 
                    {
                        Label1.Text = "导入失败，表头格式有误，请检查！！";
                        return;
                    };
                    tb.Dispose();
                    Label1.Text = "已导入：" + this.FileUpload1.FileName + " 共计：" + tb.Rows.Count.ToString() + "条记录";
                    DataVerify("");
                }
                ds.Dispose();
            }
        }

        #region  文件重命名的方法
        /// <summary>
        /// 复制文件时 对复制后的文件进行重命名的方法
        /// </summary>
        private string GetUniqueFileName(string path)
        {
            //获取文件名中文件夹路径部分
            string dicPath = path.Substring(0, path.LastIndexOf("\\") + 1);
            //获取文件名部分
            string fileName = path.Substring(path.LastIndexOf("\\") + 1);
            //获取文件名前缀部分
            string prefix = fileName.Substring(0, fileName.LastIndexOf("."));
            //获取文件名后缀部分
            string suffix = fileName.Substring(fileName.LastIndexOf("."));
            string tempPath = string.Empty;
            int i = 1;
            while (i > 0)
            {
                tempPath = string.Format("{0}{1}[{2}]{3}", dicPath, prefix, i, suffix);

                if (File.Exists(tempPath))
                {
                    i++;
                    continue;
                }
                else
                {
                    break;
                }
            }
            return tempPath;
        }

        #endregion

        protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {
            ViewState["SI"] = Check.CollectSelected(this.GridView1.Rows, 4, (ArrayList)ViewState["SI"]);
            DataTable tb =(DataTable)ViewState["tb"];
            if (tb != null)
            {
                tb.Rows[e.RowIndex].Delete();
                tb.AcceptChanges();
                GridView1.DataSource = tb;
                GridView1.DataBind();
                ViewState["tb"] = tb;
                DataVerify("");
                tb.Dispose();                
            }
            else
                GridView1.DataBind();
        }

        protected void DelChecked(object sender, EventArgs e)
        {
            DataTable tb = (DataTable)ViewState["tb"];
            if (tb != null && tb.Rows.Count != 0)
            {
                for (int i = 0, j = 0; i < GridView1.Rows.Count; i++)
                {
                    CheckBox cb = GridView1.Rows[i].FindControl("CheckBox1") as CheckBox;
                    if (cb.Checked)
                    {
                        tb.Rows.RemoveAt(i - j);
                        j++;
                    }
                }
                tb.AcceptChanges();
                ViewState["tb"] = tb;
                DataVerify("");
                tb.Dispose();
            }          
            Bind();
            ViewState["SI"] = null;
        }

        protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                //为GridView数据行添加onmouseover事件JavaScript事件处理脚本
                // 使鼠标悬停时首先使用变量记录当前数据行背景色，再将数据行背景色变为天蓝色
                e.Row.Attributes.Add("onmouseover", "oldColor=this.style.backgroundColor;this.style.backgroundColor='skyblue';");
                //为GridView数据行添加onmouseout事件JavaScript事件处理脚本
                //当鼠标移出当前数据行时  使数据行背景色恢复为原来的颜色
                e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=oldColor;");

                //获取当前数据行中第12列的第一个控件 即删除链接
                try
                {
                    LinkButton btn = e.Row.Cells[11].Controls[0] as LinkButton;
                    //添加弹出询问对话框的JavaScript脚本
                    string s = (e.Row.Cells[4].Controls[0] as DataBoundLiteralControl).Text.Trim();
                    btn.Attributes.Add("onclick", "return confirm('您确定要删除【"+s+"】吗？');");
                }
                catch { };

                if (e.Row.RowIndex == GridView1.EditIndex)
                {
                    DropDownList drplst1 = e.Row.FindControl("txtChnName") as DropDownList;
                    drplst1.Text = ((Label)e.Row.FindControl("LbChnName")).Text;
                }
                Check.RDB(e.Row, (ArrayList)ViewState["SI"], "素材名称");
            }
         }

        protected void Btn_Reset_Click(object sender, EventArgs e)
        {
            ViewState["tb"] = (DataTable)ViewState["tb_old"];
            Bind();
        }

        protected void GridView1_RowEditing(object sender, GridViewEditEventArgs e)
        {
            this.GridView1.EditIndex = e.NewEditIndex;
            Bind();
        }

        protected void GridView1_RowUpdating(object sender, GridViewUpdateEventArgs e)
        {
    
            DataTable tb = (DataTable)ViewState["tb"];
            
            GridViewRow gvr=GridView1.Rows[e.RowIndex];
            string strLogicID = (gvr.FindControl("txtstrLogicID") as TextBox).Text;
            for (int i = 0; i < tb.Rows.Count; i++) 
            { 
                 DataRow dr = tb.Rows[i];
             //    Label1.Text = strLogicID;
              if (strLogicID==tb.Rows[i]["节目代码"].ToString())
               {

                   dr.BeginEdit();
                   dr["素材名称"] = (gvr.FindControl("txtStrClipName") as TextBox).Text;
                   dr["时长"] = (gvr.FindControl("txtStrDuration") as TextBox).Text;
                   dr["频道名称"] = (gvr.FindControl("txtChnName") as DropDownList).Text;
                   dr["磁带号"] = (gvr.FindControl("txtTapeID") as TextBox).Text;
                   dr["磁带条码"] = (gvr.FindControl("strTapeGuid") as TextBox).Text;
                   try
                   {
                       dr["播出日期"] = Convert.ToDateTime((gvr.FindControl("txtAirDate") as TextBox).Text);
                       dr["保留日期"] = Convert.ToDateTime((gvr.FindControl("txtReserveDate") as TextBox).Text);
                   }
                   catch { }
                   dr["计划播出时间"] = (gvr.FindControl("txttPlayTime") as TextBox).Text;
                   dr.EndEdit();                   
               }            
            }
            GridView1.EditIndex = -1;
            Bind();
            DataVerify("");//if (tb.Rows.Count > 0) 
            tb.Dispose();
        }

        private void Bind()
        {
          
            DataTable tb = (DataTable)ViewState["tb"];
            if (tb != null)
            {
                GridView1.DataSource = tb;
                GridView1.DataBind();
                tb.Dispose();
            }
            else
                GridView1.DataBind();
        }

        protected void GridView1_RowCancelingEdit(object sender, GridViewCancelEditEventArgs e)
        {
            this.GridView1.EditIndex = -1;
            Bind();
        }

        protected void Btn_Verify_Click(object sender, EventArgs e)
        {
            if (ViewState["tb"] == null || ((DataTable)ViewState["tb"]).Rows.Count == 0)
                Label1.Text = "请先录入磁带信息！";
            else
                DataVerify("");
        }

        protected ArrayList DataVerify(string sendusername)
        {
            string[] ErrMsg = { "有必填字段为空", "播出日期早于当前日期", "保留日期早于播出日期", "磁带条码或节目名称已存在"};
            string[][] Fields = {new string[] { "磁带号", "节目代码","计划播出时间","时长","频道名称","播出日期", "保留日期","素材名称","磁带条码"}, 
                               new string[]{ "strTapeID","strLogicID","tPlayTime","strDuration" ,"strChnName","tPlayDate","tReserveDate","strClipName","strTapeGuid"} };
            string[] Notes = new string[13];//初始化数组——记录录入数据，出错信息
            ArrayList InsertNums = new ArrayList();
            DataTable tb = (DataTable)ViewState["tb"];
            int UpdateCount = 0;
            for (int i = 0; i < tb.Rows.Count; i++)
            {
                string ri = Convert.ToString(i + 1)+ ",";
                string CmdTxt="";
                bool Cont=false;
                for (int j = 0; j < 9; j++)
                {
                    Notes[j] = tb.Rows[i][Fields[0][j]].ToString().Trim();
                    if (!string.IsNullOrEmpty(Notes[j]))                        
                        CmdTxt += (j<7)?Fields[1][j] + " = '" + Notes[j] + "',":"";
                    else if (j > 3 && !Cont)
                    {
                        Notes[9] += ri ;
                        Cont =true;
                    }
                }
                ri = Convert.ToString(i + 1) + ",";
                try
                {
                    DateTime pd = Convert.ToDateTime(Notes[5]);
                    if (pd < DateTime.Now.Date)
                    {
                        Notes[10] += ri;
                        Cont =true;
                    }
                    if (pd > Convert.ToDateTime(Notes[6]))
                    {
                        Notes[11] += ri;
                        Cont =true;
                    }
                }
                catch { };
                bool Nore = Check.CheckClip(Notes[7], Notes[8], "");//素材名、条码是否重复
                if (!Nore)
                    Notes[12] += ri;
                if (string.IsNullOrEmpty(sendusername) || Cont || (!Nore&&Rb1.Checked))
                    continue;
                Label1.Text = "";
                if (!Nore)
                {
                    DataSet Ds = CmdExecute.ExecuteDataSet("select * from Tape where strClipName='" + Notes[7] + "'", "Name");
                    if (Ds.Tables[0].Rows.Count > 0)
                    {//素材名重复，更新信息，不改条码
                        CmdTxt = "update tape set " + CmdTxt.Substring(0, CmdTxt.Length - 1) + " where strClipName='" + Notes[7] + "'"; ;
                        UpdateCount++;
                    }
                    else
                    {//条码重复，不插入条码
                        CmdTxt = "insert into Tape (strTapeID,strClipName,TapeInTime,tPlayDate,tReserveDate,strLogicID,strDuration,strChnName,tPlayTime,sendusername,strTapeState,strTapeLocation) values ('"
                           + Notes[0] + "','" + Notes[7] + "','" + DateTime.Now + "','" + Notes[5] + "','" + Notes[6] + "','" + Notes[1] + "','"
                           + Notes[3] + "','" + Notes[4] + "','" + Notes[2] + "','" + sendusername + "','待处理','导播科')";//审核位置校验
                        InsertNums.Add(i);
                    }
                }                    
                else
                {
                    CmdTxt = "insert into Tape (strTapeID,strClipName,TapeInTime,tPlayDate,tReserveDate,strLogicID,strDuration,strChnName,tPlayTime,sendusername,strTapeGuid,strTapeState,strTapeLocation) values ('"
                           + Notes[0] + "','" + Notes[7] + "','" + DateTime.Now + "','" + Notes[5] + "','" + Notes[6] + "','" + Notes[1] + "','"
                           + Notes[3] + "','" + Notes[4] + "','" + Notes[2] + "','" + sendusername + "','" + Notes[8] + "','待处理','导播科')";
                    InsertNums.Add(i);
                }
                CmdExecute.Execute(CmdTxt);
            }
            Label2.Text = "数据校验信息：";
            if (InsertNums.Count < tb.Rows.Count)
            {//输出校验错误   
                for (int i = 9; i < 13; i++)
                    if (!string.IsNullOrEmpty(Notes[i]))
                        Label2.Text += "第" + Notes[i].Remove(Notes[i].Length - 1) + "行" + ErrMsg[i - 9] + "；";
            }
            else Label2.Text += "全部数据通过校验";
            if (UpdateCount>0)
                Label1.Text = "；成功更新了：" + UpdateCount.ToString() + "行";
            return InsertNums;
        }
        
        protected void Btn_Submit_Click(object sender, EventArgs e)
        {
            //  OleDbConnection con = new OleDbConnection("Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" + Path + ";Extended Properties=\"Excel 8.0;HDR=NO;IMEX=0\"");

            string sendusername;
            SqlDataReader dr = CheckUser.CheckUserLogin(txtUserGuid.Text, txtusername.Text, txtstrPassword.Text);            
            if (dr == null)
            {
                Label1.Text = "收带人员认证失败，请确认用户条码或者用户名密码正确！";
                return;
            }
            dr = CheckUser.CheckUserLogin(txtSenderGuid.Text, txtSenderName.Text, txtPassword.Text);
            if (dr == null)
            {
                Label1.Text = "送带人员认证失败，请确认用户条码或者用户名密码正确！";
                return;
            }
            sendusername = dr["username"].ToString();
            if (ViewState["tb"] == null || ((DataTable)ViewState["tb"]).Rows.Count == 0)  
                Label1.Text = "请先录入磁带信息！";
            else
            {                
                ArrayList Nums = DataVerify(sendusername);
                DataTable tb = (DataTable)ViewState["tb"];
                
                if (Nums.Count > 0)
                {
                    System.Threading.Thread.Sleep(1000);
                    DataSet ds = CmdExecute.ExecuteDataSet("select max(ID) from Tape", "last");//"select max(ID) as exp1 from Tape"
                    string last = ds.Tables[0].Rows[0][0].ToString();//["exp1"]
                    string first = (Convert.ToInt32(last) - Nums.Count + 1).ToString();
                    ArrayList Channels = new ArrayList();
                    string Clipnames = "", Chns = "";
                    foreach (int i in Nums)
                    {
                        Clipnames += tb.Rows[i]["素材名称"].ToString().Trim();
                        if (!Channels.Contains(tb.Rows[i]["频道名称"].ToString().Trim()))
                            Channels.Add(tb.Rows[i]["频道名称"].ToString().Trim());
                    }
                    Clipnames = Clipnames.Remove(Clipnames.Length - 1);
                    foreach (object tobj in Channels)
                    {
                        Chns += tobj.ToString() + ",";
                    }
                    Chns = Chns.Substring(0, Chns.Length - 1);
                    CmdExecute.Execute("insert into BatchInfo (FirstIn,LastIn,Clipnames,Channel,OpTime,Sender) values ('" + first + "','" + last + "','" + Clipnames + "','"
                        + Chns + "','" + DateTime.Now + "','" + sendusername + "')");//更新 批次信息
                }
                Label1.Text = "已成功插入了" + Nums.Count.ToString() + "行" + Label1.Text;               
                ViewState["tb"] = null;
                ViewState["tb_old"] = null;
                Response.Write("<script language='javascript'>alert('已导入" + Nums.Count.ToString() + "行数据！');</script>");                
                tb.Dispose();
                dr.Dispose();
            }            
        }

        protected void GridView1_SelectedIndexChanged(object sender, EventArgs e)
        {
        }

        protected void SqlDataSource1_Selecting(object sender, SqlDataSourceSelectingEventArgs e)
        {
        }
    }
}
