﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.Data.SqlClient;
using System.Text.RegularExpressions;
using TapeManager.csfiles;

namespace TapeManager.admin
{
    public partial class TapeAdmin : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            //txtID.Visible = false;         
            if (Session["username"]!=null)
            {
                string username = Session["username"].ToString();
                string UserRole = Session["qx"].ToString();

                if (CheckUser.CheckUserRole(UserRole, "磁带管理"))
                {
                    SqlDataReader sqldr1 = CheckUser.GetUserRoleReader(UserRole);
                    string userManageChnName = sqldr1["ManageChnName"].ToString();
                    if (!IsPostBack)
                    {
                        Regex r = new Regex("\\b全部频道\\b");
                        if (r.Match(userManageChnName).Success)   //如果是全部频道 采用绑定方式
                        {
                            DropDownList1.DataSource = SqlDataSource1;
                            DropDownList1.DataTextField = "strChnName";
                            DropDownList1.DataValueField = "strChnName";
                            DropDownList1.DataBind();
                        }
                        else
                        {
                            string[] ChnArray = Regex.Split(userManageChnName, ",", RegexOptions.IgnoreCase);
                            for (int i = 0; i < ChnArray.Length; i++)
                            {
                                DropDownList1.Items.Add(new ListItem(ChnArray[i], ChnArray[i]));
                            };
                        }                        
                    };
                    Button1.Attributes.Add("onclick", "return checkform()");
                    LblTile.Text = "您好：【 " + username + "】   欢迎使用磁带管理系统";
                    sqldr1.Close();
                    sqldr1.Dispose();
                    delcheck.Attributes.Add("onclick", "return confirm('您确定要删除选中记录吗？');");
                }
                else
                {
                    Response.Redirect("../UserRoleError.htm");

                }              
            }
            else
            {//导向登陆界面
                Response.Redirect("../login.aspx?linkname=磁带管理");
            }
        }

        protected void Btn_Query_Click(object sender, EventArgs e)
        {
            Bind();
            ViewState["SI"] = null;
        }

        private void Bind()
        {
            string sqlstr = "";
            if (!string.IsNullOrEmpty(TapeGuid2.Text.Trim()))//磁带条码
                sqlstr = " where strTapeGuid like '%" + TapeGuid2.Text.Trim() + "%'";
            else
            {
                if (DropDownList1.Text.Trim() != "全部频道")//频道
                    sqlstr = " where strChnName='" + DropDownList1.Text.ToString() + "'";
                if (!string.IsNullOrEmpty(txtAirDate.Text.Trim()))
                {//播出日期-起始
                    if (string.IsNullOrEmpty(sqlstr))
                        sqlstr = " where tPlayDate>='" + txtAirDate.Text.ToString() + "'";
                    else
                        sqlstr += " and tPlayDate>='" + txtAirDate.Text.ToString() + "'";
                };
                if (!string.IsNullOrEmpty(EBDate.Text.Trim()))
                {//播出日期-结束
                    DateTime rd = DateTime.Now;
                    try
                    {
                        rd = (Convert.ToDateTime(EBDate.Text)).AddDays(1);
                    }
                    catch { };
                    if (string.IsNullOrEmpty(sqlstr))
                        sqlstr = "where tPlayDate <='" + rd + "'";
                    else
                        sqlstr = sqlstr + " and tPlayDate <= '" + rd + "'";
                }
                if (!string.IsNullOrEmpty(Txtkeyword.Text.Trim()))
                {//关键字-素材名称
                    if (string.IsNullOrEmpty(sqlstr))
                        sqlstr = " where strClipName like '%" + Txtkeyword.Text.Trim() + "%'";
                    else
                        sqlstr += " and strClipName like '%" + Txtkeyword.Text.Trim() + "%'";
                };
                if (DropDownList2.Text != "全部")
                {//磁带状态
                    if (string.IsNullOrEmpty(sqlstr))
                        sqlstr = " where strTapeState like '%" + DropDownList2.Text + "%'";
                    else
                        sqlstr = sqlstr + " and strTapeState like '%" + DropDownList2.Text + "%'";
                }
                if (!ck1.Checked)
                {
                    if (string.IsNullOrEmpty(sqlstr))
                        sqlstr = " where strTapeState <> '已删除'";
                    else
                        sqlstr += " and strTapeState <> '已删除'";
                }
                if (txtTID.Text != "@$&")
                {
                    if (!string.IsNullOrEmpty(txtTID.Text.Trim()))
                    {//磁带号
                        if (string.IsNullOrEmpty(sqlstr))
                            sqlstr = " where strTapeID like '%" + txtTID.Text.Trim() + "%'";
                        else
                            sqlstr = sqlstr + " and strTapeID  like '%" + txtTID.Text.Trim() + "%'";
                    }
                    if (!string.IsNullOrEmpty(DplSender.Text))
                    {//送带人
                        if (string.IsNullOrEmpty(sqlstr))
                            sqlstr = " where sendusername like '%" + DplSender.Text + "%'";
                        else
                            sqlstr = sqlstr + " and sendusername  like '%" + DplSender.Text + "%'";
                    }
                    if (!string.IsNullOrEmpty(SendDate.Text.Trim()))
                    {//送带日期-起始
                        if (string.IsNullOrEmpty(sqlstr))
                            sqlstr = " where TapeInTime>='" + SendDate.Text.ToString() + "'";
                        else
                            sqlstr += " and TapeInTime>='" + SendDate.Text.ToString() + "'";
                    }
                    if (!string.IsNullOrEmpty(SLDate.Text.Trim()))
                    {//送带日期-结束
                        DateTime rd = DateTime.Now;
                        rd = (Convert.ToDateTime(SLDate.Text)).AddDays(1);
                        if (string.IsNullOrEmpty(sqlstr))
                            sqlstr = "where TapeInTime <='" + rd + "'";
                        else
                            sqlstr = sqlstr + " and TapeInTime <= '" + rd + "'";
                    }
                    if (!string.IsNullOrEmpty(RSDate.Text.Trim()))
                    {//保留日期
                        if (string.IsNullOrEmpty(sqlstr))
                            sqlstr = " tReserveDate <='" + RSDate.Text.ToString() + "'";
                        else
                            sqlstr = sqlstr + " and tReserveDate <='" + RSDate.Text.ToString() + "'";
                    }
                    if (DpLocation.Text != "所有位置")
                    {//磁带位置
                        if (string.IsNullOrEmpty(sqlstr))
                            sqlstr = " where strTapeLocation ='" + DpLocation.Text + "'";
                        else
                            sqlstr = sqlstr + " and strTapeLocation  ='" + DpLocation.Text + "'";
                    }
                }
            }
            
            sqlstr = "select * from Tape" + sqlstr;
            SqlConnection sqlcon = new SqlConnection(System.Configuration.ConfigurationManager.ConnectionStrings["TapeManageConnectionString"].ToString());
            sqlcon.Open();
            SqlDataAdapter adp = new SqlDataAdapter(sqlstr, sqlcon);
            DataSet ds = new DataSet();
            adp.Fill(ds, "Tape");
            GridView1.DataSource = ds;
            GridView1.DataBind();
            sqlcon.Close();
            sqlcon.Dispose();
            adp.Dispose();
            ds.Dispose();


            // GridView1.Columns[11].ItemStyle.CssClass = "hidden";
            Label1.Text = "共计：" + ds.Tables[0].Rows.Count.ToString() + "条记录,共：" + GridView1.PageCount.ToString() + "页";
        }
        

        protected void GridView1_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            GridView1.PageIndex = e.NewPageIndex;
            Bind();
        }

        protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                //为GridView数据行添加onmouseover事件JavaScript事件处理脚本
                // 使鼠标悬停时首先使用变量记录当前数据行背景色，再将数据行背景色变为天蓝色
               e.Row.Attributes.Add("onmouseover", "this.style.cursor='hand'");
              //  e.Row.Attributes.Add("onmouseover", "mouseover(this);"); 
                
              //  e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=oldColor;");//为GridView数据行添加onmouseout事件JavaScript事件处理脚本
             //   e.Row.Attributes.Add("onmouseout", "mouseout(this);");//当鼠标移出当前数据行时  使数据行背景色恢复为原来的颜色
                //获取当前数据行中第6列的第一个控件 即删除链接
                try
                {

                    LinkButton btn = e.Row.Cells[15].Controls[0] as LinkButton;
                    Label lblClipName = e.Row.Cells[3].FindControl("LblClipName") as Label;
                    //添加弹出询问对话框的JavaScript脚本
                    btn.Attributes.Add("onclick", "return confirm('您确定要删除【" + lblClipName.Text + "】吗？');");
                }
                catch { };
                if (e.Row.RowIndex == GridView1.EditIndex)
                {
                    DropDownList drplst1 = e.Row.FindControl("txtChnName") as DropDownList;
                    drplst1.Text = ((Label)e.Row.FindControl("LbChnName")).Text;
                }
                for (int i = 1; i < e.Row.Cells.Count-1; i++)
                    e.Row.Cells[i].Attributes.Add("onclick", "selectx(this.parentElement);");//e.Row.ClientID.ToString() + ".checked=true;
                Check.RDB(e.Row, (ArrayList)ViewState["SI"], "ID");
            }
            //e.Row.Attributes.Add("onclick", "javascirpt:__doPostBack('GridView1','Select$" + e.Row.RowIndex + "')");            
        }

        protected void GridView1_SelectedIndexChanged(object sender, EventArgs e)
        {
            // Label1.Text = e.ToString();
        }

        protected void GridView1_RowCancelingEdit(object sender, GridViewCancelEditEventArgs e)
        {
            this.GridView1.EditIndex = -1;
            Bind();
        }

        protected void GridView1_RowEditing(object sender, GridViewEditEventArgs e)
        {
            this.GridView1.EditIndex = e.NewEditIndex;
            Bind();
        }               

        protected void DropDownList1_DataBound(object sender, EventArgs e)
        {
            DropDownList1.Items.Insert(0, new ListItem("全部频道", "全部频道")); 
        }

        protected void GridView1_RowCreated(object sender, GridViewRowEventArgs e)
        {
        }

        protected void GridView1_SelectedIndexChanging(object sender, GridViewSelectEventArgs e)
        {
            //Label1.Text = "asdsadasd";
        }

        protected void Button1_Click(object sender, EventArgs e)
        {

            string sqlstr,strID = txtID.Text.Trim();
            string strTapeGuid = txtTapeGuid.Text.Trim();
            string strClipName = txtstrClipName.Text.Trim();
            string alstr = "";
            string strsender = "";
            string receiver = Session["username"].ToString();
            DateTime pd = new DateTime(), rd = new DateTime(), tin = new DateTime();
  
            try
            {
                pd = Convert.ToDateTime(txttPlayDate.Text);
                
                if (pd < DateTime.Now.Date && tapestate.Text == "待处理")
                    alstr = "待处理磁带播出日期不能早于当前日期！！";
                rd = Convert.ToDateTime(txttReserveDate.Text);
                if (pd > rd)
                    alstr = "保留日期不能早于播出日期！！";
                tin = Convert.ToDateTime(TapeInTime.Text);
                if (tin > DateTime.Now)
                    alstr = "送带时间不能晚于当前时间！！";
            }
            catch
            {
                alstr = "日期时间格式输入有误，请检查！";       
            }            
            if (hf1.Value == "3")
            {
                if ((string.IsNullOrEmpty(txtRecvGuid.Text.Trim())) && (string.IsNullOrEmpty(Username2.Text.Trim())))
                    alstr = "编辑特殊字段必须认证确认人员！";
                else
                {
                    SqlDataReader sqldr = CheckUser.CheckUserLogin(txtRecvGuid.Text, Username2.Text, Password2.Text);
                    if (sqldr == null)
                        alstr = "确认人员认证失败，请确认用户条码或者用户名密码正确！";
                    else if (sqldr["qx"].ToString()=="管理员")
                        receiver = sqldr["username"].ToString();
                    else alstr = "编辑特殊字段需要管理员权限！！";
                }
                if ((!string.IsNullOrEmpty(txtSenderGuid.Text.Trim())) || (!string.IsNullOrEmpty(txtUserName.Text.Trim())))
                {
                    SqlDataReader sqldr = CheckUser.CheckUserLogin(txtSenderGuid.Text, txtUserName.Text, txtPassword.Text);
                    if (sqldr == null)
                        alstr = "送带人认证失败，请确认用户条码或者用户名密码正确！";
                    else
                    {
                        strsender = sqldr["username"].ToString();
                        sqldr.Dispose();
                    }
                }
            }            
            if (!Check.CheckClip(strClipName, strTapeGuid, strID))
                alstr = "磁带条码或节目名称与其它素材重复，请检查！";
            if (!string.IsNullOrEmpty(alstr))
                ScriptManager.RegisterClientScriptBlock(UpdatePanel1, typeof(UpdatePanel), "123", "alert('" + alstr + "');", true);//setdisplay(0);
            else   //如果节目不重复
            {
                string tPlayTime = string.IsNullOrEmpty(txttPlayTimeH.Text.Trim()) ? "" : (txttPlayTimeH.Text + ":" + txttPlayTimeM.Text + ":" + txttPlayTimeS.Text);
                string dur = string.IsNullOrEmpty(txtstrDurationH.Text.Trim()) ? "" : (txtstrDurationH.Text + ":" + txtstrDurationM.Text + ":" + txtstrDurationS.Text);
                sqlstr = "update Tape set strTapeID='" + txtTapeID.Text +  "',strClipName='"+ txtstrClipName.Text + "',tPlayDate='"+ pd + "',tReserveDate='" + rd 
                    + "',strDuration='" + dur + "',strChnName='"+ DrpChnName.Text + "',tPlayTime='" + tPlayTime + "',strTapeLocation='" + DrpTapeLocation.Text+ "',strLogicID='";
                string lid = txtstrLogicID.Text.ToString().Trim();  
                if (hf1.Value == "3")
                {
                    if (tapestate.Text.ToString() == "已删除")
                        lid = Check.newid(strID,"","");                                         
                    sqlstr +=lid+ "',strTapeGuid='" + txtTapeGuid.Text.Trim() + "',TapeInTime='" + tin + "',strTapeState='" + tapestate.Text;
                    if (!string.IsNullOrEmpty(strsender))
                        sqlstr += "',sendusername='" + strsender;
                }
                else sqlstr += lid;
                sqlstr +="' where ID=" + strID;             
                CmdExecute.Execute(sqlstr);
                sqlstr = "insert into TapeOpLog(TapeGuid,Opuser,OpTime,OpName) values ('" + txtTapeGuid.Text + "','" + receiver + "','"
                    + DateTime.Now.ToString() + "','修改')";
                CmdExecute.Execute(sqlstr);
                hf1.Value = "1";
            }

            Bind();            
        }       

        protected void DS_DataBound(object sender, EventArgs e)
        {
            DplSender.Items.Insert(0, new ListItem("", ""));            
        }

        protected void DpL_DataBound(object sender, EventArgs e)
        {
            DpLocation.Items.Insert(0, new ListItem("所有位置", "所有位置"));
        }

        protected void LinkButton1_Click(object sender, EventArgs e)
        {
        }

        protected void DelChecked(object sender, EventArgs e)
        {
            //CollectSelected();
            int count = 0,ncount=0;
            for (int i = 0; i < GridView1.Rows.Count; i++)
            {
                CheckBox cb = GridView1.Rows[i].FindControl("CheckBox1") as CheckBox;
                if (cb.Checked)
                {                    
                    string strID = "", strLID = "", orist = "";                    
                    try
                    {
                        strID = GridView1.DataKeys[i]["ID"].ToString();//数据行编号
                        strLID = (GridView1.Rows[i].Cells[3].Controls[0] as DataBoundLiteralControl).Text.Trim();//原节目ID
                        orist = (GridView1.Rows[i].Cells[12].Controls[0] as DataBoundLiteralControl).Text.Trim();//原状态
                        CmdExecute.Execute("update Tape set strTapeState='已删除',strLogicID='" + Check.newid(strID, strLID, orist) + "' where ID=" + strID);
                        string guid = ((DataBoundLiteralControl)GridView1.Rows[i].Cells[5].Controls[0]).Text.Trim();
                        CmdExecute.Execute("insert into TapeOpLog(TapeGuid,Opuser,OpTime,OpName) values ('" + guid + "','" + Session["username"].ToString() + "','" + DateTime.Now + "','删除')");
                        count++;
                    }
                    catch { ncount++; }                    
                }
            }
            string alstr = "已删除" + count.ToString() + "条记录到回收站";
            if (ncount > 0)
                alstr += "，有" + ncount.ToString() + "记录删除操作失败";
            ScriptManager.RegisterClientScriptBlock(UpdatePanel1, typeof(UpdatePanel), "323", "alert('" + alstr + "');", true);
            Bind();
            ViewState["SI"] = null;
        }

        protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {//删除磁带信息
            string strID = "", strLID = "", orist = "";
            ViewState["SI"] = Check.CollectSelected(this.GridView1.Rows, 13, (ArrayList)ViewState["SI"]);
            try
            {
                strID = GridView1.DataKeys[e.RowIndex]["ID"].ToString();//数据行编号
                strLID = (GridView1.Rows[e.RowIndex].Cells[3].Controls[0] as DataBoundLiteralControl).Text.Trim();//原节目ID
                orist = (GridView1.Rows[e.RowIndex].Cells[12].Controls[0] as DataBoundLiteralControl).Text.Trim();//原状态
            }
            catch { }
            SqlConnection sqlcon = new SqlConnection(System.Configuration.ConfigurationManager.ConnectionStrings["TapeManageConnectionString"].ToString());
            sqlcon.Open();
            SqlCommand cmd = sqlcon.CreateCommand();
            
            cmd.CommandText = "update Tape set strTapeState='已删除',strLogicID='" + Check.newid(strID,strLID,orist) + "' where ID=" + strID;
            if (cmd.ExecuteNonQuery() == 1)
            {
                Bind();
            }
            else
                Response.Write("系统操作数据库出错！！");

            string guid = ((DataBoundLiteralControl)GridView1.Rows[e.RowIndex].Cells[5].Controls[0]).Text.Trim();
            cmd.CommandText = "insert into TapeOpLog(TapeGuid,Opuser,OpTime,OpName) values ('" + guid + "','" + Session["username"].ToString() + "','" + DateTime.Now + "','删除')";
            cmd.ExecuteNonQuery();
            cmd.Dispose();
            sqlcon.Close();
            sqlcon.Dispose();
        }        
    }
}
