﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.Data.SqlClient;
using TapeManager.csfiles;

namespace TapeManager.admin
{
    public partial class UserManage : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {

            if (Session["username"] != null)
            {
                string username = Session["username"].ToString();
                string UserRole = Session["qx"].ToString();

                if (CheckUser.CheckUserRole(UserRole, "用户管理"))
                {
                    if (!IsPostBack)
                    {
                        Bind();
                        Btn_submit.Attributes.Add("onclick", "return checkSubmit()");
                    }
                }
                else
                {
                    Response.Redirect("../UserRoleError.htm");
                }
            }
            else
            {
                //导向登陆界面
                Response.Redirect("../login.aspx?linkname=用户管理");

            }
        }

        protected void DrplistQx_DataBound(object sender, EventArgs e)
        {
            DrplistQx.Items.Insert(0,new ListItem("全部人员",""));
        }

        private void Bind()
        {
            string sqlstr = "select * from users";
            if ((DrplistQx.Text != "") || (txtUsername.Text != ""))
            {
                int j = 0;
                sqlstr += " where";
                if (DrplistQx.Text != "")
                {
                    sqlstr += " qx='" + DrplistQx.Text + "'";
                    j++;
                }
                if (txtUsername.Text != "")
                {
                    if (j == 0)
                    {
                        sqlstr += " username like '%" + txtUsername.Text + "%'";
                    }
                    else
                    {
                        sqlstr += " and username like '%" + txtUsername.Text + "%'";
                    }
                
                }       
            }

            DataSet ds = CmdExecute.ExecuteDataSet(sqlstr, "users");
            GridView1.DataSource = ds;
            GridView1.DataBind();
            ds.Dispose();
            username.Text = "";
            password.Text = "";
            userguid.Text = "";
            txtID.Text = "";
            DropDownList1.SelectedIndex = 0;
  

        }

        protected void Btn_Query_Click(object sender, EventArgs e)
        {
            Bind();
        }

        protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                //为GridView数据行添加onmouseover事件JavaScript事件处理脚本
                // 使鼠标悬停时首先使用变量记录当前数据行背景色，再将数据行背景色变为天蓝色
                e.Row.Attributes.Add("onmouseover", "this.style.cursor='hand'");
                //  e.Row.Attributes.Add("onmouseover", "mouseover(this);");



                //为GridView数据行添加onmouseout事件JavaScript事件处理脚本
                //当鼠标移出当前数据行时  使数据行背景色恢复为原来的颜色
                //  e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=oldColor;");
                //   e.Row.Attributes.Add("onmouseout", "mouseout(this);");
                //获取当前数据行中第6列的第一个控件 即删除链接
                try
                {

                    LinkButton btn = e.Row.Cells[5].Controls[0] as LinkButton;
                    Label LblUsername = e.Row.Cells[0].FindControl("LblUsername") as Label;
                    //添加弹出询问对话框的JavaScript脚本
                    btn.Attributes.Add("onclick", "return confirm('您确定要删除【" + LblUsername.Text + "】吗？');");
                }
                catch { };
                e.Row.Attributes.Add("onclick", "selectx(this)");
            }
            //e.Row.Attributes.Add("onclick", "javascirpt:__doPostBack('GridView1','Select$" + e.Row.RowIndex + "')");
            
        }

        protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {
            string strID = GridView1.DataKeys[e.RowIndex]["ID"].ToString();
            SqlConnection sqlcon = new SqlConnection(System.Configuration.ConfigurationManager.ConnectionStrings["TapeManageConnectionString"].ToString());
            sqlcon.Open();
            SqlCommand cmd = sqlcon.CreateCommand();
            cmd.CommandText = "delete from users where ID=" + strID;
            if (cmd.ExecuteNonQuery() == 1)
            {
                Bind();
            }
            else
            {

                Response.Write("系统操作数据库出错！！");

            }
            cmd.Dispose();
            sqlcon.Close();
            sqlcon.Dispose();

        }

        protected void DropDownList1_DataBound(object sender, EventArgs e)
        {
            DropDownList1.Items.Insert(0, new ListItem("", ""));
        }

        protected void Btn_submit_Click(object sender, EventArgs e)
        {

            string strID = txtID.Text.Trim();
            string strUserName = username.Text.Trim();
            string strPassword = password.Text.Trim();
            string strUserGuid = userguid.Text;
            string qx = DropDownList1.Text;
            string sqlstr;
            string checkresult=CheckUser.CheckUserRepeat(strUserName, strUserGuid, strID);
            if (checkresult!= "成功")
            {
                //报警
                ScriptManager.RegisterClientScriptBlock(UpdatePanel1, typeof(UpdatePanel), "123", "alert('" + checkresult + "');", true);
                return;
            }
            else
            {
                if (!string.IsNullOrEmpty(strID))
                {
                    //执行Update操作
                    sqlstr = "update users set username='" + strUserName + "',strpassword='" + strPassword + "',UserGuid='"
                        + strUserGuid + "',qx='" + qx + "' where ID=" + strID;
                }
                else
                {
                    //执行Insert操作
                    sqlstr = "insert into users (username,strpassword,UserGuid,qx) values ('" + strUserName + "','" + strPassword
                        + "','" + strUserGuid + "','" + qx + "')";
                }
                CmdExecute.Execute(sqlstr);
                Bind();
            }
        }

    }
}
//SortExpression="strClipName"