﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.Data.SqlClient;
using System.Text.RegularExpressions;
using TapeManager.csfiles;

namespace TapeManager.admin
{
    public partial class UserRoleManage : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["username"] != null)
            {
                string UserRole = Session["qx"].ToString();
                if (CheckUser.CheckUserRole(UserRole, "用户角色管理"))
                {

                    if (!IsPostBack)
                    {
                        Btn_Del.Attributes.Add("onclick", "return checkdel()");
                        BindAll();
                    }
                }
                else
                {

                    Response.Redirect("../UserRoleError.htm");
                }
                    
            }
            else
            {
                Response.Redirect("../login.aspx?linkname=用户角色管理");
            }
        }
        private void BindAll()
        {
            ListUserRoleBind();
            CheckListChnNameBind();
            ChkListLinkMapBind();
            CheckListTapeLocationBind();
            ChkListMenuNodeBind();
        
        }



        protected void ListUserRole_SelectedIndexChanged(object sender, EventArgs e)
        {
            string sqlstr = "select * from UserRole where RoleName='" + ListUserRole.Text + "'";
            DataSet ds = CmdExecute.ExecuteDataSet(sqlstr, "UserRole");
            string ManageChnName = ds.Tables[0].Rows[0]["ManageChnName"].ToString();
            string ManageTapeLocation = ds.Tables[0].Rows[0]["ManageTapeLocation"].ToString();
            string LinkNames = ds.Tables[0].Rows[0]["LinkNames"].ToString();
            string MenuNodes = ds.Tables[0].Rows[0]["MenuNodes"].ToString();
            checkboxselect(ManageChnName, ChkListChannel);
            checkboxselect(ManageTapeLocation, ChkListTapeLocation);
            checkboxselect(LinkNames, ChkListLinkMap);
            checkboxselect(MenuNodes, ChkListMenuNode);
            ds.Dispose();
     
        }

        protected void ChkListTapeLocation_DataBound(object sender, EventArgs e)
        {
            ChkListTapeLocation.Items.Insert(0,new ListItem ("全部位置","全部位置"));
        }
        private void ListUserRoleBind()
        {
            string sqlstr = "select * from UserRole";
            SqlConnection sqlcon = new SqlConnection(System.Configuration.ConfigurationManager.ConnectionStrings["TapeManageConnectionString"].ToString());
            sqlcon.Open();
            SqlDataAdapter adp = new SqlDataAdapter(sqlstr, sqlcon);
            //  adp.SelectCommand=sqlstr;
            DataSet ds = new DataSet();
            adp.Fill(ds, "UserRole");
            ListUserRole.DataSource = ds;
            ListUserRole.DataBind();
            ds.Dispose();
            adp.Dispose();
            sqlcon.Close();
            sqlcon.Dispose();
        }
        private void CheckListChnNameBind()
        {
            string sqlstr = "select * from Channel";
            SqlConnection sqlcon = new SqlConnection(System.Configuration.ConfigurationManager.ConnectionStrings["TapeManageConnectionString"].ToString());
            sqlcon.Open();
            SqlDataAdapter adp = new SqlDataAdapter(sqlstr, sqlcon);
            //  adp.SelectCommand=sqlstr;
            DataSet ds = new DataSet();
            adp.Fill(ds, "ChnName");
            ChkListChannel.DataSource = ds;
            ChkListChannel.RepeatColumns = 2;
            ChkListChannel.DataBind();
            ds.Dispose();
            adp.Dispose();
            sqlcon.Close();
            sqlcon.Dispose();

        }
        private void CheckListTapeLocationBind()
        {
            string sqlstr = "select * from TapeLocation";
            SqlConnection sqlcon = new SqlConnection(System.Configuration.ConfigurationManager.ConnectionStrings["TapeManageConnectionString"].ToString());
            sqlcon.Open();
            SqlDataAdapter adp = new SqlDataAdapter(sqlstr, sqlcon);
            //  adp.SelectCommand=sqlstr;
            DataSet ds = new DataSet();
            adp.Fill(ds, "TapeLocation");
            ChkListTapeLocation.DataSource = ds;
            ChkListTapeLocation.RepeatColumns = 2;
            ChkListTapeLocation.DataBind();
            ds.Dispose();
            adp.Dispose();
            sqlcon.Close();
            sqlcon.Dispose();
        }
        private void ChkListMenuNodeBind()
        {
            string sqlstr = "select * from MenuNode order by SortOrder Desc";
            SqlConnection sqlcon = new SqlConnection(System.Configuration.ConfigurationManager.ConnectionStrings["TapeManageConnectionString"].ToString());
            sqlcon.Open();
            SqlDataAdapter adp = new SqlDataAdapter(sqlstr, sqlcon);
            //  adp.SelectCommand=sqlstr;
            DataSet ds = new DataSet();
            adp.Fill(ds, "MenuNode");
            ChkListMenuNode.DataSource = ds;
            ChkListMenuNode.DataBind();
            ds.Dispose();
            adp.Dispose();
            sqlcon.Close();
            sqlcon.Dispose();
        }
        private void ChkListLinkMapBind()
        {
            string sqlstr = "select * from LinkMap order by NodeName";
            SqlConnection sqlcon = new SqlConnection(System.Configuration.ConfigurationManager.ConnectionStrings["TapeManageConnectionString"].ToString());
            sqlcon.Open();
            SqlDataAdapter adp = new SqlDataAdapter(sqlstr, sqlcon);
            //  adp.SelectCommand=sqlstr;
            DataSet ds = new DataSet();
            adp.Fill(ds, "LinkMap");
            ChkListLinkMap.DataSource = ds;
            ChkListLinkMap.RepeatColumns = 2;
            ChkListLinkMap.DataBind();
            ds.Dispose();
            adp.Dispose();
            sqlcon.Close();
            sqlcon.Dispose();
        }


        protected void ChkListChannel_DataBinding(object sender, EventArgs e)
        {
            //string UserRole = ListUserRole.Text;
        }


        private static void checkboxselect(string ChnNames,CheckBoxList chkbox)
        {

            for (int i = 0; i < chkbox.Items.Count; i++)
            {
                Regex  r = new Regex("\\b" + chkbox.Items[i] .Text+ "\\b");
                Regex  r2 = new Regex("\\b全部");
                if (r.Match(ChnNames).Success||r2.Match(ChnNames).Success)
                {
                    chkbox.Items[i].Selected = true;
                }
                else
                {
                    chkbox.Items[i].Selected = false;
                }
            }
        }


        private static string getcheckItems(CheckBoxList chkbox)
        {
            string ItemStrings = "";
            int j = 0;
            for (int i = 0; i < chkbox.Items.Count; i++)
            {
                if (chkbox.Items[i].Selected)
                {
                    
                    if (j == 0)
                    {
                        ItemStrings = ItemStrings + chkbox.Items[i].Text;
                    }
                    else
                    {
                        ItemStrings = ItemStrings + "," + chkbox.Items[i].Text;
                    
                    }
                    j++;
                }
            }
            return ItemStrings;
        }
        
        protected void Btn_submit_Click(object sender, EventArgs e)
        {
            string ManageChnName = getcheckItems(ChkListChannel);
            string ManageTapeLocation = getcheckItems(ChkListTapeLocation);
            string LinkNames = getcheckItems(ChkListLinkMap);
            string MenuNodes = getcheckItems(ChkListMenuNode);
            string RoleName = ListUserRole.Text;
            string sqlstr = "update UserRole set ManageChnName='" + ManageChnName + "',ManageTapeLocation='" + ManageTapeLocation
                + "',LinkNames='" + LinkNames + "',MenuNodes='" + MenuNodes + "' where RoleName='" + RoleName+"'";
            CmdExecute.Execute(sqlstr);
            alert("权限设置成功！");


        }

        protected void ChkListChannel_DataBound(object sender, EventArgs e)
        {
            ChkListChannel.Items.Insert(0, new ListItem("全部频道", "全部频道"));
        }

        protected void Btb_Add_Click(object sender, EventArgs e)
        {
            string UserRole = txtNewUserRole.Text.Trim();
            if (!Check.CheckUserRoleRepeat(UserRole))  //如果没有重复，那么Insert
            {
                string sqlstr = "insert into UserRole (RoleName,ManageChnName,ManageTapeLocation,LinkNames,MenuNodes) values ('"
                    + UserRole + "','','','','')";
                CmdExecute.Execute(sqlstr);
                alert("添加成功！");
                txtNewUserRole.Text = "";
                BindAll();
            }
            else
            {

                Response.Write("<script type='text/javascript' language='javascript'>");
                Response.Write("alert('用户角色名称重复，请重新添加！');");
                Response.Write("</script>");
            };
        }

        protected void Btn_Del_Click(object sender, EventArgs e)
        {
            string UserRole = ListUserRole.Text.Trim();            
            string sqlstr = "delete UserRole where RoleName='"+UserRole+"'";
            CmdExecute.Execute(sqlstr);
            alert("删除成功！");
            txtNewUserRole.Text = "";
            BindAll();
            
        }
        public void alert(string alertstr)
            {
                Response.Write("<script type='text/javascript' language='javascript'>");
                Response.Write("alert('"+alertstr+"');");
                Response.Write("</script>");
            
            }




        }

}
