﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.Data.SqlClient;
using System.Text.RegularExpressions;
using TapeManager.csfiles;

namespace TapeManager
{
    public partial class _return : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {

            if (Session["username"] != null)
            {
                string username = Session["username"].ToString();
                string UserRole = Session["qx"].ToString();

                if (CheckUser.CheckUserRole(UserRole, "退带管理"))
                {

                    SqlDataReader sqldr1 = CheckUser.GetUserRoleReader(UserRole);
                    //string ManageTapeLocation = sqldr1["ManageTapeLocation"].ToString();
                    sqldr1.Close();
                    sqldr1.Dispose();
                    if (!IsPostBack)
                    {                       
                        LblTile.Text = "您好：【 " + username + "】   欢迎使用磁带管理系统";
                        Btn_confirmChangeStat.Attributes.Add("onclick", "return checkSubmit()");
                        delcheck.Attributes.Add("onclick", "return confirm('您确定要删除选中记录吗？');");
                    }

                }
                else
                {
                    Response.Redirect("UserRoleError.htm");

                }

            }
            else
            {
                //导向登陆页面
                Response.Redirect("Login.aspx?linkname=退带管理");

            }
        }

        protected void On_BC(object sender, EventArgs e)
        {
            
            DataTable tb = (DataTable)ViewState["tb"];
            if (tb != null)
            {
                    tb.Rows[tb.Rows.Count-1].Delete();
                    tb.AcceptChanges();
                    ViewState["tb"] = tb;
                    Bind();
                    tb.Dispose();
            }                            
            
            ScriptManager.RegisterClientScriptBlock(UpdatePanel1, typeof(UpdatePanel), "bc", "document.all.txtstrTapeGuid.focus();", true);                    
            //Response.Write("test");
        }

        protected void TextBox1_TextChanged(object sender, EventArgs e)
        {
            SqlConnection sqlcon = new SqlConnection(System.Configuration.ConfigurationManager.ConnectionStrings["TapeManageConnectionString"].ToString());
            sqlcon.Open();
            SqlCommand sqlcmd = sqlcon.CreateCommand();
            string strTapeGuid = txtstrTapeGuid.Text;
            sqlcmd.CommandText = "select * from Tape where strTapeGuid='" + strTapeGuid + "'";
            SqlDataAdapter adpt = new SqlDataAdapter();
            DataSet ds = new DataSet();            
            adpt.SelectCommand = sqlcmd;
            adpt.Fill(ds, "SelectTape");

            if (ds.Tables[0].Rows.Count != 1)//只处理一档节目
            {
                Label1.Text = "未查到该磁带信息，请确定该节目已登记";
            }
            else if (ds.Tables[0].Rows[0]["strTapeState"].ToString().Trim() == "待处理")
                Label1.Text = "磁带未通过审核,不可调拨";            
            else
            {
                Label1.Text = "";
                DateTime tre = (DateTime)ds.Tables[0].Rows[0]["tReserveDate"]; 
                //*
                string loca=ds.Tables[0].Rows[0]["strTapeLocation"].ToString();
                if ((loca != "导播科退带") && (loca != "频道"))
                {
                    dl1.Text = "导播科退带";
                    dl1.Enabled = false;
                }//*/
                if (DateTime.Now.Date <= tre)
                {
                    Label1.Text = "该磁带尚在保留期";
                    ScriptManager.RegisterClientScriptBlock(UpdatePanel1, typeof(UpdatePanel), "s12", "show_confirm();", true);
                }
                else if (ds.Tables[0].Rows[0]["strTapeState"].ToString().Trim() != "可调拨")
                {
                    Label1.Text = "该磁带已退带至【" + loca + "】，或磁带记录已删除";
                    ScriptManager.RegisterClientScriptBlock(UpdatePanel1, typeof(UpdatePanel), "s11", "show_confirm2('" + Label1.Text + "');", true);
                }
                DataRow dr = ds.Tables[0].NewRow();
                DataTable tb = (DataTable)ViewState["tb"];

                for (int i = 0; i < ds.Tables[0].Columns.Count; i++)
                {
                    dr[i] = ds.Tables[0].Rows[0][i];
                }
                if (tb != null)
                {
                    DataRow[] dr2 = tb.Select("strTapeGuid='" + strTapeGuid + "'");
                    if (dr2.Length < 1)
                    {
                        //tb.Rows.Find("strTapeGuid",
                        tb.Rows.Add(dr.ItemArray);
                        ViewState["tb"] = tb;
                    }
                }
                else
                {   //首次初始化表结构
                    tb = ds.Tables[0].Clone();
                    tb.Rows.Add(dr.ItemArray);
                    ViewState["tb"] = tb;
                }                
                tb.Dispose();
            }
            Bind();
            ds.Dispose();
            adpt.Dispose();
            sqlcmd.Dispose();
            sqlcon.Close();
            sqlcon.Dispose();
        }

        private void Bind()
        {
            DataTable tb = (DataTable)ViewState["tb"];
            ViewState["SI"] = Check.CollectSelected(this.GridView1.Rows, 3, (ArrayList)ViewState["SI"]);
            if (tb != null)
            {
                LblClipCount.Text = "共有【" + tb.Rows.Count.ToString() + "】条记录待调播";
                GridView1.Columns[7].Visible = false;
                GridView1.DataSource = tb;
                GridView1.DataBind();
                tb.Dispose();
            }
            else
            {
                LblClipCount.Text = "";
            }
            txtstrTapeGuid.Text = "";
            ScriptManager.RegisterClientScriptBlock(UpdatePanel1, typeof(UpdatePanel), "getfocus", "document.all.txtstrTapeGuid.focus();", true);
            txtstrTapeGuid.Focus();
        }

        protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                Check.RDB(e.Row, (ArrayList)ViewState["SI"], "strClipName");
            }
        }

        protected void DelChecked(object sender, EventArgs e)
        {
            DataTable tb = (DataTable)ViewState["tb"];
            if (tb != null && tb.Rows.Count != 0)
            {
                for (int i = 0, j = 0; i < GridView1.Rows.Count; i++)
                {
                    CheckBox cb = GridView1.Rows[i].FindControl("CheckBox1") as CheckBox;
                    if (cb.Checked)
                    {
                        tb.Rows.RemoveAt(i - j);
                        j++;
                    }
                }
                tb.AcceptChanges();
                ViewState["tb"] = tb;
                tb.Dispose();
                Bind();
            }
            else
                GridView1.DataBind();
            ViewState["SI"] = null;
        }

        protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {
            ViewState["SI"] = Check.CollectSelected(this.GridView1.Rows, 3, (ArrayList)ViewState["SI"]);
            DataTable tb = (DataTable)ViewState["tb"];
            if (tb != null && tb.Rows.Count != 0)
            {
                tb.Rows[e.RowIndex].Delete();
                tb.AcceptChanges();
                ViewState["tb"] = tb;
                Bind();
                tb.Dispose();
            }
            else
                GridView1.DataBind();
        }

        protected void Btn_confirmChangeStat_Click(object sender, EventArgs e)
        {

            string strConfirmUserGuid = txtConfirmUserGuid.Text;
            string strusername = txtusername.Text;
            string strpassword = txtstrPassword.Text;

            SqlDataReader sqldr = CheckUser.CheckUserLogin(strConfirmUserGuid, strusername, strpassword);

            if (sqldr != null)
            {
                //表明认证成功
                string ConfirmUserName = sqldr["username"].ToString();
                if (ViewState["tb"] == null || ((DataTable)ViewState["tb"]).Rows.Count<1)
                {
                    Label1.Text = "请扫描需要调播的磁带！！";
                }
                else if (ConfirmUserName == Session["username"].ToString())
                {
                    Label1.Text = "确认人和操作人不能相同！！";
                }
                else
                {
                    DataTable tb = (DataTable)ViewState["tb"];
                    for (int i = 0; i < tb.Rows.Count; i++)
                    {
                        //  向调播表中插入记录；
                        string strTapeGuid = tb.Rows[i]["strTapeGuid"].ToString();
                        string desLocation = dl1.Text.ToString().Trim();
                        string sqlstr = "insert into Tape_transfer (strTapeGuid,Opuser,ConfirmUser,OpTime,srcLocation,DesLocation) values ('"
                            + tb.Rows[i]["strTapeGuid"].ToString() + "','" + Session["username"].ToString() + "','" + ConfirmUserName + "','" 
                            + DateTime.Now.ToString() + "','" + tb.Rows[i]["strTapeLocation"].ToString() + "','" + desLocation + "')";
                        CmdExecute.Execute(sqlstr);                        
                        /*string newstate;//修改Tape表中
                        if (ck1.Checked )
                            newstate="问题带";
                        else if (desLocation=="频道")
                            newstate="已删除";
                        else
                            newstate="已退带";*/
                        sqlstr = "update Tape set strTapeLocation='" + dl1.Text + "' ,strTapeState='" + (ck1.Checked ? "问题带" : "已退带") + "'where strTapeGuid='" + strTapeGuid + "'";
                        CmdExecute.Execute(sqlstr);
                        if (ck1.Checked)
                        {//插入操作记录，标记问题带
                            sqlstr = "insert into TapeOpLog (TapeGuid,OpUser,OpTime,OpName) values ('" + tb.Rows[i]["strTapeGuid"].ToString() + "','"
                                + Session["username"].ToString() + "','" + DateTime.Now.ToString() + "','标记问题')"; ;
                            CmdExecute.Execute(sqlstr);
                        }
                    }
                    string s = "已完成以下【" + tb.Rows.Count.ToString() + "】盘磁带退回" + dl1.Text + "的调拨！！";
                    ScriptManager.RegisterClientScriptBlock(UpdatePanel1, typeof(UpdatePanel), "new", "alert('" + s +"');", true);
                    tb.Dispose();
                    // 清除viewstate
                    ViewState["tb"] = null;
                    txtstrTapeGuid.Text = "";
                    txtConfirmUserGuid.Text = "";
                    txtusername.Text = "";
                    txtstrPassword.Text = "";
                    //DropDownList1.SelectedIndex = 0;
                    Label1.Text = "";
                    Bind();
                    LblClipCount.Text = s;
                    dl1.Enabled = true;
                    ViewState["SI"] = null;
                }
            }
            else
            {
                Label1.Text = "确认人员认证失败，请确认用户条码或者用户名密码正确！";

            }
            sqldr.Close();
            sqldr.Dispose();

        }

    }
}
