﻿using System;
using System.Collections.Generic;
using System.Web;


public class DataAccess : IDataProvider
{
    public System.Data.DataTable ReadStudent()
    {
        using (AccessHelper helper = new AccessHelper())
        {
            helper.Command.CommandText = "select * from [Students]";
            helper.Open();
            return helper.ReadTable();
        }
    }

    public System.Data.DataTable DeleteStudent(int student_id)
    {
        using (AccessHelper helper = new AccessHelper())
        {
            helper.Command.CommandText = "delete from [Students] where stid=@stid";
            helper.AddParameter("@stid", System.Data.OleDb.OleDbType.VarChar, student_id);
            helper.Open();
            helper.ExecuteNoneQuery();
            helper.Command.Parameters.Clear();

            helper.Command.CommandText = "select * from [Students]";
            return helper.ReadTable();
        }
    }

    public System.Data.DataTable AddStudent(string studentname, string stu_class)
    {
        using (AccessHelper helper = new AccessHelper())
        {
            helper.Command.CommandText = "insert into [Students]([student_name],[class])values(@student_name,@class)";
            helper.AddParameter("@student_name", System.Data.OleDb.OleDbType.VarChar, 255, studentname);
            helper.AddParameter("@class", System.Data.OleDb.OleDbType.VarChar, 255, stu_class);
            helper.Open();
            helper.ExecuteNoneQuery();
            helper.Command.Parameters.Clear();
            helper.Command.CommandText = "select * from [Students]";
            return helper.ReadTable();
        }
    }
}