﻿using System;
using System.Collections.Generic;
using System.Web;
using www.dbhelper.org.SqlHelper;
using System.Data;
using System.Data.OracleClient;

public class DataOracle : IDataProvider
{
    public System.Data.DataTable ReadStudent()
    {
        using (OracleHelper helper = new OracleHelper())
        {
            helper.Command.CommandText = "select * from dtStudents";
            helper.Open();
            return helper.ReadTable();
        }
    }

    public System.Data.DataTable DeleteStudent(int student_id)
    {
        using (OracleHelper helper = new OracleHelper())
        {
            helper.Command.CommandText = "delete from dtStudents where stid=:stid";
            helper.AddParameter(":stid", OracleType.Int32, student_id);
            helper.Open();
            helper.ExecuteNoneQuery();
            helper.Command.Parameters.Clear();
            helper.Command.CommandText = "select * from dtStudents";
            return helper.ReadTable();
        }
    }

    public System.Data.DataTable AddStudent(string studentname, string stu_class)
    {
        using (OracleHelper helper = new OracleHelper())
        {
            helper.Command.CommandText = "insert into dtStudents(stid,student_name,class)values(dtstudents_autoid.nextVal, :student_name,:class)";
            helper.AddParameter(":student_name", OracleType.VarChar, 255, studentname);
            helper.AddParameter(":class", OracleType.VarChar, 255, stu_class);
            helper.Open();
            helper.ExecuteNoneQuery();
            helper.Command.Parameters.Clear();
            helper.Command.CommandText = "select * from dtStudents";
            return helper.ReadTable();
        }
    }
}