﻿using System;
using System.Collections.Generic;
using System.Web;
using www.dbhelper.org.SqlHelper;
using System.Data.SqlClient;
using System.Data;

public class DataSqlServer: IDataProvider
{
    public System.Data.DataTable ReadStudent()
    {
        using (SqlServerHelper helper = new SqlServerHelper())
        {
            helper.Command.CommandText = "select * from [Students]";
            helper.Open();
            return helper.ReadTable();
        }
    }

    public System.Data.DataTable DeleteStudent(int student_id)
    {
        using (SqlServerHelper helper = new SqlServerHelper())
        {
            helper.Command.CommandText = "delete from [Students] where stid=@stid";
            helper.AddParameter("@stid", SqlDbType.Int, student_id);
            helper.Open();
            helper.ExecuteNoneQuery();
            helper.Command.Parameters.Clear();
            helper.Command.CommandText = "select * from [Students]";
            return helper.ReadTable();
        }
    }

    public System.Data.DataTable AddStudent(string studentname, string stu_class)
    {
        using (SqlServerHelper helper = new SqlServerHelper())
        {
            helper.Command.CommandText = "insert into [Students]([student_name],[class])values(@student_name,@class)";
            helper.AddParameter("@student_name", SqlDbType.VarChar, 255, studentname);
            helper.AddParameter("@class", SqlDbType.VarChar, 255, stu_class);
            helper.Open();
            helper.ExecuteNoneQuery();
            helper.Command.Parameters.Clear();
            helper.Command.CommandText = "select * from [Students]";
            return helper.ReadTable();
        }
    }
}