﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using www.dbhelper.org.SqlHelper;
using System.Data.SqlClient;
using System.Data.OracleClient;

public partial class _Default : System.Web.UI.Page
{
    protected override void OnInit(EventArgs e)
    {
        btn_add.Click += new EventHandler(btn_add_Click);
        btn_add_oracle.Click += new EventHandler(btn_add_oracle_Click);
        btn_add_sqlserver.Click += new EventHandler(btn_add_sqlserver_Click);
        g1.RowCommand += new GridViewCommandEventHandler(g1_RowCommand);
        dropdownlist_dbtype.SelectedIndexChanged += new EventHandler(dropdownlist_dbtype_SelectedIndexChanged);
        base.OnInit(e);
    }

    void btn_add_sqlserver_Click(object sender, EventArgs e)
    {
        using (SqlConnection conn = SqlServerHelper.GetConnection())
        {
            conn.Open();
            SqlServerHelper.ExecuteNonQuery(conn,CommandType.Text,"insert into [students] values(@student_name,@class)",
                SqlServerHelper.CreateInputParameter("@student_name", SqlDbType.NVarChar, 100, txt_student_name_sqlserver.Text),
                SqlServerHelper.CreateInputParameter("@class", SqlDbType.NVarChar, 100, txt_class_sqlserver.Text)
                );
            g1.DataSource = SqlServerHelper.ReadTable(conn, CommandType.Text, "select * from [students]", null);
            g1.DataBind();
        }
    }

    void btn_add_oracle_Click(object sender, EventArgs e)
    {
        using (OracleConnection conn = OracleHelper.GetConnection())
        {
            conn.Open();
            OracleHelper.ExecuteNonQuery(conn, CommandType.Text, "insert into dtstudents values(dtstudents_autoid.nextval,:student_name,:class)",
                OracleHelper.CreateInputParameter(":student_name", OracleType.VarChar, 100, txt_student_name_oracle.Text),
                OracleHelper.CreateInputParameter(":class", OracleType.VarChar, 100, txt_class_oracle.Text)
                );
            g1.DataSource = OracleHelper.ReadTable(conn, CommandType.Text, "select * from dtstudents", null);
            g1.DataBind();
        }
    }

    void dropdownlist_dbtype_SelectedIndexChanged(object sender, EventArgs e)
    {
        bindgrid();
    }

    void g1_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "del")
        {
            IDataProvider provider = getProvider();
            if (provider != null)
            {
                bindgrid(provider.DeleteStudent(Convert.ToInt32(e.CommandArgument)));
            }
        }
    }

    void btn_add_Click(object sender, EventArgs e)
    {
        
        IDataProvider provider = getProvider();
        if (provider != null)
        {
            bindgrid(provider.AddStudent(txt_student_name.Text, txt_class.Text));
            txt_student_name.Text = txt_class.Text = "";
        }
    }

    IDataProvider getProvider()
    {
        IDataProvider provider =null;
        div_oracle.Visible = div_sql.Visible = false;
        if (dropdownlist_dbtype.SelectedIndex == 1)
        {//access
            provider = new DataAccess();
        }
        else if (dropdownlist_dbtype.SelectedIndex == 2)
        {//sqlserver
            provider = new DataSqlServer();
            div_sql.Visible = true;
        }
        else if (dropdownlist_dbtype.SelectedIndex == 3)
        {//oracle
            provider = new DataOracle();
            div_oracle.Visible = true;
        }
        return provider;
    }

    void bindgrid()
    {
        IDataProvider provider = getProvider();
        if (provider != null)
        {
            bindgrid(provider.ReadStudent());
        }
    }

    void bindgrid(DataTable dt)
    {
        g1.DataSource = dt;
        g1.DataBind();
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            bindgrid();
        }
    }
}