﻿//*-----------------------------------------------------------------
//=Copyright (C) 2010 7and7网络工作室
//=版权所有。 
//=文件名：DBHelper.cs
//=文件功能描述：数据访问基类
//=创建人：7and7
//=创建时间：2010/5/5
//=注意：此代码由CodeSmith工具自动生成，请不要在此修改代码，以免被覆盖。
//----------------------------------------------------------------*/
using System;
using System.Collections.Generic;
using System.Text;
using System.Data.SqlClient;
using System.Data;

namespace _7he7.DataBaseAccess.DBUtility
{
	/// <summary>
    /// 数据访问
    /// </summary>
	public class DBHelper
	{
		
		private SqlConnection _myConn;
        private SqlDataAdapter da;
        private SqlCommand sc;
        /// <summary>
		/// 取得数据库连接串
		/// </summary>
		public static readonly string connSql = System.Configuration.ConfigurationManager.ConnectionStrings["cmsSQL"].ConnectionString;

        /// <summary>
        /// 创建链接
        /// </summary>
        public DBHelper()
        {
			_myConn = new SqlConnection(connSql);
        }

        /// <summary>
        /// 关闭连接
        /// </summary>
        private void CloseConn()
        {
            _myConn.Close();
        }

        /// <summary>
        /// 通过存储过程返回表（无参数）
        /// </summary>
        /// <param name="proc">存储过程名称</param>
        /// <returns>DataTable</returns>
        public DataTable GetDataTableByProc(string proc)
        {
            using (DataTable dt = new DataTable())
            {
                using (da = new SqlDataAdapter(proc, _myConn))
                {
                    da.SelectCommand.CommandType = CommandType.StoredProcedure;
                    da.Fill(dt);
                    _myConn.Close();
                }
                return dt;
            }
        }

        /// <summary>
        /// 通过存储过程返回表（有参数）
        /// </summary>
        /// <param name="proc">存储过程名称</param>
        /// <param name="sc">参数集</param>
        /// <returns>DataTable</returns>
        public DataTable GetDataTableByProc(string proc, SqlParameter[] sc)
        {
            using (DataTable dt = new DataTable())
            {
                using (da = new SqlDataAdapter(proc, _myConn))
                {
                    da.SelectCommand.CommandType = CommandType.StoredProcedure;
                    da.SelectCommand.Parameters.AddRange(sc);
                    da.Fill(dt);
                    _myConn.Close();
                }
                return dt;
            }
        }

        /// <summary>
        /// 通过存储过程更新数据库
        /// </summary>
        /// <param name="Proc">存储过程名称</param>
        /// <param name="sc">参数集</param>
        /// <returns>bool</returns>
        public int UpdateByProc(string Proc, SqlParameter[] sc)
        {
            int result=0;
            _myConn.Open();
            using (this.sc = new SqlCommand(Proc, _myConn))
            {
                this.sc.CommandType = CommandType.StoredProcedure;
                this.sc.Parameters.AddRange(sc);
                result = this.sc.ExecuteNonQuery();
            }
			_myConn.Close();
			return result;
        }
		
		/// <summary> 
        /// 通过sql语句返回表
        /// </summary> 
        /// <param name="sql">Sql语句</param> 
        /// <returns>DataTable</returns> 
        public DataTable GetDataTableBySql(string sql)
        {
            try
            {
                using (DataTable dt = new DataTable())
                {
                    SqlDataAdapter da = new SqlDataAdapter(sql, _myConn);
                    da.Fill(dt);
                    _myConn.Close();
                    return dt;
                }
            }
            catch (Exception e)
            {
                throw new Exception(e.Message);
            }
            finally
            {
                _myConn.Close();
            }
        }
		
		/// <summary>
        /// 通过Sql语句更新数据库
        /// </summary>
        /// <param name="sql">sql语句</param>
        /// <returns>int</returns>
        public int ExecuteReturnInt(string sql)
        {
            using (SqlCommand exc = new SqlCommand(sql, _myConn))
            {
                int result = Convert.ToInt32(exc.ExecuteScalar());
                _myConn.Close();
                return result;
            }
        }
	}
}