﻿<%@ WebHandler Language="C#" Class="ReadDocLabelChilds" %>

using System;
using System.Web;
using System.Data;
using _7he7.DataBaseAccess.BLL;
//sign说明：0:普通节点，1：特殊节点，2：带正文标签的特殊节点，99：模板节点，98：正文节点
public class ReadDocLabelChilds : IHttpHandler {
        public string NodeId = "0";
        public string ac = "";
        public string txt = "";
        public string Text = "";
        public string  sign = "0";

		Class_7he7_com bll = new Class_7he7_com();
		_7he7.DataBaseAccess.Model.Class_7he7_com modelClass = new _7he7.DataBaseAccess.Model.Class_7he7_com();
        public void ProcessRequest(HttpContext context)
        {            
            context.Response.ContentType = "text/plain";
            NodeId = context.Request["node"] != null ? context.Request["node"].ToString() : "0";
            
            ac = context.Request["ac"] != null ? context.Request["ac"].ToString() : "";
            Text = context.Request["Text"] != null ? context.Request["Text"].ToString() : "";
            sign = context.Request["sign"] != null ? context.Request["sign"].ToString() : "0";
            if (NodeId.Trim() == "") NodeId = "0";

            switch (ac) 
            {
                case "":
                    if (NodeId != "") 
                    {
                        AppendNode(NodeId);
                            
                        context.Response.Write("[" + txt + "]");
                        context.Response.End();
                    }
                    break;
                case "addsame"://添加节点
                    if (Text.Trim() != "") 
                    {
                        Add(ac, context);
                    }
                    break;
                case "addchild"://添加节点
                    if (Text.Trim() != "")
                    {
                        Add(ac, context);
                    }
                    break;
                case "editname": //编辑节点
                    if ( Text.Trim() != "")
                    {
                        EditName(context);
                    }
                    break;
                case "del"://删除节点
                        DelNode(context);
                    break;
                case "move"://拖拽
                    Move(context);
                    break;

            }


            
           
        }
    


        /// <summary>
        /// 拖拽
        /// </summary>
        /// <param name="context"></param>
        private void Move(HttpContext context) 
        {
            string id_str = context.Request["id_str"] != null ? context.Request["id_str"].ToString() : "";//用于储存目标节点的父节点的所有子节点经过拖拽排序后的id串
            string point = context.Request["point"] != null ? context.Request["point"].ToString() : "";//辨别是排序还是添加
            string dropNode = context.Request["dropNode"] != null ? context.Request["dropNode"].ToString() : "";//被拖拽的节点ID
            string targetnodeParent = context.Request["targetnodeParent"] != null ? context.Request["targetnodeParent"].ToString() : "";//目标节点的父ID
            string targetnode = context.Request["targetnode"] != null ? context.Request["targetnode"].ToString() : "";//目标节点ID
            //移动到目标节点的子级
            if (point.Trim() == "append")
            {
                MoveAppendNode(dropNode, targetnode, context);
            }

            //above:移动到目标节点的上面,below:移动到目标节点的下面
            if (point.Trim() == "above" || point.Trim() == "below")
            {
                MoveAppendNode(dropNode, targetnodeParent, context);//如果不是在同级中拖拽的话，就要先进行移动到目标节点的子级

                MovePathNode(id_str, context);//排序
            }

        }

        /// <summary>
        /// 排序
        /// </summary>
        /// <param name="NodeIdStr">排序后的nodeID串</param>
        /// <param name="context"></param>
        private void MovePathNode(string NodeIdStr, HttpContext context) 
        {
            string[] NodeStr = NodeIdStr.Split('|');
            for (int i = 0; i < NodeStr.Length; i++)
            {
                if (NodeStr[i].ToString().Trim() != "")
                {
					modelClass = bll.LoadByID(int.Parse(NodeStr[i].ToString()));
					modelClass.Sort = i;
					bll.UpdateByID(modelClass);
                }
            }
        }

        /// <summary>
        /// 移动到目标节点的子级
        /// </summary>
        /// <param name="SnodeId">被拖拽的节点ID</param>
        /// <param name="DnodeId">目标节点ID</param>
        private void MoveAppendNode(string SnodeId, string DnodeId, HttpContext context) 
        {
            modelClass = bll.LoadByID(int.Parse(SnodeId));
            modelClass.ParentID = int.Parse(DnodeId);
            if (DnodeId == "0") return;
            try
            {
                bll.UpdateByID(modelClass);
            }
            catch
            {
                context.Response.Write("失败");
                context.Response.End();
                return;
            }
        }

        /// <summary>
        /// 删除
        /// </summary>
        /// <param name="context"></param>
        private void DelNode(HttpContext context) 
        {
            int value=isDelete(int.Parse(NodeId));
            if (value<1)
            {
                bll.DeleteByID(int.Parse(NodeId));
            }
            else if (value == 1)
            {
                context.Response.Write("1");
                context.Response.End();
                return;
            }
            //else
            //{
            //    context.Response.Write("2");
            //    context.Response.End();
            //    return;
            //}
        }

        /// <summary>
        /// 判断是否存在子目录或信息返回0可以删除 1存在子目录 2存在信息
        /// </summary>
        /// <param name="nid">节点ID</param>
        /// <returns></returns>
        private int isDelete(int nid)
        {
            int value = 0;
			if (bll.LoadTopByWhereOrder("", "parentID=" + nid, "").Rows.Count > 0)
            {
                value = 1;
            }
            //else
            //{
            //    if (BllInfo.GetListByTypeId(nid).Rows.Count > 0)
            //    {
            //        value = 2;
            //    }
            //}
            return value;
        }

        /// <summary>
        /// 修改分类
        /// </summary>
        /// <param name="context"></param>
        private void EditName(HttpContext context) 
        {
            modelClass = bll.LoadByID(int.Parse(NodeId));
            modelClass.Name = Text;
            bll.UpdateByID(modelClass);
        }

        /// <summary>
        /// 添加同级和下级分类
        /// </summary>
        private void Add(string ac, HttpContext context)
        {
            if (ac == "addsame")//如果是同级分类
            {
                _7he7.DataBaseAccess.Model.Class_7he7_com cacheModel = bll.LoadByID(int.Parse(NodeId));
                modelClass.ParentID = cacheModel.ParentID;
                modelClass.Sort = cacheModel.Sort;
                modelClass.Model = cacheModel.Model;
            }
            else //下级分类
            {
				_7he7.DataBaseAccess.Model.Class_7he7_com cacheModel = bll.LoadByID(int.Parse(NodeId));
                modelClass.ParentID = cacheModel.ClassID;
                modelClass.Model = cacheModel.Model;
            }
            modelClass.Name = Text;
            bll.Insert(modelClass);

            context.Response.Write(Text);
            context.Response.End();
        }

    
        /// <summary>
        /// 读取节点
        /// </summary>
        /// <param name="rootid"></param>
        private void AppendNode(string rootid) 
        {
            DataView dv = bll.LoadAll().DefaultView;
            dv.Sort = "Sort";
            dv.RowFilter="[parentID] = " + rootid;

            if (sign == "2")
            {
                txt = "{id:'" + rootid + "-s',text:'正文',sign:'98',leaf:true,draggable:false,singleClickExpand:true}";
                if (dv.Count > 0)
                {
                    txt = txt + ",";
                }
            }

            string href, hrefTarget;
            hrefTarget = "hrefTarget:'Model_Frame'";
            for (int i = 0; i < dv.Count; i++)
            {
                if (rootid == "0")
                {
                    //href = "href:'../ClassAttribute.aspx?ClassID=" + dv[i]["ClassID"].ToString() + "'";  //节点链接
                    //txt += "{id:'" + dv[i]["ClassID"].ToString() + "',text:'" + dv[i]["Name"].ToString().Trim() + "',yearnode:true,singleClickExpand:true,draggable:true,sign:'0'," + href + "," + hrefTarget + "}";
                    txt += "{id:'" + dv[i]["ClassID"].ToString() + "',text:'" + dv[i]["Name"].ToString().Trim() + "',yearnode:true,singleClickExpand:true,draggable:true,sign:'0'}";
                }
                else if (bll.LoadTopByWhereOrder("","parentID="+dv[i]["ClassID"].ToString(),"").Rows.Count < 1)
                {
                    txt += "{id:'" + dv[i]["ClassID"].ToString() + "',text:'" + dv[i]["Name"].ToString().Trim() + "',singleClickExpand:true,leaf:true}";
                }
                else
                {
                    txt += "{id:'" + dv[i]["ClassID"].ToString() + "',text:'" + dv[i]["Name"].ToString().Trim() + "',yearnode:true,singleClickExpand:true,draggable:true,sign:'0'}";
                }
                if (i < dv.Count - 1)
                {
                    txt += ",";
                }

            }  
        }

        public bool IsReusable
        {
            get
            {
                return false;
            }
        }
}