﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using MySql.Data.MySqlClient;

using Security;
namespace Security
{
    public partial class ArticleTree : PageBase
    {
		MysqlHelp mh = null;
		DataTable dt = null;
		string treeStr = "";
		
		///定义树节点的结构体
		struct ClassTreeNode{
			public string ID;
			public string Name;
			public string OutLinkHref;
			public int Level;
		}
		
		protected void Page_Load(object sender, EventArgs e)
        {
			if (!IsPostBack) 
			{ 
				
			}
			
			btnDelAll.Attributes.Add("onclick","return confirm(\"敬告：清除全站所有文章，数据无法恢复，您确定清空吗？\")") ;
			
			mh = new MysqlHelp();
			dt = mh.GetDatabysql("Select * From Class4DeepSoon Order By Id");
			
			    
            string delID = Request.QueryString["delClassID"];
			string delName = Request.QueryString["delClassName"];
			if(delID != null && delName != null){
				Response.Write("清空文章节点信息：ID="+delID+" Name="+delName+"<br>");
				mh.Runsql("Delete From Article4DeepSoon Where instr((Select ChildID From Class4DeepSoon Where ID = "+delID+" ),Article4DeepSoon.ClassID)>0");
				Response.Redirect("DeepSoonArticleTree.aspx");
			}
			
			
				
			///显示ID=?的节点+孩子节点，并设定层级初值level
			ClassTreeNode nd;
            nd.ID="0";               ///节点ID
            nd.Name="门户网";        ///节点Name
			nd.OutLinkHref = "";     ///节点外链OutLinkHref
			nd.Level=0;              ///节点Level
			showNodes(nd);
			
        }
		
		///显示节点+孩子节点
		private void showNodes(ClassTreeNode node)
        {
			this.showNodesFunction(node);
			this.myLabel.Text = treeStr;
			
		}
		///显示节点递归函数
		private void showNodesFunction(ClassTreeNode node)
        {			
			DataRow [] rows = dt.Select("fatherId = '"+node.ID+"'");///筛选node的孩子节点 
			foreach(DataRow dr in rows)///循环孩子节点
            {
				ClassTreeNode childNd;
				childNd.ID = dr["id"].ToString();                    ///孩子节点ID
                childNd.Name = dr["name"].ToString();                ///孩子节点Name
				childNd.OutLinkHref = dr["outLinkHref"].ToString();  ///孩子节点外链OutLinkHref
				childNd.Level = node.Level+1;                        ///孩子节点Level
				for(int i=0;i<childNd.Level;i++){
					treeStr += "&nbsp;&nbsp;&nbsp;&nbsp;";
				}
				treeStr += "<font style='color:#C0C2C1;'>&brvbar;--</font>";
				///判断当前节点是否有孩子节点
				bool isFather = dr["childID"].ToString().Contains(",");
				if(isFather){
					treeStr += "" + childNd.Name + " <span class='grayFont'>+添加文章</span>|<a href='DeepSoonArticleAdmin.aspx?ClassID="+childNd.ID+"&ClassName="+childNd.Name+"' >管理</a>|<a href='DeepSoonArticleTree.aspx?delClassID="+childNd.ID+"&delClassName="+childNd.Name+"' onclick='return confirm(\"敬告：栏目文章清空后无法恢复，确定清空吗？\")'>-清空</a><br>";
				}
				else{
					treeStr += "" + childNd.Name + " <a href='DeepSoonArticleAdd.aspx?ClassID="+childNd.ID+"&ClassName="+childNd.Name+"'>+添加文章</a>|<a href='DeepSoonArticleAdmin.aspx?ClassID="+childNd.ID+"&ClassName="+childNd.Name+"' >管理</a>|<a href='DeepSoonArticleTree.aspx?delClassID="+childNd.ID+"&delClassName="+childNd.Name+"' onclick='return confirm(\"敬告：栏目文章清空后无法恢复，确定清空吗？\")'>-清空</a><br>";
				}
				this.showNodesFunction(childNd);//递归调用自身  
            }
		}
		
		
		
		///删除节点及其包含的子节点
		private void deleteNodes(TreeNode node)
        {
			Response.Write("<font color=red>删除"+node.Text+" ID="+node.Value+" 执行SQL：Delete from tree where ID="+node.Value+"</font><br>");
			///删除node记录：
			mh.Runsql("Delete From Class4DeepSoon Where ID="+node.Value);
			///重新搜索数据表
			dt = mh.GetDatabysql("Select * From Class4DeepSoon Order By Id");
			///更新数据库的childId字段
			for(int i=0;i<dt.Rows.Count;i++){
				string opId = dt.Rows[i]["Id"].ToString();
				string oldChildId = dt.Rows[i]["childId"].ToString();
				string newChildId = oldChildId.Replace(","+node.Value, "");
				mh.Runsql("Update Class4DeepSoon Set ChildId='"+newChildId+"' Where ID="+opId);
			}
			this.deleteNodesFunction(node,node.Value);
			Response.Redirect("DeepSoonTree.aspx");
		}
		///删除节点递归函数：
		private void deleteNodesFunction(TreeNode node,string id)
        {
			DataRow [] rows = dt.Select("fatherId = '"+id+"'"); //筛选出属于父节点 “node”的子节点集合
            foreach(DataRow dr in rows) //循环子节点集合
            {
                TreeNode nd = new TreeNode();
                nd.Value=dr["id"].ToString();//节点ID
				nd.Text=dr["name"].ToString();//节点Name
                Response.Write("<font color=red>删除"+nd.Text+" ID="+nd.Value+" 执行SQL：Delete from tree where ID="+nd.Value+"</font><br>");
				///删除nd记录：
				mh.Runsql("Delete From Class4DeepSoon Where ID="+nd.Value);
				///重新搜索数据表
				dt = mh.GetDatabysql("Select * From Class4DeepSoon Order By Id");
				///更新数据库的childId字段
				for(int i=0;i<dt.Rows.Count;i++){
					string opId = dt.Rows[i]["Id"].ToString();
					string oldChildId = dt.Rows[i]["childId"].ToString();
					string newChildId = oldChildId.Replace(","+nd.Value, "");
					mh.Runsql("Update Class4DeepSoon Set ChildId='"+newChildId+"' Where ID="+opId);
				}
				this.deleteNodesFunction(nd,nd.Value);    //递归调用自身
            }
		}
		
		
		protected void btnDelAll_Click(object sender, EventArgs e)
		{
			mh.Runsql("Truncate Table Article4DeepSoon");
			Response.Redirect("DeepSoonArticleTree.aspx");
		}
    }
}