﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using MySql.Data.MySqlClient;

using Security;
namespace Security
{
    public partial class DeepSoonLinks : PageBase
    {
		protected void Page_Load(object sender, EventArgs e)
        {
			if (!IsPostBack) 
			{ 
				GridviewBind();
			}
			
			btnDelAll.Attributes.Add("onclick","return confirm(\"删除后数据无法恢复，是否确认删除？\")") ;
			
        }
		
		protected void GridviewBind() 
		{ 
			///创建数据连接对象：
			MysqlHelp mh = new MysqlHelp();
			///查询并显示数据：
			DataTable dt=new DataTable();
			dt = mh.GetDatabysql("Select * From Links4DeepSoon Order By ID DESC");
			myGridView.DataSource = dt;        
			myGridView.DataBind();
		}
	
		protected void myGridView_PageIndexChanging(object sender, GridViewPageEventArgs e)
		{
			myGridView.PageIndex = e.NewPageIndex;
			GridviewBind();//重新执行自定义的GridView数据绑定函数
			((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text = ""+(myGridView.PageIndex+1);
		}

		protected void myGridView_RowDeleting(object sender, GridViewDeleteEventArgs e) 
		{ 
			int deleteID = Convert.ToInt32(myGridView.DataKeys[e.RowIndex].Value);//获取主键
		
			///创建数据连接对象：
			MysqlHelp mh = new MysqlHelp();
			MySqlParameter[] updateParms ={new MySqlParameter("?ID",MySqlDbType.VarChar,4)};
			updateParms[0].Value = ""+deleteID;
			mh.Runsql("Delete From Links4DeepSoon Where ID=?ID", updateParms);		
			GridviewBind(); 
		} 
	
		protected void btnDelAll_Click(object sender, EventArgs e) 
		{ 
			string sqlText = "("; 
			int countNum = 0;//统计用户选取的记录数目
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				if (cbx.Checked == true) 
				{ 
					sqlText = sqlText + Convert.ToInt32(myGridView.DataKeys[i].Value) + ",";
					countNum ++;
				} 
			} 
			//去掉最后的逗号，并且加上右括号 
			sqlText = sqlText.Substring(0,sqlText.Length - 1) + ")"; 
			if(countNum>0){///如果选择不为空
				sqlText = "Delete From Links4DeepSoon Where ID In" + sqlText; 
				MysqlHelp mh = new MysqlHelp();
				mh.Runsql(sqlText);			
			}
			GridviewBind(); 
		}

		#region 转到触发方法
		protected void btnGo_Click(object sender, EventArgs e)
		{
			if(((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text != ""){
				myGridView.PageIndex = int.Parse(((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text) - 1;
				GridviewBind();   //重新绑定GridView
				((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text = ""+(myGridView.PageIndex+1);
			}
		}
		#endregion
		
		protected void btnAdd_Click(object sender, EventArgs e)
        {
			///获取输入的链接名称：
			string txtLinkNameValue = this.txtLinkName.Text.Replace("'", "");
			if(txtLinkNameValue.Length>20)txtLinkNameValue = txtLinkNameValue.Substring(0,20);
			///获取输入的链接地址：
			string txtLinkHrefValue = this.txtLinkHref.Text.Replace("'", "");
			if(txtLinkHrefValue.Length>150)txtLinkHrefValue = txtLinkHrefValue.Substring(0,150);
			
			
			if (txtLinkNameValue!="" && txtLinkHrefValue!=""){//判断用户输入的是否为空用户名和密码
				///创建数据连接对象：
				string Values = "'"+txtLinkNameValue+"','"+txtLinkHrefValue+"'";
				MysqlHelp mh = new MysqlHelp();
				mh.Runsql("Insert Into Links4DeepSoon(LinkName,LinkHref) Values ("+Values+")");	
				this.labelAddInfor.Text="友情链接添加成功!";
				GridviewBind();
			}//end 判断是否链接名称和链接地址为空
			else
			{
				this.labelAddInfor.Text="链接名称和地址不允许为空!";
			}
		}///end btnAdd_Click()
		
		
	}
}