﻿using System;
using System.Text;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Security.Cryptography;
using MySql.Data.MySqlClient;

using Security;
namespace Security
{
	public partial class login : ValidateBase
    {
        protected void Page_Load(object sender, EventArgs e)
        {
			if(!IsPostBack){
				if (Request.Cookies["strUser4Deepsoon"] != null){
					HttpCookie userCookie = Request.Cookies["strUser4Deepsoon"];
					string loginName = HttpUtility.UrlDecode(HttpUtility.UrlDecode(userCookie.Value, Encoding.GetEncoding("UTF-8")));
					this.labelInfor.Text = "您当前状态为已登录，已登录账户:"+loginName+" <a href='deepsoonindex.aspx'>直接进入后台</a><br>或者更换一个登录账户:";
					this.txtLoginName.Text = loginName;
				}
			}
        }
		
		public bool notHasSqlInsert(string sSql)
        { 
            int srcLen, decLen = 0;
            sSql = sSql.ToLower().Trim();
            srcLen = sSql.Length;
            sSql = sSql.Replace("exec", "");
            sSql = sSql.Replace("delete", "");
            sSql = sSql.Replace("master", "");
            sSql = sSql.Replace("truncate", "");
            sSql = sSql.Replace("declare", "");
            sSql = sSql.Replace("create", "");
            sSql = sSql.Replace("xp_", "no");
            decLen = sSql.Length;
            if (srcLen == decLen) 
				return true;
			else 
				return false;         
        }
		
        protected void btnLogin_Click(object sender, EventArgs e)
        {
			///获取用户输入的验证码：
			String txtVailValue = this.txtVail.Text.ToUpper().Replace("'", "");
			if(txtVailValue.Length>4)txtVailValue = this.txtVail.Text.Substring(0,4);
			///获取用户输入的账户名：
			String txtLoginNameValue = this.txtLoginName.Text.Replace("'", "");
			if(txtLoginNameValue.Length>20)txtLoginNameValue = this.txtLoginName.Text.Substring(0,20);
			///获取用户输入的保密码：
			String txtLoginPWDValue = this.txtLoginPWD.Text.Replace("'", "");
			if(txtLoginPWDValue.Length>8)txtLoginPWDValue = this.txtLoginPWD.Text.Substring(0,8);
			
			///检验是否有sql注入敏感字符
			if(notHasSqlInsert(txtLoginNameValue) && notHasSqlInsert(txtLoginPWDValue)){
				if ( txtVailValue== base.strValidate)///如果用户输入的验证码和系统自生成的验证码相同
				{
					///利用MD5进行加密：
					string MD5PWD=System.Web.Security.FormsAuthentication.HashPasswordForStoringInConfigFile(txtLoginPWDValue,"MD5");
			
					///创建数据连接对象：
					MysqlHelp mh = new MysqlHelp();
					///查询数据库
					DataTable dt=new DataTable();
					MySqlParameter[] quryParms  = {new MySqlParameter("?Name",MySqlDbType.VarChar,20),new MySqlParameter("?PWD",MySqlDbType.VarChar,20)};
					quryParms[0].Value = ""+txtLoginNameValue;
					quryParms[1].Value = ""+MD5PWD;
					dt = mh.GetDatabysql("Select * From Users4DeepSoon Where Name=?Name and PWD=?PWD and class='super' ",quryParms);
				
					///如果数据库查询到了记录，则成功登陆
					if (dt.Rows.Count>0){
						///保存用户登录名到基类的成员变量，并写入cookie
						base.strUser = txtLoginNameValue;
						
						///管理日志：登录
						MySqlParameter[] logParms ={new MySqlParameter("?Name",MySqlDbType.VarChar,20),
						new MySqlParameter("?EventStr",MySqlDbType.VarChar,40),
						new MySqlParameter("?IPStr",MySqlDbType.VarChar,20)};
						logParms[0].Value = ""+base.strUser;
						logParms[1].Value = "登录系统";
						logParms[2].Value = ""+getClientIP();
						mh.Runsql("Insert Into Log4DeepSoon(Name,EventStr,IPStr) Values (?Name,?EventStr,?IPStr)", logParms);
						
						///登录成功，跳转到管理首页
						Response.Redirect("DeepSoonIndex.aspx");
					}
					else {
						base.strUser = "";
						this.labelInfor.Text = "您输入的用户名或密码不对!";
					}
				}
				else
				{
					///base.strUser = "";
					this.labelInfor.Text = "您输入的验证不对!";
				}	
			
			}///end if(notHasSqlInsert(txtLoginNameValue)
			else{
				base.strUser = "";
                this.labelInfor.Text = "本站禁止SQL注入!";
			}	
			
        }
    }
}